/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.nativeAdapterData.os400.internal;

import com.ibm.cic.common.commonNativeAdapterData.ICommonNativeAdapterDataParser;
import com.ibm.cic.common.commonNativeAdapterData.ICommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.NativeAdapterData;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.adapterdata.ArtifactCommonAttributes;
import com.ibm.cic.common.core.model.adapterdata.IAdapterData;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.adapterdata.IErrorReporter;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.nativeAdapterData.os400.DesktopIconNativeData;
import com.ibm.cic.common.nativeAdapterData.os400.internal.IXMLConstants;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.xml.sax.Attributes;

public class NativeAdapterDataParser
extends ICommonNativeAdapterDataParser
implements IXMLConstants {
    private NativeAdapterData nativeData;
    private IErrorReporter reporter;
    private ICommonNativeAdapterDataParser.ElemStack elemStack;

    public void initialize(IInstallableUnit iu, IErrorReporter errorReporter) {
        this.nativeData = new NativeAdapterData();
        this.reporter = errorReporter;
        this.elemStack = new ICommonNativeAdapterDataParser.ElemStack();
        super.initialize(iu, this.nativeData, this.elemStack, errorReporter);
    }

    public IArtifact startArtifact(String uri, String name, String qName, Attributes attributes, String key) {
        return super.startArtifact(this.elemStack, this.reporter, uri, name, qName, attributes, key);
    }

    public void endArtifact() {
        this.elemStack.pop();
    }

    public IArtifact startArtifactNoKey(String uri, String name, String qName, Attributes attributes, ArtifactCommonAttributes aca) {
        return super.startArtifactNoKey(this.elemStack, this.reporter, uri, name, qName, attributes, aca);
    }

    public void startElement(String uri, String name, String qName, Attributes attributes) {
        this.elemStack.push((Object)new ICommonNativeAdapterDataParser.ElemStackEntry(name));
        boolean processed = this.processCommonElement(name, attributes);
        if (!processed) {
            if (name.equals("desktopIcon_os400")) {
                this.handleDesktopIconAttributes(attributes);
            } else {
                this.reporter.unexpectedElement(name, attributes);
            }
        }
    }

    public void endElement(String uri, String name, String qName) {
        this.elemStack.pop();
    }

    public IAdapterData getAdapterData() {
        return this.nativeData;
    }

    public URL getSchema() {
        Bundle bundle = Platform.getBundle((String)"com.ibm.cic.common.nativeAdapterData.os400");
        Path path = new Path("schema/nativeAdapterData.xsd");
        return FileLocator.find((Bundle)bundle, (IPath)path, null);
    }

    private void handleDesktopIconAttributes(Attributes attributes) {
        String command;
        String workingDirectory;
        String name;
        boolean hasErrors = false;
        if (!this.isTopLevelElement()) {
            this.reporter.unexpectedElement("desktopIcon_os400", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "desktopIcon_os400", new String[]{"name", "workingDirectory", "command", "arguments", "iconPath", "context", "categories", "description", "desktopFile"})) {
            hasErrors = true;
        }
        if ((name = attributes.getValue("name")) == null) {
            this.reporter.checkRequiredAttribute("desktopIcon_os400", "name", null);
            hasErrors = true;
        }
        if ((workingDirectory = attributes.getValue("workingDirectory")) == null) {
            this.reporter.checkRequiredAttribute("desktopIcon_os400", "workingDirectory", null);
            hasErrors = true;
        }
        if ((command = attributes.getValue("command")) == null) {
            this.reporter.checkRequiredAttribute("desktopIcon_os400", "command", null);
            hasErrors = true;
        }
        String arguments = attributes.getValue("arguments");
        String iconPath = attributes.getValue("iconPath");
        String categories = attributes.getValue("categories");
        if (categories == null) {
            this.reporter.checkRequiredAttribute("desktopIcon_os400", "categories", null);
            hasErrors = true;
        }
        String description = attributes.getValue("description");
        String desktopFile = attributes.getValue("desktopFile");
        if (!hasErrors) {
            DesktopIconNativeData data = new DesktopIconNativeData(name, workingDirectory, command, arguments, iconPath, CicCommonSettings.getAccessRightsMode().isAdminMode(), categories, description, desktopFile);
            this.nativeData.addData((ICommonNativeData)data);
        }
    }
}

