/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.ui.utils.InstalledOfferingTreeFixNode;
import com.ibm.cic.agent.internal.ui.utils.InstalledOfferingTreePackageNode;
import com.ibm.cic.agent.internal.ui.utils.InstalledOfferingTreeProfileNode;
import com.ibm.cic.agent.internal.ui.wizards.AbstractCicTreeDetailsWizardPage;
import com.ibm.cic.agent.internal.ui.wizards.IInstalledOfferingsPage;
import com.ibm.cic.agent.internal.ui.wizards.InstalledOfferingSection;
import com.ibm.cic.agent.internal.ui.wizards.ResponseFileGenInstalledPkgWizard;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.ui.parts.IFormContext;
import com.ibm.cic.common.ui.parts.TreeSection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ResponseFileGenInstalledPkgPage
extends AbstractCicTreeDetailsWizardPage
implements IInstalledOfferingsPage {
    private InstalledOfferingSection offeringSection;
    private Map<Profile, InstalledOfferingTreeProfileNode> profileMap;
    private final ResponseFileGenInstalledPkgWizard wizard;
    private final List selectedPkgFixNodes = new ArrayList();

    public ResponseFileGenInstalledPkgPage(FormToolkit toolkit, String title, String description, ResponseFileGenInstalledPkgWizard wizard) {
        super(title, toolkit, description);
        this.wizard = wizard;
    }

    @Override
    protected TreeSection createTreeSection(IFormContext context, Composite parent) {
        this.offeringSection = new InstalledOfferingSection(context, parent, this);
        return this.offeringSection;
    }

    @Override
    public Map<Profile, InstalledOfferingTreeProfileNode> generateInput() {
        Profile[] profiles;
        this.profileMap = new HashMap<Profile, InstalledOfferingTreeProfileNode>();
        Profile[] profileArray = profiles = Agent.getInstance().getProfiles();
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            InstalledOfferingTreeProfileNode profileNode;
            Profile profile = profileArray[n2];
            if (!profile.isAgentProfile() && !profile.isLicenseProfile() && (profileNode = this.profileMap.get(profile)) == null) {
                profileNode = new InstalledOfferingTreeProfileNode(profile);
                this.profileMap.put(profile, profileNode);
                this.createPackageFixNodes(profileNode);
            }
            ++n2;
        }
        return this.profileMap;
    }

    private void createPackageFixNodes(InstalledOfferingTreeProfileNode profileNode) {
        IOffering[] offerings;
        Profile profile = profileNode.getProfile();
        IOffering[] iOfferingArray = offerings = Agent.getInstance().getInstalledOfferings(profile);
        int n = offerings.length;
        int n2 = 0;
        while (n2 < n) {
            IFix[] fixes;
            IOffering offering = iOfferingArray[n2];
            InstalledOfferingTreePackageNode pkgNode = new InstalledOfferingTreePackageNode(offering, profileNode);
            pkgNode.setSelected(true);
            profileNode.addPackage(pkgNode);
            IFix[] iFixArray = fixes = Agent.getInstance().getInstalledFixes(profile, offering);
            int n3 = fixes.length;
            int n4 = 0;
            while (n4 < n3) {
                IFix fix = iFixArray[n4];
                InstalledOfferingTreeFixNode fixNode = new InstalledOfferingTreeFixNode(fix, pkgNode);
                fixNode.setSelected(true);
                pkgNode.addFix(fixNode);
                ++n4;
            }
            ++n2;
        }
    }

    @Override
    public void defaultChecked() {
        this.checkStatusChanged(true);
    }

    @Override
    public boolean fixDependOnOffering() {
        return false;
    }

    public boolean isPageComplete() {
        return !this.selectedPkgFixNodes.isEmpty();
    }

    @Override
    public void checkStatusChanged(boolean checked) {
        this.selectedPkgFixNodes.clear();
        if (!this.profileMap.isEmpty()) {
            Collection<InstalledOfferingTreeProfileNode> profileNodes = this.profileMap.values();
            for (InstalledOfferingTreeProfileNode profileNode : profileNodes) {
                List pkgNodes = profileNode.getPackages();
                int i = 0;
                while (i < pkgNodes.size()) {
                    InstalledOfferingTreePackageNode pNode = (InstalledOfferingTreePackageNode)pkgNodes.get(i);
                    if (pNode.isSelected()) {
                        this.selectedPkgFixNodes.add(pNode);
                    }
                    List fixNodes = pNode.getFixes();
                    int j = 0;
                    while (j < fixNodes.size()) {
                        InstalledOfferingTreeFixNode fNode = (InstalledOfferingTreeFixNode)fixNodes.get(j);
                        if (fNode.isSelected()) {
                            this.selectedPkgFixNodes.add(fNode);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        this.wizard.setSelections(this.selectedPkgFixNodes);
        this.wizard.getContainer().updateButtons();
    }
}

