/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.SortUtil;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.AgentUILabelProvider;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.parts.TreeMasterPart;
import com.ibm.cic.agent.internal.ui.utils.ProductProfileFilter;
import com.ibm.cic.agent.internal.ui.wizards.ProfileSelectionPage;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.ui.internal.CommonImages;
import com.ibm.cic.common.ui.parts.IFormContext;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class ProfileSelectionSection
extends TreeMasterPart {
    private final List profiles = new ArrayList();
    protected ProfileSelectionPage wizardPage;
    private IDialogSettings dialogSettings;
    private static final String DEFAULT_SELECTED_PROFILE = "defaultSelectedProfile";

    public ProfileSelectionSection(IFormContext context, Composite parent, ProfileSelectionPage wizardPage, Object[] input) {
        this(context, parent, wizardPage, null, 512, input);
    }

    public ProfileSelectionSection(IFormContext context, Composite parent, ProfileSelectionPage wizardPage, String[] buttonLabels, int buttonOrientation, Object[] input) {
        super(context, parent, 4096, buttonLabels, buttonOrientation);
        this.wizardPage = wizardPage;
        this.setInput(input);
        this.configureViewer(this.getTreePart().getTreeViewer());
        this.getSection().setText(Messages.ProfileSelectionSection_header);
        this.getSection().setDescription(Messages.ProfileSelectionSection_description);
    }

    @Override
    protected void configureViewer(TreeViewer viewer) {
        super.configureViewer(viewer);
        IDialogSettings settings = AgentUI.getDefault().getDialogSettings();
        this.dialogSettings = settings.getSection(((Object)((Object)this.wizardPage)).getClass().getName());
        if (this.dialogSettings == null) {
            this.dialogSettings = settings.addNewSection(((Object)((Object)this.wizardPage)).getClass().getName());
        }
        viewer.setLabelProvider((IBaseLabelProvider)new ProfileLabelProvider());
        viewer.setContentProvider((IContentProvider)new ProfileContentProvider());
        viewer.setSorter((ViewerSorter)new ProfileSorter());
        viewer.addFilter((ViewerFilter)new ProductProfileFilter());
        this.createColumns(viewer);
        viewer.setInput((Object)(this.profiles.isEmpty() ? Agent.getInstance().getVisibleProfiles() : this.profiles.toArray(new Profile[this.profiles.size()])));
    }

    @Override
    public void primeSelection() {
        TreeViewer viewer = this.getTreePart().getTreeViewer();
        String defaultSelectedProfileId = this.dialogSettings.get(DEFAULT_SELECTED_PROFILE);
        if (viewer != null && viewer.getTree().getItemCount() > 0) {
            if (defaultSelectedProfileId == null || defaultSelectedProfileId.length() == 0) {
                viewer.setSelection((ISelection)new StructuredSelection(viewer.getTree().getItem(0).getData()));
            } else {
                Profile defaultSelectedProfile = null;
                int i = 0;
                while (i < viewer.getTree().getItemCount()) {
                    Profile profile = (Profile)viewer.getTree().getItem(i).getData();
                    if (defaultSelectedProfileId.equals(profile.getProfileId())) {
                        defaultSelectedProfile = profile;
                        break;
                    }
                    ++i;
                }
                if (defaultSelectedProfile == null) {
                    viewer.setSelection((ISelection)new StructuredSelection(viewer.getTree().getItem(0).getData()));
                } else {
                    viewer.setSelection((ISelection)new StructuredSelection(defaultSelectedProfile));
                }
            }
        }
    }

    private TreeColumn createColumn(Tree tree, String name, int width) {
        TreeColumn column = new TreeColumn(tree, 0);
        column.setText(name);
        column.setWidth(width);
        column.setResizable(true);
        return column;
    }

    private void createColumns(TreeViewer viewer) {
        Tree tree = viewer.getTree();
        tree.setHeaderVisible(true);
        this.createColumn(tree, Messages.ProfileSelectionSection_locationName, 400);
        this.createColumn(tree, Messages.ProfileSelectionSection_locationDirectory, 300);
    }

    @Override
    protected TreeViewer createTreeViewer(Composite parent, int style) {
        TreeViewer viewer = new TreeViewer(parent, 2052);
        this.getContext().getForm().getToolkit().adapt(viewer.getControl(), true, true);
        return viewer;
    }

    @Override
    public IBaseLabelProvider getLabelProvider() {
        return this.getTreePart().getTreeViewer().getLabelProvider();
    }

    ITreeContentProvider getContentProvider() {
        return (ITreeContentProvider)this.getTreePart().getTreeViewer().getContentProvider();
    }

    @Override
    public void showURL(String url) {
        AgentUI.getDefault().showURL(url);
    }

    @Override
    protected void selectionChanged(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return;
        }
        boolean isSameSelection = false;
        Object[] previousSelection = this.wizardPage.getSelections();
        Object currentSelection = ((StructuredSelection)selection).getFirstElement();
        if (previousSelection != null && previousSelection.length == 1) {
            isSameSelection = currentSelection.equals(previousSelection[0]);
        }
        if (!isSameSelection) {
            this.wizardPage.resetLocationCheckStatus();
        }
        super.selectionChanged(selection);
        this.setSelection(currentSelection);
    }

    protected void setSelection(Object selection) {
        Profile profile = null;
        if (selection instanceof Profile) {
            profile = (Profile)selection;
        }
        if (profile == null) {
            this.wizardPage.setSelection(null);
        } else {
            this.wizardPage.setSelection(new Profile[]{profile});
            this.dialogSettings.put(DEFAULT_SELECTED_PROFILE, profile.getProfileId());
        }
    }

    private void setInput(Object[] inputElements) {
        if (inputElements != null) {
            Object[] objectArray = inputElements;
            int n = inputElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object inputElement = objectArray[n2];
                if (inputElement instanceof AgentJob) {
                    this.profiles.add(((AgentJob)inputElement).getProfile());
                }
                ++n2;
            }
        }
    }

    private static class ProfileContentProvider
    implements ITreeContentProvider {
        private ProfileContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object[] getElements(Object inputElement) {
            return (Object[])inputElement;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class ProfileLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider,
    ITableFontProvider {
        private final AgentUILabelProvider agentLabelProvider = AgentUI.getDefault().getLabelProvider();

        public ProfileLabelProvider() {
            this.agentLabelProvider.connect((Object)this);
        }

        public void dispose() {
            this.agentLabelProvider.disconnect((Object)this);
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return this.getImage(element);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return this.getText(element);
            }
            if (element instanceof Profile) {
                switch (columnIndex) {
                    case 0: {
                        return this.getText(element);
                    }
                    case 1: {
                        String installLocation = ((Profile)element).getInstallLocation();
                        return TextProcessor.process((String)installLocation);
                    }
                }
            }
            return "";
        }

        public Font getFont(Object element, int columnIndex) {
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            return null;
        }

        public Image getImage(Object element) {
            if (element instanceof Profile) {
                return this.agentLabelProvider.get(CommonImages.DESC_PROFILE_OBJ);
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof Profile) {
                return ((Profile)element).getProfileId();
            }
            return super.getText(element);
        }
    }

    private static class ProfileSorter
    extends ViewerSorter {
        private ProfileSorter() {
        }

        public int category(Object element) {
            if (element instanceof Profile) {
                return 1;
            }
            return super.category(element);
        }

        public void sort(Viewer viewer, Object[] elements) {
            if (elements.length < 2) {
                return;
            }
            SortUtil.ProfileSorter sorter = new SortUtil.ProfileSorter();
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                Profile profile = (Profile)element;
                IOffering[] iOfferingArray = profile.getInstallRegistry().getInstalledOfferings();
                int n3 = iOfferingArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IOffering offering = iOfferingArray[n4];
                    sorter.add(profile, (IOfferingOrFix)offering);
                    ++n4;
                }
                ++n2;
            }
            int i = 0;
            for (Profile profile : sorter.getSortedProfiles()) {
                elements[i++] = profile;
            }
        }
    }
}

