/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.BitModeUtils;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.parts.TreeMasterPart;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.internal.ui.utils.ProductProfileFilter;
import com.ibm.cic.agent.internal.ui.utils.ProfileTreeNode;
import com.ibm.cic.agent.internal.ui.utils.UpdateResultContentProvider;
import com.ibm.cic.agent.internal.ui.utils.UpdateResultLabelProvider;
import com.ibm.cic.agent.internal.ui.wizards.MultipleProfileInstallLocationPage;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.ui.internal.CommonImages;
import com.ibm.cic.common.ui.internal.CommonUIUtils;
import com.ibm.cic.common.ui.parts.IFormContext;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class MultipleProfileInstallLocationSection
extends TreeMasterPart {
    private List currentInput = new ArrayList();
    private final MultipleProfileInstallLocationPage locationPage;
    private TreeViewer treeViewer;

    public MultipleProfileInstallLocationSection(IFormContext context, Composite parent, MultipleProfileInstallLocationPage locationPage) {
        super(context, parent, 4096, new String[0], 512);
        this.locationPage = locationPage;
        this.configureViewer(this.getTreePart().getTreeViewer());
        this.getSection().setText(Messages.InstallLocationSection_header);
    }

    @Override
    protected void configureViewer(TreeViewer viewer) {
        super.configureViewer(viewer);
        viewer.setLabelProvider((IBaseLabelProvider)new MultipleProfileTreeLabelProvider(DisplayKeeper.INSTANCE.getDisplay()));
        viewer.setContentProvider((IContentProvider)new UpdateResultContentProvider(false));
        viewer.setSorter((ViewerSorter)new ProfileSorter());
        viewer.addFilter((ViewerFilter)new MultipleProfileViewFilter());
        this.createColumns(viewer);
        viewer.setInput(null);
    }

    private TreeColumn createColumn(Tree tree, String name, TableLayout tableLayout, int width) {
        TreeColumn column = new TreeColumn(tree, 0x800000);
        column.setText(name);
        column.setResizable(true);
        if (tableLayout == null) {
            column.setWidth(width);
        } else {
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(width, width, true));
        }
        return column;
    }

    private void createColumns(TreeViewer viewer) {
        Tree tree = viewer.getTree();
        tree.setHeaderVisible(true);
        TableLayout tableLayout = new TableLayout();
        int width = 300;
        int bitColWidth = 0;
        if (BitModeUtils.isMultiBitModePlatform()) {
            bitColWidth = CommonUIUtils.calculateStringWidth((Control)tree, (String)Messages.InstallLocationSection_columnBitMode, (int)2);
            width -= bitColWidth / 2;
        }
        this.createColumn(tree, Messages.InstallLocationSection_columnName, tableLayout, width);
        this.createColumn(tree, Messages.InstallLocationSection_columnLocation, tableLayout, width);
        if (BitModeUtils.isMultiBitModePlatform()) {
            this.createColumn(tree, Messages.InstallLocationSection_columnBitMode, tableLayout, bitColWidth);
        }
        tree.setLayout((Layout)tableLayout);
    }

    protected Profile getSelection() {
        TreePath path;
        Object firstObj;
        ISelection selection = this.treeViewer.getSelection();
        if (!selection.isEmpty() && selection instanceof TreeSelection && (firstObj = (path = ((TreeSelection)selection).getPaths()[0]).getFirstSegment()) instanceof ProfileTreeNode) {
            return ((ProfileTreeNode)firstObj).getProfile();
        }
        return null;
    }

    @Override
    protected TreeViewer createTreeViewer(Composite parent, int style) {
        this.treeViewer = new TreeViewer(parent, 2052);
        this.getContext().getForm().getToolkit().adapt(this.treeViewer.getControl(), true, true);
        return this.treeViewer;
    }

    @Override
    public IBaseLabelProvider getLabelProvider() {
        return this.treeViewer.getLabelProvider();
    }

    @Override
    public void primeSelection() {
        TreeItem[] items = this.treeViewer.getTree().getItems();
        if (items == null || items.length == 0) {
            return;
        }
        ProfileTreeNode primeSelectedProfile = null;
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus status;
            TreeItem item = treeItemArray[n2];
            ProfileTreeNode profileWithError = (ProfileTreeNode)item.getData();
            Map map = this.locationPage.getProfileSetLocationMap();
            if (map != null && (status = (IStatus)map.get(profileWithError.getProfile())) != null && StatusUtil.isErrorOrCancel((IStatus)status)) {
                primeSelectedProfile = profileWithError;
                break;
            }
            map = this.locationPage.getProfileStatusMap();
            if (map != null && (status = (IStatus)map.get(profileWithError.getProfile())) != null && StatusUtil.isErrorOrCancel((IStatus)status)) {
                primeSelectedProfile = profileWithError;
                break;
            }
            map = this.locationPage.getProfileLocationOverlapStatusMap();
            if (map != null && (status = (IStatus)map.get(profileWithError.getProfile())) != null && StatusUtil.isErrorOrCancel((IStatus)status)) {
                primeSelectedProfile = profileWithError;
                break;
            }
            ++n2;
        }
        if (primeSelectedProfile == null) {
            primeSelectedProfile = (ProfileTreeNode)items[0].getData();
        }
        Object[] selectProfile = new ProfileTreeNode[]{primeSelectedProfile};
        StructuredSelection newSelection = new StructuredSelection(selectProfile);
        this.treeViewer.setSelection((ISelection)newSelection);
    }

    public void refresh() {
        super.refresh();
        this.treeViewer.refresh();
    }

    protected void setInput(Object inputElement) {
        if (inputElement instanceof List) {
            if (!this.currentInput.equals(inputElement)) {
                this.currentInput = (List)inputElement;
                this.locationPage.initializeProfileProperties();
                this.locationPage.validateInitialStatus();
                Map profileRootMap = AgentUIUtils.generateProfileJobFeatureTree(this.currentInput);
                this.locationPage.setSelection(new ArrayList(profileRootMap.keySet()));
                this.treeViewer.setInput(profileRootMap.values());
                this.treeViewer.expandAll();
                this.primeSelection();
            } else {
                this.locationPage.revalidateProfileStatus();
                this.locationPage.resetCurrentProfileStatus(true);
            }
        }
    }

    @Override
    public void showURL(String url) {
        AgentUI.getDefault().showURL(url);
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    private class MultipleProfileTreeLabelProvider
    extends UpdateResultLabelProvider {
        public MultipleProfileTreeLabelProvider(Display display) {
            super(display);
        }

        @Override
        public Image getImage(Object element) {
            if (element instanceof ProfileTreeNode) {
                IStatus status;
                Profile profile = ((ProfileTreeNode)element).getProfile();
                boolean isWarning = false;
                Map map = MultipleProfileInstallLocationSection.this.locationPage.getProfileSetLocationMap();
                if (map != null) {
                    status = (IStatus)map.get(profile);
                    if (status != null && StatusUtil.isErrorOrCancel((IStatus)status)) {
                        return this.agentLabelProvider.get(CommonImages.LOG_ERROR);
                    }
                    if (status != null && status.matches(2)) {
                        isWarning = true;
                    }
                }
                if ((map = MultipleProfileInstallLocationSection.this.locationPage.getProfileStatusMap()) != null) {
                    status = (IStatus)map.get(profile);
                    if (status != null && StatusUtil.isErrorOrCancel((IStatus)status)) {
                        return this.agentLabelProvider.get(CommonImages.LOG_ERROR);
                    }
                    if (status != null && status.matches(2)) {
                        isWarning = true;
                    }
                }
                if ((map = MultipleProfileInstallLocationSection.this.locationPage.getProfileLocationOverlapStatusMap()) != null) {
                    status = (IStatus)map.get(profile);
                    if (status != null && StatusUtil.isErrorOrCancel((IStatus)status)) {
                        return this.agentLabelProvider.get(CommonImages.LOG_ERROR);
                    }
                    if (status != null && status.matches(2)) {
                        isWarning = true;
                    }
                }
                if (isWarning) {
                    return this.agentLabelProvider.get(CommonImages.LOG_WARNING);
                }
            }
            return super.getImage(element);
        }

        @Override
        public String getColumnText(Object element, int columnIndex) {
            List productJobs;
            Profile profile;
            if (columnIndex == 2 && element instanceof IAdaptable && (profile = (Profile)((IAdaptable)element).getAdapter(Profile.class)) != null && BitModeUtils.isBitModeApplicable((Profile)profile, (IOffering[])AgentUIUtils.getSelectedProductOfferingArray(productJobs = MultipleProfileInstallLocationSection.this.locationPage.getProfileProductJobs(profile)))) {
                return BitModeUtils.getBitModeText((Profile)profile);
            }
            return super.getColumnText(element, columnIndex);
        }
    }

    private static class MultipleProfileViewFilter
    extends ProductProfileFilter {
        private MultipleProfileViewFilter() {
        }

        @Override
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof ProfileTreeNode) {
                Profile profile = ((ProfileTreeNode)element).getProfile();
                return super.select(viewer, parentElement, profile);
            }
            return true;
        }
    }

    private static class ProfileSorter
    extends ViewerSorter {
        private ProfileSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            if (e1 instanceof ProfileTreeNode && e2 instanceof ProfileTreeNode) {
                String label1 = ((ProfileTreeNode)e1).getProfile().getProfileId();
                String label2 = ((ProfileTreeNode)e2).getProfile().getProfileId();
                return this.getComparator().compare(label1, label2);
            }
            return super.compare(viewer, e1, e2);
        }

        public int category(Object element) {
            if (element instanceof ProfileTreeNode) {
                return 0;
            }
            return 1;
        }

        public void sort(Viewer viewer, Object[] elements) {
            AgentUIUtils.sortByNameAndVersion(viewer, this, elements);
        }
    }
}

