/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.BitModeUtils;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.SortUtil;
import com.ibm.cic.agent.core.SpaceInfoUtils;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.internal.ui.wizards.MultipleProfileInstallLocationPage;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.ui.internal.CommonUIUtils;
import com.ibm.cic.common.ui.services.UiServices;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;

public class MultipleProfileInstallLocationDetailsPage
extends AbstractFormPart
implements IDetailsPage {
    private FormToolkit toolkit;
    private Table diskspaceTable;
    private Button installLocationButton;
    private Text installLocationDirectoryText;
    private Label installLocationNameText;
    private FormText installedOfferings;
    private Label bitModeLabel;
    private Button bits32button;
    private Button bits64button;
    private ModifyListener profileDirModifyListener;
    private final MultipleProfileInstallLocationPage locationPage;
    private Profile previousSelectedProfile;
    private Composite sectionParent;

    public MultipleProfileInstallLocationDetailsPage(MultipleProfileInstallLocationPage locationPage) {
        this.locationPage = locationPage;
    }

    public void createContents(Composite parent) {
        this.toolkit = this.getManagedForm().getToolkit();
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 20;
        parent.setLayout((Layout)layout);
        this.sectionParent = parent;
        this.createInstallLocationSection(parent);
        this.createDetailsSection(parent);
    }

    private void createDetailsSection(Composite parent) {
        SashForm sashForm = new SashForm(parent, 0);
        this.toolkit.adapt((Control)sashForm, false, false);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        sashForm.setLayout((Layout)layout);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        sashForm.setOrientation(256);
        this.createProfileDetailsSection((Composite)sashForm);
        this.createDiskspaceSection((Composite)sashForm);
        sashForm.setWeights(new int[]{60, 40});
    }

    protected void createProfileDetailsSection(Composite container) {
        Section detailsSection = this.toolkit.createSection(container, 512);
        detailsSection.setText(com.ibm.cic.agent.core.sharedUI.Messages.DetailsPage_title);
        SharedScrolledComposite detailsComposite = new SharedScrolledComposite((Composite)detailsSection, this.toolkit.getOrientation()){};
        detailsComposite.setExpandVertical(true);
        this.toolkit.adapt((Composite)detailsComposite);
        GridData gridData = new GridData(4, 4, true, true);
        detailsComposite.setLayoutData((Object)gridData);
        detailsSection.setClient((Control)detailsComposite);
        detailsSection.setLayoutData((Object)new GridData(4, 4, true, true));
        this.installedOfferings = this.toolkit.createFormText((Composite)detailsComposite, true);
        this.installedOfferings.setLayoutData((Object)new GridData(4, 4, true, true));
        detailsComposite.setContent((Control)this.installedOfferings);
    }

    protected void createDiskspaceSection(Composite container) {
        Section spaceSection = this.toolkit.createSection(container, 512);
        spaceSection.setText(Messages.InstallLocationDetailsPage_diskspaceInfo);
        Composite spaceComposite = this.toolkit.createComposite((Composite)spaceSection);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        spaceComposite.setLayout((Layout)layout);
        spaceSection.setClient((Control)spaceComposite);
        spaceSection.setLayoutData((Object)new GridData(4, 4, true, false));
        int originalBorderStype = this.toolkit.getBorderStyle();
        this.toolkit.setBorderStyle(0);
        int spaceTableStyle = 32772;
        this.diskspaceTable = this.toolkit.createTable(spaceComposite, spaceTableStyle);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        data.heightHint = this.diskspaceTable.getItemHeight() * 2;
        this.diskspaceTable.setLayoutData((Object)data);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, 80, false));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(7, 150, false));
        this.diskspaceTable.setLayout((Layout)tableLayout);
        new TableColumn(this.diskspaceTable, 16384, 0);
        new TableColumn(this.diskspaceTable, 16384, 1);
        this.diskspaceTable.pack();
        this.toolkit.setBorderStyle(originalBorderStype);
    }

    private void createInstallLocationSection(final Composite parent) {
        Composite locationComposite = this.toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        locationComposite.setLayout((Layout)layout);
        locationComposite.setLayoutData((Object)new GridData(768));
        this.createLabel(locationComposite, Messages.InstallLocationDetailsPage_installLocationNameLabel);
        this.installLocationNameText = this.createLabel(locationComposite, "");
        this.installLocationNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.createLabel(locationComposite, "");
        this.createLabel(locationComposite, Messages.InstallLocationDetailsPage_installLocationLabel);
        this.installLocationDirectoryText = this.toolkit.createText(locationComposite, null, 2048);
        this.installLocationDirectoryText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.profileDirModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String directory = ((Text)e.widget).getText();
                MultipleProfileInstallLocationDetailsPage.this.locationPage.handleInstallLocationChange(TextProcessor.deprocess((String)directory.trim()));
            }
        };
        this.installLocationDirectoryText.addModifyListener(this.profileDirModifyListener);
        this.installLocationButton = this.toolkit.createButton(locationComposite, Messages.InstallLocationDetailsPage_browseButton, 8);
        this.installLocationButton.setEnabled(false);
        this.installLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String directory = UiServices.getInstance().getDirectoryDialog(parent.getShell()).title(Messages.InstallLocationDetailsPage_installDialogTitle).message(Messages.InstallLocationDetailsPage_installDialogMessage).filterPath(TextProcessor.deprocess((String)MultipleProfileInstallLocationDetailsPage.this.installLocationDirectoryText.getText())).run();
                if (directory != null) {
                    MultipleProfileInstallLocationDetailsPage.this.installLocationDirectoryText.setText(TextProcessor.process((String)directory.trim()));
                }
            }
        });
        if (BitModeUtils.isMultiBitModePlatform()) {
            this.createBitModeButtons(locationComposite);
        }
    }

    private void createBitModeButtons(Composite locationComposite) {
        this.bitModeLabel = this.createLabel(locationComposite, Messages.InstallLocationDetailsPage_bitModeLabel);
        Composite bitmodeComposite = this.toolkit.createComposite(locationComposite);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        bitmodeComposite.setLayout((Layout)layout);
        bitmodeComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.bits32button = this.createBitModeButton(bitmodeComposite, 32);
        this.bits32button.setSelection(true);
        this.bits64button = this.createBitModeButton(bitmodeComposite, 64);
        Label label = this.toolkit.createLabel(bitmodeComposite, "");
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    private Button createBitModeButton(Composite bitmodeComposite, final int bits) {
        final Button bitModeButton = this.toolkit.createButton(bitmodeComposite, BitModeUtils.getBitModeText((int)bits), 0x800010);
        bitModeButton.setLayoutData((Object)new GridData(0, 0x1000000, false, false));
        bitModeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                MultipleProfileInstallLocationDetailsPage.this.handleBitModeChange(bits);
            }

            public void widgetSelected(SelectionEvent e) {
                if (bitModeButton.getSelection()) {
                    MultipleProfileInstallLocationDetailsPage.this.handleBitModeChange(bits);
                }
            }
        });
        return bitModeButton;
    }

    void handleBitModeChange(int bits) {
        this.locationPage.handleBitModeChange(bits);
        String profileDirectory = this.locationPage.getSelection().getInstallLocation();
        this.installLocationDirectoryText.setText(TextProcessor.process((String)profileDirectory));
    }

    private Label createLabel(Composite composite, String value) {
        Label label = this.toolkit.createLabel(composite, value);
        label.setLayoutData((Object)new GridData(0, 0x1000000, false, false));
        return label;
    }

    private void enableLocationArea(Object object) {
        Profile profile = (Profile)object;
        boolean enableInstallLocation = profile.isShadow();
        this.installLocationDirectoryText.setEditable(enableInstallLocation);
        this.installLocationDirectoryText.setEnabled(enableInstallLocation);
        this.installLocationButton.setEnabled(enableInstallLocation);
        if (BitModeUtils.isMultiBitModePlatform()) {
            List productJobs = this.locationPage.getProfileProductJobs(profile);
            IOffering[] selectedProductOfferings = AgentUIUtils.getSelectedProductOfferingArray(productJobs);
            boolean enableBitMode = enableInstallLocation && BitModeUtils.hasBitModeChoice((IOffering[])selectedProductOfferings);
            this.bits32button.setEnabled(enableBitMode);
            this.bits64button.setEnabled(enableBitMode);
            boolean bitModeIsVisible = BitModeUtils.isBitModeApplicable((Profile)profile, (IOffering[])selectedProductOfferings);
            this.bitModeLabel.setVisible(bitModeIsVisible);
            this.bits32button.setVisible(bitModeIsVisible);
            this.bits64button.setVisible(bitModeIsVisible);
        }
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        Profile selectedProfile = this.locationPage.getSelection();
        if (selectedProfile != null && selectedProfile != this.previousSelectedProfile) {
            this.previousSelectedProfile = selectedProfile;
            String profileName = selectedProfile.getProfileId();
            this.installLocationNameText.setText(profileName);
            String profileDirectory = selectedProfile.getInstallLocation();
            this.installLocationDirectoryText.removeModifyListener(this.profileDirModifyListener);
            if (!this.installLocationDirectoryText.getText().equals(profileDirectory)) {
                this.installLocationDirectoryText.setText(TextProcessor.process((String)profileDirectory));
            }
            this.locationPage.validateProfileSelectionChange();
            this.installLocationDirectoryText.addModifyListener(this.profileDirModifyListener);
            if (BitModeUtils.isMultiBitModePlatform()) {
                this.bits32button.setSelection(selectedProfile.is32bit());
                this.bits64button.setSelection(selectedProfile.is64bit());
            }
            this.showInstalledOfferings();
            this.updateLocationInfo();
        }
    }

    protected void showInstalledOfferings() {
        Profile profile = this.locationPage.getSelection();
        StringBuffer details = new StringBuffer();
        if (profile != null) {
            Agent agent = AgentUI.getDefault().getAgent();
            StringBuffer profileDes = new StringBuffer(Messages.DetailSection_commonComponentLocation);
            profileDes.append(" ");
            profileDes.append(CommonUIUtils.escapeSpecialChars((String)profile.getCacheLocation()));
            String eclipseLocation = CommonUIUtils.escapeSpecialChars((String)profile.getEclipseLocation());
            if (eclipseLocation != null && eclipseLocation.length() > 0 && !profile.isShadow() && profile.isExistingEclipseProfile()) {
                StringBuffer buffer = new StringBuffer("<li>");
                buffer.append(profileDes);
                buffer.append("</li>");
                profileDes = buffer;
                String processedEclipseLocation = TextProcessor.process((String)eclipseLocation);
                profileDes.append("<li>");
                profileDes.append(Messages.SummaryPage_eclipseIDELabel);
                profileDes.append(" ");
                profileDes.append(processedEclipseLocation);
                profileDes.append("</li>");
            }
            StringBuffer installedOfferingsList = new StringBuffer();
            IOffering[] offerings = agent.getInstalledOfferings(profile);
            if (offerings.length > 0) {
                installedOfferingsList.append("<p><b>");
                installedOfferingsList.append(Messages.InstallLocationDetailsPage_installedPackages);
                installedOfferingsList.append("</b></p>");
                SortUtil.sortByNameAndVersion((IOfferingOrFix[])offerings);
                IOffering[] iOfferingArray = offerings;
                int n = offerings.length;
                int n2 = 0;
                while (n2 < n) {
                    IOffering offering = iOfferingArray[n2];
                    String offeringLabel = AgentUIUtils.getOfferingOrFixLabel((IOfferingOrFix)offering);
                    if (offeringLabel != null && offeringLabel.length() > 0) {
                        installedOfferingsList.append("<li>");
                        installedOfferingsList.append(CommonUIUtils.escapeSpecialChars((String)offeringLabel));
                        installedOfferingsList.append("</li>");
                    }
                    ++n2;
                }
            }
            details.append("<form>");
            details.append(profileDes);
            details.append(installedOfferingsList);
            details.append("</form>");
        }
        this.installedOfferings.setText(details.toString(), details.length() > 0, false);
        if (this.sectionParent != null) {
            this.sectionParent.layout();
        }
    }

    public void setSelection(IStructuredSelection selection) {
    }

    protected void showDiskSpaceInfo() {
        this.diskspaceTable.removeAll();
        TableItem tableItem = new TableItem(this.diskspaceTable, 0);
        tableItem.setText(new String[]{Messages.InstallLocationDetailsPage_spaceTable_volumeName, Messages.InstallLocationDetailsPage_spaceTable_availableSpace});
        int width1 = AgentUIUtils.calculateSpaceTableColumnWidth(this.diskspaceTable, Messages.InstallLocationDetailsPage_spaceTable_volumeName);
        int width2 = AgentUIUtils.calculateSpaceTableColumnWidth(this.diskspaceTable, Messages.InstallLocationDetailsPage_spaceTable_availableSpace);
        List jobs = this.locationPage.getSelectedProductJobs();
        if (jobs == null || jobs.size() == 0) {
            return;
        }
        HashSet<String> volumeNames = new HashSet<String>();
        int i = 0;
        while (i < jobs.size()) {
            AbstractJob job = (AbstractJob)jobs.get(i);
            Profile profile = job.getProfile();
            volumeNames.add(PlatformUtils.getLocationDevice((String)profile.getInstallLocation()));
            volumeNames.add(PlatformUtils.getLocationDevice((String)profile.getEclipseLocation()));
            ++i;
        }
        for (String driveName : volumeNames) {
            String availableSpace = SpaceInfoUtils.getAvailableSpace((String)driveName);
            TableItem item = new TableItem(this.diskspaceTable, 0);
            item.setText(new String[]{driveName, availableSpace});
            int width = AgentUIUtils.calculateSpaceTableColumnWidth(this.diskspaceTable, driveName);
            width1 = Math.max(width1, width);
            width = AgentUIUtils.calculateSpaceTableColumnWidth(this.diskspaceTable, availableSpace);
            width2 = Math.max(width2, width);
        }
        int rowCount = volumeNames.size() + 1;
        GridData data = (GridData)this.diskspaceTable.getLayoutData();
        data.heightHint = this.diskspaceTable.getItemHeight() * rowCount;
        TableColumn col1 = this.diskspaceTable.getColumn(0);
        col1.setWidth(width1);
        TableColumn col2 = this.diskspaceTable.getColumn(1);
        col2.setWidth(width2);
        this.diskspaceTable.redraw();
    }

    void updateLocationInfo() {
        this.showDiskSpaceInfo();
        this.enableLocationArea(this.locationPage.getSelection());
    }

    boolean isReady() {
        return this.installedOfferings != null;
    }
}

