/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.LocationCheckManager;
import com.ibm.cic.agent.core.ModifyJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.agent.internal.ui.wizards.ModifyWizard;
import com.ibm.cic.agent.internal.ui.wizards.PrimaryWizard;
import com.ibm.cic.agent.internal.ui.wizards.ProfileSelectionPage;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.ServiceRepositoryUtils;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.wizards.CustomMessageWizardPage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;

public class ModifyProfileSelectionPage
extends ProfileSelectionPage {
    static final CustomMessageWizardPage.WarningId LOCATION_CHECK_WARNING = new CustomMessageWizardPage.WarningId();
    static final CustomMessageWizardPage.ErrorId LOCATION_CHECK_ERROR = new CustomMessageWizardPage.ErrorId();

    public ModifyProfileSelectionPage(String title, String description, PrimaryWizard wizard) {
        super(title, description, wizard);
        super.setHelpRef("com.ibm.cic.agent.ui.ModifyProfileSelectionPage");
    }

    @Override
    protected AgentUIWizard createInnerWizard() {
        return new ModifyWizard();
    }

    @Override
    protected IStatus prepareInstalledOfferingsInSelectedProfile(IProgressMonitor monitor) {
        IStatus returnStatus = Status.OK_STATUS;
        SplitProgressMonitor sm = new SplitProgressMonitor(monitor, new int[]{3, 1});
        returnStatus = super.prepareInstalledOfferingsInSelectedProfile(false, sm.next());
        if (!StatusUtil.isErrorOrCancel((IStatus)returnStatus)) {
            Object[] selectionArray = this.getSelections();
            ArrayList<ModifyJob> selectedJobs = new ArrayList<ModifyJob>();
            Object[] objectArray = selectionArray;
            int n = selectionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object selectedItem = objectArray[n2];
                if (selectedItem instanceof Profile) {
                    IFix[] fixes;
                    IOffering[] offerings;
                    Profile selectedProfile = (Profile)selectedItem;
                    IOffering[] iOfferingArray = offerings = Agent.getInstance().getInstalledOfferings(selectedProfile);
                    int n3 = offerings.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IOffering offering = iOfferingArray[n4];
                        selectedJobs.add(new ModifyJob(selectedProfile, (IOfferingOrFix)offering));
                        ++n4;
                    }
                    IFix[] iFixArray = fixes = Agent.getInstance().getInstalledFixes(selectedProfile);
                    int n5 = fixes.length;
                    n3 = 0;
                    while (n3 < n5) {
                        IFix fix = iFixArray[n3];
                        selectedJobs.add(new ModifyJob(selectedProfile, (IOfferingOrFix)fix));
                        ++n3;
                    }
                }
                ++n2;
            }
            returnStatus = AgentUIUtils.runPrecheckBundlesWithMonitor(selectedJobs, false, sm.next());
        }
        monitor.done();
        return returnStatus;
    }

    protected void loadServiceRepositoriesForInstalledOfferingsInSelectedProfile(IProgressMonitor monitor) {
        Object[] selectionArray;
        Agent agent = AgentUI.getDefault().getAgent();
        ArrayList<IOffering> offeringsToScanForServiceReps = new ArrayList<IOffering>();
        Object[] objectArray = selectionArray = this.getSelections();
        int n = selectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof Profile) {
                IOffering[] offerings;
                IOffering[] iOfferingArray = offerings = agent.getInstalledOfferings((Profile)element);
                int n3 = offerings.length;
                int n4 = 0;
                while (n4 < n3) {
                    IOffering offering = iOfferingArray[n4];
                    offeringsToScanForServiceReps.add(offering);
                    ++n4;
                }
            }
            ++n2;
        }
        ServiceRepositoryUtils.loadServiceRepositoriesIfPrefIsSet((IRepositoryGroup)agent.getRepositoryGroup(), (IOffering[])offeringsToScanForServiceReps.toArray(new IOffering[offeringsToScanForServiceReps.size()]), (IProgressMonitor)monitor);
    }

    @Override
    protected CustomMessageWizardPage.ErrorId getLocationCheckError() {
        return LOCATION_CHECK_ERROR;
    }

    @Override
    protected CustomMessageWizardPage.WarningId getLocationCheckWarning() {
        return LOCATION_CHECK_WARNING;
    }

    @Override
    public IWizardPage getNextPage() {
        if (!this.performLocationChecks()) {
            return this;
        }
        return super.getNextPage();
    }

    private boolean performLocationChecks() {
        CicMultiStatus status = this.performLocationPermissionCheck();
        if (!StatusUtil.isErrorOrCancel((IStatus)status)) {
            try {
                status = this.performOfferingLocationCheck();
            }
            catch (InvocationTargetException ite) {
                AgentUI.reportException(ite);
                return false;
            }
            catch (InterruptedException ie) {
                AgentUI.reportException(ie);
                return false;
            }
        }
        this.setLocationCheckStatus((IStatus)status);
        this.reportErrorOnPage((IStatus)status, LOCATION_CHECK_ERROR, LOCATION_CHECK_WARNING);
        return !StatusUtil.isErrorOrCancel((IStatus)status);
    }

    private IStatus performOfferingLocationCheck() throws InvocationTargetException, InterruptedException {
        Status[] result = new Status[1];
        Profile[] profileArray = (Profile[])this.getSelections();
        CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress((IStatus[])result, profileArray){
            private final /* synthetic */ IStatus[] val$result;
            private final /* synthetic */ Profile[] val$profileArray;
            {
                this.val$result = iStatusArray;
                this.val$profileArray = profileArray;
            }

            public void run(IProgressMonitor monitor) {
                SplitProgressMonitor pm = new SplitProgressMonitor(monitor, new int[]{2, 1});
                ModifyProfileSelectionPage.this.loadServiceRepositoriesForInstalledOfferingsInSelectedProfile(pm.next());
                this.val$result[0] = LocationCheckManager.getInstance().perform(this.val$profileArray[0], AgentJob.AgentJobType.MODIFY_JOB, pm.next());
            }
        });
        return result[0];
    }
}

