/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.SubstitutionOperation;
import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.agent.core.sharedUI.ProfileOffering;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.AgentUILabelProvider;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.parts.TreeMasterPart;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.internal.ui.utils.DefaultLicenseSelection;
import com.ibm.cic.agent.internal.ui.utils.ProfileOfferingFeature;
import com.ibm.cic.agent.internal.ui.wizards.LicensesByPackagePage;
import com.ibm.cic.common.core.model.IFeatureBase;
import com.ibm.cic.common.core.model.IFeatureGroup;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.LicenseUtils;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.ui.internal.CommonImages;
import com.ibm.cic.common.ui.parts.IFormContext;
import com.ibm.cic.common.ui.services.UiServices;
import com.ibm.cic.licensing.common.util.LicenseStatus;
import com.ibm.cic.licensing.common.util.PolicyManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class LicensesByPackageSection
extends TreeMasterPart {
    private Button importLicenseButton;
    private Button setupFlexButton;
    private final LicensesByPackagePage wizardPage;
    private final DefaultLicenseSelection defaultSelection;
    private StackLayout stackLayout;
    private Composite commonOfferingBtnComp;
    private Composite teamProductBtnComp;
    private Label teamProductLabel;
    private Button teamProductButton;
    private final Map teamProductConfigurationMap = new HashMap();

    public LicensesByPackageSection(IFormContext context, Composite parent, DefaultLicenseSelection defaultSelection, LicensesByPackagePage wizardPage) {
        super(context, parent, 4096, new String[0], 512);
        this.defaultSelection = defaultSelection;
        PolicyManager.reload((String)AgentUI.getDefault().getAgent().getLicensePolicyFile().getAbsolutePath());
        this.configureViewer(this.getTreePart().getTreeViewer());
        this.getSection().setText(Messages.LicenseManagementPage_header);
        this.wizardPage = wizardPage;
    }

    @Override
    protected void configureViewer(TreeViewer viewer) {
        super.configureViewer(viewer);
        viewer.setLabelProvider((IBaseLabelProvider)new LBPLabelProvider());
        viewer.setContentProvider((IContentProvider)new InstalledPackagesContentProvider());
        viewer.setSorter((ViewerSorter)new LicenseByPackageSorter());
        this.createColumns(viewer);
        viewer.setInput((Object)AgentUI.getDefault().getAgent());
        viewer.addSelectionChangedListener((ISelectionChangedListener)new ViewerListener());
        viewer.expandAll();
        Tree tree = viewer.getTree();
        if (tree.getItemCount() > 0) {
            TreeItem item = tree.getItem(0);
            tree.setTopItem(item);
        }
    }

    private TreeColumn createColumn(Tree tree, String name) {
        TreeColumn column = new TreeColumn(tree, 0x800000);
        column.setText(name);
        return column;
    }

    private void createColumns(TreeViewer viewer) {
        Tree tree = viewer.getTree();
        tree.setHeaderVisible(true);
        this.createColumn(tree, Messages.LicenseManagementPage_columnName);
        this.createColumn(tree, Messages.LicenseManagementPage_columnVendor);
        this.createColumn(tree, Messages.LicenseManagementPage_columnLicenseType);
        this.createColumn(tree, Messages.LicenseManagementPage_columnLicenseExpiration);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(54, 385, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(11, 80, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(14, 100, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, 140, true));
        tree.setLayout((Layout)tableLayout);
    }

    @Override
    public IBaseLabelProvider getLabelProvider() {
        return this.getTreePart().getTreeViewer().getLabelProvider();
    }

    @Override
    protected TreeViewer createTreeViewer(Composite parent, int style) {
        if (style == 0) {
            style = this.getToolkit().getBorderStyle() | 4;
        }
        TreeViewer viewer = new TreeViewer(parent, style);
        this.getContext().getForm().getToolkit().adapt(viewer.getControl(), true, true);
        viewer.addFilter((ViewerFilter)new DefaultSelectionFilter());
        return viewer;
    }

    @Override
    public void primeSelection() {
        TreeViewer viewer = this.getTreePart().getTreeViewer();
        if (viewer != null) {
            if (this.defaultSelection != null) {
                ProfileOffering profileOffering = this.defaultSelection.getProfileOffering();
                if (profileOffering != null) {
                    viewer.setSelection((ISelection)new StructuredSelection((Object)profileOffering));
                    if (this.defaultSelection.getLicenceSelection() == 1 && this.setupFlexButton.isEnabled()) {
                        this.setupFlexButton.setSelection(true);
                    } else if (this.defaultSelection.getLicenceSelection() == 0 && this.importLicenseButton.isEnabled()) {
                        this.importLicenseButton.setSelection(true);
                    }
                }
            } else {
                TreeItem item;
                Tree tree = viewer.getTree();
                if (tree.getItemCount() > 0 && (item = tree.getItem(0)).getItemCount() > 0) {
                    TreeItem childItem = item.getItem(0);
                    viewer.setSelection((ISelection)new StructuredSelection(childItem.getData()));
                }
            }
        }
    }

    @Override
    public void showURL(String url) {
        AgentUI.getDefault().showURL(url);
    }

    @Override
    protected Control createFilterButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.stackLayout = new StackLayout();
        composite.setLayout((Layout)this.stackLayout);
        composite.setLayoutData((Object)new GridData(1, 1, true, false));
        this.commonOfferingBtnComp = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.commonOfferingBtnComp.setLayout((Layout)layout);
        GridData gd = new GridData(1, 1, true, false);
        this.commonOfferingBtnComp.setLayoutData((Object)gd);
        Label importLicenseLabel = new Label(this.commonOfferingBtnComp, 64);
        importLicenseLabel.setText(Messages.ManageLicenseWizardPage_importLicenseLabel);
        importLicenseLabel.setLayoutData((Object)new GridData(4, 1, true, false));
        this.importLicenseButton = new Button(this.commonOfferingBtnComp, 16);
        this.importLicenseButton.setText(Messages.LicenseManagementPage_installLumkitButton);
        this.importLicenseButton.setEnabled(false);
        this.importLicenseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicensesByPackageSection.this.setupFlexButton.setSelection(!LicensesByPackageSection.this.importLicenseButton.getSelection());
                LicensesByPackageSection.this.sendSelectionChangedEvent();
            }
        });
        Label configureLicenseLabel = new Label(this.commonOfferingBtnComp, 64);
        configureLicenseLabel.setText(Messages.ManageLicenseWizardPage_configureLicenseLabel);
        configureLicenseLabel.setLayoutData((Object)new GridData(4, 1, true, false));
        this.setupFlexButton = new Button(this.commonOfferingBtnComp, 16);
        this.setupFlexButton.setText(Messages.LicenseManagementPage_flexButton);
        this.setupFlexButton.setEnabled(false);
        this.setupFlexButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicensesByPackageSection.this.importLicenseButton.setSelection(!LicensesByPackageSection.this.setupFlexButton.getSelection());
                LicensesByPackageSection.this.sendSelectionChangedEvent();
            }
        });
        this.teamProductBtnComp = new Composite(composite, 0);
        this.teamProductBtnComp.setLayout((Layout)new GridLayout());
        this.teamProductBtnComp.setLayoutData((Object)new GridData(1, 1, true, false));
        this.teamProductLabel = new Label(this.teamProductBtnComp, 64);
        GridData data = new GridData(4, 1, true, false);
        data.widthHint = 700;
        this.teamProductLabel.setLayoutData((Object)data);
        this.teamProductButton = new Button(this.teamProductBtnComp, 8);
        this.teamProductButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selectedObj;
                StructuredSelection structuredSelection;
                ISelection selection = LicensesByPackageSection.this.getTreePart().getTreeViewer().getSelection();
                if (selection != null && selection instanceof StructuredSelection && !(structuredSelection = (StructuredSelection)selection).isEmpty() && (selectedObj = structuredSelection.getFirstElement()) instanceof ProfileOffering) {
                    IOffering offering = ((ProfileOffering)selectedObj).getOffering();
                    Profile profile = ((ProfileOffering)selectedObj).getProfile();
                    if (offering != null && LicensesByPackageSection.this.hasExternalLicenseTool(offering)) {
                        boolean launchExternalToolSuccess = false;
                        try {
                            String path = LicensesByPackageSection.this.getExternalToolPath(offering);
                            SubstitutionOperation operation = new SubstitutionOperation(LicensesByPackageSection.this.getInstallContext(profile));
                            String command = operation.performVariableSubstitutions(path);
                            launchExternalToolSuccess = UiServices.getInstance().launchProgram(command);
                        }
                        catch (Exception exception) {
                            launchExternalToolSuccess = false;
                        }
                        LicensesByPackageSection.this.teamProductConfigurationMap.put(offering, launchExternalToolSuccess);
                        LicensesByPackageSection.this.sendSelectionChangedEvent();
                    }
                }
            }
        });
        return composite;
    }

    private InstallContext getInstallContext(Profile profile) {
        String contextId = profile.getData("eclipseContext");
        if (contextId == null) {
            return profile.getRootContext();
        }
        InstallContext context = profile.findInstallContext(contextId);
        if (context == null) {
            return profile.getRootContext();
        }
        return context;
    }

    private void handleSelectionChangedEvent(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            Object selectedObj = structuredSelection.getFirstElement();
            if (selectedObj instanceof ProfileOffering) {
                IOffering offering = ((ProfileOffering)selectedObj).getOffering();
                if (offering == null) {
                    return;
                }
                if (this.hasExternalLicenseTool(offering)) {
                    this.stackLayout.topControl = this.teamProductBtnComp;
                    this.teamProductLabel.setText(this.getLicenseDescription(offering));
                    this.teamProductButton.setText(this.getExternalToolLabel(offering));
                    this.teamProductButton.setEnabled(true);
                    this.teamProductBtnComp.layout();
                    this.teamProductBtnComp.getParent().layout();
                } else {
                    this.stackLayout.topControl = this.commonOfferingBtnComp;
                    this.commonOfferingBtnComp.getParent().layout();
                    if (this.importLicenseButton != null && this.setupFlexButton != null) {
                        if (LicenseUtils.isOfferingFlexlmApplicable((IOffering)offering) || LicenseUtils.isOfferingFloatingEnabled((IOffering)offering)) {
                            this.setupFlexButton.setEnabled(true);
                        } else {
                            this.setupFlexButton.setSelection(false);
                            this.setupFlexButton.setEnabled(false);
                        }
                        if (LicenseUtils.isOfferingLumApplicable((IOffering)offering)) {
                            if (LicenseUtils.isOfferingLumPermanent((IOffering)offering) && !LicensesByPackageSection.isRbdRdiSoaOffering(offering)) {
                                this.importLicenseButton.setSelection(false);
                                this.importLicenseButton.setEnabled(false);
                            } else {
                                this.importLicenseButton.setEnabled(true);
                            }
                        } else {
                            this.importLicenseButton.setSelection(false);
                            this.importLicenseButton.setEnabled(false);
                        }
                    }
                }
            } else if (selectedObj instanceof ProfileNode) {
                List versions = ((ProfileNode)selectedObj).getVersions();
                if (versions.size() > 0) {
                    IOffering offering = ((ProfileOffering)versions.get(0)).getOffering();
                    if (this.hasExternalLicenseTool(offering)) {
                        this.stackLayout.topControl = this.teamProductBtnComp;
                        this.teamProductLabel.setText(this.getLicenseDescription(offering));
                        this.teamProductButton.setText(this.getExternalToolLabel(offering));
                        this.teamProductButton.setEnabled(false);
                        this.teamProductBtnComp.layout();
                        this.teamProductBtnComp.getParent().layout();
                    } else {
                        this.stackLayout.topControl = this.commonOfferingBtnComp;
                        this.commonOfferingBtnComp.getParent().layout();
                        this.importLicenseButton.setSelection(false);
                        this.importLicenseButton.setEnabled(false);
                        this.setupFlexButton.setSelection(false);
                        this.setupFlexButton.setEnabled(false);
                    }
                }
            } else if (selectedObj instanceof FeatureOrGroupNode) {
                this.stackLayout.topControl = this.commonOfferingBtnComp;
                this.commonOfferingBtnComp.getParent().layout();
                if (this.importLicenseButton != null && this.setupFlexButton != null) {
                    FeatureOrGroupNode featureOrGroupNode = (FeatureOrGroupNode)selectedObj;
                    IOffering offering = featureOrGroupNode.profileOffering.getOffering();
                    IFeatureBase featureBase = featureOrGroupNode.getFeatureOrGroup();
                    if (offering != null && featureBase != null && LicenseUtils.isFeatureFlexlmApplicable((IOffering)offering, (IFeatureBase)featureBase)) {
                        this.setupFlexButton.setEnabled(true);
                    } else {
                        this.setupFlexButton.setSelection(false);
                        this.setupFlexButton.setEnabled(false);
                    }
                    if (offering != null && featureBase != null) {
                        IInstallableUnit iu = LicenseUtils.getFeatureIplaUnit((IOffering)offering, (IFeatureBase)featureBase);
                        if (iu != null) {
                            if (LicenseUtils.isFeatureLumPermanent((IOffering)offering, (IFeatureBase)featureBase)) {
                                this.importLicenseButton.setSelection(false);
                                this.importLicenseButton.setEnabled(false);
                            } else {
                                this.importLicenseButton.setEnabled(true);
                            }
                        } else {
                            this.importLicenseButton.setSelection(false);
                            this.importLicenseButton.setEnabled(false);
                        }
                    } else {
                        this.importLicenseButton.setSelection(false);
                        this.importLicenseButton.setEnabled(false);
                    }
                }
            }
        }
        this.sendSelectionChangedEvent();
    }

    private void sendSelectionChangedEvent() {
        ISelection selection;
        if (this.wizardPage != null && (selection = this.getViewerSelection()) instanceof IStructuredSelection) {
            this.wizardPage.setSelection(((IStructuredSelection)selection).toArray());
        }
    }

    public boolean importLicense() {
        if (this.stackLayout.topControl == this.commonOfferingBtnComp) {
            return this.importLicenseButton.isEnabled() && this.importLicenseButton.getSelection();
        }
        return false;
    }

    public boolean configLicenseServer() {
        if (this.stackLayout.topControl == this.commonOfferingBtnComp) {
            return this.setupFlexButton.isEnabled() && this.setupFlexButton.getSelection();
        }
        return false;
    }

    public boolean configureTeamProductLicense() {
        if (this.stackLayout.topControl == this.teamProductBtnComp) {
            IOffering offering;
            Object selectedObj;
            StructuredSelection structuredSelection;
            ISelection selection;
            if (this.teamProductButton.isEnabled() && (selection = this.getTreePart().getTreeViewer().getSelection()) != null && selection instanceof StructuredSelection && !(structuredSelection = (StructuredSelection)selection).isEmpty() && (selectedObj = structuredSelection.getFirstElement()) instanceof ProfileOffering && (offering = ((ProfileOffering)selectedObj).getOffering()) != null && this.hasExternalLicenseTool(offering)) {
                Boolean configuredSuccess = (Boolean)this.teamProductConfigurationMap.get(offering);
                if (configuredSuccess != null) {
                    return configuredSuccess;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public ProfileOfferingFeature getSelectedProfileOfferingFeature() {
        ISelection selection = this.getViewerSelection();
        if (selection instanceof IStructuredSelection) {
            Object selectedObject = ((IStructuredSelection)selection).getFirstElement();
            if (selectedObject instanceof ProfileOffering) {
                return new ProfileOfferingFeature((ProfileOffering)selectedObject);
            }
            if (selectedObject instanceof FeatureOrGroupNode) {
                FeatureOrGroupNode featureOrGroupNode = (FeatureOrGroupNode)selectedObject;
                ProfileOfferingFeature pof = new ProfileOfferingFeature(featureOrGroupNode.profileOffering);
                pof.setFeatureOrGroup(featureOrGroupNode.getFeatureOrGroup());
                return pof;
            }
        }
        return null;
    }

    private boolean hasExternalLicenseTool(IOffering offering) {
        return LicenseUtils.hasExternalLicenseManager((IOffering)offering);
    }

    private String getLicenseDescription(IOffering offering) {
        return LicenseUtils.getExternalLicenseManagerDescription((IOffering)offering);
    }

    private String getExternalToolLabel(IOffering offering) {
        return LicenseUtils.getExternalLicenseManagerCommandLabel((IOffering)offering);
    }

    private String getExternalToolPath(IOffering offering) {
        return LicenseUtils.getExternalLicenseManagerCommand((IOffering)offering);
    }

    private static boolean isRbdRdiSoaOffering(IOffering offering) {
        IInstallableUnit[] iplaUnits = LicenseUtils.getIplaUnits((IOffering)offering);
        if (iplaUnits.length > 0) {
            IInstallableUnit unit = iplaUnits[0];
            String lumid = unit.getProperties().getProperty("enablement.lum.id");
            String lumversion = unit.getProperties().getProperty("enablement.lum.version");
            return lumid.equals("35") && LicenseUtils.isPre75RbdLumVersion((String)lumversion);
        }
        return false;
    }

    private class DefaultSelectionFilter
    extends ViewerFilter {
        private DefaultSelectionFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (LicensesByPackageSection.this.defaultSelection == null) {
                return true;
            }
            ProfileOffering defaultSelectedProfileOffering = LicensesByPackageSection.this.defaultSelection.getProfileOffering();
            if (defaultSelectedProfileOffering == null) {
                return true;
            }
            if (element instanceof ProfileNode) {
                Profile profile = defaultSelectedProfileOffering.getProfile();
                return ((ProfileNode)element).getProfile().equals(profile);
            }
            if (element instanceof ProfileOffering) {
                return element.equals(defaultSelectedProfileOffering);
            }
            return true;
        }
    }

    private static class FeatureOrGroupNode {
        private final IFeatureBase featureOrGroup;
        ProfileOffering profileOffering;

        FeatureOrGroupNode(IFeatureBase featureOrGroup) {
            this.featureOrGroup = featureOrGroup;
        }

        IFeatureBase getFeatureOrGroup() {
            return this.featureOrGroup;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof FeatureOrGroupNode) {
                return ((FeatureOrGroupNode)obj).getFeatureOrGroup().equals(this.featureOrGroup);
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return this.featureOrGroup.hashCode();
        }
    }

    private static class InstalledPackagesContentProvider
    implements ITreeContentProvider,
    IPropertyChangeListener {
        private InstalledPackagesContentProvider() {
        }

        private boolean showThisProfile(String profileKind) {
            return !profileKind.equals("self") && !profileKind.equals("license");
        }

        private boolean showThisOffering(ProfileOffering profileOffering) {
            IOffering offering = profileOffering.getOffering();
            if (offering == null) {
                return false;
            }
            return LicenseUtils.isOfferingLumApplicable((IOffering)offering) || LicenseUtils.isOfferingFlexlmApplicable((IOffering)offering) || LicenseUtils.hasExternalLicenseManager((IOffering)offering);
        }

        private Object[] getProfileNodes(Agent agent) {
            Profile[] profiles;
            ArrayList<ProfileNode> profileNodes = new ArrayList<ProfileNode>();
            Profile[] profileArray = profiles = agent.getVisibleProfiles();
            int n = profiles.length;
            int n2 = 0;
            while (n2 < n) {
                Profile profile = profileArray[n2];
                if (this.showThisProfile(profile.getProfileKind())) {
                    ProfileOffering[] profileOfferings = ProfileOffering.getOfferingsFromProfile((Profile)profile);
                    ProfileNode profileNode = new ProfileNode(profile);
                    ProfileOffering[] profileOfferingArray = profileOfferings;
                    int n3 = profileOfferings.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ProfileOffering profileOffering = profileOfferingArray[n4];
                        if (this.showThisOffering(profileOffering)) {
                            profileNode.addVersionNode(profileOffering);
                        }
                        ++n4;
                    }
                    List offerings = profileNode.getVersions();
                    if (offerings != null && !offerings.isEmpty()) {
                        profileNodes.add(profileNode);
                    }
                }
                ++n2;
            }
            return profileNodes.toArray();
        }

        private Object[] generateFeatureOrGroupNodes(ProfileOffering profileOffering) {
            Profile profile;
            IOffering offering = profileOffering.getOffering();
            IFeatureBase[] installedVisibleLicensedFeatureOrGroups = AgentUIUtils.getInstalledVisibleLicensedFeatureOrGroup(offering, profile = profileOffering.getProfile());
            if (installedVisibleLicensedFeatureOrGroups == null || installedVisibleLicensedFeatureOrGroups.length == 0) {
                return new Object[0];
            }
            ArrayList<FeatureOrGroupNode> return_result = new ArrayList<FeatureOrGroupNode>();
            IFeatureBase[] iFeatureBaseArray = installedVisibleLicensedFeatureOrGroups;
            int n = installedVisibleLicensedFeatureOrGroups.length;
            int n2 = 0;
            while (n2 < n) {
                IFeatureBase installedVisibleLicensedFeatureOrGroup = iFeatureBaseArray[n2];
                FeatureOrGroupNode node = new FeatureOrGroupNode(installedVisibleLicensedFeatureOrGroup);
                node.profileOffering = profileOffering;
                return_result.add(node);
                ++n2;
            }
            return return_result.toArray();
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Agent) {
                return this.getProfileNodes((Agent)parentElement);
            }
            if (parentElement instanceof ProfileNode) {
                return ((ProfileNode)parentElement).getVersions().toArray();
            }
            if (parentElement instanceof ProfileOffering) {
                return this.generateFeatureOrGroupNodes((ProfileOffering)parentElement);
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void propertyChange(PropertyChangeEvent event) {
        }
    }

    private static class LBPLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider,
    ITableFontProvider {
        private Font boldFont;
        private final Image profileImage;
        private final Image featureGroupImage;
        private final Image featureImage;
        private final AgentUILabelProvider labelProvider = AgentUI.getDefault().getLabelProvider();

        public LBPLabelProvider() {
            this.labelProvider.connect((Object)this);
            this.profileImage = this.labelProvider.get(CommonImages.DESC_PROFILE_OBJ);
            this.featureGroupImage = this.labelProvider.get(CommonImages.DESC_FEATUREGROUP_OBJ);
            this.featureImage = this.labelProvider.get(CommonImages.DESC_FEATURE_OBJ);
        }

        public Image getImage(Object obj) {
            if (obj instanceof ProfileNode) {
                return this.profileImage;
            }
            if (obj instanceof ProfileOffering) {
                IOffering offering = ((ProfileOffering)obj).getOffering();
                return this.labelProvider.getOfferingImage(offering);
            }
            if (obj instanceof FeatureOrGroupNode) {
                IFeatureBase featureOrGroup = ((FeatureOrGroupNode)obj).getFeatureOrGroup();
                if (featureOrGroup instanceof IFeatureGroup) {
                    return this.featureGroupImage;
                }
                return this.featureImage;
            }
            return null;
        }

        public String getText(Object obj) {
            if (obj instanceof ProfileNode) {
                return ((ProfileNode)obj).getName();
            }
            if (obj instanceof ProfileOffering) {
                ProfileOffering profileOffering = (ProfileOffering)obj;
                return AgentUIUtils.getOfferingOrFixLabel((IOfferingOrFix)profileOffering.getOffering());
            }
            if (obj instanceof FeatureOrGroupNode) {
                IFeatureBase featureOrGroup = ((FeatureOrGroupNode)obj).getFeatureOrGroup();
                return SharedUIUtils.getFeatureBaseLabel((IFeatureBase)featureOrGroup);
            }
            return super.getText(obj);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return this.getImage(element);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.getText(element);
                }
                case 1: {
                    if (!(element instanceof ProfileOffering)) break;
                    return ((ProfileOffering)element).getOffering().getProperties().getProperty("vendor.name", "");
                }
                case 2: {
                    if (element instanceof ProfileOffering) {
                        return LicenseUtils.getRuntimeLicenseKinds((IOffering)((ProfileOffering)element).getOffering(), (int)1);
                    }
                    if (!(element instanceof FeatureOrGroupNode)) break;
                    IFeatureBase featureOrGroup = ((FeatureOrGroupNode)element).getFeatureOrGroup();
                    IOffering offering = ((FeatureOrGroupNode)element).profileOffering.getOffering();
                    IInstallableUnit iu = LicenseUtils.getFeatureIplaUnit((IOffering)offering, (IFeatureBase)featureOrGroup);
                    if (iu == null) break;
                    return LicenseUtils.getRuntimeLicenseKind((IInstallableUnit)iu);
                }
                case 3: {
                    LicenseStatus status;
                    if (element instanceof ProfileOffering) {
                        LicenseStatus[] status2 = LicenseUtils.getRuntimeLicenseStatusArray((IOffering)((ProfileOffering)element).getOffering(), (int)1);
                        if (status2.length <= 0) break;
                        return AgentUIUtils.getLicenseExpirationDateLabel(status2[0]);
                    }
                    if (!(element instanceof FeatureOrGroupNode)) break;
                    IFeatureBase featureOrGroup = ((FeatureOrGroupNode)element).getFeatureOrGroup();
                    IOffering offering = ((FeatureOrGroupNode)element).profileOffering.getOffering();
                    IInstallableUnit iu = LicenseUtils.getFeatureIplaUnit((IOffering)offering, (IFeatureBase)featureOrGroup);
                    if (iu == null || (status = LicenseUtils.getRuntimeLicenseStatus((IInstallableUnit)iu)) == null) break;
                    return AgentUIUtils.getLicenseExpirationDateLabel(status);
                }
            }
            return "";
        }

        public Color getForeground(Object element, int columnIndex) {
            return null;
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }

        public Font getFont(Object element, int columnIndex) {
            String defaultProfile;
            if (element instanceof Profile && (defaultProfile = AgentUI.getDefault().getAgentPreferenceStore().getString(ICicPreferenceConstants.DEFAULT_PROFILE.key())).equals(((Profile)element).getProfileId())) {
                if (this.boldFont == null) {
                    FontData[] data = JFaceResources.getDefaultFont().getFontData();
                    this.boldFont = JFaceResources.getFontRegistry().getBold(data[0].getName());
                }
                return this.boldFont;
            }
            return JFaceResources.getDefaultFont();
        }

        public void dispose() {
            this.labelProvider.disconnect((Object)this);
            super.dispose();
        }
    }

    private static class LicenseByPackageSorter
    extends ViewerSorter {
        private LicenseByPackageSorter() {
        }

        public int category(Object element) {
            if (element instanceof FeatureOrGroupNode) {
                IFeatureBase featureOrGroup = ((FeatureOrGroupNode)element).getFeatureOrGroup();
                if (featureOrGroup instanceof IFeatureGroup) {
                    return 1;
                }
                return 2;
            }
            return super.category(element);
        }
    }

    private static class ProfileNode
    implements IAdaptable {
        private final List versions = new ArrayList();
        private final Profile profile;

        public ProfileNode(Profile profile) {
            this.profile = profile;
        }

        public void addVersionNode(ProfileOffering profileOffering) {
            this.versions.add(profileOffering);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof ProfileNode) {
                return ((ProfileNode)obj).getProfile().equals(this.profile);
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return this.profile.hashCode();
        }

        public List getVersions() {
            return this.versions;
        }

        public String getName() {
            return this.profile.getProfileId();
        }

        public Profile getProfile() {
            return this.profile;
        }

        public Object getAdapter(Class adapter) {
            if (adapter == IProfile.class || adapter == Profile.class) {
                return this.getProfile();
            }
            return null;
        }
    }

    public class ViewerListener
    implements ISelectionChangedListener {
        Object previousSelection = null;

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = event.getSelection();
            if (selection instanceof StructuredSelection) {
                Object selectedObj = ((StructuredSelection)selection).getFirstElement();
                if (selectedObj != null && !selectedObj.equals(this.previousSelection)) {
                    LicensesByPackageSection.this.handleSelectionChangedEvent(event);
                }
                this.previousSelection = selectedObj;
            }
        }
    }
}

