/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.BitModeUtils;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.AgentUIDependenciesCheckUtils;
import com.ibm.cic.agent.internal.ui.utils.AgentUIRegressingUpdateWarningUtil;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.internal.ui.wizards.AbstractAgentUIPrimaryPage;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.agent.internal.ui.wizards.AvailableOfferingDetailPage;
import com.ibm.cic.agent.internal.ui.wizards.AvailableUpdateSection;
import com.ibm.cic.agent.internal.ui.wizards.IAvailableOfferingPage;
import com.ibm.cic.agent.internal.ui.wizards.PrimaryUpdateWizard;
import com.ibm.cic.agent.internal.ui.wizards.UpdateFixPage;
import com.ibm.cic.agent.internal.ui.wizards.UpdateWizard;
import com.ibm.cic.common.core.model.FixUtil;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.dialogs.WrapDetailUIDErrorDialog;
import com.ibm.cic.common.ui.parts.IFormContext;
import com.ibm.cic.common.ui.parts.TreeSection;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import com.ibm.cic.common.ui.wizards.CustomMessageWizardPage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IDetailsPage;

public class AvailableUpdatePage
extends AbstractAgentUIPrimaryPage
implements IAvailableOfferingPage {
    public static final CustomMessageWizardPage.WarningId VALIDATE_UPDATE_WARNING = new CustomMessageWizardPage.WarningId();
    private AvailableUpdateSection updateSection;
    protected AvailableOfferingDetailPage offeringDetailPage;
    private boolean shouldSkip = false;
    private boolean validUpdates = false;
    private final PrimaryUpdateWizard primaryUpdateWizard;
    private IStatus serviceReposStatus = Status.OK_STATUS;
    private boolean needPrepareResolveAgain = false;
    protected boolean isUpdateAll = false;
    private List previousSelectedJobs = null;
    private List previousSelectedOnlyFixesOfferings = null;

    public IStatus getServiceReposStatus() {
        return this.serviceReposStatus;
    }

    @Override
    protected IDetailsPage createDetailsSection() {
        this.offeringDetailPage = new AvailableOfferingDetailPage(this);
        return this.offeringDetailPage;
    }

    public void setServiceReposStatus(IStatus serviceReposStatus) {
        this.serviceReposStatus = serviceReposStatus;
    }

    public AvailableUpdatePage(String title, String description, PrimaryUpdateWizard primaryUpdateWizard) {
        super(title, description, primaryUpdateWizard);
        this.primaryUpdateWizard = primaryUpdateWizard;
        super.setHelpRef("com.ibm.cic.agent.ui.AvailableUpdatePage");
    }

    @Override
    protected AgentUIWizard createInnerWizard() {
        UpdateWizard innerWizard = new UpdateWizard();
        innerWizard.setUpdateAll(this.isUpdateAll);
        return innerWizard;
    }

    protected Profile[] getProfiles() {
        return this.primaryUpdateWizard.getSelectedProfiles();
    }

    public void updateButtons() {
        IWizardContainer container = this.getContainer();
        if (container != null) {
            container.updateButtons();
        }
    }

    protected PrimaryUpdateWizard getPrimaryUpdateWizard() {
        return this.primaryUpdateWizard;
    }

    @Override
    protected TreeSection createTreeSection(IFormContext context, Composite parent) {
        this.updateSection = new AvailableUpdateSection(context, parent, this);
        return this.updateSection;
    }

    protected AvailableUpdateSection getTreeSection() {
        return this.updateSection;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.updateSection.checkInputChanged();
            this.updateSection.setFocus();
        }
    }

    @Override
    public boolean canFlipToNextPage() {
        if (!this.updateSection.hasInstallableNodeSelected()) {
            return false;
        }
        if (this.neededJobNotSelected()) {
            return false;
        }
        return this.validUpdates;
    }

    private boolean neededJobNotSelected() {
        return !this.updateSection.hasFixesForInstalledOfferings() && !this.primaryUpdateWizard.hasSelectedJob() || !this.updateSection.hasUpdateOfferings() && !this.primaryUpdateWizard.hasSelectedJob();
    }

    @Override
    public boolean isPageComplete() {
        if (this.shouldSkip()) {
            return true;
        }
        if (this.neededJobNotSelected()) {
            return false;
        }
        return this.validUpdates;
    }

    public UpdateFixPage getUpdateFixPage() {
        IWizardPage nextPage = this.primaryUpdateWizard.getNextPage((IWizardPage)this);
        if (nextPage instanceof UpdateFixPage) {
            return (UpdateFixPage)nextPage;
        }
        return null;
    }

    public boolean selectionChanged() {
        List currentSelectedJobs = this.getPrimaryUpdateWizard().getSelectedJobs();
        if (this.previousSelectedJobs == null || !this.previousSelectedJobs.equals(currentSelectedJobs)) {
            return true;
        }
        List currentSelectedOnlyFixesOfferings = this.updateSection.getUpdateOnlyFixesOfferings();
        return this.previousSelectedOnlyFixesOfferings == null || !this.previousSelectedOnlyFixesOfferings.equals(currentSelectedOnlyFixesOfferings);
    }

    @Override
    public IWizardPage getNextPage() {
        IWizardPage nextPage = this.primaryUpdateWizard.getNextPage((IWizardPage)this);
        this.primaryUpdateWizard.setConstructedWizard(this.getConstructedWizard());
        boolean selectionChanged = false;
        List currentSelectedJobs = this.getPrimaryUpdateWizard().getSelectedJobs();
        if (this.previousSelectedJobs == null || !this.previousSelectedJobs.equals(currentSelectedJobs)) {
            this.previousSelectedJobs = currentSelectedJobs;
            selectionChanged = true;
        }
        List currentSelectedOnlyFixesOfferings = this.updateSection.getUpdateOnlyFixesOfferings();
        if (this.previousSelectedOnlyFixesOfferings == null || !this.previousSelectedOnlyFixesOfferings.equals(currentSelectedOnlyFixesOfferings)) {
            this.previousSelectedOnlyFixesOfferings = currentSelectedOnlyFixesOfferings;
            selectionChanged = true;
        }
        if (nextPage instanceof UpdateFixPage) {
            UpdateFixPage fixPage = (UpdateFixPage)nextPage;
            fixPage.setRebuildFixTree(selectionChanged);
            fixPage.setIsUpdateAll(this.isUpdateAll);
            if (this.isUpdateAll || !this.updateSection.hasUpdateOfferings()) {
                fixPage.setShouldSkip(true);
                if (selectionChanged) {
                    fixPage.setSelectedOfferingJobs(this.primaryUpdateWizard.getSelectedJobs());
                    fixPage.setFixJobs(new ArrayList(0));
                    fixPage.setSelection(null);
                }
                return fixPage.getNextPage();
            }
            if (selectionChanged) {
                final List selectedOfferingJobs = this.getSelectedOfferingJobs(this.primaryUpdateWizard.getSelectedJobs());
                fixPage.setSelectedOfferingJobs(selectedOfferingJobs);
                final Profile selectedProfile = this.getProfiles()[0];
                final List[] fixForSelectedOfferings = new ArrayList[]{new ArrayList()};
                final List[] fixForInstalledOfferings = new ArrayList[]{new ArrayList()};
                final IStatus[] dependencyStatus = new IStatus[1];
                try {
                    CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) {
                            monitor.beginTask(Messages.AvailableUpdatePage_searchFixes, 3);
                            HashSet processedFixes = new HashSet();
                            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
                            fixForSelectedOfferings[0] = AvailableUpdatePage.this.searchFixesForOfferings(AgentUIUtils.getSelectedOfferingsOrFixes(selectedOfferingJobs), selectedProfile, processedFixes, (IProgressMonitor)subMonitor);
                            subMonitor = new SubProgressMonitor(monitor, 1);
                            fixForInstalledOfferings[0] = AvailableUpdatePage.this.searchFixesForOfferings(AvailableUpdatePage.this.previousSelectedOnlyFixesOfferings, selectedProfile, processedFixes, (IProgressMonitor)subMonitor);
                            if (fixForSelectedOfferings[0].isEmpty() && fixForInstalledOfferings[0].isEmpty()) {
                                subMonitor = new SubProgressMonitor(monitor, 1);
                                AgentJob[] selectedOfferingJobArray = selectedOfferingJobs.toArray(new AgentJob[selectedOfferingJobs.size()]);
                                try {
                                    dependencyStatus[0] = AgentUIDependenciesCheckUtils.processDependencyStatus(AgentUIDependenciesCheckUtils.checkDependenciesProfilePrepareUnprepareFinal(selectedOfferingJobArray, (IProgressMonitor)subMonitor), false);
                                }
                                catch (CoreException e) {
                                    dependencyStatus[0] = new Status(4, "com.ibm.cic.agent.ui", Messages.AvailableOfferingPage_dependencyException, (Throwable)e);
                                }
                            }
                            monitor.done();
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    AgentUI.reportException(e);
                }
                catch (InterruptedException e) {
                    AgentUI.reportException(e);
                }
                if (fixForSelectedOfferings[0].isEmpty() && fixForInstalledOfferings[0].isEmpty()) {
                    if (StatusUtil.isErrorOrCancel((IStatus)dependencyStatus[0])) {
                        this.setErrorMessageWithStatus(dependencyStatus[0]);
                        if (dependencyStatus[0].isMultiStatus() && dependencyStatus[0].getChildren().length > 0) {
                            WrapDetailUIDErrorDialog errorDialog = new WrapDetailUIDErrorDialog(this.getShell(), com.ibm.cic.agent.core.sharedUI.Messages.UpdateValidationErrorDlg_title, Messages.UpdateValidationFailed_msg, dependencyStatus[0], 12);
                            errorDialog.open();
                        }
                        return this;
                    }
                    fixPage.setShouldSkip(true);
                    fixPage.setFixJobs(new ArrayList(0));
                    fixPage.setSelection(null);
                    return fixPage.getNextPage();
                }
                fixPage.setShouldSkip(false);
                fixForSelectedOfferings[0].addAll(fixForInstalledOfferings[0]);
                fixPage.setFixJobs(fixForSelectedOfferings[0]);
                return fixPage;
            }
            if (fixPage.shouldSkip()) {
                return fixPage.getNextPage();
            }
            return fixPage;
        }
        return nextPage;
    }

    private List searchFixesForOfferings(List offerings, Profile profile, HashSet processedFixes, IProgressMonitor monitor) {
        Agent agent = AgentUI.getDefault().getAgent();
        ArrayList<AbstractJob> fixJobs = new ArrayList<AbstractJob>();
        List allFixes = agent.findAllFixes(true, monitor);
        int i = 0;
        while (i < offerings.size()) {
            IOffering pOffering = (IOffering)offerings.get(i);
            if (pOffering != null) {
                for (IFix fix : allFixes) {
                    if (!FixUtil.isFixApplicable((IFix)fix, (IOffering)pOffering) || AgentUIUtils.isFixInstalled(fix, profile) || !BitModeUtils.checkSupportedPlatformsAgainstProfile((IOfferingOrFix)fix, (IProfile)profile).isOK() || !processedFixes.add(fix)) continue;
                    AbstractJob fixJob = this.primaryUpdateWizard.createJob(profile, (IOfferingOrFix)fix);
                    fixJobs.add(fixJob);
                }
            }
            ++i;
        }
        return fixJobs;
    }

    private List getSelectedOfferingJobs(List selectedJobs) {
        ArrayList<AbstractJob> return_result = new ArrayList<AbstractJob>();
        int i = 0;
        while (i < selectedJobs.size()) {
            AbstractJob job = (AbstractJob)selectedJobs.get(i);
            if (job.getOffering() != null) {
                return_result.add(job);
            }
            ++i;
        }
        return return_result;
    }

    public boolean shouldSkip() {
        return this.shouldSkip;
    }

    public void setShouldSkip(boolean skip) {
        this.shouldSkip = skip;
    }

    private IStatus prepareAndResolveJobs(List jobs, IProgressMonitor monitor) {
        return SharedUIUtils.prepareAndResolveSelectedJobs((List)(jobs != null ? jobs : this.primaryUpdateWizard.getJobs()), (IProgressMonitor)monitor);
    }

    public void validateSelectedUpdates(final List addedUpdates, final List deselectedUpdates) {
        try {
            final IStatus[] status = new IStatus[]{Status.OK_STATUS};
            CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    CicMultiStatus allStatus = Statuses.ST.createMultiStatus(com.ibm.cic.common.core.utils.Messages.MultipleWarnings, new Object[0]);
                    try {
                        try {
                            UpdateFixPage p;
                            int[] taskTicks = null;
                            if ((addedUpdates == null || addedUpdates.isEmpty()) && (deselectedUpdates == null || deselectedUpdates.isEmpty())) {
                                AvailableUpdatePage.this.needPrepareResolveAgain = true;
                            }
                            taskTicks = AvailableUpdatePage.this.needPrepareResolveAgain ? (deselectedUpdates == null || deselectedUpdates.isEmpty() ? new int[]{2, 2, 2} : new int[]{1, 2, 2, 2}) : (addedUpdates == null || addedUpdates.isEmpty() ? new int[]{1, 2, 2} : (deselectedUpdates == null || deselectedUpdates.isEmpty() ? new int[]{2, 2, 2} : new int[]{1, 2, 2, 2}));
                            SplitProgressMonitor sm = new SplitProgressMonitor(monitor, com.ibm.cic.agent.core.sharedUI.Messages.InstalledOfferingPage_validatePkgProgress, taskTicks);
                            if (deselectedUpdates != null && !deselectedUpdates.isEmpty()) {
                                ArrayList<IOfferingOrFix> unloadOfferingOrFixes = new ArrayList<IOfferingOrFix>();
                                int i = 0;
                                while (i < deselectedUpdates.size()) {
                                    IOfferingOrFix offeringOrFix = ((AgentJob)deselectedUpdates.get(i)).getOfferingOrFix();
                                    if (offeringOrFix != null) {
                                        unloadOfferingOrFixes.add(offeringOrFix);
                                    }
                                    ++i;
                                }
                                CicMultiStatus unloadStatus = Statuses.ST.createMultiStatus();
                                SplitProgressMonitor unloadMonitor = new SplitProgressMonitor(sm.next(), unloadOfferingOrFixes.size());
                                int i2 = 0;
                                while (i2 < unloadOfferingOrFixes.size()) {
                                    IOfferingOrFix offeringOrFix = (IOfferingOrFix)unloadOfferingOrFixes.get(i2);
                                    unloadStatus.add(Agent.getInstance().unloadAgentBundles(offeringOrFix, unloadMonitor.next()));
                                    ++i2;
                                }
                                if (!unloadStatus.isOK()) {
                                    AgentUI.reportStatus((IStatus)unloadStatus, false);
                                }
                            }
                            List selectedJobs = AvailableUpdatePage.this.primaryUpdateWizard.getSelectedJobs();
                            if (AvailableUpdatePage.this.needPrepareResolveAgain || addedUpdates != null && !addedUpdates.isEmpty()) {
                                List jobsToPrepare = addedUpdates;
                                if (AvailableUpdatePage.this.needPrepareResolveAgain) {
                                    jobsToPrepare = selectedJobs;
                                }
                                status[0] = AvailableUpdatePage.this.prepareAndResolveJobs(jobsToPrepare, sm.next());
                                allStatus.add(status[0]);
                                if (StatusUtil.isErrorOrCancel((IStatus)status[0]) || monitor.isCanceled()) {
                                    AvailableUpdatePage.this.needPrepareResolveAgain = true;
                                } else {
                                    AvailableUpdatePage.this.needPrepareResolveAgain = false;
                                }
                            }
                            AgentJob[] selectedJobsArray = AgentJob.toArray((Collection)selectedJobs);
                            if (AvailableUpdatePage.this.updateSection.hasUpdateOfferings()) {
                                if (!StatusUtil.isErrorOrCancel((IStatus)status[0])) {
                                    status[0] = AgentUtil.getOfferingsApplicability((List)selectedJobs, (AgentJob[])selectedJobsArray);
                                    allStatus.add(status[0]);
                                }
                                if (!StatusUtil.isErrorOrCancel((IStatus)status[0]) && selectedJobs != null && !selectedJobs.isEmpty()) {
                                    AbstractJob[] selectedJobArray = selectedJobs.toArray(new AbstractJob[selectedJobs.size()]);
                                    status[0] = AgentUI.getDefault().getAgent().checkInstall((AgentJob[])selectedJobArray, sm.next());
                                    allStatus.add(status[0]);
                                }
                            } else {
                                AgentJob[] deselectedJobArray;
                                IStatus unloadDependencyStatus;
                                SplitProgressMonitor spm = new SplitProgressMonitor(sm.next(), 3);
                                if (deselectedUpdates != null && StatusUtil.isErrorOrCancel((IStatus)(unloadDependencyStatus = AgentUIUtils.unloadAgentDependencyBundles(deselectedJobArray = deselectedUpdates.toArray(new AgentJob[deselectedUpdates.size()]), spm.next())))) {
                                    AgentUI.reportStatus(unloadDependencyStatus, false);
                                }
                                if (!StatusUtil.isErrorOrCancel((IStatus)status[0]) && selectedJobsArray.length > 0) {
                                    status[0] = AgentUIUtils.loadAgentDependencyBundles(selectedJobsArray, false, spm.next());
                                    allStatus.add(status[0]);
                                    if (!StatusUtil.isErrorOrCancel((IStatus)status[0])) {
                                        IStatus[] childrenStatus;
                                        IStatus dependencyStatus = AgentUIDependenciesCheckUtils.checkDependenciesFinalProfile(selectedJobsArray, spm.next());
                                        status[0] = !dependencyStatus.isOK() && dependencyStatus.isMultiStatus() ? ((childrenStatus = dependencyStatus.getChildren()) != null && childrenStatus.length == 1 ? childrenStatus[0] : dependencyStatus) : dependencyStatus;
                                        allStatus.add(status[0]);
                                    }
                                }
                            }
                            if (!StatusUtil.isErrorOrCancel((IStatus)status[0]) && (p = AvailableUpdatePage.this.getUpdateFixPage()) != null) {
                                List fixJobs = p.getFixJobs();
                                status[0] = fixJobs == null || AvailableUpdatePage.this.selectionChanged() ? AgentUIRegressingUpdateWarningUtil.checkRegressingUpdateWarningWithRecommendedFixes(selectedJobsArray, sm.next()) : AgentUIRegressingUpdateWarningUtil.checkRegressingUpdateWarningWithFixes(selectedJobsArray, AgentUIUtils.getSelectedJobs(fixJobs));
                                allStatus.add(status[0]);
                            }
                        }
                        catch (Exception e) {
                            if (!StatusUtil.isErrorOrCancel((IStatus)status[0])) {
                                status[0] = Statuses.ERROR.get((Throwable)e, e.toString(), new Object[0]);
                                allStatus.add(status[0]);
                            }
                            AvailableUpdatePage.this.needPrepareResolveAgain = true;
                            if (!StatusUtil.isErrorOrCancel((IStatus)status[0])) {
                                status[0] = StatusUtil.toSingleStatus((IStatus)allStatus);
                            }
                        }
                    }
                    finally {
                        if (!StatusUtil.isErrorOrCancel((IStatus)status[0])) {
                            status[0] = StatusUtil.toSingleStatus((IStatus)allStatus);
                        }
                    }
                }
            });
            if (StatusUtil.isErrorOrCancel((IStatus)status[0])) {
                IStatus multiStatus;
                this.updateSection.setShowAll();
                this.validUpdates = false;
                String errorMsg = status[0].getMessage().trim();
                if (errorMsg.length() > 0) {
                    this.setWarningState(VALIDATE_UPDATE_WARNING, null);
                    this.setErrorMessageWithStatus(status[0]);
                } else {
                    this.setWarningState(VALIDATE_UPDATE_WARNING, null);
                    this.setErrorMessage(Messages.AvailableUpdatePage_cannotUpdatePkg);
                }
                if (status[0].isMultiStatus() && (multiStatus = status[0]).getChildren().length > 0) {
                    DisplayKeeper.INSTANCE.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            String message = null;
                            if (multiStatus.getMessage().trim().length() == 0) {
                                message = Messages.AvailableUpdatePage_cannotUpdatePkg;
                            }
                            WrapDetailUIDErrorDialog errorDialog = new WrapDetailUIDErrorDialog(AgentUI.getActiveWorkbenchShell(), com.ibm.cic.common.core.sharedUI.Messages.DialogTitle_Error, message, multiStatus, 14);
                            errorDialog.open();
                        }
                    });
                }
            } else if (status[0].getSeverity() == 2) {
                this.validUpdates = true;
                this.setErrorMessage(null);
                this.setWarningMessageWithStatus(VALIDATE_UPDATE_WARNING, status[0]);
            } else {
                this.validUpdates = true;
                this.setErrorMessage(null);
                this.setWarningMessageWithStatus(VALIDATE_UPDATE_WARNING, null);
            }
            List selectedJobs = this.primaryUpdateWizard.getSelectedJobs();
            List<Object> currentSelectionList = null;
            Object[] currentSelectionArray = this.getSelections();
            currentSelectionList = currentSelectionArray == null ? new ArrayList<Object>() : Arrays.asList(currentSelectionArray);
            if (!AgentUIUtils.sameJobs(selectedJobs, currentSelectionList)) {
                Object[] jobs = selectedJobs.toArray(new AbstractJob[selectedJobs.size()]);
                this.setSelection(jobs);
                this.primaryUpdateWizard.setConstructedWizard(this.getConstructedWizard());
            }
        }
        catch (InvocationTargetException e) {
            AgentUI.reportException(e);
        }
        catch (InterruptedException e) {
            AgentUI.reportException(e);
        }
    }

    public boolean hasUpdate(boolean refresh) {
        return this.updateSection.checkUpdate(refresh);
    }

    public void setCurrentProfileList(List currentProfiles) {
        this.updateSection.setCurrentProfile(currentProfiles);
    }

    public void setUpdateAll(boolean updateAll) {
        this.isUpdateAll = updateAll;
    }

    public boolean hasFixesForInstalledOfferings() {
        return this.updateSection.hasFixesForInstalledOfferings();
    }

    @Override
    public boolean isShowAllChecked() {
        return this.updateSection.isShowAllChecked();
    }

    @Override
    public String messageHigherNotEntitledVersionsAreAvailable() {
        return com.ibm.cic.agent.internal.core.Messages.HigherVersionsNotAvailable_Update;
    }

    protected void refreshDetailPage() {
        if (this.offeringDetailPage != null) {
            this.offeringDetailPage.refreshDetails();
        }
    }
}

