/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.utils;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentRelaunch;
import com.ibm.cic.agent.core.InstallJob;
import com.ibm.cic.agent.core.UpdateOfferingJob;
import com.ibm.cic.agent.core.sharedUI.SharedUpdateAgentUtils;
import com.ibm.cic.agent.internal.ui.CheckAgentRequirementInteraction;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.common.core.internal.WebUiSafeProgressMonitor;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.SubtaskOnlyProgressMonitor;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.dialogs.WrapDetailUIDErrorDialog;
import com.ibm.cic.common.ui.internal.dialogs.YesNoErrorDialog;
import com.ibm.cic.common.ui.services.UiServices;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class UpdateAgentUtils {
    public static final int USER_CANCEL = -50;
    public static final int AGENT_UPDATE_NOT_REQUIRED = -51;

    public static IStatus checkForNewerVersionAgent(AbstractJob selectedAgentJob, AbstractJob[] newAgentJob, IProgressMonitor monitor) {
        SubProgressMonitor subMonitor = null;
        CicMultiStatus status = Statuses.ST.createMultiStatus(com.ibm.cic.agent.core.sharedUI.Messages.AvailableOfferingPage_newerIMMsg2, new Object[0]);
        monitor.beginTask(com.ibm.cic.agent.core.sharedUI.Messages.ProgressDialog_Checking_Agent_Update, 3);
        boolean otherServiceRepositoriesLoaded = SharedUpdateAgentUtils.areOtherServiceRepositoriesLoaded();
        try {
            subMonitor = new SubProgressMonitor(monitor, 1);
            final HashMap repLocationMsgMap = new HashMap();
            IOffering selectedAgentOffering = selectedAgentJob.getOffering();
            final IStatus loadServiceRepStatus = SharedUpdateAgentUtils.loadAgentServiceRepositories((IOffering)selectedAgentOffering, repLocationMsgMap, (IProgressMonitor)subMonitor);
            DisplayKeeper.INSTANCE.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell shell = CicCommonUiPlugin.getDefault().getTimeTriggeredProgressDlgShell();
                    if (shell != null) {
                        AgentUIUtils.reportRepositoryConnectionMsg(shell, loadServiceRepStatus, repLocationMsgMap);
                    }
                }
            });
            subMonitor = new SubProgressMonitor(monitor, 1);
            IOffering updateOffering = SharedUpdateAgentUtils.getAgentUpdateOfferingForSelectedAgentOffering((IOffering)selectedAgentOffering, (IProgressMonitor)subMonitor, (CicMultiStatus)status);
            if (updateOffering == null) {
                SharedUpdateAgentUtils.unloadServiceRepositories((boolean)otherServiceRepositoriesLoaded);
                CicMultiStatus cicMultiStatus = Statuses.ST.createMultiStatus(-51, "", new Object[0]);
                return cicMultiStatus;
            }
            newAgentJob[0] = new InstallJob((IOfferingOrFix)updateOffering);
            newAgentJob[0].setProfile(selectedAgentJob.getProfile());
            CheckAgentRequirementInteraction interaction = new CheckAgentRequirementInteraction(updateOffering, status, Messages.AvailableOfferingPage_offeringInstalledDlg_Continue, Messages.AvailableOfferingPage_offeringInstalledDlg_Cancel);
            DisplayKeeper.INSTANCE.getDisplay().syncExec((Runnable)interaction);
            status = interaction.getStatus();
            if (!status.isOK()) {
                SharedUpdateAgentUtils.unloadServiceRepositories((boolean)otherServiceRepositoriesLoaded);
                CicMultiStatus cicMultiStatus = status;
                return cicMultiStatus;
            }
            Agent agent = Agent.getInstance();
            IOffering installedOffering = agent.getAgentOffering();
            if (installedOffering != null) {
                IStatus prepareStatus = agent.prepareAgentUpdate(installedOffering, updateOffering, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (!prepareStatus.isOK()) {
                    SharedUpdateAgentUtils.unloadServiceRepositories((boolean)otherServiceRepositoriesLoaded);
                    IStatus iStatus = prepareStatus;
                    return iStatus;
                }
                IStatus applicabilityStatus = UpdateAgentUtils.checkAgentApplicability(newAgentJob[0]);
                if (!applicabilityStatus.isOK()) {
                    SharedUpdateAgentUtils.unloadServiceRepositories((boolean)otherServiceRepositoriesLoaded);
                    IStatus iStatus = applicabilityStatus;
                    return iStatus;
                }
            }
        }
        finally {
            monitor.done();
        }
        return status;
    }

    public static IStatus checkForAgentUpdateNDisplayServiceRepStatus(IProgressMonitor monitor) {
        CicMultiStatus ms;
        IOffering offering = null;
        SubProgressMonitor subMonitor = null;
        CicMultiStatus result = ms = Statuses.ST.createMultiStatus(com.ibm.cic.agent.core.sharedUI.Messages.AgentUIAction_agentUpdateAvailable, new Object[0]);
        monitor.beginTask(com.ibm.cic.agent.core.sharedUI.Messages.ProgressDialog_Updating_Agent, 4);
        boolean otherServiceRepositoriesLoaded = SharedUpdateAgentUtils.areOtherServiceRepositoriesLoaded();
        try {
            subMonitor = new SubProgressMonitor(monitor, 1);
            final HashMap repLocationMsgMap = new HashMap();
            final IStatus loadServiceRepStatus = SharedUpdateAgentUtils.loadAgentServiceRepositories(null, repLocationMsgMap, (IProgressMonitor)subMonitor);
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            DisplayKeeper.INSTANCE.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell shell = CicCommonUiPlugin.getDefault().getTimeTriggeredProgressDlgShell();
                    if (shell != null) {
                        AgentUIUtils.reportRepositoryConnectionMsg(shell, loadServiceRepStatus, repLocationMsgMap);
                    }
                }
            });
            subMonitor = new SubProgressMonitor(monitor, 1);
            offering = SharedUpdateAgentUtils.getAgentUpdateOffering((IProgressMonitor)subMonitor, (CicMultiStatus)ms);
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            subMonitor = new SubProgressMonitor(monitor, 2);
            result = UpdateAgentUtils.updateAgent((IProgressMonitor)subMonitor, offering, ms);
            if (result.matches(8)) {
                CicMultiStatus cicMultiStatus = result;
                return cicMultiStatus;
            }
        }
        finally {
            SharedUpdateAgentUtils.unloadServiceRepositories((boolean)otherServiceRepositoriesLoaded);
            monitor.done();
        }
        if (offering != null && !monitor.isCanceled()) {
            UpdateAgentUtils.performPostAgentUpdate((IStatus)result, offering);
        }
        return result;
    }

    public static IStatus updateAgent(IProgressMonitor monitor, IOffering offering, CicMultiStatus status) {
        SplitProgressMonitor pm = new SplitProgressMonitor((IProgressMonitor)new WebUiSafeProgressMonitor(monitor), new int[]{1, 9});
        String msg = com.ibm.cic.agent.core.sharedUI.Messages.ProgressDialog_Checking_Agent_Update;
        monitor.setTaskName(msg);
        try {
            if (offering == null) {
                CicMultiStatus cicMultiStatus = Statuses.ST.createMultiStatus(-51, "", new Object[0]);
                return cicMultiStatus;
            }
            CheckAgentRequirementInteraction interaction = new CheckAgentRequirementInteraction(offering, status);
            DisplayKeeper.INSTANCE.getDisplay().syncExec((Runnable)interaction);
            if (!interaction.getStatus().isOK()) {
                CicMultiStatus cicMultiStatus = interaction.getStatus();
                return cicMultiStatus;
            }
            Agent agent = Agent.getInstance();
            UpdateOfferingJob job = agent.createAgentUpdateOfferingJob(offering);
            monitor.setTaskName(com.ibm.cic.agent.core.sharedUI.Messages.ProgressDialog_Checking_Agent_Applicability);
            IStatus prepareStatus = agent.prepareAgentUpdate(job, pm.next());
            if (!prepareStatus.isOK()) {
                IStatus iStatus = prepareStatus;
                return iStatus;
            }
            IStatus applicabilityStatus = UpdateAgentUtils.checkAgentApplicability((AbstractJob)job);
            if (!applicabilityStatus.isOK()) {
                IStatus iStatus = applicabilityStatus;
                return iStatus;
            }
            monitor.setTaskName(com.ibm.cic.agent.core.sharedUI.Messages.ProgressDialog_Updating_Agent);
            SubtaskOnlyProgressMonitor pmWrapper = new SubtaskOnlyProgressMonitor(pm.next());
            IStatus iStatus = agent.updateAgent(job, (IProgressMonitor)pmWrapper);
            return iStatus;
        }
        finally {
            pm.done();
            monitor.done();
        }
    }

    public static void performPostAgentUpdate(final IStatus status, final IOffering offering) {
        DisplayKeeper.INSTANCE.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = CicCommonUiPlugin.getDefault().getTimeTriggeredProgressDlgShell();
                if (!StatusUtil.isErrorOrCancel((IStatus)status)) {
                    if (status.matches(2)) {
                        new WrapDetailUIDErrorDialog(shell, com.ibm.cic.agent.core.sharedUI.Messages.UpdateAgent_Problems_Title, null, status, 3, true).open();
                    }
                    String title = com.ibm.cic.agent.core.sharedUI.Messages.WorkbenchRestartDlg_Title;
                    String msg = NLS.bind((String)com.ibm.cic.agent.core.sharedUI.Messages.WorkbenchRestartDlg_Msg, (Object)offering.getInformation().getVersion());
                    MessageDialog.openInformation((Shell)shell, (String)title, (String)msg);
                    AgentRelaunch.getInstance().setAgentPostUpdateInProgress(true);
                    UiServices.getInstance().restartWorkbench();
                } else if (!status.matches(8)) {
                    new WrapDetailUIDErrorDialog(shell, com.ibm.cic.agent.core.sharedUI.Messages.UpdateAgent_Problems_Title, null, status, 7, true).open();
                }
            }
        });
    }

    private static IStatus checkAgentApplicability(final AbstractJob job) {
        final IStatus[] status = new IStatus[]{Status.OK_STATUS};
        DisplayKeeper.INSTANCE.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = CicCommonUiPlugin.getDefault().getTimeTriggeredProgressDlgShell();
                if (shell != null) {
                    status[0] = UpdateAgentUtils.checkAgentApplicability(shell, job);
                }
            }
        });
        return status[0];
    }

    private static IStatus checkAgentApplicability(Shell shell, AbstractJob job) {
        IStatus status = job.checkOfferingApplicability();
        if (!status.isOK()) {
            if (status.matches(8)) {
                CicMultiStatus result = Statuses.ST.createMultiStatusWithChild(Status.CANCEL_STATUS, null, new Object[0]);
                result.setCode(-50);
                return result;
            }
            if (status.matches(4)) {
                new WrapDetailUIDErrorDialog(shell, Messages.AgentUIWorkbenchWindowAdvisor_windowTitle, null, status, 7).open();
                return Status.CANCEL_STATUS;
            }
            int response = new YesNoErrorDialog(shell, Messages.AgentUIWorkbenchWindowAdvisor_windowTitle, null, status, 3, Messages.AvailableOfferingPage_offeringInstalledDlg_Continue, Messages.AvailableOfferingPage_offeringInstalledDlg_Cancel).open();
            if (response != 2) {
                CicMultiStatus result = Statuses.ST.createMultiStatusWithChild(Status.CANCEL_STATUS, null, new Object[0]);
                result.setCode(-50);
                return result;
            }
        }
        return Status.OK_STATUS;
    }
}

