/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.utils;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.sharedUI.IContainsOffering;
import com.ibm.cic.agent.internal.ui.utils.FixNode;
import com.ibm.cic.agent.internal.ui.utils.InstallCapability;
import com.ibm.cic.agent.internal.ui.utils.OnlyFixesNode;
import com.ibm.cic.agent.internal.ui.utils.ProfileNode;
import com.ibm.cic.agent.internal.ui.utils.VersionNode;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.repository.UnavailableUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public class PackageNode
implements IContainsOffering {
    private IOffering offering;
    private ProfileNode parent;
    private final List children = new ArrayList();
    private boolean isInstalled = false;
    private PackageNode baseNode;
    private InstallCapability capabilityProvided;
    private final Map<String, InstallCapability> capabilities = new HashMap<String, InstallCapability>();
    private boolean selected = false;
    public boolean isSelectedBaseNode = false;
    public boolean isSelectByVersion = false;
    public String prevFilter = "";
    private boolean checkInstallStatus = true;

    public PackageNode(IOffering offering) {
        this.offering = offering;
    }

    public PackageNode(IOffering offering, boolean checkStatus) {
        this(offering);
        this.checkInstallStatus = checkStatus;
    }

    public PackageNode(IOffering offering, ProfileNode profileNode) {
        this.offering = offering;
        this.parent = profileNode;
    }

    public boolean isAgentPackageNode() {
        if (this.offering == null) {
            return false;
        }
        IIdentity identity = this.offering.getIdentity();
        return "com.ibm.cic.agent".equals(identity.getId());
    }

    public VersionNode addVersion(AbstractJob job) {
        VersionNode versionNode = new VersionNode(job, this, this.checkInstallStatus);
        this.getChildren().add(versionNode);
        return versionNode;
    }

    public FixNode addFix(AbstractJob job) {
        FixNode fixNode = new FixNode(job, this);
        this.getChildren().add(fixNode);
        return fixNode;
    }

    public void setBaseNode(PackageNode node) {
        this.baseNode = node;
    }

    public void selectBaseNode(boolean select) {
        this.isSelectedBaseNode = select;
    }

    public void selectByVersion(boolean select) {
        this.isSelectByVersion = select;
    }

    public IOffering getOffering() {
        return this.offering;
    }

    public void setOffering(IOffering offering) {
        this.offering = offering;
    }

    public ProfileNode getParent() {
        return this.parent;
    }

    public PackageNode getBaseNode() {
        return this.baseNode;
    }

    public List getVersionNodes() {
        ArrayList versions = new ArrayList();
        int i = 0;
        while (i < this.children.size()) {
            Object child = this.children.get(i);
            if (child instanceof VersionNode) {
                versions.add(child);
            }
            ++i;
        }
        return versions;
    }

    public List<FixNode> getFixNodes() {
        ArrayList<FixNode> fixes = new ArrayList<FixNode>();
        int i = 0;
        while (i < this.children.size()) {
            Object child = this.children.get(i);
            if (child instanceof FixNode) {
                fixes.add((FixNode)child);
            }
            ++i;
        }
        return fixes;
    }

    public List getChildren() {
        return this.children;
    }

    public boolean isInstalled() {
        return this.isInstalled;
    }

    public void setInstalled(boolean isInstalled) {
        this.isInstalled = isInstalled;
    }

    public IIdentity getIdentity() {
        return this.offering.getIdentity();
    }

    public VersionNode getRecommendedVersion() {
        VersionNode firstVersionNode = null;
        for (Object child : this.children) {
            if (!(child instanceof VersionNode)) continue;
            VersionNode versionNode = (VersionNode)child;
            if (firstVersionNode == null) {
                firstVersionNode = versionNode;
            }
            if (!versionNode.isRecommended()) continue;
            return versionNode;
        }
        return firstVersionNode;
    }

    public List getInstallableFixNodes() {
        ArrayList<FixNode> installableFixes = new ArrayList<FixNode>();
        List<FixNode> fixes = this.getFixNodes();
        int i = 0;
        while (i < fixes.size()) {
            FixNode fixNode = fixes.get(i);
            if (fixNode.canBeInstalled()) {
                installableFixes.add(fixNode);
            }
            ++i;
        }
        return installableFixes;
    }

    public boolean containsVersion(AbstractJob job) {
        for (Object child : this.children) {
            VersionNode versionNode;
            IOffering currentOffering;
            if (!(child instanceof VersionNode) || !(currentOffering = (versionNode = (VersionNode)child).getJob().getOffering()).equals(job.getOffering())) continue;
            return true;
        }
        return false;
    }

    public OnlyFixesNode addOnlyFixesNode(boolean hasRecommended) {
        OnlyFixesNode onlyFixesNode = this.getOnlyFixesNode();
        if (onlyFixesNode == null) {
            onlyFixesNode = new OnlyFixesNode(this, hasRecommended);
            this.getChildren().add(onlyFixesNode);
        }
        return onlyFixesNode;
    }

    public OnlyFixesNode getOnlyFixesNode() {
        int i = 0;
        while (i < this.children.size()) {
            Object child = this.children.get(i);
            if (child instanceof OnlyFixesNode) {
                return (OnlyFixesNode)child;
            }
            ++i;
        }
        return null;
    }

    public boolean containsUnavailableFixes() {
        if (this.checkInstallStatus) {
            for (FixNode fixNode : this.getFixNodes()) {
                if (!UnavailableUtils.isUnavailable((IContent)fixNode.getFix())) continue;
                return true;
            }
        }
        return false;
    }

    public VersionNode getVersionNodeForOffering(IIdentity id) {
        for (Object child : this.children) {
            VersionNode versionNode;
            IOffering currentOffering;
            if (!(child instanceof VersionNode) || (currentOffering = (versionNode = (VersionNode)child).getJob().getOffering()) == null || !currentOffering.getIdentity().equals(id)) continue;
            return versionNode;
        }
        return null;
    }

    public void addChild(PackageNode pNode) {
        this.children.add(pNode);
    }

    public void setCapabilityProvided(String capability, VersionRange version) {
        this.capabilityProvided = new InstallCapability(capability, version);
    }

    public InstallCapability getCapabilityProvided() {
        return this.capabilityProvided;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean s) {
        this.selected = s;
    }

    public void addCapability(String capId, InstallCapability capability) {
        this.capabilities.put(capId, capability);
    }

    public Set<String> getCapabilityIDs() {
        return this.capabilities.keySet();
    }

    public Collection<InstallCapability> getCapabilities() {
        return this.capabilities.values();
    }

    public InstallCapability getCapability(String capId) {
        return this.capabilities.get(capId);
    }

    public IOffering getHighestVersionOffering() {
        IOffering highestVerOffering = null;
        Version highestVer = null;
        for (Object child : this.children) {
            if (!(child instanceof VersionNode)) continue;
            IOffering childOff = ((VersionNode)child).getOffering();
            if (highestVerOffering == null) {
                highestVer = childOff.getVersion();
                highestVerOffering = childOff;
                continue;
            }
            if (childOff.getVersion().compareTo(highestVer) <= 0) continue;
            highestVer = childOff.getVersion();
            highestVerOffering = childOff;
        }
        return highestVerOffering;
    }
}

