/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.utils;

import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.sharedUI.CustomPanelJobPair;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.utils.ConfigurationCustomPanelNode;
import com.ibm.cic.agent.internal.ui.utils.ConfigurationOfferingNode;
import com.ibm.cic.agent.internal.ui.utils.CustomPanelProfileNode;
import com.ibm.cic.agent.ui.extensions.CustomPanel;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.utils.MapList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;

public class CustomPanelManager {
    private static CustomPanelManager instance = new CustomPanelManager();
    private Map idOfferingNodeMap;
    private List offeringNodes;
    private List panelNodes;
    private Map panelSkipInfoMap;
    private Map previousSkipStatusMap;
    private CustomPanelJobPair[] panelJobPairList;
    private MapList profileOfferingNodesMap;
    private boolean displayProfileNode = false;
    private static final String AllPackageKey = "AllPackages";

    public static CustomPanelManager getInstance() {
        return instance;
    }

    public void setCustomPanelJobs(CustomPanelJobPair[] panelJobPair) {
        this.panelJobPairList = panelJobPair;
        this.panelSkipInfoMap = new HashMap();
        this.previousSkipStatusMap = new HashMap();
    }

    public void reset() {
        this.idOfferingNodeMap = null;
        this.offeringNodes = null;
        this.panelJobPairList = null;
        this.panelNodes = null;
        this.panelSkipInfoMap = null;
        this.previousSkipStatusMap = null;
        this.profileOfferingNodesMap = null;
    }

    private Collection groupPanelJobsByProfile(CustomPanelJobPair[] panelJobPairs) {
        MapList map = new MapList();
        CustomPanelJobPair[] customPanelJobPairArray = panelJobPairs;
        int n = panelJobPairs.length;
        int n2 = 0;
        while (n2 < n) {
            CustomPanelJobPair panelJobPair = customPanelJobPairArray[n2];
            String profileId = panelJobPair.getProfile().getProfileId();
            map.add((Object)profileId, (Object)panelJobPair);
            ++n2;
        }
        int size = map.size();
        if (size == 0) {
            return Collections.EMPTY_LIST;
        }
        if (size == 1) {
            return Collections.singletonList(panelJobPairs);
        }
        ArrayList<CustomPanelJobPair[]> result = new ArrayList<CustomPanelJobPair[]>(size);
        for (List list : map.toMap().values()) {
            CustomPanelJobPair[] pairArray = list.toArray(new CustomPanelJobPair[list.size()]);
            result.add(pairArray);
        }
        return result;
    }

    public void generateTreeStructure() {
        this.idOfferingNodeMap = new HashMap();
        this.offeringNodes = new ArrayList();
        this.panelNodes = new ArrayList();
        this.profileOfferingNodesMap = new MapList();
        CustomPanelJobPair[] nonSkippedPanelJobs = this.filterSkippedPanels(this.panelJobPairList);
        Collection groupedNonSkippedPanelJobs = this.groupPanelJobsByProfile(nonSkippedPanelJobs);
        Iterator it = groupedNonSkippedPanelJobs.iterator();
        while (it.hasNext()) {
            CustomPanelJobPair[] groupedPanelJobPair;
            CustomPanelJobPair[] customPanelJobPairArray = groupedPanelJobPair = (CustomPanelJobPair[])it.next();
            int n = groupedPanelJobPair.length;
            int n2 = 0;
            while (n2 < n) {
                IOffering offering;
                CustomPanelJobPair element = customPanelJobPairArray[n2];
                CustomPanel panel = (CustomPanel)element.getPanel();
                AgentJob job = element.getJob();
                Profile profile = element.getProfile();
                String key = null;
                key = job != null ? ((offering = job.getOffering()) != null && profile != null ? String.valueOf(profile.getProfileId()) + offering.getIdentity().getId() : (offering != null ? offering.getIdentity().getId() : (profile != null ? profile.getProfileId() : AllPackageKey))) : (profile != null ? profile.getProfileId() : AllPackageKey);
                if (key != null) {
                    ConfigurationOfferingNode offeringNode = (ConfigurationOfferingNode)this.idOfferingNodeMap.get(key);
                    if (offeringNode == null) {
                        offeringNode = new ConfigurationOfferingNode(job);
                        if (job == null) {
                            offeringNode.setProfile(profile);
                        }
                        this.idOfferingNodeMap.put(key, offeringNode);
                        if (this.offeringNodes.isEmpty()) {
                            this.offeringNodes.add(offeringNode);
                        } else {
                            ConfigurationOfferingNode lastOfferingNode = (ConfigurationOfferingNode)this.offeringNodes.get(this.offeringNodes.size() - 1);
                            lastOfferingNode.setNextOfferingNode(offeringNode);
                            offeringNode.setPreviousOfferingNode(lastOfferingNode);
                            this.offeringNodes.add(offeringNode);
                        }
                        this.profileOfferingNodesMap.add((Object)profile, (Object)offeringNode);
                    }
                    ConfigurationCustomPanelNode panelNode = new ConfigurationCustomPanelNode(offeringNode, panel);
                    offeringNode.addChildren(panelNode);
                    if (!this.panelNodes.contains(panelNode)) {
                        this.panelNodes.add(panelNode);
                    }
                }
                ++n2;
            }
        }
    }

    private CustomPanelJobPair[] filterSkippedPanels(CustomPanelJobPair[] pairs) {
        ArrayList<CustomPanelJobPair> return_value = new ArrayList<CustomPanelJobPair>();
        CustomPanelJobPair[] customPanelJobPairArray = pairs;
        int n = pairs.length;
        int n2 = 0;
        while (n2 < n) {
            CustomPanelJobPair pair = customPanelJobPairArray[n2];
            Boolean skip = (Boolean)this.panelSkipInfoMap.get(pair);
            if (skip == null) {
                try {
                    boolean shouldSkip = pair.getPanel().shouldSkip();
                    this.panelSkipInfoMap.put(pair, shouldSkip);
                    if (!shouldSkip) {
                        return_value.add(pair);
                    }
                }
                catch (Exception e) {
                    IStatus status = SharedUIUtils.generateCustomPanelExceptionStatus((CustomPanelJobPair)pair, (Throwable)e);
                    AgentUI.reportStatus(status, true);
                }
            } else if (!skip.booleanValue()) {
                return_value.add(pair);
            }
            ++n2;
        }
        return return_value.toArray(new CustomPanelJobPair[return_value.size()]);
    }

    public boolean reEvaluatePanelSkipInfo(Profile profile) {
        boolean skipInfoChanged = false;
        if (this.panelJobPairList != null && this.panelJobPairList.length > 0) {
            this.previousSkipStatusMap = new HashMap(this.panelSkipInfoMap);
            CustomPanelJobPair[] customPanelJobPairArray = this.panelJobPairList;
            int n = this.panelJobPairList.length;
            int n2 = 0;
            while (n2 < n) {
                CustomPanelJobPair panelJob = customPanelJobPairArray[n2];
                if (panelJob.getJob() == null) {
                    panelJob.setProfile(profile);
                }
                try {
                    Boolean skipped = (Boolean)this.panelSkipInfoMap.get(panelJob);
                    if (skipped == null) {
                        skipInfoChanged = true;
                        this.panelSkipInfoMap.put(panelJob, panelJob.getPanel().shouldSkip());
                    } else {
                        Boolean shouldSkipNow = panelJob.getPanel().shouldSkip();
                        if (!skipped.equals(shouldSkipNow)) {
                            skipInfoChanged = true;
                            this.panelSkipInfoMap.put(panelJob, shouldSkipNow);
                        }
                    }
                }
                catch (Exception e) {
                    IStatus status = SharedUIUtils.generateCustomPanelExceptionStatus((CustomPanelJobPair)panelJob, (Throwable)e);
                    AgentUI.reportStatus(status, true);
                }
                ++n2;
            }
        }
        return skipInfoChanged;
    }

    public boolean reEvaluatePanelSkipInfo() {
        boolean skipInfoChanged = false;
        if (this.panelJobPairList != null && this.panelJobPairList.length > 0) {
            this.previousSkipStatusMap = new HashMap(this.panelSkipInfoMap);
            CustomPanelJobPair[] customPanelJobPairArray = this.panelJobPairList;
            int n = this.panelJobPairList.length;
            int n2 = 0;
            while (n2 < n) {
                CustomPanelJobPair panelJob = customPanelJobPairArray[n2];
                try {
                    Boolean skipped = (Boolean)this.panelSkipInfoMap.get(panelJob);
                    if (skipped == null) {
                        skipInfoChanged = true;
                        this.panelSkipInfoMap.put(panelJob, panelJob.getPanel().shouldSkip());
                    } else {
                        Boolean shouldSkipNow = panelJob.getPanel().shouldSkip();
                        if (!skipped.equals(shouldSkipNow)) {
                            skipInfoChanged = true;
                            this.panelSkipInfoMap.put(panelJob, shouldSkipNow);
                        }
                    }
                }
                catch (Exception e) {
                    IStatus status = SharedUIUtils.generateCustomPanelExceptionStatus((CustomPanelJobPair)panelJob, (Throwable)e);
                    AgentUI.reportStatus(status, true);
                }
                ++n2;
            }
        }
        return skipInfoChanged;
    }

    public ConfigurationCustomPanelNode getNextValidPanelNode(ConfigurationCustomPanelNode node) {
        List children;
        ConfigurationOfferingNode parentNode;
        ConfigurationOfferingNode nextOfferingNode;
        ConfigurationCustomPanelNode nextNode = node.getNextNode();
        if (nextNode == null && (nextOfferingNode = (parentNode = node.getParent()).getNextOfferingNode()) != null && (children = nextOfferingNode.getChildren()) != null && !children.isEmpty()) {
            return (ConfigurationCustomPanelNode)children.get(0);
        }
        return nextNode;
    }

    public ConfigurationCustomPanelNode getPreviousValidPanelNode(ConfigurationCustomPanelNode node) {
        List children;
        ConfigurationOfferingNode parentNode;
        ConfigurationOfferingNode previousOfferingNode;
        ConfigurationCustomPanelNode previousNode = node.getPreviousNode();
        if (previousNode == null && (previousOfferingNode = (parentNode = node.getParent()).getPreviousOfferingNode()) != null && (children = previousOfferingNode.getChildren()) != null && !children.isEmpty()) {
            return (ConfigurationCustomPanelNode)children.get(children.size() - 1);
        }
        return previousNode;
    }

    public List getTreeRoot() {
        if (this.profileOfferingNodesMap == null || this.profileOfferingNodesMap.isEmpty() || this.profileOfferingNodesMap.size() == 1) {
            this.displayProfileNode = false;
            return this.offeringNodes;
        }
        ArrayList<CustomPanelProfileNode> roots = new ArrayList<CustomPanelProfileNode>();
        Set keySet = this.profileOfferingNodesMap.keySet();
        for (Profile profile : keySet) {
            List offeringNodeList = this.profileOfferingNodesMap.get((Object)profile);
            if (offeringNodeList == null || offeringNodeList.isEmpty()) continue;
            CustomPanelProfileNode profileNode = new CustomPanelProfileNode(profile);
            profileNode.setChildren(offeringNodeList);
            roots.add(profileNode);
        }
        this.displayProfileNode = true;
        return roots;
    }

    public List getOfferingNodes() {
        return this.offeringNodes;
    }

    public List getPanelNodes() {
        return this.panelNodes;
    }

    public boolean isPanelSkipped(CustomPanelJobPair panelJob) {
        if (this.panelSkipInfoMap == null || this.panelSkipInfoMap.get(panelJob) == null) {
            boolean skipped = true;
            try {
                skipped = panelJob.getPanel().shouldSkip();
            }
            catch (Exception e) {
                IStatus status = SharedUIUtils.generateCustomPanelExceptionStatus((CustomPanelJobPair)panelJob, (Throwable)e);
                AgentUI.reportStatus(status, true);
                skipped = true;
            }
            return skipped;
        }
        return (Boolean)this.panelSkipInfoMap.get(panelJob);
    }

    public Boolean getPreviousSkipInfo(CustomPanelJobPair panelJob) {
        if (this.previousSkipStatusMap == null || this.previousSkipStatusMap.isEmpty()) {
            return Boolean.TRUE;
        }
        return (Boolean)this.previousSkipStatusMap.get(panelJob);
    }

    public boolean displayProfileNode() {
        return this.displayProfileNode;
    }
}

