/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.parts;

import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.common.core.downloads.RememberDownloadUserPrompts;
import com.ibm.cic.common.core.preferences.CicPreferenceManager;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.viewers.RepositoryTable;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;

public class AgentRepositoryTable
extends RepositoryTable {
    private static final Logger logger = Logger.getLogger(AgentRepositoryTable.class);
    public static final ICicPreferenceConstants.PreferenceTag prefTag = ICicPreferenceConstants.REPOSITORY_LOCATIONS;
    public static final ICicPreferenceConstants.ComposedPreferenceTag repoSpecialSettingsTag = new ICicPreferenceConstants.ComposedPreferenceTag(ICicPreferenceConstants.REPOSITORY_LOCATIONS, "", ICicPreferenceConstants.REPOSITORY_SPECIAL_SETTINGS);
    public static final ICicPreferenceConstants.ComposedPreferenceTag repoIsOpenTag = new ICicPreferenceConstants.ComposedPreferenceTag(ICicPreferenceConstants.REPOSITORY_LOCATIONS, "", ICicPreferenceConstants.REPOSITORY_IS_OPEN);

    public AgentRepositoryTable(List locations, Map locProperties, Map locOpen, Map locStatus, int col1_width, int col2_width) {
        super(locations, locProperties, locOpen, locStatus, col1_width, col2_width);
    }

    public void loadRepositorySettings(final IPreferenceStore prefStore, final CicPreferenceManager prefMan, final boolean useDefaultPreferences) {
        try {
            CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    AgentRepositoryTable.this.loadRepositorySettings(prefStore, prefMan, useDefaultPreferences, monitor);
                }
            });
        }
        catch (InvocationTargetException e) {
            logger.error((Throwable)e);
        }
        catch (InterruptedException e) {
            logger.error((Throwable)e);
        }
    }

    public void loadRepositorySettings(IPreferenceStore prefStore, CicPreferenceManager prefMan, boolean useDefaultPreferences, IProgressMonitor monitor) {
        String[] locations = useDefaultPreferences ? prefMan.getDefaultsPreferenceHandler().getStringArray(prefTag.key()) : prefMan.getStringArray(prefTag.key());
        this.repLocations.clear();
        this.locationProperties.clear();
        this.repOpen.clear();
        this.repStatus.clear();
        RememberDownloadUserPrompts rememberPrompts = new RememberDownloadUserPrompts();
        monitor.beginTask(Messages.ProgressDialog_Loading_Repositories, locations.length + 2);
        try {
            monitor.worked(1);
            String[] stringArray = locations;
            int n = locations.length;
            int n2 = 0;
            while (n2 < n) {
                String location = stringArray[n2];
                String msg = NLS.bind((String)Messages.AgentMainPreferencePage_Checking_Repository, (Object)location);
                SubProgressMonitor partMonitor = new SubProgressMonitor(monitor, 1);
                partMonitor.beginTask(msg, 1);
                partMonitor.setTaskName(msg);
                try {
                    String settings = prefStore.getString(repoSpecialSettingsTag.replaceKey(1, location).key()).trim();
                    this.repLocations.add(location);
                    List properties = null;
                    if (settings != null && settings.length() > 0) {
                        properties = this.loadSettings(settings);
                    }
                    this.locationProperties.put(location, properties);
                    boolean open = useDefaultPreferences ? prefMan.getDefaultsPreferenceHandler().getBoolean(repoIsOpenTag.replaceKey(1, location)) : prefMan.getBoolean(repoIsOpenTag.replaceKey(1, location).key());
                    this.repOpen.put(location, open);
                }
                finally {
                    partMonitor.done();
                }
                ++n2;
            }
            monitor.worked(1);
        }
        finally {
            rememberPrompts.forget();
            monitor.done();
        }
    }
}

