/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.dialogs;

import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.ui.services.UiServices;
import java.io.File;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ZipFilesDialog
extends TitleAreaDialog {
    private Button browseButton;
    private Text zipText;
    private String zipDestinationFile;
    private boolean overrideExistingFile = false;
    private static final String ZipExt = ".zip";

    public ZipFilesDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.verifyZipFile();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.ZipFilesDialog_zipDlgTitle);
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite comp = new Composite(parentComposite, 0);
        comp.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(1808);
        gridData.widthHint = 500;
        comp.setLayoutData((Object)gridData);
        Composite group = new Composite(comp, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 15;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        Label desLabel = new Label(group, 64);
        desLabel.setText(Messages.ZipFilesDialog_description);
        GridData desData = new GridData(4, 0x1000000, true, false);
        desData.horizontalSpan = 3;
        desLabel.setLayoutData((Object)desData);
        Label zipFileLabel = new Label(group, 0);
        zipFileLabel.setText(Messages.ZipFilesDialog_zipFileLabel);
        this.zipText = new Text(group, 2048);
        this.zipText.setLayoutData((Object)new GridData(1808));
        this.zipText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ZipFilesDialog.this.verifyZipFile();
            }
        });
        this.browseButton = new Button(group, 8);
        this.browseButton.setText(Messages.ZipFilesDialog_zipFileBrowse);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String fullPathName;
                String deprocessedFileName;
                File specifiedZipFile;
                String currentZipPath;
                String dialogFilterPath = null;
                String existingZipFile = ZipFilesDialog.this.zipText.getText().trim();
                if (existingZipFile != null && existingZipFile.length() > 0 && (currentZipPath = (specifiedZipFile = new File(deprocessedFileName = TextProcessor.deprocess((String)existingZipFile))).getParent()) != null) {
                    dialogFilterPath = currentZipPath;
                }
                if ((fullPathName = UiServices.getInstance().getFileDialog(ZipFilesDialog.this.browseButton.getShell()).filterExtensions(new String[]{"*.zip", "*.*"}).title(Messages.ZipFilesDialog_zipFileBrowseTitle).filterPath(dialogFilterPath).run()) != null) {
                    ZipFilesDialog.this.zipText.setText(TextProcessor.process((String)fullPathName));
                }
            }
        });
        return parentComposite;
    }

    private void verifyZipFile() {
        this.overrideExistingFile = false;
        String fullPathName = this.zipText.getText().trim();
        if (fullPathName.length() == 0) {
            this.setErrorMessage(null);
            this.setMessage(null, 2);
            this.setMessage(Messages.ZipFilesDialog_zipFileMsg);
            this.getButton(0).setEnabled(false);
        } else {
            File file = new File(TextProcessor.deprocess((String)fullPathName));
            if (!fullPathName.endsWith(ZipExt)) {
                this.setErrorMessage(Messages.ZipFilesDialog_zipFileErrorMsg);
                this.getButton(0).setEnabled(false);
            } else if (file.isFile() && file.exists()) {
                this.setErrorMessage(null);
                this.setMessage(Messages.ZipFilesDialog_zipFileWarningMsg, 2);
                this.getButton(0).setEnabled(true);
                this.overrideExistingFile = true;
            } else {
                this.setErrorMessage(null);
                this.setMessage(null, 2);
                this.setMessage(Messages.ZipFilesDialog_zipFileMsg);
                this.getButton(0).setEnabled(true);
            }
        }
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(Messages.ZipFilesDialog_zipFileDlgTitle);
        super.configureShell(newShell);
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    protected void okPressed() {
        String displayedZipFile = this.zipText.getText();
        this.zipDestinationFile = TextProcessor.deprocess((String)displayedZipFile);
        if (this.overrideExistingFile) {
            boolean override = MessageDialog.openQuestion((Shell)this.browseButton.getShell(), (String)Messages.ZipFilesDialog_overrideWarningTitle, (String)NLS.bind((String)Messages.ZipFilesDialog_overrideWarningMsg, (Object)displayedZipFile));
            if (override) {
                super.okPressed();
            }
        } else {
            super.okPressed();
        }
    }

    public String getZipDestinationFile() {
        return this.zipDestinationFile;
    }
}

