/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.dialogs;

import com.ibm.cic.agent.core.sharedUI.Messages;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.views.InstallHistoryMasterDetailsBlock;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.parts.IFormContext;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.ManagedForm;

public final class ViewInstallHistoryDialog
extends TrayDialog
implements IFormContext {
    private ManagedForm managedForm;
    private InstallHistoryMasterDetailsBlock installHistoryBlock;
    private IDialogSettings dialogSettings;
    private Point dialogLocation;
    private Point dialogSize;
    private static int DIALOG_DEFAULT_WIDTH = 750;
    private static int DIALOG_DEFAULT_HEIGHT = 760;

    public ViewInstallHistoryDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.InstallHistoryView_title);
        this.readConfiguration();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 12, JFaceResources.getString((String)"close"), true);
    }

    public void create() {
        super.create();
        if (this.dialogLocation != null) {
            this.getShell().setLocation(this.dialogLocation);
        }
        if (this.dialogSize != null) {
            this.getShell().setSize(this.dialogSize);
        } else {
            this.getShell().setSize(DIALOG_DEFAULT_WIDTH, DIALOG_DEFAULT_HEIGHT);
        }
        this.getButton(12).setFocus();
    }

    protected Control createDialogArea(Composite parent) {
        Composite outer = (Composite)super.createDialogArea(parent);
        outer.setLayout((Layout)new FillLayout());
        this.managedForm = new ManagedForm(CicCommonUiPlugin.getDefault().getFormToolkit(), CicCommonUiPlugin.getDefault().getFormToolkit().createScrolledForm(outer));
        this.managedForm.getForm().getBody().setLayout((Layout)new FillLayout());
        this.installHistoryBlock = new InstallHistoryMasterDetailsBlock(this);
        this.installHistoryBlock.createContent((IManagedForm)this.managedForm);
        return outer;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 12) {
            this.close();
        }
        super.buttonPressed(buttonId);
    }

    public boolean close() {
        this.writeConfiguration();
        this.installHistoryBlock.dispose();
        return super.close();
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings = AgentUI.getDefault().getDialogSettings();
        this.dialogSettings = settings.getSection(this.getClass().getName());
        if (this.dialogSettings == null) {
            this.dialogSettings = settings.addNewSection(this.getClass().getName());
        }
        return this.dialogSettings;
    }

    public IDialogSettings getLogSettings() {
        return this.dialogSettings;
    }

    private void readConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        try {
            int x = s.getInt("x");
            int y = s.getInt("y");
            this.dialogLocation = new Point(x, y);
            x = s.getInt("width");
            y = s.getInt("height");
            this.dialogSize = new Point(x, y);
        }
        catch (NumberFormatException e) {
            this.dialogLocation = null;
            this.dialogSize = null;
        }
    }

    private void writeConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        Point location = this.getShell().getLocation();
        s.put("x", location.x);
        s.put("y", location.y);
        Point size = this.getShell().getSize();
        s.put("width", size.x);
        s.put("height", size.y);
    }

    @Override
    public IManagedForm getForm() {
        return this.managedForm;
    }

    @Override
    public IWorkbenchPage getWorkbenchPage() {
        return null;
    }
}

