/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.custompanel;

import com.ibm.cic.agent.core.api.ICustomPanelData;
import com.ibm.cic.agent.core.custompanel.api.CustomPanelWrapper;
import com.ibm.cic.agent.core.custompanel.api.TemplateCheckBox;
import com.ibm.cic.agent.core.custompanel.api.TemplateConstants;
import com.ibm.cic.agent.core.custompanel.api.TemplateCustomPanel;
import com.ibm.cic.agent.core.custompanel.api.TemplateLabel;
import com.ibm.cic.agent.core.custompanel.api.TemplateProperty;
import com.ibm.cic.agent.core.custompanel.api.TemplatePushButton;
import com.ibm.cic.agent.core.custompanel.api.TemplateRadioButton;
import com.ibm.cic.agent.core.custompanel.api.TemplateRadioGroup;
import com.ibm.cic.agent.core.custompanel.api.TemplateReadonlyList;
import com.ibm.cic.agent.core.custompanel.api.TemplateSelectableList;
import com.ibm.cic.agent.core.custompanel.api.TemplateSelectableWidget;
import com.ibm.cic.agent.core.custompanel.api.TemplateSelectableWidgetContainer;
import com.ibm.cic.agent.core.custompanel.api.TemplateSingleSelectList;
import com.ibm.cic.agent.core.custompanel.api.TemplateText;
import com.ibm.cic.agent.core.custompanel.api.TemplateWidget;
import com.ibm.cic.agent.core.custompanel.api.TemplateWidgetContainer;
import com.ibm.cic.agent.core.custompanel.api.TemplateWritableWidget;
import com.ibm.cic.agent.core.internal.headless.AgentInput;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.custompanel.ControlDecorations;
import com.ibm.cic.agent.internal.ui.custompanel.PropertyComposite;
import com.ibm.cic.agent.internal.ui.custompanel.SWTCustomPanelGenerator;
import com.ibm.cic.agent.internal.ui.custompanel.TextComposite;
import com.ibm.cic.agent.ui.extensions.CustomPanel;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.RuntimeStatusException;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.dialogs.WrapDetailUIDErrorDialog;
import com.ibm.cic.common.ui.internal.dialogs.YesNoErrorDialog;
import com.ibm.cic.common.ui.services.UiServices;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class GeneratedSWTCustomPanel
extends CustomPanel {
    private final CustomPanelWrapper template;
    private final Map<TemplateWidget, Control> widgetMap = new LinkedHashMap<TemplateWidget, Control>();
    private final Map<String, ControlDecorations> widgetDecorations = new LinkedHashMap<String, ControlDecorations>();
    private IStatus errorStatus;
    private IStatus messageStatus;

    public GeneratedSWTCustomPanel(CustomPanelWrapper template) {
        super(template.getPanelTitle());
        this.template = template;
    }

    @Override
    public void createControl(Composite parent) {
        FormToolkit toolkit = AgentUI.getDefault().getFormToolkit();
        TemplateWidgetContainer templateContainer = (TemplateWidgetContainer)((TemplateWidgetContainer)new TemplateWidgetContainer().horizontalFill(true)).verticalFill(true);
        this.template.createWidgets(templateContainer);
        Composite swtContainer = SWTCustomPanelGenerator.createComposite(toolkit, parent, templateContainer);
        this.createChildrenControls(toolkit, templateContainer, swtContainer);
        this.setControl((Control)swtContainer);
    }

    private void createChildrenControls(FormToolkit toolkit, TemplateWidgetContainer templateContainer, Composite swtContainer) {
        int propertyIndexEnd = 0;
        ArrayList<TemplateProperty> templatePropertyCollection = new ArrayList<TemplateProperty>();
        List currentWidgets = templateContainer.getChildren();
        int i = 0;
        while (i < currentWidgets.size()) {
            ControlDecorations decs;
            TemplateCustomPanel.UserData userData;
            TemplateReadonlyList tempList;
            TemplateWidget child = (TemplateWidget)currentWidgets.get(i);
            if (child instanceof TemplateWidgetContainer) {
                TemplateWidgetContainer tempContainer = (TemplateWidgetContainer)child;
                Composite parentComp = SWTCustomPanelGenerator.createComposite(toolkit, swtContainer, tempContainer);
                this.widgetMap.put((TemplateWidget)tempContainer, (Control)parentComp);
                this.createChildrenControls(toolkit, tempContainer, parentComp);
            } else if (child instanceof TemplatePushButton) {
                final TemplatePushButton buttonTemp = (TemplatePushButton)child;
                Button swtPushButton = SWTCustomPanelGenerator.createPushButton(toolkit, swtContainer, buttonTemp);
                this.widgetMap.put((TemplateWidget)buttonTemp, (Control)swtPushButton);
                swtPushButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        GeneratedSWTCustomPanel.this.setErrorStatus(null);
                        GeneratedSWTCustomPanel.this.setMessageStatus(null);
                        GeneratedSWTCustomPanel.this.setPageComplete(true);
                        if (buttonTemp.getTriggerUpdate()) {
                            GeneratedSWTCustomPanel.this.template.updateWidgets(buttonTemp.getUserData());
                            GeneratedSWTCustomPanel.this.updateSWTWidgets();
                        }
                    }
                });
            } else if (child instanceof TemplateLabel) {
                TemplateLabel labelTemplate = (TemplateLabel)child;
                Control swtLabel = SWTCustomPanelGenerator.createLabel(toolkit, swtContainer, labelTemplate);
                this.widgetMap.put((TemplateWidget)labelTemplate, swtLabel);
            } else if (child instanceof TemplateText) {
                TemplateText textTemp = (TemplateText)child;
                TextComposite swtTextComposite = SWTCustomPanelGenerator.createTextComposite(toolkit, swtContainer, textTemp);
                this.widgetMap.put((TemplateWidget)textTemp, (Control)swtTextComposite);
                this.configureWidgetsInTextComposite((TemplateWritableWidget)textTemp, swtTextComposite, textTemp.getStyle());
            } else if (child instanceof TemplateProperty) {
                TemplateProperty propertyTemplate = (TemplateProperty)child;
                if (propertyIndexEnd == 0) {
                    propertyIndexEnd = i;
                    templatePropertyCollection.add(propertyTemplate);
                    int index = i + 1;
                    while (index < currentWidgets.size()) {
                        Object peekChild = currentWidgets.get(index);
                        if (!(peekChild instanceof TemplateProperty)) break;
                        ++propertyIndexEnd;
                        TemplateProperty peekChildTemplate = (TemplateProperty)peekChild;
                        templatePropertyCollection.add(peekChildTemplate);
                        ++index;
                    }
                }
                if (propertyIndexEnd == i) {
                    TemplateConstants.LayoutType containerLayout = propertyTemplate.getParent().getLayout();
                    Composite propertiesContainer = toolkit.createComposite(swtContainer);
                    GridLayout layout = new GridLayout();
                    if (containerLayout == TemplateConstants.LayoutType.VERTICAL) {
                        layout.numColumns = 2;
                    } else {
                        int propertySize = templatePropertyCollection.size();
                        layout.numColumns = 2 * propertySize;
                    }
                    layout.marginWidth = 0;
                    layout.marginHeight = 0;
                    propertiesContainer.setLayout((Layout)layout);
                    propertiesContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                    Iterator iterator = templatePropertyCollection.iterator();
                    while (iterator.hasNext()) {
                        TemplateProperty templateProperty;
                        TemplateProperty templatePropertyWidget = templateProperty = (TemplateProperty)iterator.next();
                        PropertyComposite swtPropertyWidget = SWTCustomPanelGenerator.createPropertyControl(toolkit, propertiesContainer, templatePropertyWidget);
                        this.widgetMap.put((TemplateWidget)templatePropertyWidget, (Control)swtPropertyWidget);
                        this.configureWidgetsInTextComposite((TemplateWritableWidget)templatePropertyWidget, swtPropertyWidget, templatePropertyWidget.getStyle());
                    }
                    propertyIndexEnd = 0;
                    templatePropertyCollection.clear();
                }
            } else if (child instanceof TemplateRadioGroup) {
                final TemplateRadioGroup radioGroupTemplate = (TemplateRadioGroup)child;
                Composite radioGroupComposite = SWTCustomPanelGenerator.createRadioButtonGroup(toolkit, swtContainer, radioGroupTemplate);
                this.widgetMap.put((TemplateWidget)radioGroupTemplate, (Control)radioGroupComposite);
                List items = radioGroupTemplate.getItems();
                for (TemplateSelectableWidget item : items) {
                    if (!(item instanceof TemplateRadioButton)) continue;
                    final TemplateRadioButton radioButtonTemplate = (TemplateRadioButton)item;
                    final Button radioButton = SWTCustomPanelGenerator.createRadioButton(toolkit, radioGroupComposite, radioButtonTemplate);
                    this.widgetMap.put((TemplateWidget)radioButtonTemplate, (Control)radioButton);
                    if (radioButtonTemplate.isSelected()) {
                        radioButton.setSelection(true);
                    }
                    final TemplateCustomPanel.UserData userData2 = radioGroupTemplate.getUserData();
                    final LinkedList<Composite> visibleComposites = new LinkedList<Composite>();
                    final LinkedList<Composite> enableComposites = new LinkedList<Composite>();
                    Map children = radioButtonTemplate.getChildren();
                    if (children != null && !children.isEmpty()) {
                        Set entries = children.entrySet();
                        for (Map.Entry entry : entries) {
                            TemplateWidgetContainer templateChildContainer = (TemplateWidgetContainer)entry.getKey();
                            Composite swtChildContainer = SWTCustomPanelGenerator.createComposite(toolkit, radioGroupComposite, templateChildContainer);
                            this.widgetMap.put((TemplateWidget)templateChildContainer, (Control)swtChildContainer);
                            this.createChildrenControls(toolkit, templateChildContainer, swtChildContainer);
                            TemplateSelectableWidget.DeselectAction action = (TemplateSelectableWidget.DeselectAction)entry.getValue();
                            if (action == TemplateSelectableWidget.DeselectAction.HIDE) {
                                visibleComposites.add(swtChildContainer);
                                continue;
                            }
                            if (action != TemplateSelectableWidget.DeselectAction.DISABLE) continue;
                            enableComposites.add(swtChildContainer);
                        }
                    }
                    radioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            GeneratedSWTCustomPanel.this.setErrorStatus(null);
                            GeneratedSWTCustomPanel.this.setMessageStatus(null);
                            GeneratedSWTCustomPanel.this.setPageComplete(true);
                            boolean buttonSelected = radioButton.getSelection();
                            if (buttonSelected) {
                                radioButtonTemplate.setSelected();
                            }
                            for (Composite comp : visibleComposites) {
                                GeneratedSWTCustomPanel.this.setCompositeVisible(comp, buttonSelected);
                            }
                            for (Composite comp : enableComposites) {
                                comp.setEnabled(buttonSelected);
                                GeneratedSWTCustomPanel.this.recursiveEnableControl(comp, buttonSelected);
                            }
                            if (buttonSelected && (radioGroupTemplate.getTriggerUpdate() || SharedUIUtils.anyRadioButtonTriggerUpdate((TemplateRadioGroup)radioGroupTemplate))) {
                                GeneratedSWTCustomPanel.this.template.updateWidgets(userData2);
                                GeneratedSWTCustomPanel.this.updateSWTWidgets();
                            }
                        }
                    });
                }
            } else if (child instanceof TemplateCheckBox) {
                final TemplateCheckBox checkButtonTemplate = (TemplateCheckBox)child;
                final Button checkButton = SWTCustomPanelGenerator.createCheckButton(toolkit, swtContainer, checkButtonTemplate);
                this.widgetMap.put((TemplateWidget)checkButtonTemplate, (Control)checkButton);
                final LinkedList<Composite> visibleComposites = new LinkedList<Composite>();
                final LinkedList<Composite> enableComposites = new LinkedList<Composite>();
                Map children = checkButtonTemplate.getChildren();
                if (children != null && !children.isEmpty()) {
                    Set entries = children.entrySet();
                    for (Map.Entry entry : entries) {
                        TemplateWidgetContainer childTemplateContainer = (TemplateWidgetContainer)entry.getKey();
                        Composite childSWTContainer = SWTCustomPanelGenerator.createComposite(toolkit, swtContainer, childTemplateContainer);
                        this.widgetMap.put((TemplateWidget)childTemplateContainer, (Control)childSWTContainer);
                        this.createChildrenControls(toolkit, childTemplateContainer, childSWTContainer);
                        TemplateSelectableWidget.DeselectAction action = (TemplateSelectableWidget.DeselectAction)entry.getValue();
                        if (action == TemplateSelectableWidget.DeselectAction.HIDE) {
                            visibleComposites.add(childSWTContainer);
                            continue;
                        }
                        if (action != TemplateSelectableWidget.DeselectAction.DISABLE) continue;
                        enableComposites.add(childSWTContainer);
                    }
                }
                checkButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        GeneratedSWTCustomPanel.this.setErrorStatus(null);
                        GeneratedSWTCustomPanel.this.setMessageStatus(null);
                        GeneratedSWTCustomPanel.this.setPageComplete(true);
                        TemplateCustomPanel.UserData userData = checkButtonTemplate.getUserData();
                        boolean buttonSelected = checkButton.getSelection();
                        checkButtonTemplate.setSelected(buttonSelected);
                        for (Composite comp : visibleComposites) {
                            GeneratedSWTCustomPanel.this.setCompositeVisible(comp, buttonSelected);
                        }
                        for (Composite comp : enableComposites) {
                            comp.setEnabled(buttonSelected);
                            GeneratedSWTCustomPanel.this.recursiveEnableControl(comp, buttonSelected);
                        }
                        if (checkButtonTemplate.getTriggerUpdate()) {
                            GeneratedSWTCustomPanel.this.template.updateWidgets(userData);
                            GeneratedSWTCustomPanel.this.updateSWTWidgets();
                        }
                    }
                });
            } else if (child instanceof TemplateReadonlyList) {
                tempList = (TemplateReadonlyList)child;
                org.eclipse.swt.widgets.List swtList = SWTCustomPanelGenerator.createReadonlyList(toolkit, swtContainer, tempList);
                this.widgetMap.put((TemplateWidget)tempList, (Control)swtList);
                new ControlDecorations((Control)swtList, swtContainer);
            } else if (child instanceof TemplateSingleSelectList && ((TemplateSingleSelectList)child).isDropDown()) {
                tempList = (TemplateSingleSelectList)child;
                final Combo dropDownCombo = SWTCustomPanelGenerator.createCombo(toolkit, swtContainer, (TemplateSingleSelectList)tempList);
                this.widgetMap.put((TemplateWidget)tempList, (Control)dropDownCombo);
                userData = tempList.getUserData();
                dropDownCombo.addSelectionListener((SelectionListener)new SelectionAdapter((TemplateSingleSelectList)tempList, userData){
                    private final /* synthetic */ TemplateSingleSelectList val$tempList;
                    private final /* synthetic */ TemplateCustomPanel.UserData val$userData;
                    {
                        this.val$tempList = templateSingleSelectList;
                        this.val$userData = userData;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        GeneratedSWTCustomPanel.this.setErrorStatus(null);
                        GeneratedSWTCustomPanel.this.setMessageStatus(null);
                        GeneratedSWTCustomPanel.this.setPageComplete(true);
                        int selectionIndex = dropDownCombo.getSelectionIndex();
                        this.val$tempList.setSelected(selectionIndex);
                        if (this.val$tempList.getTriggerUpdate()) {
                            GeneratedSWTCustomPanel.this.template.updateWidgets(this.val$userData);
                            GeneratedSWTCustomPanel.this.updateSWTWidgets();
                        }
                    }
                });
                decs = this.widgetDecorations.get(userData.getId());
                if (decs == null) {
                    decs = new ControlDecorations((Control)dropDownCombo, swtContainer);
                    this.widgetDecorations.put(userData.getId(), decs);
                } else {
                    decs.addDecoration((Control)dropDownCombo, swtContainer);
                }
            } else if (child instanceof TemplateSelectableList) {
                tempList = (TemplateSelectableList)child;
                org.eclipse.swt.widgets.List swtList = SWTCustomPanelGenerator.createList(toolkit, swtContainer, (TemplateSelectableList)tempList);
                this.widgetMap.put((TemplateWidget)tempList, (Control)swtList);
                userData = tempList.getUserData();
                swtList.addSelectionListener((SelectionListener)new SelectionAdapter((TemplateSelectableList)tempList, swtList, userData){
                    private final /* synthetic */ TemplateSelectableList val$tempList;
                    private final /* synthetic */ org.eclipse.swt.widgets.List val$swtList;
                    private final /* synthetic */ TemplateCustomPanel.UserData val$userData;
                    {
                        this.val$tempList = templateSelectableList;
                        this.val$swtList = list;
                        this.val$userData = userData;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        GeneratedSWTCustomPanel.this.setErrorStatus(null);
                        GeneratedSWTCustomPanel.this.setMessageStatus(null);
                        GeneratedSWTCustomPanel.this.setPageComplete(true);
                        this.val$tempList.setSelectedIndexes(this.val$swtList.getSelectionIndices());
                        if (this.val$tempList.getTriggerUpdate()) {
                            GeneratedSWTCustomPanel.this.template.updateWidgets(this.val$userData);
                            GeneratedSWTCustomPanel.this.updateSWTWidgets();
                        }
                    }
                });
                decs = this.widgetDecorations.get(userData.getId());
                if (decs == null) {
                    decs = new ControlDecorations((Control)swtList, swtContainer);
                    this.widgetDecorations.put(userData.getId(), decs);
                } else {
                    decs.addDecoration((Control)swtList, swtContainer);
                }
            }
            ++i;
        }
    }

    private void configureWidgetsInTextComposite(final TemplateWritableWidget templateTextOrProperty, final TextComposite swtTextComposite, final TemplateConstants.TextStyle style) {
        ControlDecorations decs;
        Button browseButton;
        final TemplateCustomPanel.UserData userData = templateTextOrProperty.getUserData();
        final Text swtText = swtTextComposite.getTextWidget();
        if (swtText.getEditable()) {
            swtText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    GeneratedSWTCustomPanel.this.setErrorStatus(null);
                    GeneratedSWTCustomPanel.this.setMessageStatus(null);
                    GeneratedSWTCustomPanel.this.setPageComplete(true);
                    char[] textChars = swtText.getTextChars();
                    templateTextOrProperty.setProfileValueChars(textChars);
                    SharedUIUtils.clearText((char[])textChars);
                    if (templateTextOrProperty.getTriggerUpdate()) {
                        GeneratedSWTCustomPanel.this.template.updateWidgets(userData);
                        GeneratedSWTCustomPanel.this.updateSWTWidgets();
                    }
                }
            });
        }
        if ((browseButton = swtTextComposite.getBrowseButton()) != null) {
            browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String selectedFile;
                    if (style == TemplateConstants.TextStyle.DIRECTORY) {
                        String directory = UiServices.getInstance().getDirectoryDialog(swtTextComposite.getShell()).title(Messages.CommonLocationPage_commonDialogTitle).message(Messages.GeneratedSWTCustomPanel_BrowseDirectory).filterPath(swtText.getText()).run();
                        if (directory != null) {
                            swtText.setText(directory.trim());
                        }
                    } else if (style == TemplateConstants.TextStyle.FILE && (selectedFile = UiServices.getInstance().getFileDialog(swtTextComposite.getShell()).title(Messages.GeneratedSWTCustomPanel_BrowseFile).filterPath(swtText.getText()).run()) != null) {
                        swtText.setText(selectedFile);
                    }
                }
            });
        }
        if ((decs = this.widgetDecorations.get(userData.getId())) == null) {
            decs = new ControlDecorations((Control)swtTextComposite, swtTextComposite.getParent());
            this.widgetDecorations.put(userData.getId(), decs);
        } else {
            decs.addDecoration((Control)swtTextComposite, swtTextComposite.getParent());
        }
    }

    private void setCompositeVisible(Composite comp, boolean visible) {
        Composite parentComp = comp.getParent();
        if (parentComp == null) {
            comp.setVisible(visible);
        } else {
            Layout parentLayout = parentComp.getLayout();
            if (parentLayout instanceof StackLayout) {
                StackLayout stackLayout = (StackLayout)parentLayout;
                if (visible) {
                    stackLayout.topControl = comp;
                    parentComp.layout();
                }
            } else {
                comp.setVisible(visible);
            }
        }
    }

    private void recursiveEnableChildrenWidgets(TemplateWidget widget, boolean enabled) {
        List children = null;
        if (widget instanceof TemplateWidgetContainer) {
            children = ((TemplateWidgetContainer)widget).getChildren();
        } else if (widget instanceof TemplateSelectableWidgetContainer) {
            children = ((TemplateSelectableWidgetContainer)widget).getItems();
        }
        if (children != null) {
            for (TemplateWidget child : children) {
                child.enabled(enabled);
                if (!(child instanceof TemplateWidgetContainer) && !(child instanceof TemplateSelectableWidgetContainer)) continue;
                this.recursiveEnableChildrenWidgets(child, enabled);
            }
        }
    }

    private void recursiveEnableControl(Composite composite, boolean enabled) {
        Control[] children = composite.getChildren();
        if (children != null) {
            Control[] controlArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.setEnabled(enabled);
                if (control instanceof Composite) {
                    this.recursiveEnableControl((Composite)control, enabled);
                }
                ++n2;
            }
        }
    }

    private void updateSWTWidgets() {
        this.updateSWTWidgets(false);
    }

    private void updateSWTWidgets(boolean setInitialStatus) {
        if (this.widgetMap != null && !this.widgetMap.isEmpty()) {
            Control topControl;
            boolean swtControlChanged = false;
            for (Map.Entry<TemplateWidget, Control> entry : this.widgetMap.entrySet()) {
                org.eclipse.swt.widgets.List swtList;
                Object[] displayLabels;
                TemplateSingleSelectList tempList;
                Control swtWidget;
                boolean currentWidgetChanged = false;
                TemplateWidget templateWidget = entry.getKey();
                boolean statusUpdated = this.updateWidgetStatus(templateWidget, swtWidget = entry.getValue());
                if (statusUpdated) {
                    currentWidgetChanged = true;
                }
                if (templateWidget instanceof TemplateLabel && (swtWidget instanceof Label || swtWidget instanceof Link)) {
                    TemplateLabel templateLabel = (TemplateLabel)templateWidget;
                    String templateDisplayString = templateLabel.getDisplayLabel();
                    String swtWidgetLabel = null;
                    if (swtWidget instanceof Label) {
                        Label swtLabel = (Label)swtWidget;
                        swtWidgetLabel = swtLabel.getText();
                    } else {
                        Link swtLink = (Link)swtWidget;
                        swtWidgetLabel = swtLink.getText();
                    }
                    if (templateDisplayString != null && !templateDisplayString.equals(swtWidgetLabel)) {
                        currentWidgetChanged = true;
                        if (swtWidget instanceof Label) {
                            ((Label)swtWidget).setText(templateDisplayString);
                        } else {
                            ((Link)swtWidget).setText(templateDisplayString);
                        }
                        swtWidget.redraw();
                    }
                } else if (templateWidget instanceof TemplateText && swtWidget instanceof TextComposite) {
                    char[] textChars;
                    TemplateText templateText = (TemplateText)templateWidget;
                    TextComposite swtTextComp = (TextComposite)swtWidget;
                    Text swtText = swtTextComp.getTextWidget();
                    char[] valueArray = templateText.getProfileValueChars();
                    if (!Arrays.equals(valueArray, textChars = swtText.getTextChars())) {
                        currentWidgetChanged = true;
                        swtText.setTextChars(valueArray);
                    }
                    if (valueArray != null) {
                        SharedUIUtils.clearText((char[])valueArray);
                    }
                    if (textChars != null) {
                        SharedUIUtils.clearText((char[])textChars);
                    }
                } else if (templateWidget instanceof TemplateProperty && swtWidget instanceof PropertyComposite) {
                    char[] textChars;
                    TemplateProperty templateProperty = (TemplateProperty)templateWidget;
                    Text swtText = ((PropertyComposite)swtWidget).getTextWidget();
                    char[] valueArray = templateProperty.getProfileValueChars();
                    if (!Arrays.equals(valueArray, textChars = swtText.getTextChars())) {
                        currentWidgetChanged = true;
                        swtText.setTextChars(valueArray);
                    }
                    if (valueArray != null) {
                        SharedUIUtils.clearText((char[])valueArray);
                    }
                    if (textChars != null) {
                        SharedUIUtils.clearText((char[])textChars);
                    }
                } else if (templateWidget instanceof TemplateCheckBox && swtWidget instanceof Button) {
                    TemplateCheckBox templateCheckButton = (TemplateCheckBox)templateWidget;
                    Button swtCheckButton = (Button)swtWidget;
                    if (templateCheckButton.isSelected()) {
                        if (!swtCheckButton.getSelection()) {
                            swtCheckButton.setSelection(true);
                            this.updateChildrenStatus((TemplateSelectableWidget)templateCheckButton, true);
                        }
                    } else if (swtCheckButton.getSelection() || setInitialStatus) {
                        swtCheckButton.setSelection(false);
                        this.updateChildrenStatus((TemplateSelectableWidget)templateCheckButton, false);
                    }
                } else if (templateWidget instanceof TemplateRadioButton && swtWidget instanceof Button) {
                    TemplateRadioButton templateRadioButton = (TemplateRadioButton)templateWidget;
                    Button swtRadioButton = (Button)swtWidget;
                    if (templateRadioButton.isSelected()) {
                        if (!swtRadioButton.getSelection()) {
                            swtRadioButton.setSelection(true);
                            this.updateChildrenStatus((TemplateSelectableWidget)templateRadioButton, true);
                        }
                    } else if (swtRadioButton.getSelection() || setInitialStatus) {
                        swtRadioButton.setSelection(false);
                        this.updateChildrenStatus((TemplateSelectableWidget)templateRadioButton, false);
                    }
                } else if (templateWidget instanceof TemplateSingleSelectList && swtWidget instanceof Combo) {
                    tempList = (TemplateSingleSelectList)templateWidget;
                    Combo dropDownCombo = (Combo)swtWidget;
                    displayLabels = tempList.getLabels();
                    if (!Arrays.deepEquals(dropDownCombo.getItems(), displayLabels)) {
                        currentWidgetChanged = true;
                        dropDownCombo.setItems((String[])displayLabels);
                    }
                    int widgetIndex = tempList.getSelected();
                    if (dropDownCombo.getSelectionIndex() != widgetIndex) {
                        currentWidgetChanged = true;
                        if (widgetIndex == -1) {
                            dropDownCombo.clearSelection();
                        } else {
                            dropDownCombo.select(widgetIndex);
                        }
                    }
                } else if (templateWidget instanceof TemplateSelectableList && swtWidget instanceof org.eclipse.swt.widgets.List) {
                    tempList = (TemplateSelectableList)templateWidget;
                    swtList = (org.eclipse.swt.widgets.List)swtWidget;
                    displayLabels = tempList.getLabels();
                    if (!Arrays.deepEquals(swtList.getItems(), displayLabels)) {
                        currentWidgetChanged = true;
                        swtList.setItems((String[])displayLabels);
                    }
                    int[] currentSelection = tempList.getSelectedIndexes();
                    if (!Arrays.equals(swtList.getSelectionIndices(), currentSelection)) {
                        currentWidgetChanged = true;
                        swtList.deselectAll();
                        swtList.select(currentSelection);
                    }
                } else if (templateWidget instanceof TemplateReadonlyList) {
                    tempList = (TemplateReadonlyList)templateWidget;
                    swtList = (org.eclipse.swt.widgets.List)swtWidget;
                    displayLabels = tempList.getLabels();
                    if (!Arrays.deepEquals(swtList.getItems(), displayLabels)) {
                        currentWidgetChanged = true;
                        swtList.setItems((String[])displayLabels);
                    }
                } else if (!(templateWidget instanceof TemplateWidgetContainer || templateWidget instanceof TemplateRadioGroup || templateWidget instanceof TemplatePushButton)) {
                    throw new AssertionError((Object)("Unexpected template widget type: " + templateWidget));
                }
                if (!currentWidgetChanged) continue;
                swtControlChanged = true;
                Composite labelParent = swtWidget.getParent();
                if (labelParent == null) continue;
                labelParent.layout();
            }
            if (swtControlChanged && (topControl = this.getControl()) instanceof Composite) {
                Composite topComposite = (Composite)topControl;
                topComposite.layout();
            }
        }
    }

    private void updateChildrenStatus(TemplateSelectableWidget selectableWidget, boolean select) {
        Map selectableChildren = selectableWidget.getChildren();
        if (selectableChildren == null) {
            return;
        }
        for (Map.Entry childEntry : selectableChildren.entrySet()) {
            TemplateWidgetContainer childContainer = (TemplateWidgetContainer)childEntry.getKey();
            TemplateSelectableWidget.DeselectAction action = (TemplateSelectableWidget.DeselectAction)childEntry.getValue();
            if (action == TemplateSelectableWidget.DeselectAction.DISABLE) {
                childContainer.enabled(select);
                continue;
            }
            if (action != TemplateSelectableWidget.DeselectAction.HIDE) continue;
            childContainer.visible(select);
        }
    }

    private boolean checkSWTWidgetVisible(Control swtWidget) {
        Layout layout;
        Composite parentComp;
        if (swtWidget instanceof Composite && (parentComp = ((Composite)swtWidget).getParent()) != null && (layout = parentComp.getLayout()) instanceof StackLayout) {
            StackLayout stackLayout = (StackLayout)layout;
            Control topControl = stackLayout.topControl;
            return topControl == swtWidget;
        }
        return swtWidget.getVisible();
    }

    private boolean updateWidgetStatus(TemplateWidget widgetTemplate, Control swtWidget) {
        boolean swtEnabled;
        boolean templateEnabled;
        boolean swtVisible;
        boolean widgetUpdated = false;
        boolean templateVisible = widgetTemplate.getVisible();
        if (templateVisible != (swtVisible = this.checkSWTWidgetVisible(swtWidget))) {
            widgetUpdated = true;
            if (swtWidget instanceof Composite) {
                this.setCompositeVisible((Composite)swtWidget, templateVisible);
            } else {
                swtWidget.setVisible(templateVisible);
            }
        }
        if ((templateEnabled = widgetTemplate.getEnabled()) != (swtEnabled = swtWidget.getEnabled())) {
            widgetUpdated = true;
            swtWidget.setEnabled(templateEnabled);
            if ((widgetTemplate instanceof TemplateWidgetContainer || widgetTemplate instanceof TemplateSelectableWidgetContainer) && swtWidget instanceof Composite) {
                this.recursiveEnableChildrenWidgets(widgetTemplate, templateEnabled);
                this.recursiveEnableControl((Composite)swtWidget, templateEnabled);
            }
        }
        return widgetUpdated;
    }

    @Override
    public boolean shouldSkip() {
        return this.template.shouldSkip();
    }

    @Override
    public String getPanelId() {
        return this.template.getPanelTitle();
    }

    @Override
    public void initCustomPanelData(ICustomPanelData panelData) {
        this.template.initCustomPanelData(panelData);
        super.initCustomPanelData(panelData);
    }

    @Override
    public boolean canAddPanel() {
        return this.template.canAddPanelToWizard();
    }

    @Override
    public void setInitialData() {
        this.template.startInitializing();
        this.template.loadProfilePropertyValues();
        this.updateSWTWidgets(true);
        boolean reportValidationStatus = AgentInput.getInstance().showValidationResult();
        this.validateAndUpdateStatus(reportValidationStatus);
        this.template.endInitializing();
    }

    private void updateDecorations(Map<String, IStatus> widgetIdStatusMap) {
        this.clearAllDecorations();
        if (!widgetIdStatusMap.isEmpty()) {
            Set<Map.Entry<String, IStatus>> entries = widgetIdStatusMap.entrySet();
            for (Map.Entry<String, IStatus> entry : entries) {
                String widgetId = entry.getKey();
                IStatus status = entry.getValue();
                ControlDecorations decorations = this.widgetDecorations.get(widgetId);
                if (status == null || decorations == null) continue;
                decorations.applyStatus(status);
            }
        }
    }

    private void clearAllDecorations() {
        Collection<ControlDecorations> decs = this.widgetDecorations.values();
        for (ControlDecorations decoration : decs) {
            decoration.setVisible(false);
        }
    }

    private IStatus singletonValidationStatus(Map<String, IStatus> widgetIdStatusMap) {
        CicMultiStatus ms = Statuses.ST.createMultiStatus();
        ms.addAll(widgetIdStatusMap.values());
        return StatusUtil.fixMultiStatusNoMsgProblem((IStatus)ms);
    }

    public boolean validateCustomPanel(boolean allowLeaveCurrentPanelIfError, boolean allowStayOnCurrentPanel) {
        IStatus status = this.validateAndUpdateStatus(true);
        if (!status.isOK()) {
            return this.displayDialogWithResult(status, allowLeaveCurrentPanelIfError, allowStayOnCurrentPanel);
        }
        return true;
    }

    private IStatus validateAndUpdateStatus(boolean reportValidationStatus) {
        final CicStatusInfo statusInfo = new CicStatusInfo();
        try {
            CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    try {
                        try {
                            statusInfo.statusMap = GeneratedSWTCustomPanel.this.template.validateInteractiveMode(monitor);
                            statusInfo.singleStatus = GeneratedSWTCustomPanel.this.singletonValidationStatus(statusInfo.statusMap);
                        }
                        catch (RuntimeStatusException e) {
                            statusInfo.singleStatus = e.getStatus();
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            AgentUI.reportException(e);
        }
        catch (InterruptedException e) {
            AgentUI.reportException(e);
        }
        if (reportValidationStatus) {
            this.updateDecorations(statusInfo.statusMap);
        } else {
            this.clearAllDecorations();
        }
        IStatus status = statusInfo.singleStatus;
        if (StatusUtil.isErrorOrCancel((IStatus)status)) {
            if (reportValidationStatus) {
                this.setErrorStatus(status);
            } else {
                this.setErrorStatus(null);
            }
            this.setPageComplete(false);
        } else {
            if (reportValidationStatus) {
                this.setErrorStatus(null);
                this.setMessageStatus((IStatus)(status.matches(3) ? status : null));
            } else {
                this.setErrorStatus(null);
                this.setMessageStatus(null);
            }
            this.setPageComplete(true);
            this.template.storeProfilePropertyValues();
        }
        return status;
    }

    private boolean displayDialogWithResult(IStatus status, boolean allowLeaveCurrentPanelIfError, boolean allowStayOnCurrentPanel) {
        boolean moveToOtherPage = false;
        String dlgTitle = com.ibm.cic.common.core.sharedUI.Messages.DialogTitle_Info;
        if (StatusUtil.isErrorOrCancel((IStatus)status)) {
            dlgTitle = com.ibm.cic.common.core.sharedUI.Messages.DialogTitle_Error;
        } else if (status.matches(2)) {
            dlgTitle = com.ibm.cic.common.core.sharedUI.Messages.DialogTitle_Warning;
        }
        if (!allowStayOnCurrentPanel || !allowLeaveCurrentPanelIfError && StatusUtil.isErrorOrCancel((IStatus)status)) {
            WrapDetailUIDErrorDialog errorDialog = new WrapDetailUIDErrorDialog(AgentUI.getActiveWorkbenchShell(), dlgTitle, null, status, 15);
            errorDialog.open();
        } else {
            YesNoErrorDialog errorDlg = new YesNoErrorDialog(AgentUI.getActiveWorkbenchShell(), dlgTitle, null, status, 15, JFaceResources.getString((String)"ok"), JFaceResources.getString((String)"cancel"));
            int result = errorDlg.open();
            if (result == 2) {
                moveToOtherPage = true;
            }
        }
        return moveToOtherPage;
    }

    public IStatus getErrorStatus() {
        return this.errorStatus;
    }

    public void setErrorStatus(IStatus errorStatus) {
        this.errorStatus = errorStatus;
        if (this.isCurrentPanel()) {
            this.getContainer().setErrorMessageWithStatus(errorStatus);
        }
    }

    public IStatus getMessageStatus() {
        return this.messageStatus;
    }

    public void setMessageStatus(IStatus messageStatus) {
        this.messageStatus = messageStatus;
        if (this.isCurrentPanel()) {
            this.getContainer().setMessageWithStatus(messageStatus);
        }
    }

    @Override
    public String getHelpRef() {
        return this.template.getHelpRef();
    }

    @Override
    public IStatus performFinish(IProgressMonitor monitor) {
        return this.template.performFinish(monitor);
    }

    @Override
    public void setVisible(boolean a_visible) {
        boolean needRefreshSWTWidgets;
        super.setVisible(a_visible);
        if (a_visible && (needRefreshSWTWidgets = this.template.updateWidgetsOnVisible())) {
            this.updateSWTWidgets(false);
        }
    }

    private static class CicStatusInfo {
        Map<String, IStatus> statusMap = Collections.EMPTY_MAP;
        IStatus singleStatus = Status.OK_STATUS;

        private CicStatusInfo() {
        }
    }
}

