/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.custompanel;

import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.ui.CICImages;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ControlDecorations {
    private final List<ControlDecoration> decorations = new LinkedList<ControlDecoration>();

    public ControlDecorations(Control control, Composite parent) {
        ControlDecoration dec = new ControlDecoration(control, 16512, parent);
        dec.setMarginWidth(1);
        dec.setShowHover(true);
        this.decorations.add(dec);
    }

    public void addDecoration(Control control, Composite parent) {
        ControlDecoration dec = new ControlDecoration(control, 16512, parent);
        dec.setMarginWidth(1);
        dec.setShowHover(true);
        this.decorations.add(dec);
    }

    public List<ControlDecoration> getControlDecorations() {
        return this.decorations;
    }

    public void setVisible(boolean a_visible) {
        for (ControlDecoration dec : this.decorations) {
            if (a_visible) {
                dec.show();
                continue;
            }
            dec.hide();
        }
    }

    public void applyStatus(IStatus status) {
        for (ControlDecoration dec : this.decorations) {
            if (StatusUtil.isErrorOrCancel((IStatus)status) || status.matches(2)) {
                if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                    dec.setImage(AgentUI.getDefault().getLabelProvider().get(CICImages.DESC_ERROR_CO));
                } else {
                    dec.setImage(AgentUI.getDefault().getLabelProvider().get(CICImages.DESC_WARNING_CO));
                }
                dec.setDescriptionText(status.getMessage());
                dec.show();
                continue;
            }
            dec.hide();
        }
    }
}

