/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentRelaunch;
import com.ibm.cic.agent.core.InstallJob;
import com.ibm.cic.agent.core.internal.headless.AgentInput;
import com.ibm.cic.agent.core.sharedUI.ProfileOffering;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.AgentUIActionBarAdvisor;
import com.ibm.cic.agent.internal.ui.AgentUIWorkbenchAdvisorListener;
import com.ibm.cic.agent.internal.ui.licenses.Messages;
import com.ibm.cic.agent.internal.ui.utils.DefaultLicenseSelection;
import com.ibm.cic.agent.internal.ui.wizards.AbstractAgentUIPrimaryPage;
import com.ibm.cic.agent.internal.ui.wizards.AvailableFixPage;
import com.ibm.cic.agent.internal.ui.wizards.AvailableOfferingPageWrapper;
import com.ibm.cic.agent.internal.ui.wizards.AvailableRollbackPage;
import com.ibm.cic.agent.internal.ui.wizards.AvailableUpdatePageWrapper;
import com.ibm.cic.agent.internal.ui.wizards.InstalledOfferingsPage;
import com.ibm.cic.agent.internal.ui.wizards.LicensePrimaryWizard;
import com.ibm.cic.agent.internal.ui.wizards.LicensesByPackagePage;
import com.ibm.cic.agent.internal.ui.wizards.ModifyProfileSelectionPage;
import com.ibm.cic.agent.internal.ui.wizards.PrimaryInstallWizard;
import com.ibm.cic.agent.internal.ui.wizards.PrimaryRollbackWizard;
import com.ibm.cic.agent.internal.ui.wizards.PrimaryUpdateWizard;
import com.ibm.cic.agent.internal.ui.wizards.PrimaryWizard;
import com.ibm.cic.agent.internal.ui.wizards.ResponseFileGenAvailablePkgWizard;
import com.ibm.cic.agent.internal.ui.wizards.ResponseFileGenInstalledPkgWizard;
import com.ibm.cic.agent.internal.ui.wizards.RollbackProfileSelectionPage;
import com.ibm.cic.agent.internal.ui.wizards.UpdateFixPage;
import com.ibm.cic.agent.internal.ui.wizards.UpdateProfileSelectionPage;
import com.ibm.cic.agent.internal.ui.wizards.WizardView;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.utils.LicenseUtils;
import com.ibm.cic.common.core.preferences.CicPreferenceManager;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.logging.ExceptionUtil;
import com.ibm.cic.common.ui.CICImages;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.ShellAdapterFactory;
import com.ibm.cic.common.ui.internal.views.AbstractCicWizardView;
import com.ibm.cic.common.ui.internal.wizardry.AbstractCicWizard;
import com.ibm.cic.common.ui.services.UiServices;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.osgi.service.prefs.BackingStoreException;

public class AgentUIWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    private ShellAdapterFactory shellAdapterFactory;

    public AgentUIWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new AgentUIActionBarAdvisor(configurer);
    }

    public void preWindowOpen() {
        this.configureWindow();
    }

    public void configureWindow() {
        final IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        this.setupStandardMode(configurer);
        if (AgentInput.getInstance().getMode() == 1) {
            configurer.setShowMenuBar(false);
            configurer.setShowStatusLine(false);
        } else if (AgentInput.getInstance().getMode() == 3) {
            configurer.setShellStyle(8);
            configurer.setShowMenuBar(true);
            configurer.setShowStatusLine(false);
        } else {
            configurer.setShowMenuBar(true);
            configurer.setShowStatusLine(true);
        }
        AgentUI.getDefault().getWorkbenchAdvisor().addListener(new AgentUIWorkbenchAdvisorListener(){

            @Override
            public void prePerspectiveChange(String newPerspectiveId) {
                if ("com.ibm.cic.agent.ui.wizards".equals(newPerspectiveId)) {
                    AgentUIWorkbenchWindowAdvisor.this.setupWizardMode(configurer);
                } else {
                    configurer.setShowMenuBar(true);
                    configurer.setShowStatusLine(true);
                }
            }
        });
    }

    private void setupStandardMode(IWorkbenchWindowConfigurer configurer) {
        if (!Agent.getInstance().isServerMode()) {
            configurer.setInitialSize(this.getStoredShellSize());
        }
        configurer.setShowCoolBar(false);
        configurer.setShowStatusLine(true);
        configurer.setShowProgressIndicator(false);
        configurer.setTitle(com.ibm.cic.agent.internal.ui.Messages.AgentUIWorkbenchWindowAdvisor_windowTitle);
    }

    private Point getStoredShellSize() {
        Point storedSize = new Point(1024, 768);
        try {
            String windowSize = AgentUI.getDefault().getAgentPreferenceStore().getString(ICicPreferenceConstants.WINDOW_SIZE.key());
            if (windowSize.length() > 0) {
                storedSize = AgentUIWorkbenchWindowAdvisor.deserializePoint(windowSize);
            }
        }
        catch (RuntimeException e) {
            ExceptionUtil.debugLogToReview((Throwable)e);
        }
        return storedSize;
    }

    public void postWindowCreate() {
        if (AgentInput.getInstance().getMode() == 3) {
            Shell shell = this.getWindowConfigurer().getWindow().getShell();
            shell.setMaximized(true);
        }
    }

    private void savePluginPreferences() {
        try {
            InstanceScope.INSTANCE.getNode("com.ibm.cic.agent.ui").flush();
        }
        catch (BackingStoreException e) {
            AgentUI.reportException(e, false);
        }
    }

    private void setupWizardMode(IWorkbenchWindowConfigurer configurer) {
        AgentInput agentInput = AgentInput.getInstance();
        int wizardSubMode = agentInput.getWizardSubMode();
        if (wizardSubMode == 7) {
            ResponseFileGenInstalledPkgWizard wizard = new ResponseFileGenInstalledPkgWizard();
            AgentUI.getDefault().setCurrentWizard(wizard);
        } else if (wizardSubMode == 8) {
            ResponseFileGenAvailablePkgWizard wizard = new ResponseFileGenAvailablePkgWizard();
            AgentUI.getDefault().setCurrentWizard(wizard);
        } else if (wizardSubMode == 0) {
            PrimaryInstallWizard wizard = new PrimaryInstallWizard(Messages.InstallWizard_installing, Messages.InstallAction_finishButtonLabel, CICImages.WIZ_INSTALL);
            AvailableOfferingPageWrapper wrapper = new AvailableOfferingPageWrapper(wizard);
            AvailableFixPage fixPage = new AvailableFixPage(wizard);
            wizard.setPrimaryPages(new AbstractAgentUIPrimaryPage[]{wrapper, fixPage});
            wizard.setInput(agentInput.getWizardJobs());
            wizard.setHelpAvailable(true);
            AgentUI.getDefault().setCurrentWizard(wizard);
        } else if (wizardSubMode != 6) {
            if (wizardSubMode == 3) {
                PrimaryUpdateWizard wizard = new PrimaryUpdateWizard(Messages.UpdateWizard_title, Messages.UpdateAction_finishButtonLabel, CICImages.WIZ_CHECKUPDATE);
                UpdateProfileSelectionPage page1 = new UpdateProfileSelectionPage(Messages.UpdateWizard_profilesTitle, com.ibm.cic.agent.internal.ui.Messages.UpdateWizard_profilesDescription, wizard);
                AvailableUpdatePageWrapper wrapper = new AvailableUpdatePageWrapper(wizard);
                UpdateFixPage fixPage = new UpdateFixPage(wizard);
                AbstractAgentUIPrimaryPage[] pages = new AbstractAgentUIPrimaryPage[]{page1, wrapper, fixPage};
                wizard.setPrimaryPages(pages);
                wizard.setInput(agentInput.getWizardJobs());
                wizard.setHelpAvailable(true);
                AgentUI.getDefault().setCurrentWizard(wizard);
            } else if (wizardSubMode == 1) {
                PrimaryWizard wizard = new PrimaryWizard(com.ibm.cic.agent.internal.ui.Messages.UninstallWizard_uninstalling, com.ibm.cic.agent.internal.ui.Messages.UninstallAction_finishButtonLabel, CICImages.WIZ_UNINSTALL);
                InstalledOfferingsPage primaryPage = new InstalledOfferingsPage(com.ibm.cic.agent.internal.ui.Messages.UninstallWizard_profilesTitle, com.ibm.cic.agent.internal.ui.Messages.UninstallWizard_profilesDescription, wizard);
                wizard.setPrimaryPages(new AbstractAgentUIPrimaryPage[]{primaryPage});
                wizard.setHelpAvailable(true);
                wizard.setInput(agentInput.getWizardJobs());
                AgentUI.getDefault().setCurrentWizard(wizard);
            } else if (wizardSubMode == 4) {
                PrimaryRollbackWizard wizard = new PrimaryRollbackWizard(com.ibm.cic.agent.internal.ui.Messages.RollbackWizard_Rollbacking, com.ibm.cic.agent.internal.ui.Messages.RollbackWizard_RollbackButtonLabel, CICImages.WIZ_ROLLBACK);
                RollbackProfileSelectionPage profilePage = new RollbackProfileSelectionPage(com.ibm.cic.agent.internal.ui.Messages.RollbackWizard_ProfilePage_Title, com.ibm.cic.agent.internal.ui.Messages.RollbackWizard_ProfilePage_Desc, wizard);
                AvailableRollbackPage rollbackPage = new AvailableRollbackPage(com.ibm.cic.agent.internal.ui.Messages.RollbackWizard_AvailableRollbackPage_Title, com.ibm.cic.agent.internal.ui.Messages.RollbackWizard_AvailableRollbackPage_Desc, wizard);
                wizard.setPrimaryPages(new AbstractAgentUIPrimaryPage[]{profilePage, rollbackPage});
                wizard.setHelpAvailable(true);
                wizard.setInput(agentInput.getWizardJobs());
                AgentUI.getDefault().setCurrentWizard(wizard);
            } else if (wizardSubMode == 2) {
                PrimaryWizard wizard = new PrimaryWizard(com.ibm.cic.agent.internal.ui.Messages.ModifyWizard_modifying, com.ibm.cic.agent.internal.ui.Messages.ModifyAction_finishButtonLabel, CICImages.WIZ_MODIFY);
                ModifyProfileSelectionPage page = new ModifyProfileSelectionPage(com.ibm.cic.agent.internal.ui.Messages.ModifyWizard_profilesTitle, com.ibm.cic.agent.internal.ui.Messages.ModifyWizard_profilesDescription, wizard);
                wizard.setPrimaryPages(new AbstractAgentUIPrimaryPage[]{page});
                wizard.setHelpAvailable(true);
                wizard.setInput(agentInput.getWizardJobs());
                AgentUI.getDefault().setCurrentWizard(wizard);
            } else if (wizardSubMode == 5) {
                DefaultLicenseSelection defaultSelection = new DefaultLicenseSelection();
                AbstractJob[] jobs = agentInput.getWizardJobs();
                if (jobs != null) {
                    AbstractJob[] abstractJobArray = jobs;
                    int n = jobs.length;
                    int fixPage = 0;
                    while (fixPage < n) {
                        AbstractJob job = abstractJobArray[fixPage];
                        if (job instanceof InstallJob) {
                            InstallJob installJob = (InstallJob)job;
                            IOffering pekOffering = installJob.getPEKOffering();
                            IOffering existingOffering = installJob.getExistingOffering();
                            if (existingOffering != null && (LicenseUtils.isOfferingLumApplicable((IOffering)existingOffering) || LicenseUtils.isOfferingFlexlmApplicable((IOffering)existingOffering) || LicenseUtils.hasExternalLicenseManager((IOffering)existingOffering))) {
                                if (pekOffering != null) {
                                    defaultSelection.setPekOffering(pekOffering);
                                }
                                defaultSelection.setProfileOffering(new ProfileOffering(installJob.getProfile(), existingOffering));
                            }
                        }
                        ++fixPage;
                    }
                }
                if (agentInput.isNeedConfigureFloatingLicense()) {
                    defaultSelection.setLicenceSelection(1);
                } else if (agentInput.isNeedConfigureLUMLicense()) {
                    defaultSelection.setLicenceSelection(0);
                }
                LicensePrimaryWizard wizard = new LicensePrimaryWizard(Messages.ManageLicanseWizardTitle, Messages.LicenseManagementAction_finishButtonLabel);
                LicensesByPackagePage page = new LicensesByPackagePage(defaultSelection, wizard);
                wizard.setPrimaryPages(new AbstractAgentUIPrimaryPage[]{page});
                wizard.setHelpAvailable(true);
                AgentUI.getDefault().setCurrentWizard(wizard);
            }
        }
        if (!Agent.getInstance().isServerMode()) {
            configurer.setInitialSize(this.getStoredShellSize());
        }
        configurer.setShowMenuBar(false);
        configurer.setShowCoolBar(false);
        configurer.setShowStatusLine(false);
        configurer.setShowProgressIndicator(false);
    }

    public boolean preWindowShellClose() {
        boolean exit = true;
        AbstractCicWizard wizard = AgentUI.getDefault().getCurrentWizard();
        if (wizard != null) {
            if (!wizard.isAllowExit()) {
                MessageDialog.openInformation((Shell)this.getWindowConfigurer().getWindow().getShell(), (String)com.ibm.cic.agent.internal.ui.Messages.IgnoreCloseDialog_title, (String)com.ibm.cic.agent.internal.ui.Messages.IgnoreCloseDialog_message);
                exit = false;
            } else {
                exit = MessageDialog.openQuestion((Shell)this.getWindowConfigurer().getWindow().getShell(), (String)com.ibm.cic.agent.internal.ui.Messages.ConfirmExitDlg_title, (String)com.ibm.cic.agent.internal.ui.Messages.ConfirmExitDlg_msg);
                if (!exit) {
                    return false;
                }
                IWizardContainer container = wizard.getContainer();
                if (container instanceof AbstractCicWizardView) {
                    AbstractCicWizardView wizardView = (AbstractCicWizardView)container;
                    boolean hasJobRunning = wizardView.hasJobRunning();
                    if (!hasJobRunning || wizardView.isCanceled() && wizardView.getConfirmCancelStatus() == 0) {
                        wizardView.restoreConfirmCancelStatus();
                        if (exit) {
                            boolean performCloseResult = this.performClose();
                            if (performCloseResult) {
                                AgentRelaunch.getInstance().setNeedsRelaunch(false);
                            }
                            return performCloseResult;
                        }
                    } else {
                        if (wizardView.isCanceled() && wizardView.getConfirmCancelStatus() == -1) {
                            return false;
                        }
                        wizardView.restoreConfirmCancelStatus();
                        wizardView.confirmCancel();
                        Display display = DisplayKeeper.INSTANCE.getDisplay();
                        while (display != null && !display.isDisposed()) {
                            if (display.readAndDispatch() && wizardView.getConfirmCancelStatus() != -1) break;
                            display.sleep();
                        }
                        exit = wizardView.getConfirmCancelStatus() == 0;
                        wizardView.restoreConfirmCancelStatus();
                        if (exit) {
                            return this.performClose();
                        }
                    }
                }
            }
        }
        return exit;
    }

    private boolean performClose() {
        IWorkbenchWindow window = this.getWindowConfigurer().getWindow();
        IViewPart foundView = window.getActivePage().findView("com.ibm.cic.agent.ui.wizardsView");
        if (foundView != null && foundView instanceof WizardView) {
            return ((WizardView)foundView).close();
        }
        return false;
    }

    public void postWindowOpen() {
        Shell shell;
        super.postWindowOpen();
        Shell activeWindowShell = this.getWindowConfigurer().getWindow().getShell();
        if (activeWindowShell != null) {
            UiServices.getInstance().setWorkbenchWindowTitle(activeWindowShell, SharedUIUtils.getFullProductName());
            activeWindowShell.setMinimumSize(800, 600);
            activeWindowShell.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    IPreferenceStore store = AgentUI.getDefault().getAgentPreferenceStore();
                    Shell shell = AgentUIWorkbenchWindowAdvisor.this.getWindowConfigurer().getWindow().getShell();
                    if (shell == null) {
                        return;
                    }
                    Point size = shell.getSize();
                    if (!size.equals((Object)AgentUIWorkbenchWindowAdvisor.this.getStoredShellSize()) && !Agent.getInstance().isServerMode()) {
                        store.setValue(ICicPreferenceConstants.WINDOW_SIZE.key(), AgentUIWorkbenchWindowAdvisor.serializePoint(size));
                        AgentUIWorkbenchWindowAdvisor.this.savePluginPreferences();
                        CicPreferenceManager.getInstance().getCurrentPreferenceHandler().save();
                    }
                }
            });
        }
        if ((shell = CicCommonUiPlugin.getActiveWorkbenchShell()) != null) {
            shell.forceActive();
            if (shell.getMinimized()) {
                shell.setMinimized(false);
            }
        }
        if (!CicPreferenceManager.getInstance().isReady()) {
            PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(null, (String)"com.ibm.cic.agent.internal.ui.preferences.PreferenceSourcePage", null, null);
            dialog.open();
        }
        this.shellAdapterFactory = new ShellAdapterFactory();
        Platform.getAdapterManager().registerAdapters((IAdapterFactory)this.shellAdapterFactory, AgentJob.class);
    }

    public static String serializePoint(Point point) {
        return new StringBuffer().append(point.x).append(',').append(point.y).toString();
    }

    public static Point deserializePoint(String string) {
        int comma = string.indexOf(44);
        return new Point(Integer.parseInt(string.substring(0, comma)), Integer.parseInt(string.substring(comma + 1)));
    }

    public void dispose() {
        if (this.shellAdapterFactory != null) {
            Platform.getAdapterManager().unregisterAdapters((IAdapterFactory)this.shellAdapterFactory);
        }
        super.dispose();
    }
}

