/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui;

import com.ibm.cic.agent.core.sharedUI.AgentReopenRepositoryUtil;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.repository.IReopenRepositoryPrompter;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.sharedUI.IRepositoryOpener;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.CommonImages;
import com.ibm.cic.common.ui.internal.dialogs.OpenRepositoryDialog;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class AgentReopenRepositoryPrompter
implements IReopenRepositoryPrompter {
    public IReopenRepositoryPrompter.ReopenRepositoryResult promptOpenRepository(IRepositoryGroup group, IOfferingOrFix offeringOrFix, IRepositoryInfo repoInfo, IArtifactSession session, IArtifact artifact, boolean wantAbort) {
        String prompt;
        String browseMessage;
        ImageDescriptor titleImageDescriptor;
        AgentReopenRepositoryUtil.RepositoryOpener opener = new AgentReopenRepositoryUtil.RepositoryOpener(group, offeringOrFix, session, artifact, repoInfo);
        if (repoInfo.getType().equals("Volume")) {
            titleImageDescriptor = CommonImages.WIZ_NEXTDISC;
            browseMessage = NLS.bind((String)Messages.AgentReopenRepositoryPrompter_VolumeRepo_browseMessage, (Object)opener.getDiskLabel());
            prompt = NLS.bind((String)Messages.AgentReopenRepositoryPrompter_VolumeRepo_prompt, (Object)opener.getDiskLabel());
        } else {
            String offeringLabel = OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)offeringOrFix, (boolean)false);
            titleImageDescriptor = CommonImages.WIZ_ADDREP;
            prompt = offeringOrFix instanceof IFix ? NLS.bind((String)Messages.AgentReopenRepositoryPrompter_promptFix, (Object)offeringLabel) : NLS.bind((String)Messages.AgentReopenRepositoryPrompter_prompt, (Object)offeringLabel);
            browseMessage = NLS.bind((String)Messages.AgentReopenRepositoryPrompter_browseMessage, (Object)offeringLabel);
        }
        IStatus status = this.promptOpenRepository(opener, repoInfo, prompt, browseMessage, titleImageDescriptor, wantAbort);
        return new IReopenRepositoryPrompter.ReopenRepositoryResult(status, group, opener.getOpenedRepository());
    }

    private IStatus promptOpenRepository(final AgentReopenRepositoryUtil.RepositoryOpener opener, final IRepositoryInfo repoInfo, final String prompt, final String browseMessage, final ImageDescriptor titleImageDescriptor, final boolean wantAbort) {
        final IStatus[] retStatus = new IStatus[1];
        DisplayKeeper.INSTANCE.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = CicCommonUiPlugin.getDefault().getTimeTriggeredProgressDlgShell();
                OpenRepositoryDialog dlg = new OpenRepositoryDialog(shell, (IRepositoryOpener)opener, repoInfo, opener.getTitle(), titleImageDescriptor, opener.getTitleMessage(), prompt, browseMessage, wantAbort);
                int rc = dlg.open();
                retStatus[0] = rc == 0 ? dlg.getOkStatus() : Status.CANCEL_STATUS;
            }
        });
        return retStatus[0];
    }
}

