/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.transports.commons.net;

import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.downloads.AbstractHostInfo;
import com.ibm.cic.common.downloads.ByteRange;
import com.ibm.cic.common.downloads.ByteRangeMonitorInputStream;
import com.ibm.cic.common.downloads.ContentInfo;
import com.ibm.cic.common.downloads.DownloadCanceledException;
import com.ibm.cic.common.downloads.DownloadEvents;
import com.ibm.cic.common.downloads.DownloadHandler;
import com.ibm.cic.common.downloads.DownloadHandlerDefaultRetryLevel;
import com.ibm.cic.common.downloads.DownloadHandlerRequest;
import com.ibm.cic.common.downloads.DownloadProperties;
import com.ibm.cic.common.downloads.DownloadRetryLevel;
import com.ibm.cic.common.downloads.HostInfo;
import com.ibm.cic.common.downloads.ICanOpenStream;
import com.ibm.cic.common.downloads.ICanOpenStreamAtRange;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.IDownloadContext;
import com.ibm.cic.common.downloads.IDownloadListener;
import com.ibm.cic.common.downloads.IDownloadStream;
import com.ibm.cic.common.downloads.IHasIsCanceled;
import com.ibm.cic.common.downloads.ITransferMonitor;
import com.ibm.cic.common.downloads.PreferencesHolder;
import com.ibm.cic.common.downloads.ProgressInputStream;
import com.ibm.cic.common.downloads.ProxyInfo;
import com.ibm.cic.common.downloads.ProxySupport;
import com.ibm.cic.common.downloads.RequestStatus;
import com.ibm.cic.common.downloads.SimpleContentInfo;
import com.ibm.cic.common.downloads.SocketEvents;
import com.ibm.cic.common.downloads.handlerImpl.AuthenticationContext;
import com.ibm.cic.common.downloads.handlerImpl.DownloadHandlerUtil;
import com.ibm.cic.common.downloads.handlerImpl.DownloadHooks;
import com.ibm.cic.common.downloads.handlerImpl.DownloadStream;
import com.ibm.cic.common.downloads.handlerImpl.RequestRetry;
import com.ibm.cic.common.transports.commons.net.FTPClientConnections;
import com.ibm.cic.common.transports.commons.net.FTPClientUtil;
import com.ibm.cic.common.transports.commons.net.FtpCredentialsProvider;
import com.ibm.cic.common.transports.commons.net.Messages;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.net.ftp.FTPClient;
import org.eclipse.osgi.util.NLS;

public class FtpCommonsNetDownloadHandler
extends DownloadHandler
implements ICanOpenStream,
ICanOpenStreamAtRange,
RequestRetry.IRequestWithoutRetry {
    private static final ProxySupport proxySupport = new ProxySupport(true, false, true);
    private static final String FTP = "ftp";

    protected FTPClientConnections getClientConnections() {
        return FTPClientConnections.INSTANCE;
    }

    public ProxySupport getProxySupport() {
        return proxySupport;
    }

    private AuthenticationContext getAuthenticationContext(HostInfo hostInfo) {
        ProxyInfo pi = PreferencesHolder.INSTANCE.getProxyInfo(FTP);
        AuthenticationContext.CompositeAuthContext cac = new AuthenticationContext.CompositeAuthContext();
        cac.add((AuthenticationContext)new FtpAuthContext().init(hostInfo));
        if (pi.isNoProxy() || pi.getHost().length() == 0) {
            AuthenticationContext.NoSocksProxy.INSTANCE.init();
        } else if (pi.useSocks()) {
            cac.add((AuthenticationContext)new AuthenticationContext.SocksAuthenticationContext().init(pi));
        } else {
            AuthenticationContext.NoSocksProxy.INSTANCE.init();
        }
        return cac;
    }

    public DownloadRetryLevel retryLevel(Exception exception) {
        return DownloadHandlerDefaultRetryLevel.retryLevel((Exception)exception);
    }

    protected IContentInfo implementDownload(DownloadHandlerRequest.DownloadRequest request, ITransferMonitor transferPerformance, long[] outBytesRead) throws IOException {
        return DownloadHandlerUtil.downloadUsingOpenStreamAtRange((ICanOpenStreamAtRange)this, (DownloadHandlerRequest.DownloadRequest)request, (ITransferMonitor)transferPerformance, (long[])outBytesRead);
    }

    protected IContentInfo implementDownload(DownloadHandlerRequest.DownloadSinkRequest request, ITransferMonitor transferPerformance, long[] outBytesRead) throws IOException {
        return DownloadHandlerUtil.downloadUsingOpenStreamAtRange((ICanOpenStreamAtRange)this, (DownloadHandlerRequest.DownloadSinkRequest)request, (ITransferMonitor)transferPerformance, (long[])outBytesRead);
    }

    public IDownloadStream openStreamAtRange(DownloadHandlerRequest.OpenStreamForRangeRequest request, ITransferMonitor transferPerformance, IContentInfo[] outContentInfo) throws IOException {
        HostInfo hostInfo = this.getHostInfo((DownloadHandlerRequest)request);
        AuthenticationContext ac = this.getAuthenticationContext(hostInfo);
        try {
            IDownloadStream iDownloadStream = RequestRetry.openStreamAtRangeWithRetry((AuthenticationContext)ac, (RequestRetry.IRequestWithoutRetry)this, (DownloadHandlerRequest.OpenStreamForRangeRequest)request, (ITransferMonitor)transferPerformance, (IContentInfo[])outContentInfo);
            return iDownloadStream;
        }
        catch (IOException e) {
            this.handleCancelOfRequest((DownloadHandlerRequest)request, ac, e);
            throw e;
        }
        finally {
            ac.release();
        }
    }

    private void handleCancelOfRequest(DownloadHandlerRequest request, AuthenticationContext ac, IOException e) throws DownloadCanceledException {
        if (ac.checkThreadCanceled(true)) {
            ac.onState(RequestStatus.ASK_CREDENTIAL_CANCELED, null);
            if (!(e instanceof DownloadCanceledException)) {
                throw DownloadCanceledException.createAuthenticationCanceled((DownloadHandlerRequest)request, (Exception)e);
            }
        } else {
            ac.onState(RequestStatus.EXCEPTION, (Throwable)e);
        }
    }

    public IDownloadStream openStreamAtRangeNoRetry(AuthenticationContext ac, DownloadHandlerRequest.OpenStreamForRangeRequest request, ITransferMonitor transferPerformance, IContentInfo[] outContentInfo) throws IOException {
        DownloadStream downloadStream;
        FTPClientConnections.IFTPClientConnection ftpc;
        block15: {
            String urlString = request.getUrlString();
            ByteRange requestedRange = request.getByteRange();
            DownloadHandlerUtil.pluginTrace.entering(new Object[]{urlString, requestedRange});
            traceHeartBeat.heartbeat();
            InputStream in = null;
            ftpc = null;
            IDownloadListener.Access access = new IDownloadListener.Access((DownloadHandlerRequest)request);
            IDownloadListener fire = DownloadEvents.getFire((IDownloadContext)request.getDownloadContext());
            try {
                URI uri = FtpCommonsNetDownloadHandler.createUri(urlString);
                this.updateAccess(access, urlString, uri);
                fire.beforeSendRequest(access);
                ftpc = this.getClientConnections().getFtpConnection(uri);
                ac.onState(RequestStatus.SUCCEEDED, null);
                FTPClient ftp = ftpc.getFTPClient();
                if (requestedRange.getStart() > 0L) {
                    ftp.setRestartOffset(requestedRange.getStart());
                }
                ByteRange servedRange = !requestedRange.isEndAtEof() ? ByteRange.remainingRange((long)requestedRange.getStart()) : requestedRange;
                String path = uri.getPath();
                try {
                    in = ftp.retrieveFileStream(path);
                    ac.onState(RequestStatus.SUCCEEDED, null);
                }
                catch (IOException ioe) {
                    DownloadHandlerUtil.rethrowExpectedException((IOException)ioe);
                    DownloadHandlerUtil.pluginTrace.catching((Throwable)ioe);
                    throw ioe;
                }
                int rc = ftp.getReplyCode();
                fire.receivedResponse(access, (Object)ftp.getReplyString());
                if (rc == 550) {
                    this.getClientConnections().returnConnection(ftpc);
                    ftpc = null;
                    throw new FileNotFoundException(urlString);
                }
                if (in == null) {
                    throw new IOException(NLS.bind((String)Messages.FtpCommonsNetDownloadHandler_retrieveFileStream_returns_null, (Object)path, (Object)ftpc));
                }
                FTPClientUtil.checkNegativeReply(ftp);
                long remoteLength = -1L;
                InputStream hookedStream = DownloadHooks.openedStreamAtRange((InputStream)in, (DownloadHandlerRequest.OpenStreamForRangeRequest)request, (ByteRange)requestedRange, (ByteRange)requestedRange, (long)remoteLength);
                ProgressInputStream.EmitDownloadEvents emitEvents = new ProgressInputStream.EmitDownloadEvents(access, DownloadEvents.getFire((IDownloadContext)request.getDownloadContext()));
                in = new ProgressInputStream(emitEvents, hookedStream, remoteLength, -1L, transferPerformance, true);
                FtpClientConnectionStream ftpcs = new FtpClientConnectionStream(this.getClientConnections(), ftpc, urlString, in, requestedRange, requestedRange);
                in = null;
                ftpc = null;
                if (outContentInfo != null) {
                    if (remoteLength != -1L) {
                        SimpleContentInfo ci = new SimpleContentInfo();
                        ci.setSize(remoteLength);
                        outContentInfo[0] = ci;
                    } else {
                        outContentInfo[0] = ContentInfo.EMPTY_CONTENT_INFO;
                    }
                }
                dlTraceHappy.println("SUCCESS: opened stream {0}", urlString);
                DownloadHandlerUtil.pluginTrace.exiting();
                downloadStream = new DownloadStream((Object)urlString, requestedRange, servedRange, (InputStream)((Object)ftpcs), false);
                if (in == null) break block15;
            }
            catch (IOException e) {
                try {
                    fire.sendRequestException(access, (Exception)e);
                    DownloadHandlerUtil.rethrowExpectedException((IOException)e);
                    DownloadHandlerUtil.pluginTrace.catching((Throwable)e);
                    dlTrace.println("openStreamAtRange() Catching exception: {0} : {1}. enable plugin tracing for more details", urlString, String.valueOf(e.getClass().toString()) + ':' + e.toString());
                    DownloadHandlerUtil.pluginTrace.println("... rethrowing");
                    throw e;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        FileUtil.close(in);
                    }
                    if (ftpc != null) {
                        ftpc.disconnect();
                    }
                    traceHeartBeat.heartbeat();
                    throw throwable;
                }
            }
            FileUtil.close((Closeable)in);
        }
        if (ftpc != null) {
            ftpc.disconnect();
        }
        traceHeartBeat.heartbeat();
        return downloadStream;
    }

    public InputStream openStream(DownloadHandlerRequest.OpenStreamRequest request, ITransferMonitor transferPerformance, IContentInfo[] outContentInfo) throws IOException {
        return super.privateOpenStream(request, transferPerformance, outContentInfo);
    }

    protected InputStream implementOpenStream(DownloadHandlerRequest.OpenStreamRequest request, ITransferMonitor transferPerformance, IContentInfo[] outContentInfo) throws IOException {
        DownloadHandlerRequest.OpenStreamForRangeRequest rangeRequest = DownloadHandlerRequest.FACTORY.createOpenStreamForRange(request.getDownloadContext(), request.getUrlString(), ByteRange.RANGE_ALL_BYTES);
        rangeRequest.setParentRequest((DownloadHandlerRequest)request);
        IDownloadStream dlStream = this.openStreamAtRange(rangeRequest, transferPerformance, outContentInfo);
        return dlStream.getInputStream();
    }

    private HostInfo getHostInfo(DownloadHandlerRequest request) throws MalformedURLException {
        URL url = new URL(request.getUrlString());
        String host = url.getHost();
        int port = url.getPort();
        if (port == -1) {
            port = url.getDefaultPort();
        }
        return new HostInfo(host, port);
    }

    protected boolean implementExists(DownloadHandlerRequest.ExistsRequest request) throws IOException {
        HostInfo hostInfo = this.getHostInfo((DownloadHandlerRequest)request);
        AuthenticationContext ac = this.getAuthenticationContext(hostInfo);
        IHasIsCanceled cancelMonitor = FtpCommonsNetDownloadHandler.getCancelMonitor((DownloadHandlerRequest)request);
        try {
            boolean bl = RequestRetry.existsWithRetry((AuthenticationContext)ac, (RequestRetry.IRequestWithoutRetry)this, (DownloadHandlerRequest.ExistsRequest)request, (IHasIsCanceled)cancelMonitor);
            return bl;
        }
        catch (IOException e) {
            this.handleCancelOfRequest((DownloadHandlerRequest)request, ac, e);
            throw e;
        }
        finally {
            ac.release();
        }
    }

    private void updateAccess(IDownloadListener.Access access, String urlString, URI uri) {
        String host = uri.getHost();
        String protocol = uri.getScheme();
        int port = uri.getPort();
        access.setReceiver((IDownloadListener.IReceiver)IDownloadListener.IReceiverFactory.INSTANCE.createHostReceiver(urlString, protocol, host, port));
    }

    private boolean isNotImplemented(int replyCode) {
        switch (replyCode) {
            case 500: 
            case 502: 
            case 504: {
                return true;
            }
        }
        return false;
    }

    public boolean existsNoRetry(AuthenticationContext ac, DownloadHandlerRequest.ExistsRequest request, IHasIsCanceled cancelMonitor) throws IOException {
        boolean bl;
        block12: {
            String urlString = request.getUrlString();
            DownloadHandlerUtil.pluginTrace.entering((Object)urlString);
            if (cancelMonitor.isCanceled()) {
                throw DownloadCanceledException.create((DownloadHandlerRequest)request, null);
            }
            traceHeartBeat.heartbeat();
            FTPClientConnections.IFTPClientConnection ftpc = null;
            IDownloadListener.Access access = new IDownloadListener.Access((DownloadHandlerRequest)request);
            IDownloadListener fire = DownloadEvents.getFire((IDownloadContext)request.getDownloadContext());
            try {
                boolean exists;
                URI uri = FtpCommonsNetDownloadHandler.createUri(urlString);
                this.updateAccess(access, urlString, uri);
                fire.beforeSendRequest(access);
                ftpc = this.getClientConnections().getFtpConnection(uri);
                ac.onState(RequestStatus.SUCCEEDED, null);
                FTPClient ftp = ftpc.getFTPClient();
                String path = uri.getPath();
                int reply = ftp.stat(path);
                fire.receivedResponse(access, (Object)ftp.getReplyString());
                if (this.isNotImplemented(reply)) {
                    fire.beforeSendRequest(access);
                    String[] names = ftp.listNames(path);
                    exists = names != null;
                    fire.receivedResponse(access, (Object)ftp.getReplyString());
                } else {
                    boolean bl2 = exists = reply != 550 && reply != 450;
                    if (exists) {
                        boolean bl3 = exists = ftp.getReplyStrings().length > 2;
                    }
                }
                if (FtpCommonsNetDownloadHandler.dlTraceHappy.enabled) {
                    if (exists) {
                        dlTraceHappy.println("SUCCESS: stream {0} exists, response={1}", urlString, Integer.toString(reply));
                    } else {
                        dlTraceHappy.println("SUCCESS: stream {0} does NOT exist, response={1}", urlString, Integer.toString(reply));
                    }
                }
                DownloadHandlerUtil.pluginTrace.exiting((Object)exists);
                bl = exists;
                if (ftpc == null) break block12;
                this.getClientConnections().returnConnection(ftpc);
            }
            catch (IOException e) {
                try {
                    fire.sendRequestException(access, (Exception)e);
                    DownloadHandlerUtil.rethrowExpectedException((IOException)e);
                    DownloadHandlerUtil.pluginTrace.catching((Throwable)e);
                    dlTrace.println("exists() Catching exception: {0} : {1}.", urlString, String.valueOf(e.getClass().toString()) + ':' + e.getMessage());
                    DownloadHandlerUtil.pluginTrace.println("... rethrowing");
                    throw e;
                }
                catch (Throwable throwable) {
                    if (ftpc != null) {
                        this.getClientConnections().returnConnection(ftpc);
                    }
                    traceHeartBeat.heartbeat();
                    throw throwable;
                }
            }
        }
        traceHeartBeat.heartbeat();
        return bl;
    }

    protected DownloadProperties queryProperties(DownloadHandlerRequest.QueryContentInfoRequest request) throws IOException {
        return super.implementQueryProperties(request);
    }

    public boolean canQueryProperties() {
        return false;
    }

    private static URI createUri(String urlString) throws MalformedURLException {
        try {
            return new URI(urlString);
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(e.getMessage());
        }
    }

    static class FtpAuthContext
    extends AuthenticationContext {
        private HostInfo fHostInfo;

        FtpAuthContext() {
        }

        public FtpAuthContext init(HostInfo hostInfo) {
            this.fHostInfo = hostInfo;
            FtpCredentialsProvider.INSTANCE.getAuthenticator().addHostInfo((AbstractHostInfo)hostInfo);
            return this;
        }

        public void release() {
            FtpCredentialsProvider.INSTANCE.getAuthenticator().removeHostInfo((AbstractHostInfo)this.fHostInfo);
        }

        public void onState(RequestStatus state, Throwable exception) {
            super.onState(state, exception);
            FtpCredentialsProvider.INSTANCE.getAuthenticator().setResult((AbstractHostInfo)this.fHostInfo, state);
        }

        public boolean checkThreadCanceled(boolean reset) {
            return FtpCredentialsProvider.INSTANCE.getAuthenticator().checkThreadCanceled((AbstractHostInfo)this.fHostInfo, reset);
        }

        public int getAskedCount() {
            return FtpCredentialsProvider.INSTANCE.getAuthenticator().getAskedCount();
        }
    }

    static class FtpClientConnectionStream
    extends ByteRangeMonitorInputStream {
        private final FTPClientConnections ftpClientConnections;
        private FTPClientConnections.IFTPClientConnection ftpConnection;
        private final Socket socketNotUsed;

        protected FtpClientConnectionStream(FTPClientConnections ftpClientConnections, FTPClientConnections.IFTPClientConnection ftpConnection, String source, InputStream in, ByteRange requestedRange, ByteRange effectiveRange) {
            super(source, in, requestedRange, effectiveRange, -1L);
            this.ftpClientConnections = ftpClientConnections;
            this.ftpConnection = ftpConnection;
            this.socketNotUsed = ftpConnection.getControlSocket();
            SocketEvents.FIRE.beginNoResponseExpected(this.socketNotUsed);
        }

        protected void doCloseAtEOF() throws IOException {
            FTPClient ftp = this.ftpConnection.getFTPClient();
            IOException closeException = null;
            try {
                super.doCloseAtEOF();
            }
            catch (IOException e) {
                dlTrace.getLog().debug("IOException during super.close of data stream for {0}: {1}", new Object[]{this.ftpConnection, e});
                closeException = e;
            }
            IOException completePendingCommandException = null;
            boolean completePendingCommand = false;
            try {
                completePendingCommand = ftp.completePendingCommand();
            }
            catch (IOException e) {
                completePendingCommandException = e;
                dlTrace.getLog().debug("IOExcepton during completePendingCommand {0}:{1}", new Object[]{this.ftpConnection});
            }
            try {
                if (!completePendingCommand) {
                    FTPClientConnections.IFTPClientConnection c = this.ftpConnection;
                    this.ftpConnection = null;
                    c.disconnect();
                }
                if (closeException != null) {
                    throw closeException;
                }
                if (completePendingCommandException != null) {
                    throw completePendingCommandException;
                }
            }
            finally {
                if (this.ftpConnection != null) {
                    this.ftpClientConnections.returnConnection(this.ftpConnection);
                }
                SocketEvents.FIRE.endNoResponseExpected(this.socketNotUsed);
            }
        }

        protected void doCloseBeforeEOF() throws IOException {
            try {
                FTPClientConnections.IFTPClientConnection c = this.ftpConnection;
                this.ftpConnection = null;
                c.disconnect();
            }
            finally {
                SocketEvents.FIRE.endNoResponseExpected(this.socketNotUsed);
            }
        }
    }
}

