/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.transports.commons.net;

import com.ibm.cic.common.core.internal.utils.CicCommonCoreTrace;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.transports.commons.net.FTPClientConnections;
import org.apache.commons.net.ProtocolCommandEvent;
import org.apache.commons.net.ProtocolCommandListener;

public class FTPClientCommandListener
implements ProtocolCommandListener {
    private final Logger log;

    public FTPClientCommandListener(CicCommonCoreTrace trace) {
        this.log = trace.getLog();
    }

    private static String stripCRLF(String s) {
        if (s.endsWith("\r\n")) {
            return s.substring(0, s.length() - 2);
        }
        if (s.endsWith("\n")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    public void protocolCommandSent(ProtocolCommandEvent event) {
        Object source = event.getSource();
        if (source instanceof FTPClientConnections.FTPClientConnection.RevealingFTPClient) {
            FTPClientConnections.FTPClientConnection.RevealingFTPClient ftpClient = (FTPClientConnections.FTPClientConnection.RevealingFTPClient)((Object)source);
            this.log.debug("ftp>''{0}'' socket {1}", new Object[]{FTPClientCommandListener.stripCRLF(event.getMessage()), ftpClient.getControlSocket()});
        } else {
            this.log.debug("ftp>''{0}''", new Object[]{FTPClientCommandListener.stripCRLF(event.getMessage())});
        }
    }

    public void protocolReplyReceived(ProtocolCommandEvent event) {
        Object source = event.getSource();
        if (source instanceof FTPClientConnections.FTPClientConnection.RevealingFTPClient) {
            FTPClientConnections.FTPClientConnection.RevealingFTPClient ftpClient = (FTPClientConnections.FTPClientConnection.RevealingFTPClient)((Object)source);
            this.log.debug("ftp<''{0}'' socket {1}", new Object[]{FTPClientCommandListener.stripCRLF(event.getMessage()), ftpClient.getControlSocket()});
        } else {
            this.log.debug("ftp<''{0}''", new Object[]{FTPClientCommandListener.stripCRLF(event.getMessage())});
        }
    }
}

