/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.transports.httpclient.internal.win32;

import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.transports.httpclient.internal.win32.Messages;
import com.ibm.cic.common.transports.httpclient.internal.win32.WindowsCallFailedException;
import com.ibm.cic.common.transports.httpclient.internal.win32.WindowsCallFailedWithLastErrorCodeException;
import com.ibm.cic.common.transports.httpclient.internal.win32.WindowsCallFailedWithSecurityStatusCodeException;

public class WinNTLMSSP {
    private static final String EMPTY_STRING = "";
    public static final Logger log = Logger.getLogger(WinNTLMSSP.class);
    private String username = null;
    private String password = null;
    private String domain = null;
    private volatile long crdHandle;
    private volatile long ctxHandle;
    private static boolean javaLibraryInitialized;
    static boolean jniLibraryLoaded;

    static {
        jniLibraryLoaded = false;
        try {
            System.loadLibrary("winNTLMSSP");
            jniLibraryLoaded = true;
        }
        catch (UnsatisfiedLinkError e) {
            log.error((Throwable)e, Messages.WinNTLMSSP_unableToLoadNativeLibrary, new Object[]{e});
        }
    }

    public static boolean isLoaded() {
        try {
            WinNTLMSSP.loadWindowsDLL();
        }
        catch (Throwable e) {
            log.error(e);
        }
        return javaLibraryInitialized;
    }

    public static synchronized void loadWindowsDLL() throws WindowsCallFailedWithLastErrorCodeException {
        if (!javaLibraryInitialized) {
            WinNTLMSSP.initialize();
            javaLibraryInitialized = true;
        }
    }

    public static synchronized void unloadWindowsDLL() {
        if (javaLibraryInitialized) {
            WinNTLMSSP.unload();
            javaLibraryInitialized = false;
        }
    }

    public WinNTLMSSP(String username, String password, String domain) throws WindowsCallFailedException {
        if (username != null && !username.equals(EMPTY_STRING)) {
            this.username = username;
        }
        if (password != null && !password.equals(EMPTY_STRING)) {
            this.password = password;
        }
        if (domain != null && !domain.equals(EMPTY_STRING)) {
            this.domain = domain;
        }
        WinNTLMSSP.loadWindowsDLL();
    }

    public long getCrdHandle() {
        return this.crdHandle;
    }

    public long getCtxHandle() {
        return this.ctxHandle;
    }

    public byte[] generateNegotiateMessage() throws WindowsCallFailedException {
        if (!javaLibraryInitialized) {
            log.warning(Messages.WinNTLMSSP_unableToLoadNativeLibrary);
        }
        this.ctxHandle = 0L;
        this.crdHandle = this.getCredentialsHandle(this.username, this.domain, this.password);
        byte[] response = this.initializeSecurityContext(this.crdHandle, null);
        if (response != null) {
            return response;
        }
        return null;
    }

    public byte[] generateAuthenticateMessage(byte[] nonceByteArray) throws WindowsCallFailedWithSecurityStatusCodeException {
        byte[] response;
        if (!javaLibraryInitialized) {
            log.warning(Messages.WinNTLMSSP_unableToLoadNativeLibrary);
        }
        if ((response = this.initializeSecurityContext(this.crdHandle, nonceByteArray)) != null) {
            return response;
        }
        return null;
    }

    private native long getCredentialsHandle(String var1, String var2, String var3) throws WindowsCallFailedWithLastErrorCodeException;

    private native byte[] initializeSecurityContext(long var1, byte[] var3) throws WindowsCallFailedWithSecurityStatusCodeException;

    private static native void initialize() throws WindowsCallFailedWithLastErrorCodeException;

    private static native void unload();

    public static native void testLastErrorCode(long var0) throws WindowsCallFailedWithLastErrorCodeException;

    public static native void testSecurityStatus(long var0) throws WindowsCallFailedWithSecurityStatusCodeException;
}

