/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.transports.httpclient.internal.win32;

import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.transports.httpclient.internal.win32.Messages;
import com.ibm.cic.common.transports.httpclient.internal.win32.WinNTLMSSP;
import com.ibm.cic.common.transports.httpclient.internal.win32.WindowsCallFailedException;
import com.ibm.cic.common.transports.httpclient.internal.win32.WindowsCallFailedWithSecurityStatusCodeException;
import com.ibm.cic.common.transports.httpclient.ntlm.INTLMAuthGenerator;
import com.ibm.cic.common.transports.httpclient.ntlm.NTLMAuthGeneratorException;
import com.ibm.cic.common.transports.httpclient.ntlm.NTLMUserCredentials;

public class WinNTLMAuthGenerator
implements INTLMAuthGenerator {
    private final NTLMUserCredentials userCredentials;
    private final WinNTLMSSP winssp;

    public WinNTLMAuthGenerator(NTLMUserCredentials userCredentials) throws WindowsCallFailedException {
        this.userCredentials = userCredentials;
        this.winssp = new WinNTLMSSP(userCredentials.getUsername(), userCredentials.getPassword(), userCredentials.getDomain());
    }

    public byte[] genType1Message() throws NTLMAuthGeneratorException {
        try {
            return this.winssp.generateNegotiateMessage();
        }
        catch (WindowsCallFailedException e) {
            String msg = NLS.bind((String)Messages.WinNTLMAuthGenerator_ntlmNegotiateMessageGenFailed, (Object)e.getMessage());
            throw new NTLMAuthGeneratorException(msg, (Throwable)e);
        }
    }

    public byte[] genType3Message(byte[] challengeMessage) throws NTLMAuthGeneratorException {
        try {
            return this.winssp.generateAuthenticateMessage(challengeMessage);
        }
        catch (WindowsCallFailedWithSecurityStatusCodeException e) {
            String msg = NLS.bind((String)Messages.WinNTLMAuthGenerator_ntlmAuthenticateMessageGenFailed, (Object)e.getMessage());
            throw new NTLMAuthGeneratorException(msg, (Throwable)e);
        }
    }

    public String toString() {
        return "NTLM auth generator for " + this.userCredentials;
    }

    public boolean isLoggingDetails() {
        return false;
    }
}

