/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.core.utils;

import com.ibm.ws.pak.core.utils.IPakUtils;
import com.ibm.ws.pak.internal.install.failurerecovery.FailureRecoveryPlugin;
import com.ibm.ws.pak.internal.install.metadata.NIFPackageEntry;
import com.ibm.ws.pak.internal.install.metadata.NIFStack;
import com.ibm.ws.pak.internal.install.registry.NIFRegistry;
import com.ibm.ws.pak.internal.install.registry.NIFRegistryOfferingEntry;
import com.ibm.ws.pak.internal.utils.ProductUtils;
import com.ibm.ws.pak.internal.utils.SimpleXMLParser;
import com.ibm.ws.pak.internal.utils.StringUtils;
import com.ibm.ws.pak.internal.utils.URIUtils;
import com.ibm.ws.pak.internal.utils.XMLUtils;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystem;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.logging.ILogr;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Vector;
import org.w3c.dom.Node;

public class PakUtils
implements IPakUtils {
    private FailureRecoveryPlugin m_frpRecoveryPlugin = null;
    private final String className = "PakUtils";
    private final String cipFolder = "/cip";
    private final String customInstallInfoXML = "/CustomInstallInfo.xml";
    private final String mipDescriptionAttrName = "info_en_US";
    private final String mipIMFixIdAttrName = "im.fixId";

    @Override
    public String[] getInstalledPakNames(String installLocation, String productID, boolean primaryOnly) {
        return this.getInstalledPakNames(installLocation, "/properties/version/nif/backup/", productID, null, primaryOnly);
    }

    @Override
    public String[] getInstalledPakNames(String installLocation) {
        return this.getInstalledPakNames(installLocation, "/properties/version/nif/backup/", null, null);
    }

    @Override
    public String[] getInstalledPakNames(String installLocation, String productID, String packageType) {
        return this.getInstalledPakNames(installLocation, "/properties/version/nif/backup/", productID, packageType);
    }

    @Override
    public String[] getInstalledPakNames(String installLocation, String backupPakRelativePath, String productID, String packageType) {
        return this.getInstalledPakNames(installLocation, backupPakRelativePath, productID, packageType, false);
    }

    @Override
    public String[] getInstalledPakNames(String installLocation, String backupPakRelativePath, String productID, String packageType, boolean primaryOnly) {
        return this.getNIFStackParamValues("filename", installLocation, backupPakRelativePath, productID, packageType, primaryOnly);
    }

    @Override
    public String[] getPayloadIds(String installLocation, String productID, String packageType) {
        return this.getNIFStackParamValues("payloadid", installLocation, "/properties/version/nif/backup/", productID, packageType, false);
    }

    @Override
    public String[] getPayloadIds(String installLocation, String productID, String packageType, boolean primaryOnly) {
        return this.getNIFStackParamValues("payloadid", installLocation, "/properties/version/nif/backup/", productID, packageType, primaryOnly);
    }

    @Override
    public String[] getMaintenanceName(String installLocation, String productID, String packageType, boolean primaryOnly) {
        return this.getNIFStackParamValues("maintenance", installLocation, "/properties/version/nif/backup/", productID, packageType, primaryOnly);
    }

    @Override
    public boolean isNIFStackAvailable(String installLocation) {
        FileSystemEntry fseBackupRepositoryDir;
        block4: {
            ILogr.methodEntry((String)"PakUtils", (String)"isNIFStackAvailable");
            String sBackupRepositoryDir = String.valueOf(installLocation) + "/properties/version/nif/backup/";
            fseBackupRepositoryDir = URIUtils.convertPathToDefaultTargetMachineFSE((String)sBackupRepositoryDir, null);
            if (fseBackupRepositoryDir.exists()) break block4;
            ILogr.debug((String)("Backup pak location does not exist :" + fseBackupRepositoryDir.getAbsolutePath()));
            return false;
        }
        try {
            FileSystemEntry fseStack = new FileSystemEntry(fseBackupRepositoryDir.getURI(), "NIFStack.xml", null);
            ILogr.methodExit((String)"PakUtils", (String)"isNIFStackAvailable");
            return fseStack.exists();
        }
        catch (IOException e) {
            e.printStackTrace();
            ILogr.error((String)"PakUtils", (String)"isNIFStackAvailable", (String)e.getMessage(), (Exception)e);
            return false;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            ILogr.error((String)"PakUtils", (String)"isNIFStackAvailable", (String)e.getMessage(), (Exception)e);
            return false;
        }
    }

    private String[] getNIFStackParamValues(String nifStackParamName, String installLocation, String backupPakRelativePath, String productID, String packageType, boolean primaryOnly) {
        Vector<String> vValues = new Vector<String>();
        if (!this.openNIFStack(installLocation, backupPakRelativePath)) {
            return vValues.toArray(new String[vValues.size()]);
        }
        Vector vAllNIFStackElements = NIFStack.getAllNIFStackElements();
        int i = 0;
        while (i < vAllNIFStackElements.size()) {
            block11: {
                String[] targetProductIds;
                boolean isPrimary;
                String sPackageType;
                String sParamValue;
                NIFPackageEntry entry;
                block9: {
                    block10: {
                        entry = (NIFPackageEntry)vAllNIFStackElements.elementAt(i);
                        sParamValue = nifStackParamName.equals("maintenance") ? entry.getNIFPackageName() : entry.getParamValue(nifStackParamName);
                        sPackageType = entry.getParamValue("packagetype");
                        isPrimary = new Boolean(entry.getParamValue("wasinstalledasprimary"));
                        if (productID != null) break block9;
                        if (packageType != null) break block10;
                        if (!primaryOnly || isPrimary) {
                            vValues.add(sParamValue);
                        }
                        break block11;
                    }
                    if (sPackageType == null || !sPackageType.equals(packageType) || primaryOnly && !isPrimary) break block11;
                    vValues.add(sParamValue);
                    break block11;
                }
                String sTargetProductIds = entry.getParamValue("targetproductids");
                String[] stringArray = targetProductIds = StringUtils.convertStringToTokenArray((String)sTargetProductIds, (String)";");
                int n = targetProductIds.length;
                int n2 = 0;
                while (n2 < n) {
                    String targetProductId = stringArray[n2];
                    if (targetProductId.equals(productID)) {
                        if (packageType == null) {
                            if (!primaryOnly || isPrimary) {
                                vValues.add(sParamValue);
                            }
                        } else if (sPackageType != null && sPackageType.equals(packageType) && (!primaryOnly || isPrimary)) {
                            vValues.add(sParamValue);
                        }
                    }
                    ++n2;
                }
            }
            ++i;
        }
        NIFStack.close();
        return vValues.toArray(new String[vValues.size()]);
    }

    @Override
    public String[] getInstalledPakNamesForThisPayloadID(String installLocation, String payloadId) {
        Vector<String> vInstalledPakNames = new Vector<String>();
        if (!this.openNIFStack(installLocation, "/properties/version/nif/backup/")) {
            return vInstalledPakNames.toArray(new String[vInstalledPakNames.size()]);
        }
        Vector vAllNIFStackElements = NIFStack.getAllNIFStackElements();
        int i = 0;
        while (i < vAllNIFStackElements.size()) {
            NIFPackageEntry entry = (NIFPackageEntry)vAllNIFStackElements.elementAt(i);
            String sPakName = entry.getParamValue("filename");
            String sPayloadId = entry.getParamValue("payloadid");
            if (sPayloadId.equals(payloadId)) {
                vInstalledPakNames.add(sPakName);
            }
            ++i;
        }
        NIFStack.close();
        return vInstalledPakNames.toArray(new String[vInstalledPakNames.size()]);
    }

    @Override
    public String[] getInstalledPakNames(String installLocation, String productID) {
        return this.getInstalledPakNames(installLocation, "/properties/version/nif/backup/", productID, null);
    }

    @Override
    public String[] getProductIds(String installLocation) {
        return ProductUtils.getProductIds((String)installLocation, null);
    }

    @Override
    public String getVersion(String installLocation, String productID) {
        return ProductUtils.getProductVersion((String)installLocation, (String)productID, null);
    }

    @Override
    public String getName(String installLocation, String productID) {
        return ProductUtils.getProductName((String)installLocation, (String)productID, null);
    }

    @Override
    public String getPakVersion(String installLocation, String pakName) {
        if (!this.openNIFStack(installLocation, "/properties/version/nif/backup/")) {
            NIFStack.close();
            return "0.0.0.0";
        }
        Vector vAllNIFStackElements = NIFStack.getAllNIFStackElements();
        int i = 0;
        while (i < vAllNIFStackElements.size()) {
            NIFPackageEntry entry = (NIFPackageEntry)vAllNIFStackElements.elementAt(i);
            String sPakName = entry.getParamValue("filename");
            if (sPakName.equals(pakName)) {
                NIFStack.close();
                String sPakversion = entry.getParamValue("pakversion");
                if (sPakversion == null) {
                    return "0.0.0.0";
                }
                return sPakversion;
            }
            ++i;
        }
        NIFStack.close();
        return "0.0.0.0";
    }

    @Override
    public String getPakVersionForThisPayloadId(String installLocation, String payloadId) {
        if (!this.openNIFStack(installLocation, "/properties/version/nif/backup/")) {
            NIFStack.close();
            return "0.0.0.0";
        }
        String sPakversion = NIFStack.getPakversionOfPayload((String)payloadId);
        NIFStack.close();
        if (sPakversion == null) {
            return "0.0.0.0";
        }
        return sPakversion;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isThisInstallLocationUpdatedByCIP(String installLocation) {
        try {
            FileSystemEntry[] fseFilesUnderVersionDir;
            FileSystemEntry fseCIPDir = URIUtils.convertPathToDefaultTargetMachineFSE((String)(String.valueOf(installLocation) + "/cip"), null);
            if (!fseCIPDir.exists()) return false;
            FileSystemEntry[] fileSystemEntryArray = fseFilesUnderVersionDir = fseCIPDir.getDirectoryEntries();
            int n = fseFilesUnderVersionDir.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                FileSystemEntry element = fileSystemEntryArray[n2];
                String xml = String.valueOf(element.getAbsolutePath()) + "/CustomInstallInfo.xml";
                FileSystemEntry cipXML = URIUtils.convertPathToDefaultTargetMachineFSE((String)xml, null);
                if (cipXML.exists()) {
                    return true;
                }
                ++n2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            Logr.error((String)"PakUtils", (String)"isThisInstallLocationUpdatedByCIP", (String)e.getMessage(), (Exception)e);
            return false;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            Logr.error((String)"PakUtils", (String)"isThisInstallLocationUpdatedByCIP", (String)e.getMessage(), (Exception)e);
        }
        return false;
    }

    @Override
    public boolean isThisPakInstalled(String installLocation, String pakName) {
        String[] pakFileNames;
        String[] stringArray = pakFileNames = this.getInstalledPakNames(installLocation);
        int n = pakFileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String pakFileName = stringArray[n2];
            if (pakFileName.equals(pakName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isThisProductInstalled(String installLocation, String productID) {
        String[] productIds;
        String[] stringArray = productIds = this.getProductIds(installLocation);
        int n = productIds.length;
        int n2 = 0;
        while (n2 < n) {
            String productId2 = stringArray[n2];
            if (productId2.equals(productID)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean openNIFStack(String installLocation, String backupPakRelativePath) {
        FileSystemEntry fseBackupRepositoryDir;
        block3: {
            String sBackupRepositoryDir = String.valueOf(installLocation) + File.separatorChar + backupPakRelativePath;
            fseBackupRepositoryDir = null;
            try {
                fseBackupRepositoryDir = URIUtils.convertPathToDefaultTargetMachineFSE((String)sBackupRepositoryDir, null);
                if (fseBackupRepositoryDir.exists()) break block3;
                ILogr.debug((String)("Backup pak location does not exist :" + fseBackupRepositoryDir.getAbsolutePath()));
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                ILogr.error((String)"PakUtils", (String)"openNIFStack", (String)e.getMessage(), (Exception)e);
                return false;
            }
        }
        NIFStack.open((FileSystemEntry)fseBackupRepositoryDir, null);
        return true;
    }

    @Override
    public boolean doesThisInstallLocationHaveFailures(String installLocation) {
        String sBackupLocation = String.valueOf(installLocation) + File.separatorChar + "/properties/version/nif/backup/";
        FileSystemEntry fseBackupRepositoryDir = null;
        try {
            fseBackupRepositoryDir = URIUtils.convertPathToDefaultTargetMachineFSE((String)sBackupLocation, null);
            if (this.m_frpRecoveryPlugin == null) {
                this.m_frpRecoveryPlugin = FailureRecoveryPlugin.getFailureRecoveryPlugin(null);
            }
            return this.m_frpRecoveryPlugin.hasFailure(fseBackupRepositoryDir.getAbsolutePath());
        }
        catch (Exception e) {
            ILogr.error((String)"PakUtils", (String)"doesThisInstallLocationHaveFailures", (String)e.getMessage(), (Exception)e);
            return false;
        }
    }

    @Override
    public String[] getFailedPakNamesFromThisInstallLocation(String installLocation) {
        String sBackupLocation = String.valueOf(installLocation) + File.separatorChar + "/properties/version/nif/backup/";
        FileSystemEntry fseBackupRepositoryDir = null;
        try {
            fseBackupRepositoryDir = URIUtils.convertPathToDefaultTargetMachineFSE((String)sBackupLocation, null);
            if (this.m_frpRecoveryPlugin == null) {
                this.m_frpRecoveryPlugin = FailureRecoveryPlugin.getFailureRecoveryPlugin(null);
            }
            return this.m_frpRecoveryPlugin.getUpdateStatusFile(fseBackupRepositoryDir.getAbsolutePath()).getFailedPakNames();
        }
        catch (Exception e) {
            ILogr.error((String)"PakUtils", (String)"getFailedPakNamesFromThisInstallLocation", (String)e.getMessage(), (Exception)e);
            return new String[0];
        }
    }

    @Override
    public String[] getPossibleInstallLocation() {
        try {
            NIFRegistry m_nifregistry = NIFRegistry.getNIFRegistryInstance();
            NIFRegistryOfferingEntry[] anifroeThis = m_nifregistry.getAllInstalledProducts();
            Vector<String> vLocations = new Vector<String>();
            NIFRegistryOfferingEntry[] nIFRegistryOfferingEntryArray = anifroeThis;
            int n = anifroeThis.length;
            int n2 = 0;
            while (n2 < n) {
                NIFRegistryOfferingEntry anifroeThi = nIFRegistryOfferingEntryArray[n2];
                vLocations.add(anifroeThi.getOfferingLocationPath());
                ++n2;
            }
            return vLocations.toArray(new String[vLocations.size()]);
        }
        catch (Exception e) {
            ILogr.error((String)"PakUtils", (String)"getPossibleInstallLocation", (String)e.getMessage(), (Exception)e);
            return new String[0];
        }
    }

    @Override
    public String getOSArch(String installLocation, String[] pakNames) {
        try {
            String[] stringArray = pakNames;
            int n = pakNames.length;
            int n2 = 0;
            while (n2 < n) {
                String pakName = stringArray[n2];
                String sBackupPak = String.valueOf(installLocation) + File.separatorChar + "/properties/version/nif/backup/" + File.separatorChar + pakName;
                FileSystemEntry fseBackupPak = URIUtils.convertPathToDefaultTargetMachineFSE((String)sBackupPak, null);
                if (fseBackupPak.exists()) {
                    return this.getOSArch(fseBackupPak);
                }
                ++n2;
            }
            return "";
        }
        catch (Exception e) {
            Logr.warn((String)"PakUtils", (String)"getOSArch", (String)e.getMessage(), (Exception)e);
            return "";
        }
    }

    @Override
    public String getPakInfo(String installLocation, String pakName) {
        String sBackupPak = String.valueOf(installLocation) + File.separatorChar + "/properties/version/nif/backup/" + File.separatorChar + pakName;
        try {
            FileSystemEntry fseBackupPak = URIUtils.convertPathToDefaultTargetMachineFSE((String)sBackupPak, null);
            if (fseBackupPak.exists()) {
                return this.getPakInfo(fseBackupPak);
            }
            return "";
        }
        catch (Exception e) {
            Logr.warn((String)"PakUtils", (String)"getPakInfo", (String)e.getMessage(), (Exception)e);
            return "";
        }
    }

    @Override
    public String getIMFixId(String installLocation, String pakName) {
        String sBackupPak = String.valueOf(installLocation) + File.separatorChar + "/properties/version/nif/backup/" + File.separatorChar + pakName;
        try {
            FileSystemEntry fseBackupPak = URIUtils.convertPathToDefaultTargetMachineFSE((String)sBackupPak, null);
            if (fseBackupPak.exists()) {
                return this.getIMFixId(fseBackupPak);
            }
            return null;
        }
        catch (Exception e) {
            Logr.warn((String)"PakUtils", (String)"getIMFixId", (String)e.getMessage(), (Exception)e);
            return null;
        }
    }

    private String getMaintenanceXMLAttrValue(FileSystemEntry fsePathToPak, String XMLPath, String AttrName) {
        try {
            FileSystemEntry fseMaintenanceXML = new FileSystemEntry(fsePathToPak.getURI(), "maintenance.xml", null);
            if (fseMaintenanceXML.exists()) {
                SimpleXMLParser sxp = XMLUtils.getSimpleXMLParserFromFileSystemEntry((FileSystemEntry)fseMaintenanceXML);
                Vector vNode = sxp.getNodes(XMLPath);
                Vector vNodeParams = SimpleXMLParser.getAllNamedChildNodes((Node)((Node)vNode.get(0)), (String)"param");
                int i = 0;
                while (i < vNodeParams.size()) {
                    Node nodeParamThis = (Node)vNodeParams.elementAt(i);
                    if (SimpleXMLParser.getNodeAttributeValue((Node)nodeParamThis, (String)"name").equals(AttrName)) {
                        String string = SimpleXMLParser.getNodeAttributeValue((Node)nodeParamThis, (String)"value");
                        return string;
                    }
                    ++i;
                }
            }
            return "";
        }
        catch (Exception e) {
            Logr.warn((String)"PakUtils", (String)"getMaintenanceXMLAttrValue", (String)e.getMessage(), (Exception)e);
            return "";
        }
        finally {
            try {
                FileSystem.flushAllFileSystems();
            }
            catch (IOException e) {
                Logr.warn((String)"PakUtils", (String)"getMaintenanceXMLAttrValue", (String)e.getMessage(), (Exception)e);
            }
        }
    }

    private String getIMFixId(FileSystemEntry fsePathToPak) {
        return this.getMaintenanceXMLAttrValue(fsePathToPak, "install-package/information", "im.fixId");
    }

    private String getPakInfo(FileSystemEntry fsePathToPak) {
        return this.getMaintenanceXMLAttrValue(fsePathToPak, "install-package/information", "info_en_US");
    }

    private String getOSArch(FileSystemEntry fsePathToPak) {
        return this.getMaintenanceXMLAttrValue(fsePathToPak, "install-package/installFactoryInformation", "targetOSandArchs");
    }

    @Override
    public String getInstalledPakNameForThisMaintenanceName(String installLocation, String name) {
        String vInstalledPakName = null;
        if (!this.openNIFStack(installLocation, "/properties/version/nif/backup/")) {
            return vInstalledPakName;
        }
        Vector vAllNIFStackElements = NIFStack.getAllNIFStackElements();
        int i = 0;
        while (i < vAllNIFStackElements.size()) {
            NIFPackageEntry entry = (NIFPackageEntry)vAllNIFStackElements.elementAt(i);
            String sName = entry.getNIFPackageName();
            if (sName.equals(name)) {
                vInstalledPakName = entry.getParamValue("filename");
                break;
            }
            ++i;
        }
        NIFStack.close();
        return vInstalledPakName;
    }
}

