/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.core.internal.failurerecovery;

import com.ibm.ws.pak.core.PakMessages;
import com.ibm.ws.pak.core.internal.failurerecovery.IPakFailureRecovery;
import com.ibm.ws.pak.internal.NIFConstants;
import com.ibm.ws.pak.internal.NIFException;
import com.ibm.ws.pak.internal.NIFPlugin;
import com.ibm.ws.pak.internal.install.NIFInstallPlugin;
import com.ibm.ws.pak.internal.install.NIFPackageApplicationPlugin;
import com.ibm.ws.pak.internal.install.failurerecovery.FailureRecoveryPlugin;
import com.ibm.ws.pak.internal.install.failurerecovery.UpdateStatusEntry;
import com.ibm.ws.pak.internal.install.failurerecovery.UpdateStatusFile;
import com.ibm.ws.pak.internal.install.metadata.MaintenanceInfoPlugin;
import com.ibm.ws.pak.internal.install.metadata.NIFStack;
import com.ibm.ws.pak.internal.utils.StringUtils;
import com.ibm.ws.pak.internal.utils.URIUtils;
import com.ibm.ws.pak.internal.utils.XMLUtils;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystem;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.installtoolkitbridge.InstallToolkitBridge;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.IOException;
import java.net.URI;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class PakFailureRecovery
implements IPakFailureRecovery {
    private static final String className = "PakFailureRecovery";
    private boolean m_enable = false;
    private String m_selectedMaintenance = null;
    private InstallToolkitBridge m_itb = null;
    private FailureRecoveryPlugin m_frpRecoveryPlugin = null;
    private MaintenanceInfoPlugin m_mipPackageThis = null;

    @Override
    public int initializeFailureRecovery(Properties properties, InstallToolkitBridge itb) throws Exception {
        Logr.methodEntry((String)className, (String)"initializeFailureRecovery");
        if (properties == null || itb == null) {
            return 1;
        }
        this.m_enable = new Boolean((String)properties.get("wsglobalinstallconstantsProductBean.customProperties,enableFailureRecovery"));
        if (!this.m_enable) {
            return 0;
        }
        this.m_selectedMaintenance = properties.getProperty("wsglobalinstallconstantsProductBean.selectedMaintenancePackages");
        this.m_itb = itb;
        FailureRecoveryPlugin frpRecoveryPlugin = this.getFailureRecoveryPlugin(itb);
        if (frpRecoveryPlugin.hasFailure()) {
            this.executeFailureRecovery();
        }
        this.initializeUpdateStatusFile(this.m_selectedMaintenance, this.m_itb);
        Logr.methodExit((String)className, (String)"initializeFailureRecovery");
        return 0;
    }

    private FailureRecoveryPlugin getFailureRecoveryPlugin(InstallToolkitBridge itb) throws Exception {
        if (this.m_frpRecoveryPlugin == null) {
            this.m_frpRecoveryPlugin = FailureRecoveryPlugin.getFailureRecoveryPlugin((InstallToolkitBridge)itb);
        }
        return this.m_frpRecoveryPlugin;
    }

    @Override
    public int executeFailureRecovery() throws Exception {
        int rc = 0;
        if (this.m_enable) {
            if (this.m_itb != null) {
                rc = this.executeFailureRecovery(this.m_enable, this.m_itb);
            } else {
                Logr.debug((String)"Pak engine failure recovery is not initialized.");
            }
        } else {
            Logr.debug((String)"Pak engine failure recovery is not enabled.");
        }
        return rc;
    }

    public int executeFailureRecovery(boolean enable, InstallToolkitBridge itb) throws Exception {
        Logr.methodEntry((String)className, (String)"executeFailureRecovery");
        if (!enable) {
            Logr.debug((String)"Failure recovery is not enabled.");
            return 0;
        }
        FailureRecoveryPlugin frpRecoveryPlugin = this.getFailureRecoveryPlugin(itb);
        boolean hasFailure = frpRecoveryPlugin.hasFailure();
        if (!hasFailure) {
            return 0;
        }
        Logr.warn((String)PakMessages.PAK_PAK_ACTION_FAILURE_DETECTED);
        int rc = this.executeFailureRecovery(itb);
        frpRecoveryPlugin.getUpdateStatusFile().backupAndRemoveUpdateStatusFile(itb);
        return rc;
    }

    public String getPackageNameOfTheLastestFailedOne(InstallToolkitBridge itb) throws Exception {
        if (itb == null) {
            return null;
        }
        FailureRecoveryPlugin frpRecoveryPlugin = this.getFailureRecoveryPlugin(itb);
        return frpRecoveryPlugin.getPackageNameOfTheLastestFailedOne();
    }

    @Override
    public void setInstallAsCurrentStage() throws Exception {
        this.setCurrentStage("install");
    }

    @Override
    public void setUninstallAsCurrentStage() throws Exception {
        this.setCurrentStage("uninstall");
    }

    public void setCurrentStage(String stage) throws Exception {
        UpdateStatusFile.initializeAsCurrentStage((String)stage);
    }

    private void initializeUpdateStatusFile(String selectedMaintenance, InstallToolkitBridge itb) throws Exception {
        this.getFailureRecoveryPlugin(itb).getUpdateStatusFile().initializeUpdateStatusFile(itb);
        FileSystemEntry fseMeta = URIUtils.convertPathToDefaultSourceMachineFSE((String)selectedMaintenance, (InstallToolkitBridge)itb);
        if (!fseMeta.exists()) {
            return;
        }
        FileSystemEntry fseMaintenanceXML = new FileSystemEntry(fseMeta.getURI(), "maintenance.xml", itb);
        Document documentPackageThis = XMLUtils.getSimpleXMLParserFromFileSystemEntry((FileSystemEntry)fseMaintenanceXML).getDocument();
        this.m_mipPackageThis = MaintenanceInfoPlugin.getMaintenanceInfoPlugin((Document)documentPackageThis, (InstallToolkitBridge)itb);
        this.initializeThisPackageInUpdateStatus(this.m_mipPackageThis, fseMeta, fseMeta.getAbsolutePath(), this.getURIStringOfPrimaryBackup(documentPackageThis, itb));
    }

    private String getURIStringOfPrimaryBackup(Document documentPackageThis, InstallToolkitBridge itb) throws ParserConfigurationException, ClassNotFoundException, IOException, SAXException, IllegalAccessException, IllegalAccessException, InstantiationException {
        NIFPlugin[] anifipInstallPlugins = null;
        int i = 0;
        while (anifipInstallPlugins == null && i < NIFConstants.S_POSSIBLE_NIF_PACKAGE_APPLICATION_PLUGIN_PATHS.length) {
            anifipInstallPlugins = this.initPluginsWithThisPath(documentPackageThis, NIFConstants.S_POSSIBLE_NIF_PACKAGE_APPLICATION_PLUGIN_PATHS[i], itb);
            if (anifipInstallPlugins != null && anifipInstallPlugins.length > 0) {
                NIFPackageApplicationPlugin nifpapThis = (NIFPackageApplicationPlugin)anifipInstallPlugins[0];
                return nifpapThis.getBackuppackageuri();
            }
            ++i;
        }
        return "";
    }

    private NIFPlugin[] initPluginsWithThisPath(Document documentPackage, String sPluginPath, InstallToolkitBridge itb) throws ParserConfigurationException, ClassNotFoundException, IOException, SAXException, IllegalAccessException, IllegalAccessException, InstantiationException {
        return NIFInstallPlugin.getListOfInstallPluginsFor((Document)documentPackage, (String)sPluginPath, (InstallToolkitBridge)itb);
    }

    private void initializeThisPackageInUpdateStatus(MaintenanceInfoPlugin mipPackageThis, FileSystemEntry fsePackageThis, String sSelectedPackage, String sURIOfPrimaryBackupPackage) throws Exception {
        String sIsprimary = mipPackageThis.getWasinstalledasprimary();
        UpdateStatusFile.initializeNewTopLevelEntry((String)fsePackageThis.getEntryName(), (String)mipPackageThis.getName(), (String)mipPackageThis.getUritoreinstall(), (String)sURIOfPrimaryBackupPackage, (boolean)new Boolean(sIsprimary));
    }

    private int executeFailureRecovery(InstallToolkitBridge itb) throws NIFException {
        FailureRecoveryPlugin frpRecoveryPlugin;
        block7: {
            frpRecoveryPlugin = FailureRecoveryPlugin.getFailureRecoveryPlugin((InstallToolkitBridge)itb);
            if (frpRecoveryPlugin.hasFailure()) break block7;
            return 0;
        }
        try {
            UpdateStatusFile usfStatusFile = frpRecoveryPlugin.getUpdateStatusFile();
            UpdateStatusEntry[] auseFailedOnes = usfStatusFile.getFailedEntries();
            int nReturnCode = 1;
            boolean recoveredAll = true;
            UpdateStatusEntry[] updateStatusEntryArray = auseFailedOnes;
            int n = auseFailedOnes.length;
            int n2 = 0;
            while (n2 < n) {
                UpdateStatusEntry entry = updateStatusEntryArray[n2];
                nReturnCode = this.recover(entry, usfStatusFile, itb);
                if (nReturnCode != 0) {
                    Logr.warn((String)PakMessages.bind((String)PakMessages.PAK_PAK_ACTION_FAILED_TRY_RECOVERY_FAILED, (Object)entry.getFileName()));
                    recoveredAll = false;
                } else {
                    Logr.warn((String)PakMessages.bind((String)PakMessages.PAK_PAK_ACTION_FAILED_TRY_RECOVERY_PASSED, (Object)entry.getFileName()));
                }
                ++n2;
            }
            if (recoveredAll) {
                return 0;
            }
            return 1;
        }
        catch (Exception e) {
            throw new NIFException(e, (Throwable)e);
        }
    }

    public int recover(UpdateStatusEntry useFailedOne, UpdateStatusFile usfStatusFile, InstallToolkitBridge itb) throws Exception {
        if (useFailedOne == null || !useFailedOne.isFailed()) {
            return 1;
        }
        FailureRecoveryPlugin frpRecoveryPlugin = FailureRecoveryPlugin.getFailureRecoveryPlugin((InstallToolkitBridge)itb);
        String[] asURIsToBeCleaned = frpRecoveryPlugin.findURIsToBeCleaned(useFailedOne);
        String[] asPathsToBeCleaned = this.findPathsFromURIs(asURIsToBeCleaned, itb);
        String sURIsToBeCleaned = StringUtils.convertStringArrayToTokenString((String[])asURIsToBeCleaned, (String)";");
        String sPathsToBeCleaned = StringUtils.convertStringArrayToTokenString((String[])asPathsToBeCleaned, (String)";");
        if (asURIsToBeCleaned == null || asURIsToBeCleaned.length <= 0) {
            return 1;
        }
        Logr.debug((String)("The following packages will be deleted: " + sPathsToBeCleaned));
        usfStatusFile.setAttributeOfThisEntry(useFailedOne, "URIsOfPackagesToBeCleaned", sURIsToBeCleaned);
        String[] asMaintenanceNamesToBeCleaned = frpRecoveryPlugin.findMaintenanceNamesToBeCleaned(useFailedOne);
        String sMaintenanceNamesToBeCleaned = StringUtils.convertStringArrayToTokenString((String[])asMaintenanceNamesToBeCleaned, (String)";");
        if (asMaintenanceNamesToBeCleaned != null && asMaintenanceNamesToBeCleaned.length > 0) {
            Logr.debug((String)("The following maintenance names will be cleaned from maintenance stack: " + sMaintenanceNamesToBeCleaned));
        }
        usfStatusFile.setAttributeOfThisEntry(useFailedOne, "MaintenanceNamesOfPackagesToBeCleaned", sMaintenanceNamesToBeCleaned);
        String[] asURIsToBeExecuted = frpRecoveryPlugin.findURIsToBeExecuted(useFailedOne);
        String[] asPathsToBeExecuted = this.findPathsFromURIs(asURIsToBeExecuted, itb);
        String sURIsToBeExecuted = StringUtils.convertStringArrayToTokenString((String[])asURIsToBeExecuted, (String)";");
        String sPathsToBeExecuted = StringUtils.convertStringArrayToTokenString((String[])asPathsToBeExecuted, (String)";");
        if (asURIsToBeExecuted != null && asURIsToBeExecuted.length > 0) {
            Logr.debug((String)("The following packages will be executed: " + sPathsToBeExecuted));
        }
        usfStatusFile.setAttributeOfThisEntry(useFailedOne, "URIsOfPackagesToBeExecuted", sURIsToBeExecuted);
        usfStatusFile.setAttributeOfThisEntry(useFailedOne, "modified", Boolean.TRUE.toString());
        usfStatusFile.commit();
        this.clean(useFailedOne, usfStatusFile, asURIsToBeCleaned, asMaintenanceNamesToBeCleaned, itb);
        return 0;
    }

    private void clean(UpdateStatusEntry useEntry, UpdateStatusFile usfStatusFile, String[] asURIsToBeCleaned, String[] asMaintenanceNamesToBeCleaned, InstallToolkitBridge itb) throws Exception {
        this.cleanURIEntries(useEntry, usfStatusFile, asURIsToBeCleaned, itb);
        this.cleanMaintenanceNames(useEntry, usfStatusFile, asMaintenanceNamesToBeCleaned, itb);
    }

    private void cleanURIEntries(UpdateStatusEntry useEntry, UpdateStatusFile usfStatusFile, String[] asURIsToBeCleaned, InstallToolkitBridge itb) throws Exception {
        if (asURIsToBeCleaned == null) {
            return;
        }
        FailureRecoveryPlugin frpRecoveryPlugin = FailureRecoveryPlugin.getFailureRecoveryPlugin((InstallToolkitBridge)itb);
        FileSystemEntry fseRecoveryRepository = frpRecoveryPlugin.getRecoveryRepository();
        String[] stringArray = asURIsToBeCleaned;
        int n = asURIsToBeCleaned.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            FileSystemEntry fseThis = new FileSystemEntry(new URI(element), itb);
            if (fseThis.exists()) {
                Logr.debug((String)("Cleaning " + fseThis.getAbsolutePathWithFlagment() + " from the backup repository ......"));
                FileSystemEntry fseTarget = new FileSystemEntry(fseRecoveryRepository.getURI(), fseThis.getEntryName(), itb);
                FileSystem.flushAllFileSystems();
                try {
                    fseThis.moveTo(fseTarget);
                }
                catch (IOException e) {
                    fseThis.delete();
                }
            }
            usfStatusFile.markThisURIOfThisEntryCleaned(element, useEntry);
            usfStatusFile.commit();
            ++n2;
        }
    }

    private void cleanMaintenanceNames(UpdateStatusEntry useEntry, UpdateStatusFile usfStatusFile, String[] asMaintenanceNames, InstallToolkitBridge itb) throws Exception {
        if (asMaintenanceNames == null) {
            return;
        }
        FailureRecoveryPlugin frpRecoveryPlugin = FailureRecoveryPlugin.getFailureRecoveryPlugin((InstallToolkitBridge)itb);
        if (!NIFStack.isOpen()) {
            NIFStack.open((FileSystemEntry)frpRecoveryPlugin.getBackupRepositoryDir(), (InstallToolkitBridge)itb);
        }
        String[] stringArray = asMaintenanceNames;
        int n = asMaintenanceNames.length;
        int n2 = 0;
        while (n2 < n) {
            String asMaintenanceName = stringArray[n2];
            Logr.debug((String)("Cleaning " + asMaintenanceName + " from the backup repository ......"));
            NIFStack.remove((String)asMaintenanceName);
            NIFStack.commit();
            useEntry.markThisPackageNameCleaned(asMaintenanceName);
            usfStatusFile.commit();
            ++n2;
        }
    }

    private String[] findPathsFromURIs(String[] asURI, InstallToolkitBridge itb) {
        if (asURI == null) {
            return null;
        }
        String[] asPaths = new String[asURI.length];
        int i = 0;
        while (i < asURI.length) {
            try {
                FileSystemEntry fse = new FileSystemEntry(new URI(asURI[i]), itb);
                asPaths[i] = fse.getAbsolutePathWithFlagment();
            }
            catch (Exception e) {
                asPaths[i] = asURI[i];
            }
            ++i;
        }
        return asPaths;
    }
}

