/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.core.internal.action;

import com.ibm.ws.pak.core.internal.action.NGIAction;
import com.ibm.ws.pak.internal.NIFException;
import com.ibm.ws.pak.internal.NIFPlugin;
import com.ibm.ws.pak.internal.install.NIFInstallPlugin;
import com.ibm.ws.pak.internal.utils.events.NIFEvent;
import com.ibm.ws.pak.internal.utils.events.NIFEventMulticaster;
import com.ibm.ws.pak.internal.utils.events.NIFEventObserver;
import com.ibm.ws.pak.internal.utils.installtoolkitbridge.InstallToolkitBridge;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.util.Hashtable;

public class PakInstallAction
extends NGIAction {
    final String className = "PakInstallAction";
    private final NIFEventObserver m_nifeoOurObserver = new NIFEventObserver(){
        {
            NIFEventMulticaster.instance().subscribe((NIFEventObserver)this, 2);
            NIFEventMulticaster.instance().subscribe((NIFEventObserver)this, 1);
            NIFEventMulticaster.instance().subscribe((NIFEventObserver)this, 5);
        }

        public void eventOccured(NIFEvent nife) {
            Logr.methodEntry((String)"PakInstallAction", (String)"eventOccured");
            Hashtable hash = nife.getEventProperties();
            int type = nife.getEventType();
            if (type == 5) {
                Integer overallInstallProgress = (Integer)hash.get("percent");
                if (overallInstallProgress != null) {
                    Logr.debug((String)("PakInstallAction.eventOccured(): NIFEventObservereventType=" + type + " percent=" + overallInstallProgress));
                    PakInstallAction.this.firePropertyChange("PakInstallAction", 0, overallInstallProgress);
                }
            } else if (type == 2) {
                String sComponentName = (String)hash.get("COMPONENT_NAME");
                if (sComponentName != null) {
                    Logr.debug((String)("PakInstallAction.eventOccured(): NIFEventObservereventType=" + type + " component=" + sComponentName));
                    PakInstallAction.this.firePropertyChange("PakInstallComponent", null, sComponentName);
                }
            } else if (type == 1) {
                int num = (Integer)hash.get("FILE_NUMBER");
                int total = (Integer)hash.get("TOTAL_FILES");
                int percent = ++num * 100 / total;
                String file = (String)hash.get("FILE_RELATIVE_PATH");
                Logr.debug((String)("PakInstallAction.eventOccured(): NIFEventObservereventType=" + type + " percent=" + percent + " num=" + num + " total=" + total + " file=" + file));
            }
            Logr.methodExit((String)"PakInstallAction", (String)"eventOccured");
        }
    };

    public PakInstallAction(InstallToolkitBridge itb, String[] asMetaDataURIs, String[] asPluginPaths) {
        super(itb, asMetaDataURIs, asPluginPaths);
        Logr.debug((String)("Create NIFEventObserver :" + this.m_nifeoOurObserver.toString()));
    }

    @Override
    protected int executePlugin(NIFPlugin nifp) throws NIFException {
        Logr.methodEntry((String)"PakInstallAction", (String)"executePlugin");
        if (nifp instanceof NIFInstallPlugin) {
            return ((NIFInstallPlugin)nifp).execute();
        }
        Logr.methodExit((String)"PakInstallAction", (String)"executePlugin");
        return 0;
    }
}

