/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.swt.dialogs;

import com.ibm.cic.common.ui.internal.dialogs.AbstractCicAboutDialog;
import com.ibm.cic.common.ui.swt.dialogs.AboutBundleGroupDataWrapper;
import com.ibm.cic.common.ui.swt.dialogs.AboutFeaturesButtonManagerWrapper;
import com.ibm.cic.common.ui.swt.dialogs.AboutFeaturesDialogWrapper;
import com.ibm.cic.common.ui.swt.dialogs.AboutItemWrapper;
import com.ibm.cic.common.ui.swt.dialogs.AboutTextManagerWrapper;
import com.ibm.cic.common.ui.swt.dialogs.InstallationDialogWrapper;
import com.ibm.cic.eclipse.internals.dialogs.AboutUtils;
import java.util.LinkedList;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;

public class SwtCicAboutDialog
extends AbstractCicAboutDialog {
    private final AboutBundleGroupDataWrapper[] bundleGroupInfos;
    private final AboutFeaturesButtonManagerWrapper buttonManager = new AboutFeaturesButtonManagerWrapper();
    private AboutTextManagerWrapper aboutTextManager;
    private StyledText text;

    public SwtCicAboutDialog(Shell parentShell, String version, int textHeight) {
        this(parentShell, version, null, null, null, true, textHeight);
    }

    public SwtCicAboutDialog(Shell parentShell, String internalVersion, String externalVersion, String productName, String architecture, boolean showFeatures) {
        this(parentShell, internalVersion, externalVersion, productName, architecture, showFeatures, 100);
    }

    public SwtCicAboutDialog(Shell parentShell, String internalVersion, String externalVersion, String fullProductName, String architecture, boolean showFeatures, int textHeight) {
        super(parentShell, internalVersion, externalVersion, fullProductName, architecture, showFeatures, textHeight);
        IBundleGroupProvider[] providers = Platform.getBundleGroupProviders();
        LinkedList<AboutBundleGroupDataWrapper> groups = new LinkedList<AboutBundleGroupDataWrapper>();
        if (providers != null) {
            IBundleGroupProvider[] iBundleGroupProviderArray = providers;
            int n = providers.length;
            int n2 = 0;
            while (n2 < n) {
                IBundleGroup[] bundleGroups;
                IBundleGroupProvider provider = iBundleGroupProviderArray[n2];
                IBundleGroup[] iBundleGroupArray = bundleGroups = provider.getBundleGroups();
                int n3 = bundleGroups.length;
                int n4 = 0;
                while (n4 < n3) {
                    IBundleGroup bundleGroup = iBundleGroupArray[n4];
                    groups.add(new AboutBundleGroupDataWrapper(bundleGroup));
                    ++n4;
                }
                ++n2;
            }
        }
        this.bundleGroupInfos = groups.toArray(new AboutBundleGroupDataWrapper[0]);
    }

    private Button createFeatureButton(Composite parent, final AboutBundleGroupDataWrapper info) {
        if (!this.buttonManager.add(info)) {
            return null;
        }
        ImageDescriptor desc = info.getFeatureImage();
        Image featureImage = null;
        Button button = new Button(parent, 0x800008);
        button.setData((Object)info);
        featureImage = desc.createImage();
        this.images.add(featureImage);
        button.setImage(featureImage);
        button.setToolTipText(info.getProviderName());
        button.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = info.getProviderName();
            }
        });
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AboutBundleGroupDataWrapper selection = (AboutBundleGroupDataWrapper)event.widget.getData();
                AboutFeaturesDialogWrapper d = new AboutFeaturesDialogWrapper(SwtCicAboutDialog.this.getShell(), SwtCicAboutDialog.this.productName, SwtCicAboutDialog.this.buttonManager.getRelatedInfos(info), selection.getAboutBundleGroupData());
                d.open();
            }
        });
        return button;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1025: {
                BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        InstallationDialogWrapper dialog = new InstallationDialogWrapper(SwtCicAboutDialog.this.getShell(), (IServiceLocator)workbenchWindow);
                        dialog.setModalParent((Dialog)SwtCicAboutDialog.this);
                        dialog.open();
                    }
                });
                break;
            }
            default: {
                super.buttonPressed(buttonId);
            }
        }
    }

    private void createTextMenu() {
        final MenuManager textManager = new MenuManager();
        textManager.add((IContributionItem)new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)PlatformUI.getWorkbench(), null, "org.eclipse.ui.edit.copy", 8)));
        textManager.add((IContributionItem)new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)PlatformUI.getWorkbench(), null, "org.eclipse.ui.edit.selectAll", 8)));
        this.text.setMenu(textManager.createContextMenu((Control)this.text));
        this.text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                textManager.dispose();
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Image aboutImage = null;
        AboutItemWrapper item = null;
        if (this.product != null) {
            ImageDescriptor imageDescriptor = AboutUtils.getAboutImage((IProduct)this.product);
            if (imageDescriptor != null) {
                aboutImage = imageDescriptor.createImage();
            }
            if ((aboutImage == null || aboutImage.getBounds().width <= 250) && this.aboutText != null) {
                item = AboutTextManagerWrapper.scanString(this.aboutText);
            }
            if (aboutImage != null) {
                this.images.add(aboutImage);
            }
        }
        Composite workArea = new Composite(parent, 0);
        GridLayout workLayout = new GridLayout();
        workLayout.marginHeight = 0;
        workLayout.marginWidth = 0;
        workLayout.verticalSpacing = 0;
        workLayout.horizontalSpacing = 0;
        workArea.setLayout((Layout)workLayout);
        workArea.setLayoutData((Object)new GridData(1808));
        Color background = JFaceColors.getBannerBackground((Display)parent.getDisplay());
        Color foreground = JFaceColors.getBannerForeground((Display)parent.getDisplay());
        Composite top = (Composite)super.createDialogArea(workArea);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        top.setLayout((Layout)layout);
        top.setLayoutData((Object)new GridData(1808));
        top.setBackground(background);
        top.setForeground(foreground);
        Composite topContainer = new Composite(top, 0);
        topContainer.setBackground(background);
        topContainer.setForeground(foreground);
        layout = new GridLayout();
        layout.numColumns = aboutImage == null || item == null ? 1 : 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        topContainer.setLayout((Layout)layout);
        GC gc = new GC((Drawable)parent);
        int lineHeight = gc.getFontMetrics().getHeight();
        gc.dispose();
        int topContainerHeightHint = this.textHeightHint;
        topContainerHeightHint = Math.max(topContainerHeightHint, lineHeight * 6);
        if (aboutImage != null) {
            Label imageLabel = new Label(topContainer, 0);
            imageLabel.setBackground(background);
            imageLabel.setForeground(foreground);
            GridData data = new GridData();
            data.horizontalAlignment = 4;
            data.verticalAlignment = 1;
            data.grabExcessHorizontalSpace = false;
            imageLabel.setLayoutData((Object)data);
            imageLabel.setImage(aboutImage);
            topContainerHeightHint = Math.max(topContainerHeightHint, aboutImage.getBounds().height);
        }
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.heightHint = topContainerHeightHint;
        topContainer.setLayoutData((Object)data);
        if (item != null) {
            int minWidth = 432;
            final ScrolledComposite scroller = new ScrolledComposite(topContainer, 768);
            data = new GridData(1808);
            data.widthHint = 432;
            scroller.setLayoutData((Object)data);
            final Composite textComposite = new Composite((Composite)scroller, 0);
            textComposite.setBackground(background);
            layout = new GridLayout();
            textComposite.setLayout((Layout)layout);
            this.text = new StyledText(textComposite, 74);
            this.text.setFont(parent.getFont());
            this.text.setText(this.aboutText);
            this.text.setCursor(null);
            this.text.setBackground(background);
            this.text.setForeground(foreground);
            this.aboutTextManager = new AboutTextManagerWrapper(this.text);
            this.aboutTextManager.setItem(item);
            this.createTextMenu();
            GridData gd = new GridData();
            gd.verticalAlignment = 1;
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.text.setLayoutData((Object)gd);
            scroller.getHorizontalBar().setIncrement(20);
            scroller.getVerticalBar().setIncrement(20);
            final boolean[] inresize = new boolean[1];
            textComposite.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    if (inresize[0]) {
                        return;
                    }
                    inresize[0] = true;
                    textComposite.layout(true);
                    int width = textComposite.getClientArea().width;
                    Point p = textComposite.computeSize(width, -1);
                    scroller.setMinSize(432, p.y);
                    inresize[0] = false;
                }
            });
            scroller.setExpandHorizontal(true);
            scroller.setExpandVertical(true);
            Point p = textComposite.computeSize(432, -1);
            textComposite.setSize(p.x, p.y);
            scroller.setMinWidth(432);
            scroller.setMinHeight(p.y);
            scroller.setContent((Control)textComposite);
        }
        Label bar = new Label(workArea, 258);
        data = new GridData();
        data.horizontalAlignment = 4;
        bar.setLayoutData((Object)data);
        Composite bottom = (Composite)super.createDialogArea(workArea);
        layout = new GridLayout();
        bottom.setLayout((Layout)layout);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        bottom.setLayoutData((Object)data);
        if (this.showFeatures) {
            this.createFeatureImageButtonRow(bottom);
        }
        bar = new Label(bottom, 0);
        data = new GridData();
        data.horizontalAlignment = 4;
        bar.setLayoutData((Object)data);
        return workArea;
    }

    protected void createFeatureImageButtonRow(Composite parent) {
        Composite featureContainer = new Composite(parent, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.wrap = true;
        featureContainer.setLayout((Layout)rowLayout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        featureContainer.setLayoutData((Object)data);
        AboutBundleGroupDataWrapper[] aboutBundleGroupDataWrapperArray = this.bundleGroupInfos;
        int n = this.bundleGroupInfos.length;
        int n2 = 0;
        while (n2 < n) {
            AboutBundleGroupDataWrapper bundleGroupInfo = aboutBundleGroupDataWrapperArray[n2];
            this.createFeatureButton(featureContainer, bundleGroupInfo);
            ++n2;
        }
    }
}

