/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.licensing.lum;

import com.ibm.LUMClient.LicenseTransaction;
import com.ibm.LUMClient.LumClient;
import com.ibm.cic.licensing.common.core.ILicenseCheckProvider;
import com.ibm.cic.licensing.common.core.LicenseChecker;
import com.ibm.cic.licensing.common.util.Constants;
import com.ibm.cic.licensing.common.util.LicUserUtils;
import com.ibm.cic.licensing.common.util.LicenseStatus;
import com.ibm.cic.licensing.common.util.Logger;
import com.ibm.cic.licensing.common.util.ProductInformation;
import com.ibm.cic.licensing.lum.Messages;
import com.ibm.icu.text.DateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class LUMCheck
implements Constants,
ILicenseCheckProvider {
    public static long ERROR_NETLS_LIC_NOT_FND = 0x1D010001L;
    public static long ERROR_NETLS_PAST_EXP_DATE = 486604803L;
    public static long ERROR_NETLS_NOT_STARTED = 486604805L;

    public LicenseStatus checkout(ProductInformation pi) {
        LicenseStatus licstatus = null;
        String aclmsg = LicenseChecker.checkLicenseDirAclMsg();
        if (aclmsg != null) {
            Exception acle = new Exception(aclmsg);
            licstatus = new LicenseStatus(2, aclmsg, acle);
            licstatus.setOfferingName(pi.getProductName());
            licstatus.setOfferingVersion(pi.getDisplayVersion());
            licstatus.setLocalizedLicenseType(com.ibm.cic.licensing.common.core.Messages.LicenseType_Unknown);
            licstatus.setLocalizedStatusString(com.ibm.cic.licensing.common.core.Messages.Key_Not_Available);
            pi.setLicenseStatus(licstatus);
            Logger.logNtrace((int)Logger.ERROR, (String)aclmsg);
            return licstatus;
        }
        int LUMID = -1;
        try {
            LUMID = Integer.parseInt(pi.getLumProductId());
        }
        catch (NumberFormatException nfe) {
            String errmsg = NLS.bind((String)Messages.Invalid_Lum_ID, (Object)pi.getProductId());
            licstatus = new LicenseStatus(2, errmsg, (Exception)nfe);
            licstatus.setOfferingName(pi.getProductName());
            licstatus.setOfferingVersion(pi.getDisplayVersion());
            licstatus.setLocalizedLicenseType(com.ibm.cic.licensing.common.core.Messages.LicenseType_Nodelocked);
            licstatus.setLocalizedStatusString(com.ibm.cic.licensing.common.core.Messages.Key_Not_Available);
            pi.setLicenseStatus(licstatus);
            Logger.logNtrace((int)Logger.ERROR, (String)errmsg);
            return licstatus;
        }
        String LUMVersion = pi.getLumVersionId();
        String nodelockFilePath = LicUserUtils.getRuntimeLumNodeLockFile().toOSString();
        licstatus = LUMCheck.checkLicense(LUMID, LUMVersion, nodelockFilePath, true);
        licstatus.setOfferingName(pi.getProductName());
        licstatus.setOfferingVersion(pi.getDisplayVersion());
        pi.setLicenseStatus(licstatus);
        return licstatus;
    }

    private static synchronized LicenseStatus checkLicense(int productId, String version, String nodelockFilePathStr, boolean logError) {
        LicenseStatus status = new LicenseStatus();
        LumClient client = LumClient.getLumClient();
        int option = 1;
        client.setOption("7ff2aa10b91c.02.45.64.43.f1.00.00.00", option, nodelockFilePathStr);
        LicenseTransaction Lic = client.initSession("7ff2aa10b91c.02.45.64.43.f1.00.00.00");
        if (Lic.getServerStatus() == 1L) {
            LUMCheck.setStatusNoLicense(status, Lic, com.ibm.cic.licensing.common.core.Messages.LicenseType_Nodelocked, com.ibm.cic.licensing.common.core.Messages.Key_Not_Available);
            if (logError) {
                Logger.logNtrace((int)Logger.ERROR, (String)("LUM check INIT failed: " + Lic.getServerErrMsg()));
            }
            return status;
        }
        byte[] adv_opt = new byte[5];
        adv_opt[3] = 2;
        adv_opt[4] = 1;
        String acid = "";
        String ser = "";
        Lic = client.requestLicense(1, productId, version, 1, 0, false, acid, ser, adv_opt);
        if (Lic.getServerStatus() == 0L) {
            if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
                Logger.logNtrace((String)("LUM check success for productID: " + productId));
            }
            status.setLicenseGranted(true);
            String licAnnotaion = Lic.getAnnotation();
            status.setLicensesCount(LUMCheck.getLiensesCount(licAnnotaion));
            status.setExpireDate(Lic.getExpirationDate());
            Date expDate = new Date(Lic.getExpirationDate() * 1000L);
            DateFormat dateFormat = DateFormat.getDateInstance();
            status.setExpireDateString(dateFormat.format(expDate));
            int daysleft = LUMCheck.getDaysToExpire(status);
            status.setDaysToExpire(daysleft);
            if (Lic.getAttrMask() == '\u0001') {
                status.setLumTrial(true);
                status.setLocalizedLicenseType(com.ibm.cic.licensing.common.core.Messages.LicenseType_Trial);
            } else if (LicenseStatus.isTermLicense((int)daysleft)) {
                status.setLocalizedLicenseType(com.ibm.cic.licensing.common.core.Messages.LicenseType_Term);
            } else {
                status.setExpireDateString("");
                status.setLocalizedLicenseType(com.ibm.cic.licensing.common.core.Messages.LicenseType_Perm);
            }
            status.setLocalizedStatusString(com.ibm.cic.licensing.common.core.Messages.Key_Available);
            status.setStatusCode(0);
            if (LicenseStatus.isExpiringSoon((int)daysleft)) {
                status.setStatusCode(1);
                status.setLicenseWillExpire(true);
                status.setLocalizedStatusString(NLS.bind((String)com.ibm.cic.licensing.common.core.Messages.Key_Expires_In_Days, (Object)String.valueOf(daysleft)));
            }
        } else if (Lic.getServerStatus() == 486604803L) {
            if (Lic.getLicenseType() == 1) {
                status.setLumTrial(true);
                LUMCheck.setStatusNoLicense(status, Lic, com.ibm.cic.licensing.common.core.Messages.LicenseType_Trial, com.ibm.cic.licensing.common.core.Messages.Key_Expired);
            } else {
                LUMCheck.setStatusNoLicense(status, Lic, com.ibm.cic.licensing.common.core.Messages.LicenseType_Term, com.ibm.cic.licensing.common.core.Messages.Key_Expired);
            }
            if (logError) {
                Logger.logNtrace((int)Logger.ERROR, (String)("LUM license expired for productID " + productId + ": " + Lic.getServerErrMsg()));
            }
        } else {
            LUMCheck.setStatusNoLicense(status, Lic, com.ibm.cic.licensing.common.core.Messages.LicenseType_Nodelocked, com.ibm.cic.licensing.common.core.Messages.Key_Not_Available);
            if (logError) {
                Logger.logNtrace((int)Logger.ERROR, (String)("LUM check failed for productID " + productId + ": " + Lic.getServerErrMsg() + " RC= " + Lic.getServerStatus()));
            }
        }
        return status;
    }

    private static int getLiensesCount(String licAnnotaion) {
        int count = 1;
        int tagPos = licAnnotaion.indexOf("EntitledSeats:");
        if (tagPos >= 0) {
            String numOfSeats = licAnnotaion.substring(tagPos + "EntitledSeats:".length());
            try {
                count = Integer.parseInt(numOfSeats);
            }
            catch (NumberFormatException nfe) {
                Logger.logNtrace((String)"Internal error occured when getting integer value of EntitledSeats:", (Exception)nfe);
                count = -1;
            }
        }
        return count;
    }

    private static void setStatusNoLicense(LicenseStatus status, LicenseTransaction Lic, String licenseTypeLabel, String licenseStatusLabel) {
        status.setServerStatus(Lic.getServerStatus());
        status.setErrMsg(Lic.getServerErrMsg());
        status.setLicenseGranted(false);
        status.setErrException(new Exception(Lic.getServerErrMsg()));
        status.setStatusCode(2);
        status.setLocalizedLicenseType(licenseTypeLabel);
        status.setLocalizedStatusString(licenseStatusLabel);
    }

    private static int getDaysToExpire(LicenseStatus status) {
        int daysleft = -1;
        long expirationDate = status.getExpireDate();
        long currDate = new Date().getTime();
        daysleft = (int)((expirationDate - currDate / 1000L) / 60L / 60L / 24L);
        return daysleft;
    }

    public boolean checkin(ProductInformation pi) {
        return true;
    }

    public boolean canHandle(String lictype) {
        return lictype != null && lictype.equalsIgnoreCase("LUM");
    }

    public LicenseStatus checkStatus(ProductInformation pi) {
        LicenseStatus licstatus = null;
        String aclmsg = LicenseChecker.checkLicenseDirAclMsg();
        if (aclmsg != null) {
            Exception acle = new Exception(aclmsg);
            licstatus = new LicenseStatus(2, aclmsg, acle);
            licstatus.setOfferingName(pi.getProductName());
            licstatus.setOfferingVersion(pi.getDisplayVersion());
            licstatus.setLocalizedLicenseType(com.ibm.cic.licensing.common.core.Messages.LicenseType_Unknown);
            licstatus.setLocalizedStatusString(com.ibm.cic.licensing.common.core.Messages.Key_Not_Available);
            pi.setLicenseStatus(licstatus);
            return licstatus;
        }
        int LUMID = -1;
        try {
            LUMID = Integer.parseInt(pi.getLumProductId());
        }
        catch (NumberFormatException nfe) {
            String errmsg = NLS.bind((String)Messages.Invalid_Lum_ID, (Object)pi.getProductId());
            licstatus = new LicenseStatus(2, errmsg, (Exception)nfe);
            licstatus.setOfferingName(pi.getProductName());
            licstatus.setOfferingVersion(pi.getDisplayVersion());
            licstatus.setLocalizedLicenseType(com.ibm.cic.licensing.common.core.Messages.LicenseType_Nodelocked);
            licstatus.setLocalizedStatusString(com.ibm.cic.licensing.common.core.Messages.Key_Not_Available);
            pi.setLicenseStatus(licstatus);
            return licstatus;
        }
        String LUMVersion = pi.getLumVersionId();
        String nodelockFilePath = LicUserUtils.getRuntimeLumNodeLockFile().toOSString();
        licstatus = LUMCheck.checkLicense(LUMID, LUMVersion, nodelockFilePath, false);
        licstatus.setOfferingName(pi.getProductName());
        licstatus.setOfferingVersion(pi.getDisplayVersion());
        pi.setLicenseStatus(licstatus);
        return licstatus;
    }

    public IStatus testConnection(ProductInformation pi, String serverName, String portNum) {
        return null;
    }

    public LicenseStatus checkStatus(ProductInformation pi, String licenseLocation) {
        LicenseStatus licstatus = null;
        int LUMID = -1;
        try {
            LUMID = Integer.parseInt(pi.getLumProductId());
        }
        catch (NumberFormatException nfe) {
            String errmsg = NLS.bind((String)Messages.Invalid_Lum_ID, (Object)pi.getProductId());
            licstatus = new LicenseStatus(2, errmsg, (Exception)nfe);
            licstatus.setOfferingName(pi.getProductName());
            licstatus.setOfferingVersion(pi.getDisplayVersion());
            licstatus.setLocalizedLicenseType(com.ibm.cic.licensing.common.core.Messages.LicenseType_Nodelocked);
            licstatus.setLocalizedStatusString(com.ibm.cic.licensing.common.core.Messages.Key_Not_Available);
            pi.setLicenseStatus(licstatus);
            Logger.logNtrace((int)Logger.ERROR, (String)errmsg);
            return licstatus;
        }
        String LUMVersion = pi.getLumVersionId();
        String nodelockpath = LicUserUtils.getInstallTimeLumNodeLockFile((IPath)new Path(licenseLocation)).toOSString();
        licstatus = LUMCheck.checkLicense(LUMID, LUMVersion, nodelockpath, false);
        licstatus.setOfferingName(pi.getProductName());
        licstatus.setOfferingVersion(pi.getDisplayVersion());
        pi.setLicenseStatus(licstatus);
        return licstatus;
    }

    public void initializeRCLLogging(String configFileLocation) {
    }

    public boolean configureRCLLogging(String configFileLocation, String logFileLocation, String product, String version, int size, int logLevel, int traceLevel, int maxFiles, boolean enableLogging, boolean enableTracing) {
        return true;
    }
}

