/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.nativeInstallAdapter.desktopMenu;

import com.ibm.cic.agent.core.nativeInstallAdapter.desktopMenu.AbstractDesktopElement;
import com.ibm.cic.agent.core.nativeInstallAdapter.desktopMenu.DesktopDirectory;
import com.ibm.cic.agent.core.nativeInstallAdapter.desktopMenu.DesktopEntry;
import com.ibm.cic.agent.core.nativeInstallAdapter.desktopMenu.DesktopMenu;
import com.ibm.cic.agent.core.nativeInstallAdapter.desktopMenu.DesktopMenuHandler;
import com.ibm.cic.agent.core.nativeInstallAdapter.desktopMenu.IOsSpecificPolicy;
import com.ibm.cic.agent.internal.adapters.nativeAdapter.Messages;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.utils.Encodings;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.XMLWriter;
import com.ibm.cic.common.logging.ExceptionUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;

public class UnixSpecificDesktopMenuPolicy
implements IOsSpecificPolicy {
    public static final String XDG_CONFIG_HOME = "XDG_CONFIG_HOME";
    public static final String XDG_DATA_HOME = "XDG_DATA_HOME";
    static final String GU_DESKTOP_ROOT_DIR = "/desktop";
    static final String CU_DEFAULT_MENU_DIR = "${homeLocation}/.config/menus";
    static final String GU_DEFAULT_MENU_DIR = String.valueOf(CicCommonSettings.getApplicationDataLocation()) + "/desktop" + "/.config/menus";
    static final String AU_DEFAULT_MENU_DIR = "/etc/xdg/menus";
    static final String GNOME_DEFAULT_MERGED_MENU_DIR = "applications-merged";
    static final String KDE_DEFAULT_MERGED_MENU_DIR = "kde-applications-merged";
    static final String CU_DEFAULT_DESKTOP_ITEM_DIR = "${homeLocation}/.local/share";
    static final String GU_DEFAULT_DESKTOP_ITEM_DIR = String.valueOf(CicCommonSettings.getApplicationDataLocation()) + "/desktop" + "/.local/share";
    static final String AU_DEFAULT_DESKTOP_ITEM_DIR = "/usr/share";
    static final String DEFAULT_APPLICATIONS_DIR = "/applications";
    static final String DEFAULT_DIRECTORIES_DIR = "/desktop-directories";
    static final String FILE_MENU_EXT = ".menu";
    static final String FILE_DIR_EXT = ".directory";
    static final String FILE_ENTRY_EXT = ".desktop";
    File m_contextMenuDirectoryDir;
    File m_contextMenuEntryDir;
    File m_contextMenuDir;
    static final String ENTRY_TYPE = "Type";
    static final String ENTRY_TYPE_APPLICATION = "Application";
    static final String ENTRY_TYPE_DIRECTORY = "Directory";
    static final String ENTRY_NAME = "Name";
    static final String ENTRY_WORKING_DIRECTORY = "Path";
    static final String ENTRY_COMMAND = "Exec";
    static final String ENTRY_ICON = "Icon";
    static final String ENTRY_DESCRIPTION = "Comment";
    static final String ENTRY_CATEGORIES = "Categories";
    static final String MENU_XML_ELEMENT_MENU = "Menu";
    static final String MENU_XML_ELEMENT_NAME = "Name";
    static final String MENU_XML_ELEMENT_DIRECTORY = "Directory";
    static final String MENU_XML_ELEMENT_INCLUDE = "Include";
    static final String MENU_XML_ELEMENT_FILENAME = "Filename";

    public File getDesktopMenuDir(DesktopMenuHandler handler) {
        if (this.m_contextMenuDir == null) {
            String path = this.getPropertyOrEnvVar(XDG_CONFIG_HOME);
            if (path != null && path.length() > 0) {
                this.m_contextMenuDir = new File(path);
            } else if (handler.installForAllUsers()) {
                File newDir = new File(AU_DEFAULT_MENU_DIR);
                if (this.directoryIsWriteable(newDir)) {
                    this.m_contextMenuDir = newDir;
                }
            } else if (CicCommonSettings.getAccessRightsMode().isGroupMode()) {
                File newDir = new File(handler.performVariableSubstitutions(GU_DEFAULT_MENU_DIR));
                if (this.directoryIsWriteable(newDir)) {
                    this.m_contextMenuDir = newDir;
                }
            } else {
                File newDir = new File(handler.performVariableSubstitutions(CU_DEFAULT_MENU_DIR));
                if (this.directoryIsWriteable(newDir)) {
                    this.m_contextMenuDir = newDir;
                }
            }
        }
        return this.m_contextMenuDir;
    }

    private File createFileName(AbstractDesktopElement e, String extension, boolean isAgentProfile) {
        return this.createFileName(e.getContainingDir(), e, extension);
    }

    private File createShortFileName(AbstractDesktopElement e, String extension, boolean isAgentProfile) {
        return this.createShortFileName(e.getContainingDir(), e, extension);
    }

    private File createFileName(File dir, AbstractDesktopElement e, String extension) {
        String groupOrNonAdminPrefix = null;
        groupOrNonAdminPrefix = CicCommonSettings.getAccessRightsMode().isGroupMode() && e.getHandler().isAgentProfile() ? "Group" : (!CicCommonSettings.getAccessRightsMode().isAdminMode() && e.getHandler().isAgentProfile() ? "My" : "");
        String name = String.valueOf(groupOrNonAdminPrefix) + e.getHandler().getCommonName() + e.getName() + extension;
        name = name.replaceAll(" ", "_");
        File return_value = new File(dir, name);
        return return_value;
    }

    private File createShortFileName(File dir, AbstractDesktopElement e, String extension) {
        String groupOrNonAdminPrefix = null;
        groupOrNonAdminPrefix = CicCommonSettings.getAccessRightsMode().isGroupMode() && e.getHandler().isAgentProfile() ? "G_" : (!CicCommonSettings.getAccessRightsMode().isAdminMode() && e.getHandler().isAgentProfile() ? "M_" : "");
        String name = String.valueOf(groupOrNonAdminPrefix) + e.getHandler().getCommonShortName() + e.getName();
        name = String.valueOf(FileUtil.shortenNameLength((String)name)) + extension;
        File return_value = new File(dir, name);
        return return_value;
    }

    @Override
    public boolean directoryIsWriteable(File dir) {
        boolean return_value = false;
        File theDir = dir;
        while (theDir != null && !theDir.exists()) {
            theDir = theDir.getParentFile();
        }
        if (theDir != null && theDir.isDirectory()) {
            File testShortCut = new File(theDir, "IBMIM_dummy.so");
            if (!testShortCut.exists()) {
                try {
                    return_value = testShortCut.createNewFile();
                }
                catch (IOException e) {
                    ExceptionUtil.debugLogToReview((Throwable)e);
                }
            } else {
                return_value = true;
            }
            if (return_value) {
                return_value = testShortCut.delete();
            }
        }
        if (!return_value) {
            DesktopMenuHandler.log.warning(Messages.directory_is_not_writeable, new Object[]{dir.getAbsolutePath()});
        }
        return return_value;
    }

    @Override
    public File calculateContainingDir(AbstractDesktopElement parent, AbstractDesktopElement elem) {
        if (elem instanceof DesktopMenu) {
            return this.getDesktopMenuDir(elem.getHandler());
        }
        if (elem instanceof DesktopDirectory) {
            return this.calculateDesktopDirectoryDir(elem.getHandler());
        }
        return this.calculateDesktopEntryDir(elem.getHandler());
    }

    private File calculateDesktopDirectoryDir(DesktopMenuHandler handler) {
        if (this.m_contextMenuDirectoryDir == null) {
            String path = this.getPropertyOrEnvVar(XDG_DATA_HOME);
            if (path != null && path.length() > 0) {
                this.m_contextMenuDirectoryDir = new File(path);
            } else if (handler.installForAllUsers()) {
                File newDir = new File("/usr/share/desktop-directories");
                if (this.directoryIsWriteable(newDir)) {
                    this.m_contextMenuDirectoryDir = newDir;
                }
            } else if (CicCommonSettings.getAccessRightsMode().isGroupMode()) {
                File newDir = new File(handler.performVariableSubstitutions(String.valueOf(GU_DEFAULT_DESKTOP_ITEM_DIR) + DEFAULT_DIRECTORIES_DIR));
                if (this.directoryIsWriteable(newDir)) {
                    this.m_contextMenuDirectoryDir = newDir;
                }
            } else {
                File newDir = new File(handler.performVariableSubstitutions("${homeLocation}/.local/share/desktop-directories"));
                if (this.directoryIsWriteable(newDir)) {
                    this.m_contextMenuDirectoryDir = newDir;
                }
            }
        }
        return this.m_contextMenuDirectoryDir;
    }

    private File calculateDesktopEntryDir(DesktopMenuHandler handler) {
        if (this.m_contextMenuEntryDir == null) {
            String path = this.getPropertyOrEnvVar(XDG_DATA_HOME);
            if (path != null && path.length() > 0) {
                this.m_contextMenuEntryDir = new File(path);
            } else if (handler.installForAllUsers()) {
                File newDir = new File("/usr/share/applications");
                if (this.directoryIsWriteable(newDir)) {
                    this.m_contextMenuEntryDir = newDir;
                }
            } else if (CicCommonSettings.getAccessRightsMode().isGroupMode()) {
                File newDir = new File(handler.performVariableSubstitutions(String.valueOf(GU_DEFAULT_DESKTOP_ITEM_DIR) + DEFAULT_APPLICATIONS_DIR));
                if (this.directoryIsWriteable(newDir)) {
                    this.m_contextMenuEntryDir = newDir;
                }
            } else {
                File newDir = new File(handler.performVariableSubstitutions("${homeLocation}/.local/share/applications"));
                if (this.directoryIsWriteable(newDir)) {
                    this.m_contextMenuEntryDir = newDir;
                }
            }
        }
        return this.m_contextMenuEntryDir;
    }

    @Override
    public boolean createDiskFiles(DesktopMenu menu) throws CoreException {
        if (menu.getContainingDir() == null) {
            throw new CoreException((IStatus)Statuses.WARNING.get(Messages.undefined_menu_containing_dir, new Object[]{menu.getName()}));
        }
        File dirGnome = new File(menu.getContainingDir(), GNOME_DEFAULT_MERGED_MENU_DIR);
        if (!dirGnome.exists()) {
            dirGnome.mkdirs();
        }
        File fileNameGnome = this.createShortFileName(dirGnome, menu, FILE_MENU_EXT);
        this.createXMLMenuFile(fileNameGnome, menu);
        File dirKde = new File(menu.getContainingDir(), KDE_DEFAULT_MERGED_MENU_DIR);
        if (!dirKde.exists()) {
            dirKde.mkdirs();
        }
        File fileNameKde = this.createShortFileName(dirKde, menu, FILE_MENU_EXT);
        this.createXMLMenuFile(fileNameKde, menu);
        return true;
    }

    @Override
    public boolean deleteDiskFiles(DesktopMenu menu) {
        File dirKDE;
        File fileNameKde;
        boolean return_value = true;
        if (menu.getContainingDir() == null) {
            DesktopMenuHandler.log.warning(Messages.undefined_menu_containing_dir, new Object[]{menu.getName()});
            return false;
        }
        File dirGnome = new File(menu.getContainingDir(), GNOME_DEFAULT_MERGED_MENU_DIR);
        File fileNameGnome = this.createShortFileName(dirGnome, menu, FILE_MENU_EXT);
        if (fileNameGnome.delete()) {
            DesktopMenuHandler.log.debug(Messages.deleted_file, new Object[]{fileNameGnome.getAbsolutePath()});
        } else {
            DesktopMenuHandler.log.debug(Messages.cant_delete_file, new Object[]{fileNameGnome.getAbsolutePath()});
        }
        fileNameGnome = this.createFileName(dirGnome, menu, FILE_MENU_EXT);
        if (fileNameGnome.exists()) {
            if (fileNameGnome.delete()) {
                DesktopMenuHandler.log.debug(Messages.deleted_file, new Object[]{fileNameGnome.getAbsolutePath()});
            } else {
                DesktopMenuHandler.log.debug(Messages.cant_delete_file, new Object[]{fileNameGnome.getAbsolutePath()});
            }
        }
        if ((fileNameKde = this.createShortFileName(dirKDE = new File(menu.getContainingDir(), KDE_DEFAULT_MERGED_MENU_DIR), menu, FILE_MENU_EXT)).delete()) {
            DesktopMenuHandler.log.debug(Messages.deleted_file, new Object[]{fileNameKde.getAbsolutePath()});
        } else {
            DesktopMenuHandler.log.debug(Messages.cant_delete_file, new Object[]{fileNameKde.getAbsolutePath()});
        }
        fileNameKde = this.createFileName(dirKDE, menu, FILE_MENU_EXT);
        if (fileNameKde.exists()) {
            if (fileNameKde.delete()) {
                DesktopMenuHandler.log.debug(Messages.deleted_file, new Object[]{fileNameKde.getAbsolutePath()});
            } else {
                DesktopMenuHandler.log.debug(Messages.cant_delete_file, new Object[]{fileNameKde.getAbsolutePath()});
            }
        }
        return return_value;
    }

    @Override
    public boolean createDiskFiles(DesktopDirectory dir) throws CoreException {
        boolean return_value = true;
        Properties props = new Properties();
        props.setProperty(ENTRY_TYPE, "Directory");
        props.setProperty("Name", dir.getName());
        this.setProperty(props, ENTRY_ICON, dir.getIconPath());
        if (dir.getContainingDir() == null) {
            throw new CoreException((IStatus)Statuses.WARNING.get(Messages.undefined_directory_containing_dir, new Object[]{dir.getName()}));
        }
        if (!dir.getContainingDir().exists()) {
            dir.getContainingDir().mkdirs();
        }
        File fileName = this.createShortFileName(dir, FILE_DIR_EXT, dir.getHandler().isAgentProfile());
        return_value = this.createEntryOrDirFile(fileName, props, dir.getHandler().getWriter());
        return return_value;
    }

    @Override
    public boolean deleteDiskFiles(DesktopDirectory dir) {
        boolean return_value = true;
        if (dir.getContainingDir() == null) {
            DesktopMenuHandler.log.warning(Messages.undefined_directory_containing_dir, new Object[]{dir.getName()});
            return false;
        }
        File fileName = this.createShortFileName(dir, FILE_DIR_EXT, dir.getHandler().isAgentProfile());
        if (fileName.delete()) {
            DesktopMenuHandler.log.debug(Messages.deleted_file, new Object[]{fileName.getAbsolutePath()});
        } else {
            DesktopMenuHandler.log.debug(Messages.cant_delete_file, new Object[]{fileName.getAbsolutePath()});
        }
        fileName = this.createFileName(dir, FILE_DIR_EXT, dir.getHandler().isAgentProfile());
        if (fileName.exists()) {
            if (fileName.delete()) {
                DesktopMenuHandler.log.debug(Messages.deleted_file, new Object[]{fileName.getAbsolutePath()});
            } else {
                DesktopMenuHandler.log.debug(Messages.cant_delete_file, new Object[]{fileName.getAbsolutePath()});
            }
        }
        return return_value;
    }

    @Override
    public boolean createDiskFiles(DesktopEntry entry) throws CoreException {
        boolean return_value = true;
        if (entry.getContainingDir() == null) {
            throw new CoreException((IStatus)Statuses.WARNING.get(Messages.undefined_desktop_item_containing_dir, new Object[]{entry.getName()}));
        }
        if (!entry.getContainingDir().exists()) {
            entry.getContainingDir().mkdirs();
        }
        Properties props = new Properties();
        props.setProperty(ENTRY_TYPE, ENTRY_TYPE_APPLICATION);
        props.setProperty("Name", entry.getHandler().addPrefixtoNameForNonAdminAndGroup(entry.getName()));
        if (UnixSpecificDesktopMenuPolicy.notEmpty(entry.getArguments())) {
            props.setProperty(ENTRY_COMMAND, entry.getHandler().addGksudoForAdminOnUbuntu(String.valueOf(entry.getCommand()) + " " + entry.getArguments()));
        } else {
            props.setProperty(ENTRY_COMMAND, entry.getHandler().addGksudoForAdminOnUbuntu(entry.getCommand()));
        }
        this.setProperty(props, ENTRY_WORKING_DIRECTORY, entry.getWorkingDirectory());
        this.setProperty(props, ENTRY_ICON, entry.getIconPath());
        this.setProperty(props, ENTRY_DESCRIPTION, entry.getDescription());
        this.setProperty(props, ENTRY_CATEGORIES, entry.getCategories());
        if (!entry.getContainingDir().exists()) {
            entry.getContainingDir().mkdirs();
        }
        File fileName = this.createShortFileName(entry, FILE_ENTRY_EXT, entry.getHandler().isAgentProfile());
        return_value = this.createEntryOrDirFile(fileName, props, entry.getHandler().getWriter());
        return return_value;
    }

    @Override
    public boolean deleteDiskFiles(DesktopEntry entry) {
        boolean return_value = true;
        if (entry.getContainingDir() == null) {
            DesktopMenuHandler.log.warning(Messages.bind((String)Messages.undefined_desktop_item_containing_dir, (Object)entry.getName()));
            return false;
        }
        File fileName = this.createShortFileName(entry, FILE_ENTRY_EXT, entry.getHandler().isAgentProfile());
        if (fileName.delete()) {
            DesktopMenuHandler.log.debug(Messages.deleted_file, new Object[]{fileName.getAbsolutePath()});
        } else {
            DesktopMenuHandler.log.debug(Messages.cant_delete_file, new Object[]{fileName.getAbsolutePath()});
        }
        fileName = this.createFileName(entry, FILE_ENTRY_EXT, entry.getHandler().isAgentProfile());
        if (fileName.exists()) {
            if (fileName.delete()) {
                DesktopMenuHandler.log.debug(Messages.deleted_file, new Object[]{fileName.getAbsolutePath()});
            } else {
                DesktopMenuHandler.log.debug(Messages.cant_delete_file, new Object[]{fileName.getAbsolutePath()});
            }
        }
        return return_value;
    }

    void setProperty(Properties p, String key, String val) {
        if (UnixSpecificDesktopMenuPolicy.notEmpty(val)) {
            p.setProperty(key, val);
        }
    }

    boolean createXMLMenuFile(File menuFile, DesktopMenu menu) throws CoreException {
        try {
            FileOutputStream outStream = new FileOutputStream(menuFile);
            XMLWriter writer = new XMLWriter((OutputStream)outStream, false, new String[]{"<!DOCTYPE Menu PUBLIC \"-//freedesktop//DTD Menu 1.0//EN\"", "\"http://www.freedesktop.org/standards/menu-spec/menu-1.0.dtd\">"});
            this.emitXML(writer, menu, menu.getPreFolders().iterator());
            writer.flush();
            FileUtil.fdSync((FileDescriptor)outStream.getFD());
            writer.close();
        }
        catch (FileNotFoundException e) {
            throw new CoreException((IStatus)Statuses.WARNING.get(Messages.cant_create_file, new Object[]{menuFile.getAbsolutePath()}));
        }
        catch (UnsupportedEncodingException e) {
            throw new CoreException((IStatus)Statuses.WARNING.get(Messages.cant_create_file, new Object[]{menuFile.getAbsolutePath()}));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)Statuses.WARNING.get(Messages.cant_create_file, new Object[]{menuFile.getAbsolutePath()}));
        }
        return true;
    }

    boolean emitXML(XMLWriter writer, DesktopMenu menu, Iterator aI) {
        if (aI.hasNext()) {
            writer.start(MENU_XML_ELEMENT_MENU);
            writer.oneLineElement("Name", (String)aI.next(), false);
            if (!this.emitXML(writer, menu, aI)) {
                for (DesktopDirectory dir : menu.getContatinedDirectories()) {
                    this.emitXML(writer, dir);
                }
            }
            writer.end(MENU_XML_ELEMENT_MENU);
            return true;
        }
        return false;
    }

    void emitXML(XMLWriter writer, DesktopDirectory dir) {
        writer.start(MENU_XML_ELEMENT_MENU);
        writer.oneLineElement("Name", dir.getName(), false);
        writer.oneLineElement("Directory", this.createShortFileName(dir, FILE_DIR_EXT, dir.getHandler().isAgentProfile()).getName(), false);
        for (DesktopDirectory nestedDir : dir.getContatinedDirectories()) {
            this.emitXML(writer, nestedDir);
        }
        for (DesktopEntry nestedEntry : dir.getContatinedEntries()) {
            this.emitXML(writer, nestedEntry);
        }
        writer.end(MENU_XML_ELEMENT_MENU);
    }

    void emitXML(XMLWriter writer, DesktopEntry entry) {
        writer.start(MENU_XML_ELEMENT_INCLUDE);
        writer.oneLineElement(MENU_XML_ELEMENT_FILENAME, this.createShortFileName(entry, FILE_ENTRY_EXT, entry.getHandler().isAgentProfile()).getName(), false);
        writer.end(MENU_XML_ELEMENT_INCLUDE);
    }

    boolean createEntryOrDirFile(File desktopFile, Properties props, Writer outWriter) throws CoreException {
        boolean return_value = false;
        try {
            String[] keyArray;
            BufferedWriter writer = new BufferedWriter(Encodings.UTF8.writer(desktopFile));
            writer.write("[Desktop Entry]");
            writer.newLine();
            props.setProperty("Version", "1.0");
            props.setProperty("Encoding", "UTF-8");
            TreeSet<Object> keySet = new TreeSet<Object>(props.keySet());
            String[] stringArray = keyArray = keySet.toArray(new String[0]);
            int n = keyArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                String value = props.getProperty(key);
                writer.write(String.valueOf(key) + "=" + value);
                writer.newLine();
                ++n2;
            }
            writer.flush();
            writer.close();
            if (CicCommonSettings.getAccessRightsMode().isGroupMode()) {
                this.setFilePermission(desktopFile, "664", outWriter);
            } else {
                this.setFilePermission(desktopFile, "644", outWriter);
            }
            return_value = true;
            DesktopMenuHandler.log.debug(Messages.created_file, new Object[]{desktopFile.getAbsolutePath()});
        }
        catch (FileNotFoundException e) {
            throw new CoreException((IStatus)Statuses.WARNING.get(Messages.cant_create_file, new Object[]{desktopFile.getAbsolutePath()}));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)Statuses.WARNING.get(Messages.cant_create_file, new Object[]{desktopFile.getAbsolutePath()}));
        }
        return return_value;
    }

    public static boolean notEmpty(String s) {
        return s != null && s.trim().length() > 0;
    }

    private boolean setFilePermission(File file, String perm, Writer writer) {
        String canonicalPath;
        if (!file.exists()) {
            return false;
        }
        try {
            canonicalPath = file.getCanonicalPath();
        }
        catch (IOException e) {
            return false;
        }
        String[] cmds = this.getCmd(perm, false, new String[]{canonicalPath});
        if (cmds == null) {
            return false;
        }
        return this.exec(cmds, null, writer);
    }

    private String[] getCmd(String perm, boolean recursive, String[] fileList) {
        ArrayList<String> cmdList = new ArrayList<String>();
        if (new File("/bin/chmod").exists()) {
            cmdList.add("/bin/chmod");
        } else if (new File("/usr/bin/chmod").exists()) {
            cmdList.add("/usr/bin/chmod");
        } else {
            return null;
        }
        if (recursive) {
            cmdList.add("-R");
        }
        cmdList.add(perm);
        String[] stringArray = fileList;
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            cmdList.add(element);
            ++n2;
        }
        return cmdList.toArray(new String[0]);
    }

    private boolean exec(String[] args, File workingDirectory, Writer writer) {
        int status = PlatformUtils.runProcess((String[])args, null, (File)workingDirectory, (Writer)writer, (Writer)writer);
        return status == 0;
    }

    private String getPropertyOrEnvVar(String key) {
        String path = System.getProperty(key);
        if (path == null || path.length() == 0) {
            path = PlatformUtils.getEnvironmentVariable((String)key);
        }
        return path;
    }
}

