/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.nativeInstallAdapter.desktopMenu;

import com.ibm.cic.agent.core.nativeInstallAdapter.desktopMenu.AbstractDesktopElement;
import com.ibm.cic.agent.core.nativeInstallAdapter.desktopMenu.DesktopDirectory;
import com.ibm.cic.agent.core.nativeInstallAdapter.desktopMenu.DesktopMenuHandler;
import com.ibm.cic.common.commonNativeAdapterData.CommonDesktopEntyNativeData;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class DesktopMenu
extends AbstractDesktopElement {
    private final ArrayList m_desktopDirectories = new ArrayList();
    private final List m_preFolders = new ArrayList();
    private String m_folder;

    public List getContatinedDirectories() {
        return this.m_desktopDirectories;
    }

    public List getPreFolders() {
        return this.m_preFolders;
    }

    DesktopMenu(DesktopMenuHandler menuHandler, CommonDesktopEntyNativeData data) {
        super(menuHandler);
        this.setContainingDir(menuHandler.getPolicy().calculateContainingDir(null, this));
        int i = 0;
        String folder = this.getTrimmedSubstitutedValue(data.getFolder());
        if (folder.length() == 0) {
            folder = this.getTrimmedSubstitutedValue("${profileId}");
        } else {
            i = folder.indexOf(59);
        }
        if (i > 0) {
            String preFolder = folder.substring(0, i);
            this.m_folder = folder.substring(i + 1);
            StringTokenizer tok = new StringTokenizer(preFolder, "\\/");
            while (tok.hasMoreTokens()) {
                this.m_preFolders.add(tok.nextToken());
            }
        } else {
            this.m_folder = folder;
        }
        this.m_folder = this.getHandler().addPrefixtoNameForNonAdminAndGroup(this.m_folder);
        if (this.m_preFolders.isEmpty()) {
            this.m_preFolders.add("Applications");
        }
        this.setName((String)this.m_preFolders.get(0));
        this.addSubDirectories(data);
    }

    private IStatus addSubDirectories(CommonDesktopEntyNativeData data) {
        StringTokenizer tok = new StringTokenizer(this.m_folder, "\\/");
        String subName = tok.hasMoreTokens() ? tok.nextToken() : "";
        DesktopDirectory dir = this.findDesktopDirectory(subName);
        if (dir != null) {
            dir.setToDeleted(false);
        } else {
            dir = new DesktopDirectory(this, data, subName, tok);
            this.m_desktopDirectories.add(dir);
        }
        return Status.OK_STATUS;
    }

    DesktopDirectory findDesktopDirectory(String name) {
        DesktopDirectory return_value = null;
        Iterator I = this.m_desktopDirectories.iterator();
        while (I.hasNext() && return_value == null) {
            DesktopDirectory dir = (DesktopDirectory)I.next();
            if (!name.equals(dir.getName())) continue;
            return_value = dir;
        }
        return return_value;
    }

    private void waitForTheSystemToReact() {
        try {
            if (CicCommonSettings.isUbuntu()) {
                Thread.sleep(900L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public boolean writeToDisk() throws CoreException {
        boolean return_value = true;
        if (!this.isToBeDeleted()) {
            return_value = this.getHandler().getPolicy().createDiskFiles(this);
            this.waitForTheSystemToReact();
            if (return_value) {
                Iterator I = this.m_desktopDirectories.iterator();
                while (I.hasNext() && return_value) {
                    DesktopDirectory dir = (DesktopDirectory)I.next();
                    return_value = dir.writeToDisk();
                    this.waitForTheSystemToReact();
                }
            }
        } else {
            Iterator I = this.m_desktopDirectories.iterator();
            while (I.hasNext() && return_value) {
                DesktopDirectory dir = (DesktopDirectory)I.next();
                return_value = dir.writeToDisk();
            }
            if (return_value) {
                return_value = this.getHandler().getPolicy().deleteDiskFiles(this);
            }
        }
        return return_value;
    }

    @Override
    public void remove() {
        for (DesktopDirectory dir : this.m_desktopDirectories) {
            dir.remove();
        }
        super.remove();
    }

    @Override
    public String toString() {
        return "MENU Category : " + this.getName() + "\nContains  dirs: " + this.m_desktopDirectories.size() + "\n" + super.toString();
    }
}

