/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.model.validation.fast.basic;

import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.IArtifactSessionFactory;
import com.ibm.cic.common.core.artifactrepo.IReadArtifactRepo;
import com.ibm.cic.common.core.artifactrepo.impl.RepoAs;
import com.ibm.cic.common.core.model.IAssembly;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.IShareableEntity;
import com.ibm.cic.common.core.model.IncludedShareableEntity;
import com.ibm.cic.common.core.model.adapterdata.IAdapterData;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.utils.SelectorContext;
import com.ibm.cic.common.core.model.utils.SelectorExpanderRememberDuplicates;
import com.ibm.cic.common.core.model.validation.IValidator;
import com.ibm.cic.common.core.model.validation.InconsistentIUValidation;
import com.ibm.cic.common.core.model.validation.ValidationUtil;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.core.repository.StatusCodes;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.model.validation.fast.basic.Messages;
import com.ibm.cic.common.model.validation.fast.internal.util.StatusModelValidationUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ReferenceValidator
implements IValidator {
    protected IRepositoryGroup repoSvc;

    public String getDisplayName() {
        return Messages.ReferenceValidator_DisplayName;
    }

    public IStatus validate(IContent content, IRepositoryGroup repositoryGroup, IProgressMonitor progressMonitor) {
        this.repoSvc = repositoryGroup;
        CicMultiStatus mainStatus = Statuses.ST.createMultiStatus(this.getDisplayName(), new Object[0]);
        IShareableEntity mainSE = this.getShareableEntity(content, progressMonitor);
        if (mainSE != null) {
            ValidatingSelectorExpander expander = this.expand(content, mainSE, mainStatus, progressMonitor);
            if (expander != null) {
                mainStatus.add(expander.getExpansionStatus());
                this.reportInconsistentIus(expander, mainStatus, progressMonitor);
                this.reportInvalidArtifacts(expander, mainStatus, progressMonitor);
                if (!(content instanceof IFix)) {
                    this.resolveArtifacts(expander, mainStatus, progressMonitor);
                }
                this.reportUnreachableUnits(content, expander, mainStatus, progressMonitor);
            }
        } else if (content instanceof IOffering) {
            this.assemblyNotFound((IOffering)content, mainStatus);
        }
        return mainStatus;
    }

    protected IShareableEntity getShareableEntity(IContent content, IProgressMonitor progress) {
        if (content instanceof IOfferingOrFix) {
            return this.findAssembly((IOfferingOrFix)content, progress);
        }
        if (content instanceof IShareableEntity) {
            return (IShareableEntity)content;
        }
        return null;
    }

    private ValidatingSelectorExpander expand(IContent root, IShareableEntity mainSE, CicMultiStatus mainStatus, IProgressMonitor progress) {
        try {
            IOfferingOrFix oof = null;
            if (root instanceof IOfferingOrFix) {
                oof = (IOfferingOrFix)root;
            }
            ValidatingSelectorExpander expander = this.createValidatingSelectorExpander(oof, mainSE, mainStatus);
            SelectorContext context = new SelectorContext(mainSE, mainSE.getSelectors(), null, true);
            expander.expand(context, progress);
            return expander;
        }
        catch (Exception e) {
            ReferenceValidator.caughtException(e, mainStatus);
            return null;
        }
    }

    private void reportInconsistentIus(ValidatingSelectorExpander expander, CicMultiStatus mainStatus, IProgressMonitor progress) {
        try {
            InconsistentIUValidation check = new InconsistentIUValidation(mainStatus, progress);
            check.checkInconsistentIUs(expander.getOfferingIUs());
            check.checkInconsistentIUs(expander.getDuplicateIUs());
            check.checkInconsistentIUs(expander.getSelectedIUs());
            return;
        }
        catch (Exception e) {
            ReferenceValidator.caughtException(e, mainStatus);
            return;
        }
    }

    protected void reportInvalidArtifacts(ValidatingSelectorExpander expander, CicMultiStatus mainStatus, IProgressMonitor progress) {
        progress.beginTask("", 1);
        progress.done();
    }

    private void resolveArtifacts(ValidatingSelectorExpander expander, CicMultiStatus mainStatus, IProgressMonitor progress) {
        try {
            ArtifactResolver artifactLocator = new ArtifactResolver(this.repoSvc, mainStatus, progress);
            artifactLocator.resolveArtifacts(expander.getOfferingIUs());
            artifactLocator.resolveArtifacts(expander.getSelectedIUs());
        }
        catch (Exception e) {
            ReferenceValidator.caughtException(e, mainStatus);
        }
    }

    private void reportUnreachableUnits(IContent owningContent, ValidatingSelectorExpander expander, CicMultiStatus mainStatus, IProgressMonitor progress) {
        try {
            int rule = 3;
            if (ValidationUtil.isRuleSuppressed((int)3)) {
                return;
            }
            for (IContent unreachable : expander.getIgnoredUnits()) {
                String msg = ValidationUtil.formatMessage((String)Messages.ReferenceValidator_UnitIsNotSelectedByAnySelector, (Object)unreachable.getName(), (Object)unreachable.getVersion());
                ICicLocation loc = owningContent.getLocation();
                if (loc != null) {
                    URL url = loc.toURL();
                    StringBuffer buf = new StringBuffer();
                    buf.append(msg);
                    buf.append(' ');
                    buf.append(url.toExternalForm());
                    buf.append(' ');
                    msg = buf.toString();
                }
                mainStatus.add((IStatus)Statuses.WARNING.get(3, ValidationUtil.appendLineAndLocationToMessage((String)msg, (Object)unreachable), new Object[0]));
            }
        }
        catch (Exception e) {
            ReferenceValidator.caughtException(e, mainStatus);
        }
    }

    private void assemblyNotFound(IOffering offering, CicMultiStatus multiStatus) {
        boolean rule = true;
        if (ValidationUtil.isRuleSuppressed((int)1)) {
            return;
        }
        multiStatus.add(StatusModelValidationUtils.newFailedStatus(ValidationUtil.formatMessage((String)Messages.ReferenceValidator_FailedToLocateAsm, (Object)offering.getName(), (Object)offering.getAssemblyId(), (Object)offering.getAssemblyVersion()), 1));
    }

    private static void caughtException(Exception e, CicMultiStatus mainStatus) {
        e.printStackTrace();
        mainStatus.add((IStatus)Statuses.ERROR.get(-1, (Throwable)e, ValidationUtil.error((String)(String.valueOf(e.getClass().getName()) + ": " + e.getLocalizedMessage()), (int)0), new Object[0]));
    }

    protected ValidatingSelectorExpander createValidatingSelectorExpander(IOfferingOrFix oofRoot, IShareableEntity mainSE, CicMultiStatus mainStatus) {
        return new ValidatingSelectorExpander(oofRoot, mainSE, mainStatus);
    }

    protected IAssembly findAssembly(IOfferingOrFix offeringOrFix, IProgressMonitor progress) {
        IAssembly asm = offeringOrFix.getAssembly();
        if (asm == null) {
            Logger.getGlobalLogger().statusNotOK(RepositoryUtils.resolve((IOfferingOrFix)offeringOrFix, (IProgressMonitor)progress));
            asm = offeringOrFix.getAssembly();
        }
        return asm;
    }

    protected static class ArtifactResolver {
        private final IRepositoryGroup repositoryGroup;
        protected IProgressMonitor progressMonitor;
        private final CicMultiStatus multiStatus;
        private IArtifactSession session;
        private static final int RULE = 2;

        protected ArtifactResolver(IRepositoryGroup repositoryGroup, CicMultiStatus mainStatus, IProgressMonitor progress) {
            this.repositoryGroup = repositoryGroup;
            this.progressMonitor = progress;
            this.multiStatus = mainStatus;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void resolveArtifacts(Collection ius) {
            this.session = null;
            if (ValidationUtil.isRuleSuppressed((int)2)) {
                return;
            }
            try {
                try {
                    this.session = IArtifactSessionFactory.INSTANCE.createArtifactSession();
                    Iterator it = ius.iterator();
                    while (it.hasNext()) {
                        this.resolveArtifact((IInstallableUnit)it.next());
                    }
                    return;
                }
                catch (Exception e) {
                    ReferenceValidator.caughtException(e, this.multiStatus);
                    if (this.session == null) return;
                    this.session.close();
                    this.session = null;
                    return;
                }
                catch (AssertionError ae) {
                    this.multiStatus.add(StatusModelValidationUtils.newFailedStatus("Assertion Error: " + ((Throwable)((Object)ae)).getLocalizedMessage(), 0));
                    if (this.session == null) return;
                    this.session.close();
                    this.session = null;
                    return;
                }
            }
            finally {
                if (this.session != null) {
                    this.session.close();
                    this.session = null;
                }
            }
        }

        protected void resolveArtifact(IInstallableUnit iu) {
            if (this.progressMonitor.isCanceled()) {
                return;
            }
            try {
                IRepository readRep = iu.getRepository();
                IAdapterData data = iu.getAdapterData();
                if (data == null) {
                    return;
                }
                Collection artifacts = data.getArtifacts();
                if (artifacts == null || artifacts.isEmpty()) {
                    return;
                }
                this.progressMonitor.subTask(ValidationUtil.formatMessage((String)Messages.ReferenceValidator_ResolvingArtifacts, (Object)iu.getName()));
                for (IArtifact artifact : artifacts) {
                    IStatus status = Status.OK_STATUS;
                    if (readRep != null) {
                        status = RepoAs.IArtifactGet((IReadArtifactRepo)readRep).existsArtifact(this.session, artifact, this.progressMonitor);
                    }
                    if (readRep == null || this.artifactNotFound(status)) {
                        status = RepoAs.IArtifactGet((IReadArtifactRepo)this.repositoryGroup).existsArtifact(this.session, artifact, this.progressMonitor);
                    }
                    if (!this.artifactNotFound(status)) continue;
                    String msg = ValidationUtil.formatMessage((String)Messages.ReferenceValidator_MissingArtifact, (Object)artifact.toUserString(), (Object)iu.getName());
                    msg = ValidationUtil.appendLineAndLocationToMessage((String)msg, (Object)this.kludgeUpArtifactLineNumber(iu, artifacts.size()));
                    this.multiStatus.add((IStatus)Statuses.WARNING.get(2, msg, new Object[0]));
                }
            }
            catch (Exception e) {
                ReferenceValidator.caughtException(e, this.multiStatus);
            }
        }

        private boolean artifactNotFound(IStatus status) {
            return StatusCodes.isContentNotFound((IStatus)status) || !status.isOK();
        }

        private Integer kludgeUpArtifactLineNumber(IInstallableUnit iu, int artifactCount) {
            int line = iu.getLineNumber();
            if (artifactCount == 1) {
                line += 2;
            }
            return line;
        }
    }

    protected static class ValidatingSelectorExpander
    extends SelectorExpanderRememberDuplicates {
        private final CicMultiStatus multiStatus;
        private final IOfferingOrFix oofRoot;
        private final Collection offeringIUs;

        protected ValidatingSelectorExpander(IOfferingOrFix oofRoot, IShareableEntity se, CicMultiStatus rootStatus) {
            super(se, se.getSelectors());
            this.oofRoot = oofRoot;
            this.multiStatus = rootStatus;
            if (oofRoot instanceof IOffering) {
                IOffering offering = (IOffering)oofRoot;
                this.offeringIUs = new ArrayList(offering.getChildren().size());
                for (Object o : offering.getChildren()) {
                    if (!(o instanceof IInstallableUnit)) continue;
                    IInstallableUnit iu = (IInstallableUnit)o;
                    this.offeringIUs.add(iu);
                }
            } else {
                this.offeringIUs = Collections.EMPTY_LIST;
            }
        }

        public Collection getOfferingIUs() {
            return this.offeringIUs;
        }

        private void ensureVersionWithinTolerance(IncludedShareableEntity ise) {
            int rule = 4;
            if (ValidationUtil.isRuleSuppressed((int)4)) {
                return;
            }
            if (!ise.getTolerance().isIncluded(ise.getVersion())) {
                String msg = ValidationUtil.formatMessage((String)Messages.ReferenceValidator_VerOutsideToleranceInISE, (Object)ise.getVersion(), (Object)ise.getTolerance(), (Object)ise);
                msg = ValidationUtil.appendLineAndLocationToMessage((String)msg, (Object)ise);
                this.multiStatus.add(StatusModelValidationUtils.newFailedStatus(msg, 4));
            }
        }

        protected boolean isValid(IShareableEntity child, IShareableEntity parent, IncludedShareableEntity ise) {
            this.ensureVersionWithinTolerance(ise);
            boolean rule = true;
            if (ValidationUtil.isRuleSuppressed((int)1)) {
                return child != null;
            }
            if (this.oofRoot instanceof IFix) {
                return true;
            }
            if (child == null) {
                String msg = ValidationUtil.formatMessage((String)Messages.ReferenceValidator_UnresolvedInclude, (Object)parent.getName(), (Object)ise.getIdentity(), (Object)ise.getVersion());
                msg = ValidationUtil.appendLineAndLocationToMessage((String)msg, (Object)ise);
                this.multiStatus.add(StatusModelValidationUtils.newFailedStatus(msg, 1));
                return false;
            }
            return true;
        }
    }
}

