/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.commonNativeAdapterData;

import com.ibm.cic.common.core.model.Phases;
import com.ibm.icu.util.StringTokenizer;

public class CommonNativeAdapterUtils {
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int SECONDS_PER_HOUR = 3600;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int parseTime(String timeStr) {
        String[] timeparts = timeStr.split(":", -1);
        if (timeparts.length < 2 || timeparts.length > 3) {
            return -1;
        }
        try {
            int result = 0;
            int i = 0;
            while (true) {
                if (i >= timeparts.length) {
                    return result;
                }
                String timepart = timeparts[i];
                int len = timepart.length();
                if (i != 0 ? len != 2 : len < 1 || len > 2) {
                    return -1;
                }
                if (timepart.charAt(0) == '-') {
                    return -1;
                }
                int time = Integer.parseInt(timepart);
                result = result * 60 + time;
                ++i;
            }
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static String toTimeString(int time) {
        StringBuffer sb = new StringBuffer();
        int hour = time / 3600;
        int remainder = time % 3600;
        int min = remainder / 60;
        int sec = remainder % 60;
        if (hour != 0) {
            sb.append(hour).append(':').append(CommonNativeAdapterUtils.dd(min));
        } else {
            sb.append(min);
        }
        sb.append(':').append(CommonNativeAdapterUtils.dd(sec));
        return sb.toString();
    }

    private static String dd(int i) {
        String s = String.valueOf(i);
        return i < 10 ? String.valueOf('0') + s : s;
    }

    public static long parsePhases(String phasesStr) {
        long phases = 0L;
        StringTokenizer st = new StringTokenizer(phasesStr, " \t,");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int phase = Phases.nameToPhase((String)token);
            if (phase == -1) {
                return -1L;
            }
            phases |= 1L << phase;
        }
        return phases;
    }
}

