/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.manager;

import com.ibm.cic.agent.core.Profile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ProfileListManager {
    private boolean m_onlyOneSelectedProfileAllowed = false;
    private final List<Profile> m_selectedProfiles = new ArrayList<Profile>();
    private final List<Profile> m_modificationList = new ArrayList<Profile>();

    public ProfileListManager(boolean a_onlyOneSelectedProfileAllowed) {
        this.m_onlyOneSelectedProfileAllowed = a_onlyOneSelectedProfileAllowed;
    }

    public ProfileListManager() {
        this(false);
    }

    private void registerProfile(Profile a_profile) {
        if (this.m_modificationList.contains(a_profile)) {
            this.m_modificationList.remove(a_profile);
        } else {
            this.m_modificationList.add(a_profile);
        }
    }

    public Profile getSingleSelectedProfile() {
        if (this.m_selectedProfiles.size() == 1) {
            return this.m_selectedProfiles.get(0);
        }
        return null;
    }

    public void resetChanged() {
        this.m_modificationList.clear();
    }

    public boolean isChanged() {
        return !this.m_modificationList.isEmpty();
    }

    public int size() {
        return this.m_selectedProfiles.size();
    }

    public Profile get(int index) {
        return this.m_selectedProfiles.get(index);
    }

    public boolean containsProfiles() {
        return !this.m_selectedProfiles.isEmpty();
    }

    public boolean contains(Profile a_profile) {
        return this.m_selectedProfiles.contains(a_profile);
    }

    public void selectProfile(Profile a_profile) {
        if (!this.m_selectedProfiles.contains(a_profile)) {
            if (this.m_onlyOneSelectedProfileAllowed && !this.m_selectedProfiles.isEmpty()) {
                this.removeAll();
            }
            if (this.m_selectedProfiles.add(a_profile)) {
                this.registerProfile(a_profile);
            }
        }
    }

    public boolean remove(Profile a_profile) {
        boolean return_value = this.m_selectedProfiles.remove(a_profile);
        if (return_value) {
            this.registerProfile(a_profile);
        }
        return return_value;
    }

    public void removeAll() {
        Profile[] allProfiles;
        Profile[] profileArray = allProfiles = this.toArray();
        int n = allProfiles.length;
        int n2 = 0;
        while (n2 < n) {
            Profile profile = profileArray[n2];
            this.remove(profile);
            ++n2;
        }
    }

    public void clear() {
        this.m_selectedProfiles.clear();
        this.resetChanged();
    }

    public Profile[] toArray() {
        return this.m_selectedProfiles.toArray(new Profile[this.m_selectedProfiles.size()]);
    }

    public List<Profile> toList() {
        return Collections.unmodifiableList(this.m_selectedProfiles);
    }

    public Set<Profile> toSet() {
        HashSet<Profile> return_value = new HashSet<Profile>();
        return_value.addAll(this.m_selectedProfiles);
        return return_value;
    }

    public void flipProfileSelection(Profile a_profile) {
        if (this.contains(a_profile)) {
            if (this.remove(a_profile) && this.m_onlyOneSelectedProfileAllowed && !this.m_selectedProfiles.isEmpty()) {
                this.removeAll();
            }
        } else {
            this.selectProfile(a_profile);
        }
    }
}

