/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.lictext;

import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.lictext.LicenseElement;
import com.macrovision.flexlm.lictext.LineType;
import com.macrovision.flexlm.misc.FlexlmInternalConstants;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class TokenizedLine
implements FlexlmConstants,
FlexlmInternalConstants {
    private String filename;
    private String lineText = "";
    private String rawLineText = null;
    private LineType lineTypeInstance;
    private int lineNumber;
    protected int type;
    private LineNumberReader reader;
    private Vector tokens;
    private Vector positionalParameters;
    private Hashtable keywordParameters;
    private static final String LINE_SEP = System.getProperty("line.separator");

    protected TokenizedLine(LineNumberReader lineNumberReader, String string) {
        this.lineNumber = lineNumberReader.getLineNumber();
        this.filename = string;
        this.reader = lineNumberReader;
    }

    protected void doNextLine(LineType lineType) throws IOException {
        this.lineTypeInstance = lineType;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        while (true) {
            boolean bl2;
            if (bl) {
                this.reader.mark(10000);
            }
            String string = this.reader.readLine();
            String string2 = new String(string + LINE_SEP);
            if (string == null) {
                this.lineText = null;
                this.rawLineText = null;
                break;
            }
            int n = this.lineTypeInstance.getLineType(string);
            boolean bl3 = bl2 = n == 0;
            if (bl && !bl2) {
                this.reader.reset();
                break;
            }
            if (bl && string.trim().length() == 0) {
                this.reader.reset();
                break;
            }
            if (!bl && bl2) {
                this.type = n;
                stringBuffer.append(string);
                stringBuffer2.append(string2);
                break;
            }
            if (n == 8) {
                this.type = n;
                stringBuffer.append(string);
                stringBuffer2.append(string2);
                break;
            }
            if (!bl && !bl2) {
                this.type = n;
                bl = true;
            }
            if ((string = string.trim()).endsWith("\\")) {
                string = string.substring(0, string.length() - 1).trim();
            }
            stringBuffer.append(" " + string);
            stringBuffer2.append(string2);
        }
        if (stringBuffer.length() > 0) {
            this.lineText = new String(stringBuffer).trim();
            if (this.type != 8 && this.type != 0) {
                this.tokens = TokenizedLine.tokenizeLine(this.lineText);
            }
        }
        if (stringBuffer2.length() > 0) {
            this.rawLineText = new String(stringBuffer2);
        }
    }

    protected String getLineText() {
        return this.lineText;
    }

    protected String getRawLineText() {
        return this.rawLineText;
    }

    protected int getLineNumber() {
        return this.lineNumber;
    }

    protected Vector getTokens() {
        return this.tokens;
    }

    protected int getType() {
        return this.type;
    }

    protected String getFilename() {
        return this.filename;
    }

    protected boolean hasContent() {
        return this.lineText != null;
    }

    protected Vector getPositionalParameters() {
        return this.positionalParameters;
    }

    protected Hashtable getKeywordParameters() {
        return this.keywordParameters;
    }

    protected void findPositionalsAndKeywordValues(String[] stringArray) {
        int n = this.nextKeywordPosition(stringArray, 0);
        if (n == -1) {
            this.setPositionalParameters(0, this.tokens != null ? this.tokens.size() : 0);
        } else {
            this.setPositionalParameters(0, n);
            this.keywordParameters = new Hashtable();
            int n2 = n;
            do {
                String string;
                if ((string = this.tokenAfter(n2)) == null) {
                    this.keywordParameters.put(this.tokens.elementAt(n2), "");
                    break;
                }
                if (string.equals("=")) {
                    String string2 = this.tokenAfter(n2 + 1);
                    if (string2 == null) {
                        throw new RuntimeException("bad tokens:\n" + this.toString());
                    }
                    this.keywordParameters.put(this.tokens.elementAt(n2), LicenseElement.normalizeWhitespace(string2, true));
                    continue;
                }
                this.keywordParameters.put(this.tokens.elementAt(n2), "");
            } while ((n2 = this.nextKeywordPosition(stringArray, n2 + 1)) != -1);
        }
    }

    private static Vector tokenizeLine(String string) {
        Vector<String> vector = new Vector<String>();
        String string2 = " \"\t\r\n\f";
        String string3 = "\"\\";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        int n = -2;
        int n2 = -1;
        while (stringTokenizer.hasMoreTokens()) {
            CharSequence charSequence;
            int n3;
            ++n2;
            String string4 = stringTokenizer.nextToken(string2);
            if (!TokenizedLine.isDelimiter(string4, string2)) {
                int n4 = string4.indexOf(61);
                n3 = string4.indexOf(123);
                if (n4 > 0) {
                    vector.add(string4.substring(0, n4));
                    vector.add("=");
                    if (n3 == n4 + 1) {
                        charSequence = new StringBuffer("{");
                        boolean bl = false;
                        while (stringTokenizer.hasMoreTokens() && !bl) {
                            string4 = stringTokenizer.nextToken(string2);
                            ((StringBuffer)charSequence).append(string4);
                            if (string4.indexOf(125) <= -1) continue;
                            bl = true;
                        }
                        vector.add(((StringBuffer)charSequence).toString());
                    } else {
                        vector.add(string4.substring(n4 + 1));
                    }
                    n = n2;
                    continue;
                }
                vector.add(string4);
                continue;
            }
            if (!string4.equals("\"")) continue;
            if (n2 == n + 1 && ((String)vector.elementAt(vector.size() - 1)).equals("")) {
                vector.removeElementAt(vector.size() - 1);
            }
            StringBuffer stringBuffer = new StringBuffer();
            n3 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken(string3);
                if (!TokenizedLine.isDelimiter(string4, string3)) {
                    stringBuffer.append(string4);
                    continue;
                }
                if (string4.equals("\\")) {
                    charSequence = stringTokenizer.nextToken(string3);
                    if (((String)charSequence).equals("\"")) {
                        stringBuffer.append((String)charSequence);
                        continue;
                    }
                    stringBuffer.append(string4);
                    stringBuffer.append((String)charSequence);
                    continue;
                }
                vector.add(new String(stringBuffer));
                n3 = 1;
                break;
            }
            if (n3 != 0) continue;
            vector.add(new String(stringBuffer));
        }
        return vector;
    }

    private static boolean isDelimiter(String string, String string2) {
        return string2.indexOf(string) != -1;
    }

    private String tokenAfter(int n) {
        if (n + 1 >= this.tokens.size()) {
            return null;
        }
        return (String)this.tokens.elementAt(n + 1);
    }

    private int nextKeywordPosition(String[] stringArray, int n) {
        if (stringArray != null && n < this.tokens.size() - 1) {
            for (int i = n; i < this.tokens.size(); ++i) {
                for (int j = 0; j < stringArray.length; ++j) {
                    if (!((String)this.tokens.elementAt(i)).equalsIgnoreCase(stringArray[j])) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    private void setPositionalParameters(int n, int n2) {
        this.positionalParameters = new Vector();
        int n3 = n;
        while (n3 < n2) {
            String string;
            String string2 = (String)this.tokens.elementAt(n3);
            if (this.tokens.size() > n3 + 1) {
                String string3 = (String)this.tokens.elementAt(n3 + 1);
                if (string3.equals("=") && this.tokens.size() > n3 + 2) {
                    string = string2 + "=" + (String)this.tokens.elementAt(n3 + 2);
                    n3 += 3;
                } else {
                    string = string2;
                    ++n3;
                }
            } else {
                string = string2;
                ++n3;
            }
            string = LicenseElement.normalizeWhitespace(string, true);
            this.positionalParameters.add(string);
        }
    }

    public String toString() {
        return "LicenseLine{\nline=" + this.getLineText() + "\n" + "tokens=" + this.tokenString() + "\n" + "lineNumber=" + this.getLineNumber() + "\n" + "filename=" + (this.filename == null ? "null" : this.filename) + "\n" + "type=" + this.lineTypeInstance.typeString() + "\n" + "positionalParameters=" + this.positionalParametersString() + "\n" + "keywordParameters=" + this.keywordParametersString() + "\n}";
    }

    private String keywordParametersString() {
        if (this.keywordParameters == null) {
            return "none";
        }
        return this.keywordParameters.toString();
    }

    private String dumpStringVector(Vector vector) {
        if (vector == null || vector.size() == 0) {
            return "none";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < vector.size(); ++i) {
            stringBuffer.append("  " + (String)vector.elementAt(i) + "\n");
        }
        return new String(stringBuffer);
    }

    private String positionalParametersString() {
        if (this.positionalParameters == null) {
            return "none";
        }
        return this.dumpStringVector(this.positionalParameters);
    }

    private String tokenString() {
        return this.dumpStringVector(this.tokens);
    }
}

