/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.lictext;

import com.macrovision.flexlm.Feature;
import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.LicenseSource;
import com.macrovision.flexlm.VendorInfo;
import com.macrovision.flexlm.lictext.FlexlmDate;
import com.macrovision.flexlm.lictext.LicenseCertificate;
import com.macrovision.flexlm.lictext.LicenseElement;
import com.macrovision.flexlm.lictext.PackageLine;
import com.macrovision.flexlm.lictext.TokenizedLicenseLine;
import com.macrovision.flexlm.lictext.UpgradeLine;
import com.macrovision.flexlm.misc.FlexlmInternalConstants;
import java.util.ArrayList;

public class FeatureLine
extends LicenseElement
implements FlexlmConstants,
FlexlmInternalConstants,
Comparable {
    String[] keywords = new String[]{"SIGN", "SIGN2", "HOSTID", "VENDOR_STRING", "NOTICE", "SN", "ISSUER", "START", "ISSUED", "DUP_GROUP", "SUITE_DUP_GROUP", "SUPERSEDE", "HOST_BASED", "USER_BASED", "TS_OK", "BORROW", "CAPACITY", "FLOAT_OK", "MINIMUM", "OVERDRAFT", "PLATFORMS", "asset_info", "dist_info", "user_info", "sort", "vendor_info", "ck", "AUTH", "w_binary", "w_queue", "w_argv", "w_term_signal", "W_LIC_LOSS", "ONE_TS_OK"};

    public FeatureLine(TokenizedLicenseLine tokenizedLicenseLine, LicenseCertificate licenseCertificate, VendorInfo vendorInfo) throws FlexlmException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(0, "Keyword");
        arrayList.add(1, "Name");
        arrayList.add(2, "Vendor");
        arrayList.add(3, "Version");
        arrayList.add(4, "Expiration");
        arrayList.add(5, "Count");
        int n = 6;
        arrayList.add(6, "Code");
        arrayList.add(7, "VENDOR_STRING");
        arrayList.add(8, "HOSTID");
        this.assignTokensToFields(tokenizedLicenseLine, licenseCertificate, vendorInfo, n, arrayList, this.keywords);
        this.isDirty = false;
    }

    FeatureLine cloner() throws FlexlmException {
        return new FeatureLine(this.licenseLine, this.certificate, this.vInfo);
    }

    public FeatureLine() {
    }

    public boolean isAuthentic() {
        return this.authentic;
    }

    public void authenticate() throws FlexlmException {
        this.doAuthenticate();
    }

    public int compareTo(Object object) {
        FeatureLine featureLine = (FeatureLine)object;
        int n = this.getName().compareTo(featureLine.getName());
        if (n == 0) {
            int n2;
            int n3;
            int n4;
            int n5;
            n = this.isAnIncrement() && featureLine.isAFeature() ? -1 : (this.isAFeature() && featureLine.isAnIncrement() ? 1 : 0);
            if (n == 0) {
                n = this.getIntCount() == 0 && featureLine.getIntCount() != 0 ? -1 : (this.getIntCount() != 0 && featureLine.getIntCount() == 0 ? 1 : 0);
            }
            if (n == 0 && (n = (n5 = this.getVersionObject().getWhole()) < (n4 = featureLine.getVersionObject().getWhole()) ? -1 : (n5 > n4 ? 1 : ((n3 = this.getVersionObject().getFraction()) < (n2 = featureLine.getVersionObject().getFraction()) ? -1 : (n3 > n2 ? 1 : 0)))) == 0) {
                FlexlmDate flexlmDate = this.getIssuedDateObject();
                FlexlmDate flexlmDate2 = featureLine.getIssuedDateObject();
                n = flexlmDate == null && flexlmDate2 == null ? 0 : (flexlmDate == null && flexlmDate2 != null ? 1 : (flexlmDate != null && flexlmDate2 == null ? -1 : (flexlmDate2.after(flexlmDate) ? 1 : (flexlmDate.after(flexlmDate2) ? -1 : 0))));
            }
        }
        return n;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        LicenseElement licenseElement = (LicenseElement)object;
        if ((licenseElement instanceof FeatureLine || licenseElement instanceof PackageLine || licenseElement instanceof UpgradeLine) && this.cryptEquals(licenseElement)) {
            if (this.version != null && licenseElement.version != null) {
                if (this.version.compareTo(licenseElement.version) == 0) {
                    bl = true;
                }
            } else if (this.version == null && licenseElement.version == null) {
                bl = true;
            }
        }
        return bl;
    }

    public Feature createFeature(LicenseSource licenseSource) {
        Feature feature = new Feature(licenseSource);
        feature.name = this.name;
        feature.vendor = this.vendor;
        feature.fromVersion = this.fromVersion;
        feature.version = this.version;
        feature.code = this.code;
        feature.signature1 = this.signature1;
        feature.signature2 = this.signature2;
        feature.expirationDate = this.expirationDate;
        feature.count = this.count;
        feature.hostid = this.hostid;
        feature.isFeature = this.isFeature;
        feature.vendorString = this.vendorString;
        feature.notice = this.notice;
        feature.serial = this.serial;
        feature.issuer = this.issuer;
        feature.startDate = this.startDate;
        feature.issuedDate = this.issuedDate;
        feature.dupGroup = this.dupGroup;
        feature.suiteDupGroup = this.suiteDupGroup;
        feature.supersedePresent = this.supersedePresent;
        feature.namesSuperseded = this.namesSuperseded;
        feature.hostBasedPresent = this.hostBasedPresent;
        feature.userBasedPresent = this.userBasedPresent;
        feature.hostBased = this.hostBased;
        feature.userBased = this.userBased;
        feature.terminalServerOK = this.terminalServerOK;
        feature.oneTerminalServerOK = this.oneTerminalServerOK;
        feature.borrowPresent = this.borrowPresent;
        feature.borrow = this.borrow;
        feature.capacity = this.capacity;
        feature.floatOKPresent = this.floatOKPresent;
        feature.floatOKHostid = this.floatOKHostid;
        feature.minimum = this.minimum;
        feature.overdraft = this.overdraft;
        feature.platforms = this.platforms;
        feature.assetInfo = this.assetInfo;
        feature.distInfo = this.distInfo;
        feature.userInfo = this.userInfo;
        feature.vendorInfo = this.vendorInfo;
        feature.checksum = this.checksum;
        feature.sort = this.sort;
        return feature;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isAFeature()) {
            stringBuffer.append("FEATURE ");
        } else {
            stringBuffer.append("INCREMENT ");
        }
        stringBuffer.append(this.getName() + " ");
        stringBuffer.append(this.getVendorName() + " ");
        return new String(stringBuffer) + this.toCommonString();
    }

    String toCommonString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getVersion() + " ");
        stringBuffer.append(this.getExpirationDate() + " ");
        stringBuffer.append(this.getCount() + " ");
        if (this.code != null) {
            stringBuffer.append(this.getCode() + " ");
        }
        if (this.vendorString != null) {
            stringBuffer.append("VENDOR_STRING=\"" + this.vendorString + "\" ");
        }
        if (this.hostid != null) {
            stringBuffer.append("HOSTID=" + this.hostid.toString() + " ");
        }
        if (this.overdraft != 0) {
            stringBuffer.append("OVERDRAFT=" + this.overdraft + " ");
        }
        if (this.capacity) {
            stringBuffer.append("CAPACITY ");
        }
        if (this.hostBasedPresent) {
            stringBuffer.append("HOST_BASED" + (this.hostBased != this.count ? "=" + this.hostBased : "") + " ");
        }
        if (this.userBasedPresent) {
            stringBuffer.append("USER_BASED" + (this.userBased != this.count ? "=" + this.userBased : "") + " ");
        }
        if (this.minimum != 0) {
            stringBuffer.append("MINIMUM=" + this.minimum + " ");
        }
        if (this.platforms != null) {
            stringBuffer.append("PLATFORMS=\"");
            for (n = 0; n < this.platforms.length; ++n) {
                stringBuffer.append(this.platforms[n] + " ");
            }
            stringBuffer.setCharAt(stringBuffer.length() - 1, '\"');
            stringBuffer.append(" ");
        }
        if (this.borrowPresent) {
            stringBuffer.append("BORROW" + (this.borrow != 168 ? "=" + this.borrow : "") + " ");
        }
        if (this.supersedePresent) {
            stringBuffer.append("SUPERSEDE");
            if (this.namesSuperseded != null) {
                stringBuffer.append("=\"");
                for (n = 0; n < this.namesSuperseded.length; ++n) {
                    stringBuffer.append(this.namesSuperseded[n] + " ");
                }
                stringBuffer.setCharAt(stringBuffer.length() - 1, '\"');
            }
            stringBuffer.append(" ");
        }
        if (this.dupGroup != null) {
            stringBuffer.append("DUP_GROUP=" + this.dupGroup.toString() + " ");
        }
        if (this.suiteDupGroup != null) {
            stringBuffer.append("SUITE_DUP_GROUP=" + this.suiteDupGroup.toString() + " ");
        }
        if (this.vendorInfo != null) {
            stringBuffer.append("vendor_info=" + this.vendorInfo + " ");
        }
        if (this.distInfo != null) {
            stringBuffer.append("dist_info=" + this.distInfo + " ");
        }
        if (this.userInfo != null) {
            stringBuffer.append("user_info=" + this.userInfo + " ");
        }
        if (this.assetInfo != null) {
            stringBuffer.append("asset_info=" + this.assetInfo + " ");
        }
        if (this.issuer != null) {
            stringBuffer.append("ISSUER=\"" + this.issuer + "\" ");
        }
        if (this.issuedDate != null) {
            stringBuffer.append("ISSUED=" + this.issuedDate.toString() + " ");
        }
        if (this.notice != null) {
            stringBuffer.append("NOTICE=\"" + this.notice + "\" ");
        }
        if (this.checksum != 0) {
            stringBuffer.append("ck=" + this.checksum + " ");
        }
        if (this.serial != null) {
            stringBuffer.append("SN=" + this.serial + " ");
        }
        if (this.startDate != null) {
            stringBuffer.append("START=" + this.startDate.toString() + " ");
        }
        if (this.terminalServerOK) {
            stringBuffer.append("TS_OK ");
        }
        if (this.oneTerminalServerOK) {
            stringBuffer.append("ONE_TS_OK ");
        }
        if (this.signature1 != null) {
            stringBuffer.append("SIGN=\"" + this.getSignature() + "\" ");
        }
        if (this.signature2 != null) {
            if (this.signature2.indexOf(" ") != -1) {
                stringBuffer.append("SIGN2=\"" + this.getSignature2() + "\" ");
            } else {
                stringBuffer.append("SIGN2=" + this.getSignature2());
            }
        }
        if (this.floatOKPresent) {
            stringBuffer.append("FLOAT_OK" + (this.floatOKHostid != null ? "=" + this.floatOKHostid.toString() : "") + " ");
        }
        return new String(stringBuffer);
    }
}

