/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm;

import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.HostId;
import com.macrovision.flexlm.lictext.FlexlmDate;
import com.macrovision.flexlm.misc.FlexlmInternalConstants;
import java.security.PublicKey;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class VendorInfo
implements FlexlmConstants,
FlexlmInternalConstants {
    private Vector hostIdList;
    private boolean croEnabled;
    private boolean useNativeHostIds;
    int[] compositeHostIdTypes;
    private static final int PLAT_java = 2048;
    private static final int JUNK = -1544617984;
    private static final int NO_EXPIRE = 20;

    public VendorInfo() throws FlexlmException {
        this.validate();
        this.initializeHostIds();
    }

    public abstract String getVendorName();

    public abstract int[] getEncryptionSeeds();

    public abstract int[] getVendorKeys();

    public abstract int[] getCroKeys();

    public abstract int getDefaultStrength();

    public abstract PublicKey getPublicKey(int var1);

    private void initializeHostIds() throws FlexlmException {
        this.hostIdList = HostId.initializeHostIdList();
    }

    public void registerVendorHostId(HostId hostId) throws FlexlmException {
        HostId.registerVendorHostId(hostId, this.hostIdList);
    }

    public void useNativeHostIds(boolean bl, int[] nArray) throws FlexlmException {
        if (bl && this.useNativeHostIds) {
            return;
        }
        if (!bl) {
            this.useNativeHostIds = false;
            this.compositeHostIdTypes = null;
            return;
        }
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle("com.macrovision.flexlm.FlexlmResources");
        }
        catch (MissingResourceException missingResourceException) {
            throw new RuntimeException("cannot open properties file com.macrovision.flexlm.FlexlmResources");
        }
        String string = resourceBundle.getString("NativeFlexLibs");
        if (string == null) {
            throw new RuntimeException("Resource NativeFlexLibsnot present in com.macrovision.flexlm.FlexlmResources");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        boolean bl2 = false;
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            try {
                System.loadLibrary(string2);
            }
            catch (SecurityException securityException) {
                continue;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                continue;
            }
            bl2 = true;
            break;
        }
        if (!bl2) {
            throw new FlexlmException(-521, 7024);
        }
        this.useNativeHostIds = true;
        this.compositeHostIdTypes = nArray;
    }

    public boolean getUseNativeHostIds() {
        return this.useNativeHostIds;
    }

    public int[] getCompositeHostIdTypes() {
        return this.compositeHostIdTypes;
    }

    Vector getHostIdList() {
        return this.hostIdList;
    }

    private void validate() throws FlexlmException {
        int n;
        int n2;
        FlexlmDate flexlmDate;
        String string = this.getVendorName();
        int[] nArray = this.decodeVendorKeys(false);
        int n3 = nArray[3] ^ 0xA3EF0000;
        n3 >>= 16;
        n3 &= 0xFFFF;
        int n4 = nArray[1] & 0x7F;
        nArray[1] = nArray[1] & 0xFFFFFF80;
        if ((n3 -= nArray[3] & 0xFFFF) != 0 || n4 != this.l_c(nArray)) {
            throw new FlexlmException(-44, 7004);
        }
        if ((nArray[0] & 0x100000) == 0 && (flexlmDate = new FlexlmDate(n2 = nArray[3] & 0xFFFF)).isPast()) {
            throw new FlexlmException(-50, 7005);
        }
        if ((nArray[2] & 0x800) == 0) {
            throw new FlexlmException(-48, 7006);
        }
        int[] nArray2 = this.getCroKeys();
        if (string.equals("demo")) {
            this.croEnabled = true;
            return;
        }
        if (nArray2[0] == 0 || nArray2[1] == 0) {
            return;
        }
        nArray = this.decodeVendorKeys(true);
        n3 = 0;
        for (n = 1; n < 4; ++n) {
            n3 ^= nArray[1] >> n * 8;
        }
        for (n = 0; n < 4; ++n) {
            n3 ^= nArray[2] >> n * 8;
        }
        if ((n3 & 0x7F) != (nArray[1] & 0x7F)) {
            throw new FlexlmException(-44, 7007);
        }
        this.croEnabled = true;
    }

    private int[] decodeVendorKeys(boolean bl) {
        int n;
        int[] nArray;
        int[] nArray2 = new int[4];
        String string = this.getVendorName();
        if (bl) {
            nArray = new int[4];
            int[] nArray3 = this.getCroKeys();
            nArray[1] = nArray3[0];
            nArray[2] = nArray3[1];
        } else {
            nArray = this.getVendorKeys();
        }
        int n2 = bl ? 468476469 : -337091022;
        for (n = 0; n < string.length(); ++n) {
            n2 = (int)((long)n2 ^ (long)string.charAt(n) << n % 4 * 8);
        }
        for (n = 0; n < 4; ++n) {
            nArray2[n] = n > 0 ? nArray2[n - 1] ^ nArray[n - 1] ^ this.l_icf(nArray[n]) : (bl ? n2 : n2 ^ this.l_icf(nArray[n]));
        }
        return nArray2;
    }

    private int l_c(int[] nArray) {
        int n = 93;
        int n2 = 0;
        int n3 = 0;
        long l = nArray[n3];
        for (int i = 3; i >= 0; --i) {
            l = nArray[n3++];
            for (n = 93; n >= 31; n -= 2) {
                if ((l & 1L) != 0L) {
                    ++n2;
                }
                l >>= 1;
            }
        }
        return n2;
    }

    private int l_icf(int n) {
        int n2 = n & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n >> 16 & 0xFF;
        int n5 = n >> 24 & 0xFF;
        int n6 = this.l_hbs(this.l_br(n4));
        int n7 = n6 ^ this.l_hbs(n5);
        int n8 = n6 ^ this.l_br(n3);
        int n9 = n8 ^ this.l_br(this.l_hbs(n2));
        return n9 | n8 << 8 | n7 << 16 | n6 << 24;
    }

    private int l_hbs(int n) {
        return (n & 0xF0) >> 4 | (n & 0xF) << 4;
    }

    private int l_br(int n) {
        return ((n & 0x80) != 0 ? 1 : 0) | ((n & 0x40) != 0 ? 2 : 0) | ((n & 0x20) != 0 ? 4 : 0) | ((n & 0x10) != 0 ? 8 : 0) | ((n & 8) != 0 ? 16 : 0) | ((n & 4) != 0 ? 32 : 0) | ((n & 2) != 0 ? 64 : 0) | ((n & 1) != 0 ? 128 : 0);
    }
}

