/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.logging;

import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.utils.Encodings;
import com.ibm.cic.common.core.utils.XMLUtil;
import com.ibm.cic.common.logging.IXMLConstants;
import com.ibm.cic.common.logging.Level;
import com.ibm.cic.common.logging.LogEntry;
import com.ibm.cic.common.logging.LogUtil;
import org.eclipse.osgi.util.NLS;

class XMLFormatter
implements IXMLConstants {
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"{0}\" standalone=\"no\"?>";
    private static final String XML_STYLESHEET = "<?xml-stylesheet type=\"text/xsl\" href=\"{0}\"?>";
    private final long startTime;
    private final StringBuffer sb = new StringBuffer(512);
    private int indent = 0;
    private static final char INDENT = ' ';

    public static String getXMLHeader(String stylesheet, Encodings encoding) {
        StringBuffer result = new StringBuffer();
        result.append(NLS.bind((String)XML_HEADER, (Object)encoding.getName())).append(LogUtil.NEWLINE);
        if (stylesheet != null) {
            result.append(NLS.bind((String)XML_STYLESHEET, (Object)stylesheet)).append(LogUtil.NEWLINE);
        }
        return result.toString();
    }

    public XMLFormatter(long startTime) {
        this.startTime = startTime;
    }

    public String getHead(String xslFile, Encodings encoding) {
        this.append(XMLFormatter.getXMLHeader(xslFile, encoding));
        this.openElement("log");
        this.appendAttr("start", LogUtil.toISO8601(this.startTime));
        this.closeElement();
        return this.getString();
    }

    public String getTail() {
        this.endElement("log");
        return this.getString();
    }

    public String format(LogEntry entry) {
        try {
            this.appendEntry(entry);
            return this.getString();
        }
        catch (Throwable e) {
            this.getString();
            this.startElement("entry");
            LogUtil.appendObject(this.sb, 0, e);
            this.endElement("entry");
            return this.getString();
        }
    }

    private void appendEntry(LogEntry entry) {
        this.openElement("entry");
        this.appendAttr("num", Integer.toString(entry.getNum()));
        this.appendAttr("time", Long.toString(entry.getTime()));
        this.appendAttr("elapsed", LogUtil.toElapsedTime(entry.getTime() - this.startTime));
        this.appendAttr("level", Level.getName(entry.getLevel()));
        this.appendAttr("uid", entry.getUid());
        this.appendAttr("thread", XMLUtil.escape(entry.getThreadName()));
        if (entry.getStartNum() > 0) {
            this.appendAttr("startNum", Integer.toString(entry.getStartNum()));
        }
        this.closeElement();
        this.appendElement("logger", entry.getLoggerName());
        String className = entry.getCallingClass();
        if (!entry.getLoggerName().equals(className)) {
            this.appendElement("class", className);
        }
        this.appendElement("method", entry.getCallingMethod());
        String href = entry.getHref();
        int argCount = entry.getArgCount();
        if (argCount == 0) {
            if (href != null) {
                this.appendElement("message", "href", href, entry.getMessageWithAdditionalInfo());
            } else {
                this.appendElement("message", entry.getMessageWithAdditionalInfo());
            }
        } else {
            this.openElement("message");
            this.appendAttr("href", href);
            this.closeElement();
            this.appendElement("key", entry.getMessageWithAdditionalInfo());
            int i = 0;
            while (i < argCount) {
                this.appendElement("arg", entry.getArg(i));
                ++i;
            }
            this.endElement("message");
        }
        Throwable exception = entry.getException();
        if (exception != null) {
            StackTraceElement[] elements;
            this.startElement("exception");
            this.addContent(LogUtil.escape(LogUtil.replaceBadCharacters(entry.getException().toString())));
            StackTraceElement[] stackTraceElementArray = elements = exception.getStackTrace();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement element = stackTraceElementArray[n2];
                this.appendElement("stack", element);
                ++n2;
            }
            StackTraceElement[] parentStack = elements;
            Throwable cause = exception.getCause();
            while (cause != null) {
                StackTraceElement[] curStack = cause.getStackTrace();
                this.appendElement("stack", String.valueOf(Messages.XMLFormatter_CausedBy) + LogUtil.replaceBadCharacters(cause.toString()));
                int n3 = XMLFormatter.findNonMatchingStack(parentStack, curStack);
                int i = 0;
                while (i < n3) {
                    this.appendElement("stack", curStack[i]);
                    ++i;
                }
                parentStack = curStack;
                cause = cause.getCause();
            }
            this.endElement("exception");
        }
        this.endElement("entry");
    }

    private static int findNonMatchingStack(StackTraceElement[] parentStack, StackTraceElement[] currStack) {
        int parentLength = parentStack.length;
        int currLength = currStack.length;
        int i = 1;
        while (i <= currLength && i <= parentLength) {
            if (!parentStack[parentLength - i].equals(currStack[currLength - 1])) {
                return currLength - i + 1;
            }
            ++i;
        }
        return 0;
    }

    private String getString() {
        String result = this.sb.toString();
        this.sb.setLength(0);
        this.indent = 0;
        return result;
    }

    private StringBuffer append(char c) {
        return this.sb.append(c);
    }

    private StringBuffer append(String s) {
        return this.sb.append(s);
    }

    private void indent() {
        int i = 0;
        while (i < this.indent) {
            this.append(' ');
            ++i;
        }
    }

    private void newline() {
        this.append(LogUtil.NEWLINE);
    }

    private void startElement(String name) {
        this.openElement(name);
        this.closeElement();
    }

    private void openElement(String name) {
        this.indent();
        ++this.indent;
        this.append('<').append(name);
    }

    private void closeElement() {
        this.append('>');
        this.newline();
    }

    private void appendAttr(String name, String value) {
        if (value != null && value.length() > 0) {
            this.append(' ').append(name).append('=').append('\'').append(value).append('\'');
        }
    }

    private void endElement(String name) {
        --this.indent;
        this.indent();
        this.append('<').append('/').append(name).append('>');
        this.newline();
    }

    private void addContent(String text) {
        this.indent();
        this.append(text);
        this.newline();
    }

    private void appendElement(String name, Object object) {
        if (object != null) {
            this.indent();
            this.append('<').append(name).append('>');
            this.append(LogUtil.escape(LogUtil.toString(object)));
            this.append('<').append('/').append(name).append('>');
            this.newline();
        }
    }

    private void appendElement(String name, String attrName, String attrValue, Object object) {
        this.indent();
        this.append('<').append(name);
        this.appendAttr(attrName, attrValue);
        this.append('>');
        this.append(LogUtil.escape(LogUtil.toString(object)));
        this.append('<').append('/').append(name).append('>');
        this.newline();
    }
}

