/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.logging;

import com.ibm.cic.common.logging.Level;
import com.ibm.cic.common.logging.LogUtil;
import com.ibm.cic.common.logging.Logger;
import java.util.Arrays;
import org.eclipse.osgi.util.NLS;

public class LogEntry {
    private static final String NO_UID = "";
    private static final String[] NO_ARGS = new String[0];
    private static int nextNum = 0;
    private final Logger logger;
    private final int level;
    private final int num;
    private final int startNum;
    private final String message;
    private final long time;
    private final String threadName;
    private final String callingClass;
    private final String callingMethod;
    private final Throwable exception;
    private final String[] args;
    private String formattedMessage = null;
    private String additionalInfo = null;
    private String explanation = null;
    private String userAction = null;
    private String href = null;
    private String uid = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LogEntry(Logger logger, int level, int startNum, Throwable exception, String message, Object ... args) {
        if (logger == null || message == null) {
            throw new NullPointerException();
        }
        this.logger = logger;
        this.level = level;
        this.message = LogUtil.replaceBadCharacters(LogUtil.stripOffTrailingNewLine(LogUtil.fixNewlines(message)));
        Class<LogEntry> clazz = LogEntry.class;
        synchronized (LogEntry.class) {
            this.num = ++nextNum;
            // ** MonitorExit[var7_7] (shouldn't be in output)
            this.time = System.currentTimeMillis();
            this.exception = exception;
            if (args == null) {
                this.args = NO_ARGS;
            } else {
                this.args = new String[args.length];
                int i = 0;
                while (i < args.length) {
                    this.args[i] = LogUtil.toString(args[i]);
                    ++i;
                }
            }
            StackTraceElement frame = LogUtil.getCaller(logger);
            this.callingClass = frame.getClassName().replace('$', '.');
            this.callingMethod = frame.getMethodName();
            this.threadName = Thread.currentThread().getName();
            this.startNum = startNum;
            return;
        }
    }

    public String toString() {
        return String.valueOf(Level.getName(this.level)) + ": " + this.message + Arrays.asList(this.args);
    }

    public String getFormattedMessage() {
        if (this.formattedMessage == null) {
            String msg = this.args.length == 0 ? this.message : NLS.bind((String)this.message, (Object[])this.args);
            this.formattedMessage = this.addExtraInfo(msg);
        }
        return this.formattedMessage;
    }

    public String getUid() {
        return this.uid;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getLoggerName() {
        return this.logger.getName();
    }

    public int getLevel() {
        return this.level;
    }

    public int getNum() {
        return this.num;
    }

    public int getStartNum() {
        return this.startNum;
    }

    public String getMessage() {
        return this.message;
    }

    public String getMessageWithAdditionalInfo() {
        return this.addExtraInfo(this.message);
    }

    private String addExtraInfo(String prefix) {
        String result = prefix;
        if (this.additionalInfo != null && !this.additionalInfo.isEmpty()) {
            result = String.valueOf(result) + LogUtil.NEWLINE + this.additionalInfo;
        }
        if (this.explanation != null && !this.explanation.isEmpty()) {
            result = String.valueOf(result) + LogUtil.NEWLINE + this.explanation;
        }
        if (this.userAction != null && !this.userAction.isEmpty()) {
            result = String.valueOf(result) + LogUtil.NEWLINE + this.userAction;
        }
        return result;
    }

    public long getTime() {
        return this.time;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public String getCallingClass() {
        return this.callingClass;
    }

    public String getCallingMethod() {
        return this.callingMethod;
    }

    public Throwable getException() {
        return this.exception;
    }

    public int getArgCount() {
        return this.args.length;
    }

    public String getArg(int index) {
        return this.args[index];
    }

    public String getHref() {
        return this.href;
    }

    void setUid(String uid) {
        assert (this.uid.equals(NO_UID));
        this.uid = uid;
    }

    public void setHref(String href) {
        this.href = href;
    }

    void setAdditionalInfo(String additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    void setExplanation(String explanation) {
        this.explanation = explanation;
    }

    void setUserAction(String userAction) {
        this.userAction = userAction;
    }
}

