/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.downloads.ResumableDownloadProgress;
import com.ibm.cic.common.logging.Logger;
import java.util.ArrayList;
import org.eclipse.core.runtime.Plugin;

public class ResumableProgressEvents {
    private final ArrayList listeners;
    private static final Logger log = Logger.getLogger(ResumableProgressEvents.class, (Plugin)ComIbmCicCommonCorePlugin.getDefault());
    public static final ResumableProgressEvents INSTANCE = new ResumableProgressEvents();
    public static final ResumableDownloadProgress.IResumableDownloadProgress FIRE = ResumableProgressEvents.INSTANCE.MY_FIRE;
    private final FireEvents MY_FIRE = new FireEvents();

    private ResumableProgressEvents() {
        this.listeners = new ArrayList(10);
    }

    public synchronized void addListener(ResumableDownloadProgress.IResumableDownloadProgress listener) {
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    public synchronized void removeListener(ResumableDownloadProgress.IResumableDownloadProgress listener) {
        this.listeners.remove(listener);
    }

    private synchronized ResumableDownloadProgress.IResumableDownloadProgress[] getListeners() {
        return this.listeners.toArray(new ResumableDownloadProgress.IResumableDownloadProgress[this.listeners.size()]);
    }

    public static abstract class AbstractProgressListener
    implements ResumableDownloadProgress.IResumableDownloadProgress {
        @Override
        public void endResumeableDownload() {
        }

        @Override
        public void startResumeableDownload(long bytesTotal, long bytesToTransfer, boolean willVerify) {
        }

        @Override
        public void beginTransfer(long bytesToTransfer) {
        }

        @Override
        public void endTransfer() {
        }

        @Override
        public void updateTransfer(int percentDone, long bytesTransferred, long bytesToTransfer, long bytesPerSecondTotal, long bytesPerLastSecond) {
        }

        @Override
        public void beginVerification() {
        }

        @Override
        public void endVerification() {
        }

        @Override
        public void updateVerificationProgress(int percent) {
        }

        @Override
        public void notifyRestart() {
        }

        @Override
        public boolean isCanceled() {
            return false;
        }
    }

    private class FireEvents
    implements ResumableDownloadProgress.IResumableDownloadProgress {
        private FireEvents() {
        }

        @Override
        public void endResumeableDownload() {
            ResumableDownloadProgress.IResumableDownloadProgress[] aListeners;
            log.debug("enter endResumeableDownload()");
            ResumableDownloadProgress.IResumableDownloadProgress[] iResumableDownloadProgressArray = aListeners = ResumableProgressEvents.this.getListeners();
            int n = aListeners.length;
            int n2 = 0;
            while (n2 < n) {
                ResumableDownloadProgress.IResumableDownloadProgress listener = iResumableDownloadProgressArray[n2];
                try {
                    listener.endTransfer();
                }
                catch (Throwable t) {
                    log.error(t);
                }
                ++n2;
            }
        }

        @Override
        public void startResumeableDownload(long bytesTotal, long bytesToTransfer, boolean willVerify) {
            ResumableDownloadProgress.IResumableDownloadProgress[] aListeners;
            if (log.isDebugLoggable()) {
                log.debug("enter startResumeableDownload({0}, {1}, {2})", bytesTotal, bytesToTransfer, willVerify);
            }
            ResumableDownloadProgress.IResumableDownloadProgress[] iResumableDownloadProgressArray = aListeners = ResumableProgressEvents.this.getListeners();
            int n = aListeners.length;
            int n2 = 0;
            while (n2 < n) {
                ResumableDownloadProgress.IResumableDownloadProgress listener = iResumableDownloadProgressArray[n2];
                try {
                    listener.startResumeableDownload(bytesTotal, bytesToTransfer, willVerify);
                }
                catch (Throwable t) {
                    log.error(t);
                }
                ++n2;
            }
        }

        @Override
        public void beginTransfer(long bytesToTransfer) {
            ResumableDownloadProgress.IResumableDownloadProgress[] aListeners;
            log.debug("enter beginTransfer({0})", bytesToTransfer);
            ResumableDownloadProgress.IResumableDownloadProgress[] iResumableDownloadProgressArray = aListeners = ResumableProgressEvents.this.getListeners();
            int n = aListeners.length;
            int n2 = 0;
            while (n2 < n) {
                ResumableDownloadProgress.IResumableDownloadProgress listener = iResumableDownloadProgressArray[n2];
                try {
                    listener.beginTransfer(bytesToTransfer);
                }
                catch (Throwable t) {
                    log.error(t);
                }
                ++n2;
            }
        }

        @Override
        public void endTransfer() {
            ResumableDownloadProgress.IResumableDownloadProgress[] aListeners;
            log.debug("enter endTransfer()");
            ResumableDownloadProgress.IResumableDownloadProgress[] iResumableDownloadProgressArray = aListeners = ResumableProgressEvents.this.getListeners();
            int n = aListeners.length;
            int n2 = 0;
            while (n2 < n) {
                ResumableDownloadProgress.IResumableDownloadProgress listener = iResumableDownloadProgressArray[n2];
                try {
                    listener.endTransfer();
                }
                catch (Throwable t) {
                    log.error(t);
                }
                ++n2;
            }
        }

        @Override
        public void updateTransfer(int percentDone, long bytesTransferred, long bytesToTransfer, long bytesPerSecondTotal, long bytesPerLastSecond) {
            ResumableDownloadProgress.IResumableDownloadProgress[] aListeners;
            if (log.isDebugLoggable()) {
                log.debug("enter updateTransfer({0}, {1}, {2}, {3}, {4})", percentDone, bytesTransferred, bytesToTransfer, bytesPerSecondTotal, bytesPerLastSecond);
            }
            ResumableDownloadProgress.IResumableDownloadProgress[] iResumableDownloadProgressArray = aListeners = ResumableProgressEvents.this.getListeners();
            int n = aListeners.length;
            int n2 = 0;
            while (n2 < n) {
                ResumableDownloadProgress.IResumableDownloadProgress listener = iResumableDownloadProgressArray[n2];
                try {
                    listener.updateTransfer(percentDone, bytesTransferred, bytesToTransfer, bytesPerSecondTotal, bytesPerLastSecond);
                }
                catch (Throwable t) {
                    log.error(t);
                }
                ++n2;
            }
        }

        @Override
        public boolean isCanceled() {
            return false;
        }

        @Override
        public void notifyRestart() {
            ResumableDownloadProgress.IResumableDownloadProgress[] aListeners;
            log.debug("enter notifyRestart()");
            ResumableDownloadProgress.IResumableDownloadProgress[] iResumableDownloadProgressArray = aListeners = ResumableProgressEvents.this.getListeners();
            int n = aListeners.length;
            int n2 = 0;
            while (n2 < n) {
                ResumableDownloadProgress.IResumableDownloadProgress listener = iResumableDownloadProgressArray[n2];
                try {
                    listener.notifyRestart();
                }
                catch (Throwable t) {
                    log.error(t);
                }
                ++n2;
            }
        }

        @Override
        public void beginVerification() {
            ResumableDownloadProgress.IResumableDownloadProgress[] aListeners;
            log.debug("enter beginVerification()");
            ResumableDownloadProgress.IResumableDownloadProgress[] iResumableDownloadProgressArray = aListeners = ResumableProgressEvents.this.getListeners();
            int n = aListeners.length;
            int n2 = 0;
            while (n2 < n) {
                ResumableDownloadProgress.IResumableDownloadProgress listener = iResumableDownloadProgressArray[n2];
                try {
                    listener.beginVerification();
                }
                catch (Throwable t) {
                    log.error(t);
                }
                ++n2;
            }
        }

        @Override
        public void endVerification() {
            ResumableDownloadProgress.IResumableDownloadProgress[] aListeners;
            log.debug("enter endVerification()");
            ResumableDownloadProgress.IResumableDownloadProgress[] iResumableDownloadProgressArray = aListeners = ResumableProgressEvents.this.getListeners();
            int n = aListeners.length;
            int n2 = 0;
            while (n2 < n) {
                ResumableDownloadProgress.IResumableDownloadProgress listener = iResumableDownloadProgressArray[n2];
                try {
                    listener.endVerification();
                }
                catch (Throwable t) {
                    log.error(t);
                }
                ++n2;
            }
        }

        @Override
        public void updateVerificationProgress(int percent) {
            ResumableDownloadProgress.IResumableDownloadProgress[] aListeners;
            log.debug("enter updateVerificationProgress({0})", percent);
            ResumableDownloadProgress.IResumableDownloadProgress[] iResumableDownloadProgressArray = aListeners = ResumableProgressEvents.this.getListeners();
            int n = aListeners.length;
            int n2 = 0;
            while (n2 < n) {
                ResumableDownloadProgress.IResumableDownloadProgress listener = iResumableDownloadProgressArray[n2];
                try {
                    listener.updateVerificationProgress(percent);
                }
                catch (Throwable t) {
                    log.error(t);
                }
                ++n2;
            }
        }
    }
}

