/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

import com.ibm.cic.common.core.downloads.DefaultDownloader;
import com.ibm.cic.common.core.downloads.FileCacheManagerEvents;
import com.ibm.cic.common.core.downloads.IFileCacheManagerEventListener;
import com.ibm.cic.common.core.internal.downloads.FileCacheInfo;
import com.ibm.cic.common.core.internal.downloads.FileContentInfo;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.digest.RepositoryDigest;
import com.ibm.cic.common.downloads.IDownloader;
import com.ibm.cic.common.downloads.IFileContentInfo;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class FileCacheManager {
    public static final Logger log = Logger.getLogger(FileCacheManager.class);
    Map m_cachedFiles = Collections.synchronizedMap(new HashMap());
    long m_timeout = 3600000L;
    private static FileCacheManager instance = new FileCacheManager();

    private FileCacheManager() {
    }

    public static FileCacheManager getInstance() {
        return instance;
    }

    public File getFile(ICicLocation a_remoteLocation, boolean forceRefresh, IProgressMonitor progressMonitor) throws Exception {
        return this.getFile(new FileContentInfo(a_remoteLocation), forceRefresh, true, DefaultDownloader.getINSTANCE(), progressMonitor);
    }

    public IStatus getRepositoryDigest(RepositoryDigest repDigest, IFileContentInfo a_remoteContentInfo, boolean forceRefresh, boolean useTimeout, IDownloader dldr, IProgressMonitor progressMonitor) throws Exception {
        IStatus return_value = null;
        FileCacheInfo info = this.getFileCacheInfo(a_remoteContentInfo, forceRefresh, useTimeout, dldr, progressMonitor);
        File file = info.getFile();
        if (file.exists()) {
            if (info.getRepDigest() == null) {
                return_value = repDigest.load(info.getFile(), info.getRemotePath());
                if (return_value.isOK()) {
                    info.setRepDigest(repDigest);
                }
            } else {
                repDigest.getThisRepositoryData().copyDigestRepositoryData(info.getRepDigest().getThisRepositoryData());
                return_value = Status.OK_STATUS;
            }
        }
        return return_value;
    }

    public synchronized File getFile(IFileContentInfo a_remoteContentInfo, boolean forceRefresh, boolean useTimeout, IDownloader dldr, IProgressMonitor progressMonitor) throws Exception {
        File return_value = null;
        FileCacheInfo info = this.getFileCacheInfo(a_remoteContentInfo, forceRefresh, useTimeout, dldr, progressMonitor);
        if (info != null) {
            return_value = info.getFile();
        }
        return return_value;
    }

    private synchronized FileCacheInfo getFileCacheInfo(IFileContentInfo a_remoteContentInfo, boolean forceRefresh, boolean useTimeout, IDownloader dldr, IProgressMonitor progressMonitor) throws Exception {
        FileCacheInfo info = null;
        this.cleanExpiredFiles();
        if (forceRefresh) {
            this.removeCachedElement(a_remoteContentInfo.getFileLocation());
        } else {
            info = (FileCacheInfo)this.m_cachedFiles.get(a_remoteContentInfo.getFileLocation());
        }
        if (info == null) {
            FileCacheManagerEvents.FIRE.onEvent(new IFileCacheManagerEventListener.GetFileEvent(a_remoteContentInfo, forceRefresh, useTimeout));
            log.debug("FCM:   fetching {" + a_remoteContentInfo.getFileLocation().toString() + "}");
            info = new FileCacheInfo(a_remoteContentInfo, useTimeout, dldr, progressMonitor);
            if (info.getStatus().matches(8)) {
                log.debug("FCM:   canceled {" + info.getRemotePath().toString() + "}, {" + this.m_cachedFiles.size() + "} remaining");
            } else {
                this.m_cachedFiles.put(info.getRemotePath(), info);
                this.resetTimeoutForFilesAtTheSameLocation(info);
                log.debug("FCM:   added {" + info.getRemotePath().toString() + "}, {" + this.m_cachedFiles.size() + "} remaining");
            }
        } else {
            log.debug("FCM:   hit {" + info.getRemotePath().toString() + "}, {" + this.m_cachedFiles.size() + "} remaining");
        }
        IStatus status = info.getStatus();
        if (status.matches(8)) {
            throw new CoreException(status);
        }
        if (status.matches(4)) {
            if (status.getMessage().length() == 0) {
                throw (Exception)status.getException();
            }
            throw new CoreException(status);
        }
        if (info.getStatus().isOK()) {
            return info;
        }
        return null;
    }

    synchronized void cleanExpiredFiles() {
        Iterator I = this.m_cachedFiles.values().iterator();
        while (I.hasNext()) {
            FileCacheInfo element = (FileCacheInfo)I.next();
            if (!element.timeoutExpired(this.m_timeout)) continue;
            this.removeCachedElement(element, I);
        }
    }

    public synchronized void reset() {
        Iterator I = this.m_cachedFiles.values().iterator();
        while (I.hasNext()) {
            FileCacheInfo element = (FileCacheInfo)I.next();
            this.removeCachedElement(element, I);
        }
        this.m_cachedFiles.clear();
    }

    public synchronized void resetPathTree(ICicLocation a_remoteLocation) {
        if (a_remoteLocation != null) {
            Set entrySet = this.m_cachedFiles.entrySet();
            Iterator I = entrySet.iterator();
            while (I.hasNext()) {
                Map.Entry entry = I.next();
                FileCacheInfo element = (FileCacheInfo)entry.getValue();
                if (!element.getRemotePath().toString().startsWith(a_remoteLocation.toString())) continue;
                this.removeCachedElement(element, I);
            }
        }
    }

    private void resetTimeoutForFilesAtTheSameLocation(FileCacheInfo a_fci) {
        String loc = a_fci.getRemotePath().getPathSegments();
        Set entrySet = this.m_cachedFiles.entrySet();
        for (Map.Entry entry : entrySet) {
            FileCacheInfo element = (FileCacheInfo)entry.getValue();
            if (!element.hasTimeoutSet() || !element.getRemotePath().toString().startsWith(loc)) continue;
            element.setTimeout();
        }
    }

    public synchronized void resetPathTreeWithNoTimout(ICicLocation a_remoteLocation) {
        if (a_remoteLocation != null) {
            Set entrySet = this.m_cachedFiles.entrySet();
            Iterator I = entrySet.iterator();
            while (I.hasNext()) {
                Map.Entry entry = I.next();
                FileCacheInfo element = (FileCacheInfo)entry.getValue();
                if (!element.hasTimeoutSet()) {
                    if (!element.getRemotePath().toString().startsWith(a_remoteLocation.toString())) continue;
                    this.removeCachedElement(element, I);
                    continue;
                }
                element.setRepDigest(null);
            }
        }
    }

    private synchronized void removeCachedElement(FileCacheInfo element, Iterator I) {
        element.delete();
        String name = element.getRemoteFileInfo().toString();
        if (I != null) {
            I.remove();
        }
        log.debug("FCM: removed {" + name + "}, {" + this.m_cachedFiles.size() + "} remaining");
    }

    public synchronized void removeCachedElement(ICicLocation remoteLocation) {
        FileCacheInfo element = (FileCacheInfo)this.m_cachedFiles.get(remoteLocation);
        if (element != null) {
            element.delete();
            String name = element.getRemoteFileInfo().toString();
            this.m_cachedFiles.remove(remoteLocation);
            log.debug("FCM: Removed {" + name + "}, {" + this.m_cachedFiles.size() + "} remaining");
        }
    }

    public String toString() {
        return "timeout:" + this.m_timeout + " " + this.m_cachedFiles.toString();
    }

    public boolean isEmpty() {
        return this.m_cachedFiles.isEmpty();
    }
}

