/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

import com.ibm.cic.common.core.downloads.DownloadContextThreadLocalInheritedAndGlobal;
import com.ibm.cic.common.downloads.DownloadContext;
import com.ibm.cic.common.downloads.ICancelable;
import com.ibm.cic.common.downloads.IDownloadContext;
import com.ibm.cic.common.downloads.IDownloadUI;
import com.ibm.cic.common.downloads.IHasIsCanceled;
import com.ibm.cic.common.downloads.IRestorePrevious;
import com.ibm.cic.common.downloads.ISuspendResumeUI;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;

public class DownloadUI {
    public static final IDownloadUI NullUI = new IDownloadUI(){

        @Override
        public boolean autoRetryOnTimeoutOnly() {
            return false;
        }

        public String toString() {
            return "NullDownloadUI";
        }
    };
    public static final DownloadUI INSTANCE = new DownloadUI();
    private final ArrayList modalSetRestoreRequests = new ArrayList(2);
    private final ArrayList asyncSetRestoreRequests = new ArrayList(1);
    private static final String KEY_DOWNLOAD_UI = "KEY_DOWNLOAD_UI";

    private DownloadUI() {
        this.setGlobalDownloadUI(null);
    }

    public IDownloadUI getUI() {
        IDownloadUI ui = DownloadUI.getDownloadUI(DownloadContextThreadLocalInheritedAndGlobal.CONTEXT);
        return ui;
    }

    public static boolean waitUntilResumeOrRetry(IDownloadUI ui) {
        if (ui instanceof ISuspendResumeUI) {
            ISuspendResumeUI srUI = (ISuspendResumeUI)ui;
            return srUI.waitUntilResumeOrRetry();
        }
        return false;
    }

    public static void beginDownloads(IDownloadUI ui) {
        if (ui instanceof ISuspendResumeUI) {
            ISuspendResumeUI srUI = (ISuspendResumeUI)ui;
            srUI.begin();
        }
    }

    public static void endDownloads(IDownloadUI ui) {
        if (ui instanceof ISuspendResumeUI) {
            ISuspendResumeUI srUI = (ISuspendResumeUI)ui;
            srUI.end();
        }
    }

    public static boolean isCanceled(IDownloadUI ui) {
        if (ui instanceof IHasIsCanceled) {
            return ((IHasIsCanceled)((Object)ui)).isCanceled();
        }
        return false;
    }

    public static void cancelDownloads(IDownloadUI ui) {
        if (ui instanceof ICancelable) {
            ICancelable cancelable = (ICancelable)((Object)ui);
            cancelable.cancel();
        }
    }

    public synchronized IRestorePrevious setRestoreUIRequest(IDownloadUI ui, boolean async) {
        final IDownloadUI prevUI = this.getGlobalDownloadUI();
        assert (ui != null);
        if (async) {
            if (!this.modalSetRestoreRequests.isEmpty()) {
                AsyncSetRestoreUIRequest asyncRequest = new AsyncSetRestoreUIRequest(ui);
                this.asyncSetRestoreRequests.add(asyncRequest);
                return asyncRequest.getCallback();
            }
            this.setGlobalDownloadUI(ui);
            return new IRestorePrevious(){

                @Override
                public void restore() {
                    DownloadUI.this.setGlobalDownloadUI(prevUI);
                }
            };
        }
        final SetRestoreRecord srr = new SetRestoreRecord(ui, prevUI);
        this.modalSetRestoreRequests.add(srr);
        this.setGlobalDownloadUI(ui);
        return new IRestorePrevious(){

            @Override
            public void restore() {
                DownloadUI.this.setGlobalDownloadUI(srr.getPrevUI());
                DownloadUI.this.modalSetRestoreRequests.remove(srr);
                DownloadUI.this.onRestoredModalRequest();
            }
        };
    }

    public IRestorePrevious setThreadInheritedUI(IDownloadUI ui) {
        IDownloadUI newUI = ui != null ? ui : NullUI;
        final IDownloadUI prevUI = (IDownloadUI)DownloadContextThreadLocalInheritedAndGlobal.getThreadContext().put(KEY_DOWNLOAD_UI, newUI);
        IRestorePrevious prevCallback = new IRestorePrevious(){

            @Override
            public void restore() {
                DownloadContextThreadLocalInheritedAndGlobal.getThreadContext().put(DownloadUI.KEY_DOWNLOAD_UI, prevUI);
            }
        };
        return prevCallback;
    }

    private synchronized void onRestoredModalRequest() {
        if (this.modalSetRestoreRequests.isEmpty()) {
            final IDownloadUI prevUI = this.getGlobalDownloadUI();
            IRestorePrevious prevCallback = new IRestorePrevious(){

                @Override
                public void restore() {
                    DownloadUI.this.setGlobalDownloadUI(prevUI);
                }
            };
            for (AsyncSetRestoreUIRequest asyncSR : this.asyncSetRestoreRequests) {
                this.setGlobalDownloadUI(asyncSR.getUI());
                asyncSR.getCallback().setPtr(prevCallback);
            }
            this.asyncSetRestoreRequests.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IDownloadUI getGlobalDownloadUI() {
        DownloadContext globalContext;
        DownloadContext downloadContext = globalContext = DownloadContextThreadLocalInheritedAndGlobal.getGlobalContext();
        synchronized (downloadContext) {
            return DownloadUI.getDownloadUI(globalContext);
        }
    }

    public static IDownloadUI getThreadDownloadUI() {
        return DownloadUI.getDownloadUI(DownloadContextThreadLocalInheritedAndGlobal.getThreadContext());
    }

    public static IDownloadUI getDownloadUI(IDownloadContext ctxt) {
        return (IDownloadUI)ctxt.get(KEY_DOWNLOAD_UI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setGlobalDownloadUI(IDownloadUI ui) {
        IDownloadUI prevUI;
        DownloadContext globalContext;
        DownloadContext downloadContext = globalContext = DownloadContextThreadLocalInheritedAndGlobal.getGlobalContext();
        synchronized (downloadContext) {
            IDownloadUI newUI = ui != null ? ui : NullUI;
            prevUI = (IDownloadUI)globalContext.put(KEY_DOWNLOAD_UI, newUI);
        }
        if (prevUI == this.getGlobalDownloadUI() || ui != null) {
            // empty if block
        }
    }

    private static class AsyncSetRestoreUIRequest {
        private final IDownloadUI ui;
        private final PtrToIRestorePreviousUI callback;

        public AsyncSetRestoreUIRequest(IDownloadUI ui) {
            this.ui = ui;
            this.callback = new PtrToIRestorePreviousUI(null);
        }

        public IDownloadUI getUI() {
            return this.ui;
        }

        public PtrToIRestorePreviousUI getCallback() {
            return this.callback;
        }
    }

    public static class CancelMonitorDownloadUI
    implements ICancelDownloadUI {
        private final boolean autoRetryOnTimeoutOnly;
        private boolean canceled;
        private final IHasIsCanceled cancelMonitor;
        private final boolean cancelMonitorHasUserAttention;

        public CancelMonitorDownloadUI(IHasIsCanceled cancelMonitor, boolean autoRetryOnTimeoutOnly, boolean cancelMonitorHasUserAttention) {
            this.cancelMonitor = cancelMonitor;
            this.canceled = false;
            this.autoRetryOnTimeoutOnly = autoRetryOnTimeoutOnly;
            this.cancelMonitorHasUserAttention = cancelMonitorHasUserAttention;
        }

        public CancelMonitorDownloadUI(final IProgressMonitor monitor, boolean autoRetryOnTimeoutOnly, boolean cancelMonitorHasUserAttention) {
            this(new IHasIsCanceled(){

                @Override
                public boolean isCanceled() {
                    return monitor.isCanceled();
                }
            }, autoRetryOnTimeoutOnly, cancelMonitorHasUserAttention);
        }

        @Override
        public synchronized boolean isCanceled() {
            if (this.canceled) {
                return true;
            }
            return this.cancelMonitor.isCanceled();
        }

        @Override
        public synchronized void cancel() {
            this.canceled = true;
        }

        @Override
        public boolean cancelMonitorHasUserAttention() {
            return this.cancelMonitorHasUserAttention;
        }

        @Override
        public boolean autoRetryOnTimeoutOnly() {
            return this.autoRetryOnTimeoutOnly;
        }
    }

    public static interface ICancelDownloadUI
    extends IDownloadUI,
    ICancelable {
        @Override
        public boolean isCanceled();

        @Override
        public void cancel();

        public boolean cancelMonitorHasUserAttention();
    }

    private static class PtrToIRestorePreviousUI
    implements IRestorePrevious {
        private IRestorePrevious ptr;

        public PtrToIRestorePreviousUI(IRestorePrevious ptr) {
            this.ptr = ptr;
        }

        public void setPtr(IRestorePrevious ptr) {
            this.ptr = ptr;
        }

        @Override
        public void restore() {
            this.ptr.restore();
        }
    }

    public static class SetRestoreCancelMonitorDownloadUI {
        private final IRestorePrevious restoreUI;

        public SetRestoreCancelMonitorDownloadUI(IProgressMonitor monitor) {
            this(monitor, true, true);
        }

        public SetRestoreCancelMonitorDownloadUI(IProgressMonitor monitor, boolean autoRetryOnTimeoutOnly, boolean cancelMonitorHasUserAttention) {
            this.restoreUI = INSTANCE.setRestoreUIRequest(new CancelMonitorDownloadUI(monitor, autoRetryOnTimeoutOnly, cancelMonitorHasUserAttention), false);
        }

        public void restorePreviousDownloadUI() {
            this.restoreUI.restore();
        }
    }

    static class SetRestoreRecord {
        private final IDownloadUI activeUI;
        private final IDownloadUI prevUI;

        public SetRestoreRecord(IDownloadUI activeUI, IDownloadUI prevUI) {
            this.activeUI = activeUI;
            this.prevUI = prevUI;
        }

        public IDownloadUI getActiveUI() {
            return this.activeUI;
        }

        public IDownloadUI getPrevUI() {
            return this.prevUI;
        }
    }

    public static class SetRestoreThreadCancelMonitorDownloadUI {
        private final IRestorePrevious restoreUI;

        public SetRestoreThreadCancelMonitorDownloadUI(IProgressMonitor monitor) {
            this(monitor, true, true);
        }

        public SetRestoreThreadCancelMonitorDownloadUI(IProgressMonitor monitor, boolean autoRetryOnTimeoutOnly, boolean cancelMonitorHasUserAttention) {
            this.restoreUI = INSTANCE.setThreadInheritedUI(new CancelMonitorDownloadUI(monitor, autoRetryOnTimeoutOnly, cancelMonitorHasUserAttention));
        }

        public void restorePreviousDownloadUI() {
            this.restoreUI.restore();
        }
    }
}

