/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

import com.ibm.cic.common.core.artifactrepo.impl.ContentInfoUtil;
import com.ibm.cic.common.downloads.DigestUtil;

public class DigestValue {
    private final String algorithm;
    private final byte[] digest;

    public DigestValue(String algorithm, String digestString) {
        this(algorithm, DigestUtil.hexStringToBytes(digestString));
    }

    public DigestValue(String algorithm, byte[] digest) {
        assert (algorithm != null);
        assert (digest != null);
        this.digest = digest;
        this.algorithm = algorithm.toLowerCase();
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getDigestBytesCopy() {
        byte[] copy = new byte[this.digest.length];
        System.arraycopy(this.digest, 0, copy, 0, this.digest.length);
        return copy;
    }

    public String getDigestAsString() {
        return DigestUtil.bytesToHexString(this.digest);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DigestValue) {
            DigestValue dv = (DigestValue)obj;
            return dv.getAlgorithm().equalsIgnoreCase(this.algorithm) && ContentInfoUtil.isEqual(dv.digest, this.digest);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.algorithm.hashCode();
        byte[] byArray = this.digest;
        int n = this.digest.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            hash = hash * 17 + b;
            ++n2;
        }
        return hash;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("algorithm=");
        sb.append(this.algorithm);
        sb.append(" digest=");
        sb.append(DigestUtil.bytesToHexString(this.digest));
        return sb.toString();
    }
}

