/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

import com.ibm.cic.common.core.internal.downloads.HostInfoCredentials;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.downloads.AbstractHostInfo;
import com.ibm.cic.common.downloads.CredentialRequested;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class CredentialTarget {
    private final URI uri;
    private final URL url;
    private final String realm;
    private final String authScheme;
    private static final String EMPTY_STRING = "";

    public static CredentialTarget makeFromRequest(CredentialRequested requested) {
        if (requested.isProxy().booleanValue()) {
            return HostInfoCredentials.getCredentialTargetForProxyRequest(requested);
        }
        return HostInfoCredentials.getCredentialTargetForHostRequest(requested);
    }

    public static CredentialTarget makeFromRequest1003(AbstractHostInfo hostInfo, CredentialRequested requested) {
        if (requested.isProxy().booleanValue()) {
            return HostInfoCredentials.getCredentialTargetForProxyRequest1003(hostInfo, requested);
        }
        return HostInfoCredentials.getCredentialTargetForHostRequest1003(requested);
    }

    public CredentialTarget(URL url, String realm, String authScheme) {
        URL tempUrl;
        this.url = url;
        try {
            this.uri = url.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        try {
            tempUrl = this.uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new AssertionError();
        }
        assert (this.url.toString().equals(tempUrl.toString()));
        this.realm = realm == null ? EMPTY_STRING : realm;
        this.authScheme = authScheme == null ? EMPTY_STRING : authScheme;
    }

    public String getAuthScheme() {
        return this.authScheme;
    }

    public String getRealm() {
        return this.realm;
    }

    public URL getUrl() {
        return this.url;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CredentialTarget)) {
            return false;
        }
        CredentialTarget rhs = (CredentialTarget)obj;
        return rhs.uri.equals(this.uri) && rhs.realm.equals(this.realm) && rhs.authScheme.equals(this.authScheme);
    }

    public int hashCode() {
        return Util.hashCode(this.uri, this.realm, this.authScheme);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("CredentialTarget url='");
        sb.append(this.uri.toString());
        sb.append("' realm=");
        sb.append(this.realm);
        sb.append("' authScheme='");
        sb.append(this.authScheme);
        sb.append("'");
        return sb.toString();
    }
}

