/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

public class XMLUtil {
    protected static final String NO_INDENT = "";

    public static DocumentBuilderFactory createDocumentBuilderFactory() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        return dbf;
    }

    public static String escape(String x) {
        if (x == null) {
            return null;
        }
        int i = x.length() - 1;
        while (i >= 0) {
            block11: {
                String replace;
                block10: {
                    char c;
                    block9: {
                        c = x.charAt(i);
                        if (c >= ' ' && c != '\u007f') break block9;
                        replace = "&#" + Integer.toString(c) + ";";
                        break block10;
                    }
                    switch (c) {
                        case '<': {
                            replace = "&lt;";
                            break;
                        }
                        case '>': {
                            replace = "&gt;";
                            break;
                        }
                        case '\"': {
                            replace = "&quot;";
                            break;
                        }
                        case '\'': {
                            replace = "&apos;";
                            break;
                        }
                        case '&': {
                            replace = "&amp;";
                            break;
                        }
                        default: {
                            break block11;
                        }
                    }
                }
                x = String.valueOf(x.substring(0, i)) + replace + x.substring(i + 1);
            }
            --i;
        }
        return x;
    }

    public static boolean isAttributeTrue(String value) {
        return value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes");
    }

    public static boolean isAttributeFalse(String value) {
        return value.equalsIgnoreCase("false") || value.equalsIgnoreCase("no");
    }

    public static String simpleElement(String elementName, String[] attrNameValuePairs) {
        StringBuffer buffer = new StringBuffer();
        XMLUtil.simpleElement(elementName, attrNameValuePairs, buffer, NO_INDENT);
        return buffer.toString();
    }

    public static void simpleElement(String elementName, String[] attrNameValuePairs, StringBuffer buffer, String indent) {
        XMLUtil.element(elementName, attrNameValuePairs, buffer, indent, "/>");
    }

    public static void openElement(String elementName, String[] attrNameValuePairs, StringBuffer buffer, String indent) {
        XMLUtil.element(elementName, attrNameValuePairs, buffer, indent, ">");
    }

    public static void unterminatedElement(String elementName, String[] attrNameValuePairs, StringBuffer buffer, String indent) {
        buffer.append(indent).append('<').append(elementName);
        String attrPrefix = " ";
        int totalLen = buffer.length() + 1;
        String[] stringArray = attrNameValuePairs;
        int n = attrNameValuePairs.length;
        int n2 = 0;
        while (n2 < n) {
            String next = stringArray[n2];
            if (next != null && (totalLen += next.length() + 2) >= 72) {
                attrPrefix = String.valueOf('\n') + indent + "  ";
                break;
            }
            ++n2;
        }
        int i = 0;
        while (i < attrNameValuePairs.length) {
            String value;
            String name;
            if ((name = attrNameValuePairs[i++]).length() <= 0 || (value = attrNameValuePairs[i++]) == null) continue;
            buffer.append(attrPrefix).append(name);
            buffer.append("='").append(XMLUtil.escape(value)).append('\'');
        }
    }

    private static void element(String elementName, String[] attrNameValuePairs, StringBuffer buffer, String indent, String termination) {
        XMLUtil.unterminatedElement(elementName, attrNameValuePairs, buffer, indent);
        buffer.append(termination);
    }

    private XMLUtil() {
    }
}

