/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.Messages;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.ExceptionUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class SharedFileLock {
    private final File lockingFile;
    private RandomAccessFile raf;
    private FileLock fileLock;
    private static final String FilePermissions = "rw";

    public SharedFileLock(File file) {
        this.lockingFile = file;
        this.raf = null;
        this.fileLock = null;
        File dir = file.getParentFile();
        if (dir != null) {
            dir.mkdirs();
        }
    }

    public synchronized IStatus acquire() {
        block17: {
            if (this.fileLock != null) {
                return Status.OK_STATUS;
            }
            try {
                this.raf = new RandomAccessFile(this.lockingFile, FilePermissions);
                this.fileLock = this.raf.getChannel().tryLock();
            }
            catch (OverlappingFileLockException overlappingFileLockException) {
                if (this.fileLock != null || this.raf == null) break block17;
                try {
                    this.raf.close();
                }
                catch (IOException e) {
                    ExceptionUtil.debugLogIOException(e);
                }
                this.raf = null;
                break block17;
            }
            catch (IOException ioe) {
                try {
                    this.fileLock = null;
                    ICicStatus iCicStatus = Statuses.ERROR.get(6201, ioe, Messages.SharedFileLock_could_not_acquire_lock, this.lockingFile.getPath());
                    return iCicStatus;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (this.fileLock == null && this.raf != null) {
                        try {
                            this.raf.close();
                        }
                        catch (IOException e) {
                            ExceptionUtil.debugLogIOException(e);
                        }
                        this.raf = null;
                    }
                }
            }
            if (this.fileLock != null || this.raf == null) break block17;
            try {
                this.raf.close();
            }
            catch (IOException e) {
                ExceptionUtil.debugLogIOException(e);
            }
            this.raf = null;
        }
        return this.fileLock != null ? Status.OK_STATUS : Statuses.ERROR.get(6201, Messages.SharedFileLock_could_not_acquire_lock, this.lockingFile.getPath());
    }

    public synchronized void release() {
        if (this.fileLock != null) {
            try {
                this.fileLock.release();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.raf.close();
            }
            catch (IOException e) {
                ExceptionUtil.debugLogIOException(e);
            }
            this.fileLock = null;
            this.raf = null;
            this.lockingFile.delete();
        }
    }
}

