/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import com.ibm.cic.common.core.definitions.CommonDef;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.utils.DeviceSystem;
import com.ibm.cic.common.core.utils.EclipseUtil;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.Messages;
import com.ibm.cic.common.core.utils.NativeUtils;
import com.ibm.cic.common.core.utils.PPPlatformUtils;
import com.ibm.cic.common.core.utils.PassOutputThruThread;
import com.ibm.cic.common.core.utils.PathUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.UserOptions;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;

public class PlatformUtils {
    public static final String SPECIAL_FOLDER_PROGRAM_FILES = "PROGRAM_FILES";
    public static final String SPECIAL_FOLDER_PROGRAM_FILES_COMMON = "PROGRAM_FILES_COMMON";
    public static final String SPECIAL_FOLDER_COMMON_APPDATA = "COMMON_APPDATA";
    public static final String SPECIAL_FOLDER_APPDATA = "APPDATA";
    public static final String SPECIAL_FOLDER_WINDOWS = "WINDOWS";
    public static final String SPECIAL_FOLDER_OS400_PROGRAM_FILES = "OS400_PROGRAM_FILES";
    public static final String SPECIAL_FOLDER_OS400_APPDATA = "OS400_APPDATA";
    public static final String SPECIAL_FOLDER_ZOS_PROGRAM_FILES = "ZOS_PROGRAM_FILES";
    public static final String SPECIAL_FOLDER_ZOS_COMMON_APPDATA = "ZOS_COMMON_APPDATA";
    public static final String SPECIAL_FOLDER_ZOS_APPDATA = "ZOS_APPDATA";
    public static final String AGENT_RELAUNCHED_PROPERTY = "cic.agentRelaunched";
    public static final String VARIABLE_PREFIX = "${";
    public static final String VARIABLE_SUFFIX = "}";
    public static final String DEFAULT_INSTALL_ROOT_LOCATION_VAR = "defaultInstallRootLocation";
    static final Logger log = Logger.getLogger(PlatformUtils.class);
    private static String defaultInstallRootLocation = null;

    private PlatformUtils() {
        assert (false) : "no instances";
    }

    private static IPath resolve(URL url) {
        Path result;
        String device;
        String path;
        try {
            URL resolvedUrl = FileLocator.resolve((URL)url);
            path = resolvedUrl.getFile();
            if ("jar".equals(resolvedUrl.getProtocol()) && path.startsWith("file:") && path.endsWith(".jar!/")) {
                path = path.substring(5, path.length() - 2);
            }
        }
        catch (Throwable t) {
            log.error(t, String.valueOf(url.toString()) + ": " + t.toString(), new Object[0]);
            return null;
        }
        if (File.separatorChar != '/' && path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((device = (result = new Path(path)).getDevice()) != null) {
            result = result.setDevice(device.toUpperCase());
        }
        return result;
    }

    public static String getInstallLocation(Bundle bundle) {
        IPath installPath;
        block4: {
            try {
                installPath = PlatformUtils.resolve(bundle.getEntry("/"));
                if (installPath != null) break block4;
                return null;
            }
            catch (Throwable t) {
                log.error(t, String.valueOf(bundle.getSymbolicName()) + ": " + t.toString(), new Object[0]);
                return null;
            }
        }
        String path = installPath.toOSString();
        if (path.endsWith(File.separator)) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static int runProcess(String[] args, String[] env, File workingDirectory, Writer out, Writer err) {
        try {
            return PlatformUtils.doRunProcess(args, env, workingDirectory, out, err);
        }
        catch (Throwable t) {
            log.error(t, t.toString(), new Object[0]);
            PlatformUtils.debugWorkItem40492(t);
            return -1;
        }
    }

    private static void debugWorkItem40492(Throwable t) {
        if (log.isDebugLoggable()) {
            StringBuilder buf = new StringBuilder();
            buf.append("Stack trace: Unavailable").append(CommonDef.EOL);
            buf.append(PlatformUtils.getStackTrace("Current stack trace: "));
            log.debug(buf.toString());
        }
    }

    private static String getStackTrace(String heading) {
        StackTraceElement[] stack;
        StringBuilder buf = new StringBuilder();
        buf.append(heading);
        StackTraceElement[] stackTraceElementArray = stack = Thread.currentThread().getStackTrace();
        int n = stack.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            buf.append(CommonDef.EOL).append("\tat").append(" ").append(element);
            ++n2;
        }
        return buf.toString();
    }

    private static int doRunProcess(String[] args, String[] env, File workingDirectory, Writer out, Writer err) throws IOException {
        int status;
        log.debug(PlatformUtils.toLoggableMessage(args, env, workingDirectory));
        Process p = Runtime.getRuntime().exec(args, env, workingDirectory);
        try {
            p.getOutputStream().close();
        }
        catch (IOException e) {
            log.status(Statuses.INFO.get(e, Messages.PlatformUtils_outputStreamCloseException, args[0], workingDirectory));
        }
        PassOutputThruThread outThread = new PassOutputThruThread(p.getInputStream(), out);
        PassOutputThruThread errThread = new PassOutputThruThread(p.getErrorStream(), err);
        while (true) {
            try {
                status = p.waitFor();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        outThread.finish();
        errThread.finish();
        log.debug("Exit value: {0}", status);
        return status;
    }

    private static String toLoggableMessage(String[] args, String[] env, File workingDirectory) {
        if (!log.isDebugLoggable()) {
            return "";
        }
        StringBuilder message = new StringBuilder();
        message.append("Running command: ");
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            message.append(arg).append(" ");
            ++n2;
        }
        if (env != null) {
            message.append(CommonDef.EOL).append("Environment:");
            stringArray = env;
            n = env.length;
            n2 = 0;
            while (n2 < n) {
                String var = stringArray[n2];
                message.append(CommonDef.EOL).append("\t").append(var);
                ++n2;
            }
        }
        if (workingDirectory != null) {
            message.append(CommonDef.EOL).append("Working directory: ").append(workingDirectory.getAbsolutePath());
        }
        return message.toString();
    }

    public static String getLocationDevice(String location) {
        if (location == null) {
            return "";
        }
        File path = DeviceSystem.getMountPoint(new File(location));
        if (path == null) {
            return "";
        }
        String absolutePath = path.getAbsolutePath();
        if (absolutePath.length() > 1 && absolutePath.endsWith(File.separator)) {
            return absolutePath.substring(0, absolutePath.length() - 1);
        }
        return absolutePath;
    }

    public static Properties getEnvironmentVariables() {
        return (Properties)PPPlatformUtils.getPolicy().getEnvironmentVariables().clone();
    }

    public static String[] getEnvironmentVariablesArg(Properties envvars) {
        ArrayList<String> result = new ArrayList<String>(envvars.size());
        for (String name : envvars.stringPropertyNames()) {
            String value = envvars.getProperty(name);
            result.add(String.valueOf(name) + '=' + value);
        }
        return result.toArray(new String[result.size()]);
    }

    public static void disableErrorOutput() {
        if (!UserOptions.CIC_ENABLE_LAUNCHER_ERROR_OUTPUT.isSet()) {
            System.setProperty("eclipse.exitdata", "");
        }
    }

    public static void setGroupBitUmaskForCurrentIMProcess() {
        boolean GROUP_BIT_OF_UMASK = false;
        int operand1 = 56;
        int operand2 = 4039;
        int umaskToSet = -1;
        int currentUmask = PlatformUtils.getUmask();
        int groupBitOfCurrentUmask = currentUmask & operand1;
        if (groupBitOfCurrentUmask != 0) {
            PlatformUtils.setGroupPermsOnEclipseConfigDir();
            umaskToSet = currentUmask & operand2;
            if (umaskToSet == 0) {
                umaskToSet |= 2;
            }
        } else if (currentUmask == 0) {
            umaskToSet = 2;
        }
        if (umaskToSet > 0) {
            PlatformUtils.setUmask(umaskToSet);
            Logger.getGlobalLogger().info(Messages.GroupMode_SettingUmask, String.format("%04o", currentUmask), String.format("%04o", umaskToSet));
        }
    }

    public static boolean updateUmaskforCurrentIMProcess(int oldUmask, int newUmask) {
        boolean result = false;
        int currentUmask = PlatformUtils.getUmask();
        if (newUmask < 0 || newUmask > 511) {
            log.status(Statuses.WARNING.get(Messages.UpdateUmaskBadValue, String.format("%04o", newUmask)));
        } else if (oldUmask == -1 || currentUmask == oldUmask) {
            result = PlatformUtils.setUmask(newUmask) > -1;
            Logger.getGlobalLogger().info(Messages.UpdateUmask, String.format("%04o", currentUmask), String.format("%04o", newUmask));
        }
        return result;
    }

    private static void setGroupPermsOnEclipseConfigDir() {
        if (EclipseUtil.isEclipseConfigOsgiDirWriteable()) {
            String eclipseConfigDirPerms = "g=u";
            PlatformUtils.chmod(new String[]{EclipseUtil.getCurrentEclipseConfiguration().getAbsolutePath()}, "g=u", true, null, FileUtil.NULL_WRITER);
        }
    }

    public static void setGroupPermsOnEclipseWorkspaceDir() {
        if (EclipseUtil.getCurrentEclipseWorkspace().exists()) {
            String eclipseConfigDirPerms = "g=u";
            PlatformUtils.chmod(new String[]{EclipseUtil.getCurrentEclipseWorkspace().getAbsolutePath()}, "g=u", true, null, FileUtil.NULL_WRITER);
        }
    }

    public static String[] getEnvironmentVariablesArg() {
        return PlatformUtils.getEnvironmentVariablesArg(PPPlatformUtils.getPolicy().getEnvironmentVariables());
    }

    public static String getEnvironmentVariable(String key) {
        return PPPlatformUtils.getPolicy().getEnvironmentVariable(key);
    }

    public static boolean areSameDirectories(String dir1, String dir2) {
        return PPPlatformUtils.getPolicy().areSameDirectories(dir1, dir2);
    }

    public static int getMaxInstallLocationLengthForOffering(IOffering offering) {
        return PPPlatformUtils.getPolicy().getMaxInstallLocationLengthForOffering(offering);
    }

    public static int getMaxCacheLocationLengthForOffering(IOffering offering) {
        return PPPlatformUtils.getPolicy().getMaxCacheLocationLengthForOffering(offering);
    }

    public static boolean isSymlink(File path) {
        return NativeUtils.nativeGetLinkType(path.getAbsolutePath()) == 1;
    }

    public static int createSymlink(String target, String link) {
        return PPPlatformUtils.getPolicy().createSymlink(target, link);
    }

    public static int getUmask() {
        return PPPlatformUtils.getPolicy().getUmask();
    }

    public static int setUmask(int mask) {
        return PPPlatformUtils.getPolicy().setUmask(mask, null, null);
    }

    public static String getOwningGroupForFile(String path, boolean resolvePath) {
        return PPPlatformUtils.getPolicy().getOwningGroupForFile(path, resolvePath);
    }

    public static String getEffectiveGroupForProcess() {
        return PPPlatformUtils.getPolicy().getEffectiveGroupForProcess();
    }

    public static IStatus validateFileName(String filename) {
        return PPPlatformUtils.getPolicy().validateFileName(filename, false);
    }

    public static IStatus validatePath(String path) {
        return PPPlatformUtils.getPolicy().validatePath(path);
    }

    public static int chmod(String[] fileList, String perm, boolean recursive) {
        return PlatformUtils.chmod(fileList, perm, recursive, null, null);
    }

    public static int chmod(String[] fileList, String perm, boolean recursive, Writer out, Writer err) {
        boolean SHELL_SYNTAX_DEFAULT = true;
        return PlatformUtils.chmod(fileList, perm, recursive, true, out, err);
    }

    public static int chmod(String[] fileList, String perm, boolean recursive, boolean shellSyntax, Writer out, Writer err) {
        return PPPlatformUtils.getPolicy().chmod(fileList, perm, recursive, shellSyntax, out, err);
    }

    public static boolean reboot() {
        return PPPlatformUtils.getPolicy().reboot();
    }

    public static String getDefaultInstallLocation(IOffering offering) {
        return PPPlatformUtils.getPolicy().getOS().getDefaultInstallLocation(offering);
    }

    public static String getDefaultSharedLocation(IOffering offering) {
        return PPPlatformUtils.getPolicy().getOS().getDefaultSharedLocation(offering);
    }

    public static String getDefaultInstallRootLocation(boolean for64bit) {
        if (defaultInstallRootLocation != null) {
            return defaultInstallRootLocation;
        }
        if (CicCommonSettings.getAccessRightsMode().isAdminMode()) {
            return PPPlatformUtils.getPolicy().getAdminInstallRootLocation(for64bit);
        }
        if (CicCommonSettings.getAccessRightsMode().isGroupMode()) {
            return PPPlatformUtils.getPolicy().getGroupInstallRootLocation();
        }
        return PPPlatformUtils.getPolicy().getUserInstallRootLocation();
    }

    public static String setDefaultInstallRootLocation(String location) {
        String result = defaultInstallRootLocation;
        defaultInstallRootLocation = location;
        return result;
    }

    public static String variableRef(String varName) {
        return VARIABLE_PREFIX + varName + VARIABLE_SUFFIX;
    }

    public static String getDefaultDataLocation() {
        return PPPlatformUtils.getPolicy().getDefaultDataLocation();
    }

    public static File getLauncherLocation(String installLocation) {
        return PPPlatformUtils.getPolicy().getLauncherLocation(new File(installLocation));
    }

    public static File getLauncherLocation(File installLocation) {
        return PPPlatformUtils.getPolicy().getLauncherLocation(installLocation);
    }

    public static File deduceInstallLocation(File launcherLocation) {
        return PPPlatformUtils.getPolicy().deduceInstallLocation(launcherLocation);
    }

    public static String getSpecialFolder(String variableArg) {
        return PlatformUtils.getSpecialFolder(variableArg, false);
    }

    public static String getSpecialFolder(String variableArg, boolean for64bit) {
        return PPPlatformUtils.getPolicy().getSpecialFolder(variableArg, for64bit);
    }

    public static boolean is64bitOS() {
        if (UserOptions.CIC_IS_64_BIT_OS.isSet()) {
            return true;
        }
        return PPPlatformUtils.getPolicy().is64bitOS();
    }

    public static boolean isJRE6() {
        return System.getProperty("java.version").startsWith("1.6");
    }

    public static enum OS {
        DEFAULT("", null, "default.location", "default.user.location", "default.group.location", "default.commonlocation", "default.user.commonlocation", "default.group.commonlocation"),
        WIN32("win32", DEFAULT, "default.location.win32", "default.user.location.win32", "default.commonlocation.win32", "default.user.commonlocation.win32"),
        WIN32_VISTA("win32_vista", WIN32, "default.location.win32.vista", "default.user.location.win32.vista", "default.commonlocation.win32.vista", "default.user.commonlocation.win32.vista"),
        LINUX("linux", DEFAULT, "default.location.linux", "default.user.location.linux", "default.group.location.linux", "default.commonlocation.linux", "default.user.commonlocation.linux", "default.group.commonlocation.linux"),
        SOLARIS("solaris", LINUX, "default.location.solaris", "default.user.location.solaris", "default.group.location.solaris", "default.commonlocation.solaris", "default.user.commonlocation.solaris", "default.group.commonlocation.solaris"),
        AIX("aix", LINUX, "default.location.aix", "default.user.location.aix", "default.group.location.aix", "default.commonlocation.aix", "default.user.commonlocation.aix", "default.group.commonlocation.aix"),
        MACOSX("macosx", LINUX, "default.location.macosx", "default.user.location.macosx", "default.commonlocation.macosx", "default.user.commonlocation.macosx"),
        HPUX("hpux", LINUX, "default.location.hpux", "default.user.location.hpux", "default.group.location.hpux", "default.commonlocation.hpux", "default.user.commonlocation.hpux", "default.group.commonlocation.hpux"),
        ZOS("zos", LINUX, "default.location.zos", "default.user.location.zos", "default.group.location.zos", "default.commonlocation.zos", "default.user.commonlocation.zos", "default.group.commonlocation.zos"),
        OS400("os400", LINUX, "default.location.os400", "default.user.location.os400", "default.commonlocation.os400", "default.user.commonlocation.os400");

        private final String name;
        private final OS parentOS;
        private final EnumMap<CicCommonSettings.AccessRights, String> installProps = new EnumMap(CicCommonSettings.AccessRights.class);
        private final EnumMap<CicCommonSettings.AccessRights, String> sharedProps = new EnumMap(CicCommonSettings.AccessRights.class);

        public static Iterable<OS> getValues() {
            ArrayList<OS> result = new ArrayList<OS>(OS.values().length);
            OS[] oSArray = OS.values();
            int n = oSArray.length;
            int n2 = 0;
            while (n2 < n) {
                OS os = oSArray[n2];
                if (os != DEFAULT) {
                    result.add(os);
                }
                ++n2;
            }
            return result;
        }

        private OS(String name, OS parentOS, String adminInstall, String userInstall, String adminShared, String userShared) {
            this(name, parentOS, adminInstall, userInstall, null, adminShared, userShared, null);
        }

        private OS(String name, OS parentOS, String adminInstall, String userInstall, String groupInstall, String adminShared, String userShared, String groupShared) {
            this.name = name;
            this.parentOS = parentOS;
            this.installProps.put(CicCommonSettings.AccessRights.ADMIN_MODE, adminInstall);
            this.installProps.put(CicCommonSettings.AccessRights.GROUP_MODE, groupInstall);
            this.installProps.put(CicCommonSettings.AccessRights.NON_ADMIN_MODE, userInstall);
            this.sharedProps.put(CicCommonSettings.AccessRights.ADMIN_MODE, adminShared);
            this.sharedProps.put(CicCommonSettings.AccessRights.GROUP_MODE, groupShared);
            this.sharedProps.put(CicCommonSettings.AccessRights.NON_ADMIN_MODE, userShared);
        }

        public String toString() {
            return this.name;
        }

        public boolean isWindows() {
            return this == WIN32 || this == WIN32_VISTA;
        }

        public String getDefaultInstallLocation(IOffering offering) {
            if (offering == null) {
                return "";
            }
            String location = null;
            OS os = this;
            while (os != null && location == null) {
                location = this.getLocation(offering, os.installProps);
                os = os.parentOS;
            }
            if (location == null && (location = offering.getProperty("default.location")) == null) {
                location = offering.getProperty("default.profile");
            }
            return this.fixLocation(offering, location, true);
        }

        public String getDefaultSharedLocation(IOffering offering) {
            if (offering == null) {
                return "";
            }
            String location = null;
            OS os = this;
            while (os != null && location == null) {
                location = this.getLocation(offering, os.sharedProps);
                os = os.parentOS;
            }
            if (location == null) {
                location = offering.getProperty("default.commonlocation");
            }
            return this.fixLocation(offering, location, false);
        }

        public String getOsDefaultInstallLocation(IOffering offering) {
            String location = this.getLocation(offering, this.installProps);
            return this.fixLocation(offering, location, true);
        }

        public String getOsDefaultSharedLocation(IOffering offering) {
            String location = this.getLocation(offering, this.sharedProps);
            return this.fixLocation(offering, location, false);
        }

        public String getSharedLocationProperty(CicCommonSettings.AccessRights accessRights) {
            return this.sharedProps.get((Object)accessRights);
        }

        private String fixLocation(IOffering offering, String location, boolean isInstall) {
            if (location == null) {
                return "";
            }
            if (CicCommonSettings.isBeta()) {
                location = this.appendIfIm(offering, location, String.valueOf(this.isWindows() ? " " : "") + CicCommonSettings.getBetaProperty());
            }
            if (isInstall && this != ZOS && CicCommonSettings.getAccessRightsMode().isGroupMode()) {
                location = this.appendIfIm(offering, location, CicCommonSettings.getGroupProperty());
            }
            if (!this.isAbsolute(location)) {
                location = String.valueOf(PlatformUtils.variableRef(PlatformUtils.DEFAULT_INSTALL_ROOT_LOCATION_VAR)) + '/' + location;
            }
            return location;
        }

        private String appendIfIm(IOffering offering, String path, String suffix) {
            if (path.isEmpty() || !"com.ibm.cic.agent".equals(offering.getIdentity().getId())) {
                return path;
            }
            String simple = PathUtil.getSimpleName(path);
            if (simple.equalsIgnoreCase("eclipse") || simple.equalsIgnoreCase("eclipse}")) {
                String parent = PathUtil.removeSimpleName(path);
                return String.valueOf(this.appendIfIm(offering, parent, suffix)) + '/' + simple;
            }
            return String.valueOf(path) + suffix;
        }

        private boolean isAbsolute(String path) {
            if (path.startsWith(PlatformUtils.VARIABLE_PREFIX)) {
                return true;
            }
            if (!this.isWindows()) {
                return path.startsWith("/");
            }
            if (path.startsWith("//") || path.startsWith("\\\\")) {
                return true;
            }
            if (path.length() < 2) {
                return false;
            }
            return path.charAt(1) == ':' && (path.charAt(2) == '\\' || path.charAt(2) == '/');
        }

        private String getLocation(IOffering offering, EnumMap<CicCommonSettings.AccessRights, String> props) {
            return offering.getProperty(props.get((Object)CicCommonSettings.getAccessRightsMode()));
        }
    }
}

