/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import com.ibm.cic.common.core.definitions.CommonDef;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.repository.CicFileLocation;
import com.ibm.cic.common.core.utils.AbstractPlatformPolicyFactory;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.Messages;
import com.ibm.cic.common.core.utils.NIOChmodEngine;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.NativeUtils;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.UnsupportedOperationException;
import com.ibm.cic.common.core.utils.UserOptions;
import com.ibm.cic.common.logging.ExceptionUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

class PPPlatformUtils
extends AbstractPlatformPolicyFactory {
    private static final PPPlatformUtils INSTANCE = new PPPlatformUtils();

    PPPlatformUtils() {
    }

    @Override
    protected Object createLinuxPolicy() {
        return new PPLinux();
    }

    @Override
    protected Object createSolarisPolicy() {
        return new PPSolaris();
    }

    @Override
    protected Object createAixPolicy() {
        return new PPAix();
    }

    @Override
    protected Object createHpuxPolicy() {
        return new PPHpux();
    }

    @Override
    protected Object createMacOSXPolicy() {
        return new PPMacOS();
    }

    @Override
    protected Object createWindowsPolicy() {
        return new PPWindows();
    }

    @Override
    protected Object createWindowsVistaPolicy() {
        return new PPWindowsVista();
    }

    @Override
    protected Object createZOSPolicy() {
        return new PPZOS();
    }

    @Override
    protected Object createOS400Policy() {
        return new PPOS400();
    }

    static PPCommon getPolicy() {
        return (PPCommon)INSTANCE.getPlatformPolicy();
    }

    class PPAix
    extends PPLinux {
        PPAix() {
        }

        @Override
        PlatformUtils.OS getOS() {
            return PlatformUtils.OS.AIX;
        }

        @Override
        public boolean is64bitOS() {
            StringWriter getconfCmdErr;
            StringWriter getconfCmdOut;
            String output;
            String[] psCmd = new String[]{"ps", "-e"};
            if (new File("/bin/ps").exists()) {
                psCmd[0] = "/bin/ps";
            } else if (new File("/usr/bin/ps").exists()) {
                psCmd[0] = "/usr/bin/ps";
            }
            StringWriter psCmdOut = new StringWriter(4096);
            StringWriter psCmdErr = new StringWriter();
            if (this.executeCommand(psCmd, psCmdOut, psCmdErr) && (output = psCmdOut.toString()).indexOf("shlap64") >= 0) {
                return true;
            }
            String[] getconfCmd = new String[]{"getconf", "KERNEL_BITMODE"};
            if (new File("/usr/bin/getconf").canExecute()) {
                getconfCmd[0] = "/usr/bin/getconf";
            }
            if (this.executeCommand(getconfCmd, getconfCmdOut = new StringWriter(128), getconfCmdErr = new StringWriter(128))) {
                try {
                    if (Integer.parseInt(getconfCmdOut.toString().trim()) == 64) {
                        return true;
                    }
                }
                catch (Exception e) {
                    PlatformUtils.log.error(e, "Received '{0}' from {1} {2}. Expected either '32' or '64'.", getconfCmdOut.toString().trim(), getconfCmd[0], getconfCmd[1]);
                }
            }
            return false;
        }
    }

    abstract class PPCommon {
        protected Properties environmentVariables = null;
        protected final String[] ALWAYS_INVALID_NAMES = new String[]{"", ".", ".."};

        PPCommon() {
        }

        protected Set createSet(String[] names1, String[] names2) {
            String element;
            HashSet<String> result = new HashSet<String>((names1.length + names2.length) * 4 / 3);
            String[] stringArray = names1;
            int n = names1.length;
            int n2 = 0;
            while (n2 < n) {
                element = stringArray[n2];
                result.add(element);
                ++n2;
            }
            stringArray = names2;
            n = names2.length;
            n2 = 0;
            while (n2 < n) {
                element = stringArray[n2];
                result.add(element);
                ++n2;
            }
            return result;
        }

        protected int getOfferingPropertyAsInt(IOffering offering, String property, int defaultVal) {
            String val;
            if (offering != null && (val = offering.getProperties().getProperty(property)) != null) {
                try {
                    return Integer.parseInt(val);
                }
                catch (NumberFormatException e) {
                    ExceptionUtil.debugLogIllegalArgumentException(e);
                }
            }
            return defaultVal;
        }

        protected boolean executeCommand(String[] cmdArray, StringWriter out, StringWriter err) {
            return PlatformUtils.runProcess(cmdArray, null, null, out, err) == 0;
        }

        abstract PlatformUtils.OS getOS();

        abstract Properties getEnvironmentVariables();

        abstract String getEnvironmentVariable(String var1);

        abstract boolean areSameDirectories(String var1, String var2);

        abstract int getMaxInstallLocationLengthForOffering(IOffering var1);

        abstract int getMaxCacheLocationLengthForOffering(IOffering var1);

        abstract String getConcatCharForPath();

        abstract int createSymlink(String var1, String var2);

        abstract int getUmask();

        abstract int setUmask(int var1, Writer var2, Writer var3);

        abstract int chmod(String[] var1, String var2, boolean var3, boolean var4, Writer var5, Writer var6);

        abstract IStatus validateFileName(String var1, boolean var2);

        abstract IStatus validatePath(String var1);

        abstract boolean reboot();

        abstract String getSpecialFolder(String var1, boolean var2);

        abstract boolean is64bitOS();

        abstract String getOwningGroupForFile(String var1, boolean var2);

        abstract String getEffectiveGroupForProcess();

        String getAdminInstallRootLocation(boolean for64bit) {
            return PlatformUtils.getSpecialFolder("PROGRAM_FILES", for64bit);
        }

        String getUserInstallRootLocation() {
            return System.getProperty("user.home");
        }

        String getGroupInstallRootLocation() {
            return System.getProperty("user.home");
        }

        File getLauncherLocation(File installLocation) {
            return installLocation;
        }

        File deduceInstallLocation(File launcherLocation) {
            return launcherLocation;
        }

        String getDefaultDataLocation() {
            if (CicCommonSettings.getAccessRightsMode().isAdminMode()) {
                if (CicCommonSettings.isOS400()) {
                    return PlatformUtils.getSpecialFolder("OS400_APPDATA", false);
                }
                return PlatformUtils.getSpecialFolder("COMMON_APPDATA", false);
            }
            if (CicCommonSettings.getAccessRightsMode().isGroupMode()) {
                return PlatformUtils.getSpecialFolder("APPDATA", false);
            }
            return PlatformUtils.getSpecialFolder("APPDATA", false);
        }
    }

    class PPHpux
    extends PPLinux {
        PPHpux() {
        }

        @Override
        PlatformUtils.OS getOS() {
            return PlatformUtils.OS.HPUX;
        }

        @Override
        public boolean is64bitOS() {
            String[] cmdArray = new String[]{"getconf", "KERNEL_BITS"};
            if (new File("/bin/getconf").exists()) {
                cmdArray[0] = "/bin/getconf";
            } else if (new File("/usr/bin/getconf").exists()) {
                cmdArray[0] = "/usr/bin/getconf";
            }
            StringWriter out = new StringWriter(4096);
            return this.executeCommand(cmdArray, out, out) && out.toString().startsWith("64");
        }
    }

    class PPLinux
    extends PPCommon {
        PPLinux() {
        }

        @Override
        PlatformUtils.OS getOS() {
            return PlatformUtils.OS.LINUX;
        }

        @Override
        Properties getEnvironmentVariables() {
            if (this.environmentVariables == null) {
                this.environmentVariables = new Properties();
                for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
                    this.environmentVariables.setProperty(entry.getKey(), entry.getValue());
                }
            }
            return this.environmentVariables;
        }

        @Override
        String getEnvironmentVariable(String key) {
            return this.getEnvironmentVariables().getProperty(key);
        }

        @Override
        boolean areSameDirectories(String dir1, String dir2) {
            return dir1.trim().equals(dir2.trim());
        }

        @Override
        int getMaxInstallLocationLengthForOffering(IOffering offering) {
            return this.getOfferingPropertyAsInt(offering, "maxInstallLocationPathLength.linux", 1024);
        }

        @Override
        int getMaxCacheLocationLengthForOffering(IOffering offering) {
            return this.getOfferingPropertyAsInt(offering, "maxCacheLocationPathLength.linux", 1024);
        }

        @Override
        int createSymlink(String target, String link) {
            return NativeUtils.createSymlink(target, link);
        }

        @Override
        int getUmask() {
            return NativeUtils.getUmask();
        }

        @Override
        int setUmask(int mask, Writer out, Writer err) {
            return NativeUtils.setUmask(mask);
        }

        @Override
        String getOwningGroupForFile(String path, boolean resolvePath) {
            File fPath;
            String groupname = null;
            if (path != null && (fPath = new File(path)).exists()) {
                groupname = NativeUtils.getFileGroup(resolvePath ? FileUtil.getCanonicalPath(fPath) : fPath.getPath());
            }
            return groupname;
        }

        @Override
        String getEffectiveGroupForProcess() {
            return NativeUtils.getEffectiveGroup();
        }

        @Override
        protected IStatus validateFileName(String filename, boolean isPartOfPath) {
            if (filename.indexOf(File.separator) > -1) {
                return Statuses.ERROR.get(Messages.FileName_IllegalCharacterLinux, new Object[0]);
            }
            if (!isPartOfPath) {
                if (filename.trim().length() == 0) {
                    return Statuses.ERROR.get(Messages.FileName_WhitespacesEntered, new Object[0]);
                }
                if (filename.equals(".") || filename.equals("..")) {
                    return Statuses.ERROR.get(Messages.FileName_DotDotInvalid, new Object[0]);
                }
            }
            return Status.OK_STATUS;
        }

        @Override
        IStatus validatePath(String path) {
            String[] filenames;
            assert (path != null);
            if (path.length() == 0) {
                return Statuses.ERROR.get(Messages.FileName_ZeroPathLength, new Object[0]);
            }
            if (!new File(path).isAbsolute()) {
                return Statuses.ERROR.get(Messages.FileName_RelativePath, new Object[0]);
            }
            String[] stringArray = filenames = path.split("[\\\\/]");
            int n = filenames.length;
            int n2 = 0;
            while (n2 < n) {
                String filename = stringArray[n2];
                IStatus status = this.validateFileName(filename, true);
                if (!status.isOK()) {
                    return status;
                }
                ++n2;
            }
            return Status.OK_STATUS;
        }

        boolean validateChmodArgs(String[] fileList, String perm, Writer out, Writer err) {
            if (perm == null || fileList == null || fileList.length == 0) {
                throw new IllegalArgumentException(Messages.Chmod_IllegalArguments);
            }
            String lineSeparator = System.getProperty("line.separator");
            if (lineSeparator == null || lineSeparator.length() == 0) {
                lineSeparator = "\n";
            }
            boolean isValid = true;
            int i = 0;
            while (i < fileList.length) {
                if (fileList[i].startsWith("~") && !new File(fileList[i]).isAbsolute()) {
                    try {
                        err.append(NLS.bind(Messages.Chmod_RequiresAbsolutePaths, (Object)fileList[i]));
                        err.append(lineSeparator);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    isValid = false;
                }
                ++i;
            }
            try {
                err.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return isValid;
        }

        private boolean isSetIdOrStickyPerm(String perm) {
            if (perm.contains("s") || perm.contains("t")) {
                return true;
            }
            try {
                int val = Integer.parseInt(perm, 8);
                return val > 512;
            }
            catch (Throwable t) {
                return false;
            }
        }

        private void getExpandedFiles(List<Path> expandedFiles, String file) {
            File currFile = new File(file);
            String pattern = currFile.getName();
            if (!pattern.contains("*") && !pattern.contains("?")) {
                expandedFiles.add(currFile.toPath());
                return;
            }
            File parentFile = currFile.getParentFile();
            if (parentFile == null || !parentFile.exists() || parentFile.isFile()) {
                return;
            }
            File[] children = parentFile.listFiles();
            if (children == null || children.length == 0) {
                return;
            }
            PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + pattern);
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                Path path = child.toPath();
                if (matcher.matches(path.getFileName())) {
                    expandedFiles.add(path);
                }
                ++n2;
            }
        }

        private Path[] getExpandedFiles(String[] fileList) {
            ArrayList<Path> expandedFiles = new ArrayList<Path>();
            String[] stringArray = fileList;
            int n = fileList.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                this.getExpandedFiles(expandedFiles, file);
                ++n2;
            }
            return expandedFiles.toArray(new Path[expandedFiles.size()]);
        }

        @Override
        int chmod(String[] fileList, String perm, boolean recursive, boolean shellSyntax, Writer out, Writer err) {
            boolean writeErr;
            boolean writeOut;
            boolean SUCCESS = false;
            int FAILURE = -1;
            int status = -1;
            String exceptionStr = "";
            boolean bl = writeOut = out == null;
            if (out == null) {
                out = new StringWriter();
            }
            boolean bl2 = writeErr = err == null;
            if (err == null) {
                err = new StringWriter();
            }
            if (this.validateChmodArgs(fileList, perm, out, err)) {
                status = 0;
                if (UserOptions.isChmodNativeEnabled() || this.isSetIdOrStickyPerm(perm) || recursive) {
                    return this.chmodNative(fileList, perm, recursive, shellSyntax, out, err);
                }
                NIOChmodEngine chmod = null;
                try {
                    chmod = new NIOChmodEngine(perm);
                }
                catch (Throwable t) {
                    exceptionStr = t.getMessage();
                    status = -1;
                }
                Path[] files = this.getExpandedFiles(fileList);
                int i = 0;
                while (i < files.length && status == 0) {
                    Path file;
                    block19: {
                        file = files[i];
                        Path fileName = file.getFileName();
                        if (fileName == null) {
                            exceptionStr = Messages.Chmod_IllegalArguments;
                            status = -1;
                            break;
                        }
                        if (Files.exists(file, new LinkOption[0])) break block19;
                        err.append(NLS.bind(Messages.Chmod_File_Doesnt_Exist, (Object)file));
                        return -1;
                    }
                    try {
                        chmod.apply(file);
                        PlatformUtils.log.debug(Messages.Chmod_Execute_Msg, file, perm);
                    }
                    catch (IOException ioe) {
                        exceptionStr = ioe.getMessage();
                        status = -1;
                    }
                    catch (NumberFormatException ne) {
                        exceptionStr = ne.getMessage();
                        status = -1;
                    }
                    catch (IllegalArgumentException iae) {
                        exceptionStr = iae.getMessage();
                        status = -1;
                    }
                    catch (UnsupportedOperationException ue) {
                        exceptionStr = ue.getMessage();
                        status = -1;
                    }
                    ++i;
                }
            }
            try {
                if (status == -1) {
                    err.append(exceptionStr);
                    err.append(CommonDef.EOL);
                    err.append(NLS.bind(Messages.Chmod_Error, (Object)1));
                    if (writeErr) {
                        PlatformUtils.log.error(Messages.Chmod_Msg, err);
                    }
                    if (writeOut && out.toString().length() > 0) {
                        PlatformUtils.log.info(Messages.Chmod_Msg, out);
                    }
                    out.append(NLS.bind(Messages.Chmod_Native_Call, new Object[0]));
                    status = this.chmodNative(fileList, perm, recursive, shellSyntax, out, err);
                }
            }
            catch (IOException e) {
                PlatformUtils.log.error(Messages.Chmod_Error, e);
            }
            return status;
        }

        int chmodNative(String[] fileList, String perm, boolean recursive, boolean shellSyntax, Writer out, Writer err) {
            boolean writeErr;
            boolean writeOut;
            int status = -1;
            boolean bl = writeOut = out == null;
            if (out == null) {
                out = new StringWriter();
            }
            boolean bl2 = writeErr = err == null;
            if (err == null) {
                err = new StringWriter();
            }
            if (this.validateChmodArgs(fileList, perm, out, err)) {
                status = 0;
                String chmod = null;
                if (new File("/bin/chmod").exists()) {
                    chmod = "/bin/chmod";
                } else if (new File("/usr/bin/chmod").exists()) {
                    chmod = "/usr/bin/chmod";
                } else {
                    PlatformUtils.log.error(Messages.Chmod_NotFound);
                    return -1;
                }
                ArrayList<String> cmdList = new ArrayList<String>();
                if (shellSyntax) {
                    if (new File("/bin/sh").exists()) {
                        cmdList.add("/bin/sh");
                    } else {
                        cmdList.add("sh");
                    }
                    cmdList.add("-c");
                    if (recursive) {
                        chmod = String.valueOf(chmod) + " -R";
                    }
                    chmod = String.valueOf(chmod) + " " + perm;
                } else {
                    cmdList.add(chmod);
                    if (recursive) {
                        cmdList.add("-R");
                    }
                    cmdList.add(perm);
                }
                String[] stringArray = fileList;
                int n = fileList.length;
                int n2 = 0;
                while (n2 < n) {
                    String element = stringArray[n2];
                    ArrayList<String> chmodCmdList = new ArrayList<String>(cmdList);
                    File workingDir = new File(element).getParentFile();
                    if (shellSyntax) {
                        String filename = element.replaceAll("[ \t]", "\\\\ ");
                        filename = new File(filename).getName();
                        while (workingDir != null && workingDir.getAbsolutePath().indexOf("*") > 0) {
                            filename = String.valueOf(workingDir.getName()) + File.separator + filename;
                            workingDir = workingDir.getParentFile();
                        }
                        String chmodCmd = String.valueOf('`') + chmod + " " + filename + " " + '`';
                        chmodCmdList.add(chmodCmd);
                    } else {
                        chmodCmdList.add(new File(element).getName());
                    }
                    String[] cmd = chmodCmdList.toArray(new String[0]);
                    int returnStatus = PlatformUtils.runProcess(cmd, null, workingDir, out, err);
                    if (returnStatus != 0) {
                        status = -1;
                        try {
                            err.append(NLS.bind(Messages.Chmod_Error, (Object)returnStatus));
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    ++n2;
                }
            }
            if (status != 0) {
                if (writeOut && out.toString().length() > 0) {
                    PlatformUtils.log.info(Messages.Chmod_Msg, out);
                }
                if (writeErr && err.toString().length() > 0) {
                    PlatformUtils.log.error(Messages.Chmod_Msg, err);
                }
            }
            return status;
        }

        @Override
        boolean reboot() {
            throw new UnsupportedOperationException(Messages.Reboot_NotSupportedOnThisOS);
        }

        @Override
        String getSpecialFolder(String variableArg, boolean for64bit) {
            if ("PROGRAM_FILES".equals(variableArg)) {
                return "/opt";
            }
            if ("COMMON_APPDATA".equals(variableArg)) {
                return "/var";
            }
            if ("APPDATA".equals(variableArg)) {
                return new CicFileLocation(System.getProperty("user.home")).append("/var").toString();
            }
            if ("OS400_APPDATA".equals(variableArg)) {
                return "/QIBM/UserData";
            }
            if ("OS400_PROGRAM_FILES".equals(variableArg)) {
                return new CicFileLocation(System.getProperty("user.home")).toString();
            }
            return null;
        }

        @Override
        String getConcatCharForPath() {
            return "";
        }

        @Override
        public boolean is64bitOS() {
            String output;
            String[] cmdArray = new String[]{"uname", "-a"};
            if (new File("/bin/uname").exists()) {
                cmdArray[0] = "/bin/uname";
            } else if (new File("/usr/bin/uname").exists()) {
                cmdArray[0] = "/usr/bin/uname";
            }
            StringWriter out = new StringWriter(4096);
            return this.executeCommand(cmdArray, out, out) && ((output = out.toString()).indexOf("x86_64") >= 0 || output.indexOf("ppc64") >= 0 || output.indexOf("s390x") >= 0);
        }
    }

    class PPMacOS
    extends PPLinux {
        PPMacOS() {
        }

        @Override
        PlatformUtils.OS getOS() {
            return PlatformUtils.OS.MACOSX;
        }

        @Override
        File getLauncherLocation(File installLocation) {
            File[] louncherNames = installLocation.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(".app");
                }
            });
            if (louncherNames != null && louncherNames.length > 0) {
                return new File(String.format("%s/Contents/MacOS", louncherNames[0]));
            }
            return installLocation;
        }

        @Override
        File deduceInstallLocation(File launcherLocation) {
            if (launcherLocation.getName().equals("MacOS") && launcherLocation.getParentFile().getName().equals("Contents")) {
                return launcherLocation.getParentFile().getParentFile().getParentFile();
            }
            return launcherLocation;
        }

        @Override
        String getSpecialFolder(String variableArg, boolean for64bit) {
            if ("PROGRAM_FILES".equals(variableArg)) {
                return "/Applications";
            }
            if ("COMMON_APPDATA".equals(variableArg)) {
                return "/var";
            }
            if ("APPDATA".equals(variableArg)) {
                return new CicFileLocation(System.getProperty("user.home")).append("/var").toString();
            }
            return super.getSpecialFolder(variableArg, for64bit);
        }
    }

    class PPOS400
    extends PPLinux {
        PPOS400() {
        }

        @Override
        PlatformUtils.OS getOS() {
            return PlatformUtils.OS.OS400;
        }

        @Override
        public boolean is64bitOS() {
            return true;
        }
    }

    class PPSolaris
    extends PPLinux {
        PPSolaris() {
        }

        @Override
        PlatformUtils.OS getOS() {
            return PlatformUtils.OS.SOLARIS;
        }

        @Override
        public boolean is64bitOS() {
            String[] cmdArray = new String[]{"isainfo", "-v"};
            if (new File("/bin/isainfo").exists()) {
                cmdArray[0] = "/bin/isainfo";
            } else if (new File("/usr/bin/isainfo").exists()) {
                cmdArray[0] = "/usr/bin/isainfo";
            }
            StringWriter out = new StringWriter(4096);
            return this.executeCommand(cmdArray, out, out) && out.toString().indexOf("64-bit") >= 0;
        }
    }

    class PPWindows
    extends PPCommon {
        private static final String FILE_PATTERN_WIN32 = "[^|/:*?<>\"\\\\]+";
        private final Pattern pattern = Pattern.compile("[^|/:*?<>\"\\\\]+");
        private final String[] OS_INVALID_NAMES_LIST = new String[]{"con", "prn", "aux", "nul", "clock$", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9"};
        private final Set OS_INVALID_NAMES = this.createSet(this.ALWAYS_INVALID_NAMES, this.OS_INVALID_NAMES_LIST);
        private static final int MAX_WIN32_PATH = 256;

        PPWindows() {
        }

        @Override
        PlatformUtils.OS getOS() {
            return PlatformUtils.OS.WIN32;
        }

        @Override
        Properties getEnvironmentVariables() {
            if (this.environmentVariables == null) {
                String userVarPath;
                this.environmentVariables = new Properties();
                for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
                    this.environmentVariables.setProperty(entry.getKey().toUpperCase(), entry.getValue());
                }
                StringBuffer path = new StringBuffer();
                String systemVarPath = NativeUtils.regRead("HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment\\Path", true);
                if (systemVarPath != null) {
                    path.append(systemVarPath);
                }
                if ((userVarPath = NativeUtils.regRead("HKEY_CURRENT_USER\\Environment\\Path", true)) != null) {
                    if (path.length() != 0 && path.charAt(path.length() - 1) != ';') {
                        path.append(';');
                    }
                    path.append(userVarPath);
                }
                if (path.length() > 0) {
                    this.environmentVariables.setProperty("PATH", path.toString());
                } else {
                    this.environmentVariables.remove("PATH");
                }
            }
            return this.environmentVariables;
        }

        @Override
        String getEnvironmentVariable(String key) {
            return this.getEnvironmentVariables().getProperty(key.toUpperCase());
        }

        @Override
        boolean areSameDirectories(String dir1, String dir2) {
            return dir1.trim().equalsIgnoreCase(dir2.trim());
        }

        @Override
        int getMaxInstallLocationLengthForOffering(IOffering offering) {
            return this.getOfferingPropertyAsInt(offering, "maxInstallLocationPathLength.win32", 256);
        }

        @Override
        int getMaxCacheLocationLengthForOffering(IOffering offering) {
            return this.getOfferingPropertyAsInt(offering, "maxCacheLocationPathLength.win32", 256);
        }

        @Override
        protected IStatus validateFileName(String filename, boolean isPartOfPath) {
            if (isPartOfPath && (filename.equals(".") || filename.equals(".."))) {
                return Status.OK_STATUS;
            }
            if (filename.trim().length() == 0) {
                return Statuses.ERROR.get(Messages.FileName_WhitespacesEntered, new Object[0]);
            }
            Matcher matcher = this.pattern.matcher(filename);
            if (!matcher.matches()) {
                return Statuses.ERROR.get(Messages.FileName_IllegalCharacterWin32, new Object[0]);
            }
            String name = filename.toLowerCase();
            int index = name.indexOf(".");
            if (index > 0) {
                name = name.substring(0, index);
            }
            if (this.OS_INVALID_NAMES.contains(name)) {
                return Statuses.ERROR.get(Messages.FileName_IllegalNameWin32, name);
            }
            return Status.OK_STATUS;
        }

        @Override
        IStatus validatePath(String path) {
            assert (path != null);
            if (path.length() == 0) {
                return Statuses.ERROR.get(Messages.FileName_ZeroPathLength, new Object[0]);
            }
            if (path.length() > 256) {
                return Statuses.ERROR.get(Messages.FileName_MaxPathLength, 256);
            }
            if (!new File(path).isAbsolute()) {
                return Statuses.ERROR.get(Messages.FileName_RelativePath, new Object[0]);
            }
            if (path.startsWith("\\\\")) {
                return this.validateWin32UncPath(path);
            }
            return this.validateWin32LocalPath(path);
        }

        private IStatus validateWin32UncPath(String path) {
            if (path.length() == "\\\\".length()) {
                return Statuses.ERROR.get(Messages.FileName_InvalidUncPath, new Object[0]);
            }
            int index = path.indexOf(File.separator, "\\\\".length());
            if (index == -1) {
                return Statuses.ERROR.get(Messages.FileName_InvalidUncPath, new Object[0]);
            }
            String machineName = path.substring("\\\\".length(), index);
            if (machineName.length() == 0 || path.length() == index + 1) {
                return Statuses.ERROR.get(Messages.FileName_InvalidUncPath, new Object[0]);
            }
            return this.validateWin32RelativePath(path.substring(index + 1));
        }

        private IStatus validateWin32LocalPath(String path) {
            if (path.length() < 2) {
                return Statuses.ERROR.get(Messages.FileName_InvalidLocalPath, new Object[0]);
            }
            if (!Character.isLetter(path.charAt(0)) || path.charAt(1) != ':') {
                return Statuses.ERROR.get(Messages.FileName_InvalidLocalPath, new Object[0]);
            }
            if (path.length() == 2) {
                return Status.OK_STATUS;
            }
            if (path.charAt(2) != '\\' && path.charAt(2) != '/') {
                return Statuses.ERROR.get(Messages.FileName_InvalidLocalPath, new Object[0]);
            }
            return this.validateWin32RelativePath(path.substring(2));
        }

        private IStatus validateWin32RelativePath(String path) {
            String[] filenames;
            char first = path.charAt(0);
            if (first == '\\' || first == '/') {
                if (path.length() == 1) {
                    return Status.OK_STATUS;
                }
                path = path.substring(1);
            }
            String[] stringArray = filenames = path.split("[\\\\/]");
            int n = filenames.length;
            int n2 = 0;
            while (n2 < n) {
                String filename = stringArray[n2];
                IStatus status = this.validateFileName(filename, true);
                if (!status.isOK()) {
                    return status;
                }
                ++n2;
            }
            return Status.OK_STATUS;
        }

        @Override
        int createSymlink(String link, String target) {
            PlatformUtils.log.error(Messages.CreateSymLink_NotSupportedOnWindows);
            return -1;
        }

        @Override
        int getUmask() {
            PlatformUtils.log.error(Messages.GetUmask_NotSupportedOnWindows);
            return -1;
        }

        @Override
        int setUmask(int mask, Writer out, Writer err) {
            PlatformUtils.log.error(Messages.SetUmask_NotSupportedOnWindows);
            return -1;
        }

        @Override
        int chmod(String[] fileList, String perm, boolean recursive, boolean shellSyntax, Writer out, Writer err) {
            PlatformUtils.log.info(Messages.Chmod_NotSupportedOnWindows);
            return 0;
        }

        @Override
        String getOwningGroupForFile(String path, boolean resolvePath) {
            return "";
        }

        @Override
        String getEffectiveGroupForProcess() {
            return "";
        }

        @Override
        boolean reboot() {
            PlatformUtils.log.debug("reboot()");
            boolean result = NativeUtils.rebootOs(true);
            PlatformUtils.log.debug("reboot() result: {0}", result);
            return result;
        }

        @Override
        String getSpecialFolder(String variableArg, boolean for64bit) {
            String folder = NativeUtils.winSpecialFolder(variableArg, for64bit);
            if (folder != null && UserOptions.CIC_IS_64_BIT_OS.isSet() && !for64bit && ("PROGRAM_FILES".equals(variableArg) || "PROGRAM_FILES_COMMON".equals(variableArg))) {
                String x86suffix = " (x86)";
                if (!folder.endsWith(" (x86)")) {
                    folder = String.valueOf(folder) + " (x86)";
                }
            }
            return folder;
        }

        @Override
        String getConcatCharForPath() {
            return " ";
        }

        @Override
        public boolean is64bitOS() {
            String val = NativeUtils.regRead("HKLM\\HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\0\\Identifier", false);
            return val != null && val.indexOf("x86") == -1;
        }
    }

    class PPWindowsVista
    extends PPWindows {
        PPWindowsVista() {
        }

        @Override
        PlatformUtils.OS getOS() {
            return PlatformUtils.OS.WIN32_VISTA;
        }
    }

    class PPZOS
    extends PPLinux {
        PPZOS() {
        }

        @Override
        PlatformUtils.OS getOS() {
            return PlatformUtils.OS.ZOS;
        }

        @Override
        String getDefaultDataLocation() {
            if (CicCommonSettings.getAccessRightsMode().isAdminMode() || CicCommonSettings.getAccessRightsMode().isGroupMode()) {
                return this.getSpecialFolder("ZOS_COMMON_APPDATA", false);
            }
            return this.getSpecialFolder("ZOS_APPDATA", false);
        }

        @Override
        String getSpecialFolder(String variableArg, boolean for64bit) {
            if ("ZOS_PROGRAM_FILES".equals(variableArg) || "PROGRAM_FILES".equals(variableArg)) {
                return "/InstallationManager/bin";
            }
            if ("ZOS_COMMON_APPDATA".equals(variableArg) || "COMMON_APPDATA".equals(variableArg)) {
                return "/InstallationManager";
            }
            if ("ZOS_APPDATA".equals(variableArg) || "APPDATA".equals(variableArg)) {
                return new CicFileLocation(System.getProperty("user.home")).append("/InstallationManager").toString();
            }
            return null;
        }

        @Override
        public boolean is64bitOS() {
            return true;
        }
    }
}

