/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import com.ibm.cic.common.core.utils.MapCollection;
import com.ibm.cic.common.core.utils.UnsupportedOperationException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public abstract class MapSet<K, V>
extends MapCollection<K, V, Set<V>> {
    private static final MapSet EMPTY = new MapSet(Collections.EMPTY_MAP){

        @Override
        protected Collection createCollection() {
            throw new UnsupportedOperationException();
        }
    };

    public static <K, V> MapSet<K, V> empty() {
        return EMPTY;
    }

    public static <K, V> MapSet<K, V> newHash() {
        return new MapHashSet();
    }

    public static <K, V> MapSet<K, V> newLinkedHash() {
        return new MapLinkedHashSet();
    }

    public static <K, V> MapSet<K, V> newLinkedHash(int mapCapacity) {
        return new MapLinkedHashSet(new LinkedHashMap(mapCapacity));
    }

    protected MapSet(Map<K, Set<V>> map) {
        super(map);
    }

    @Override
    protected Set<V> createCollection(V value) {
        return Collections.singleton(value);
    }

    public Set<V> get(K key) {
        Set set = (Set)this.getCollection(key);
        return set == null ? Collections.emptySet() : Collections.unmodifiableSet(set);
    }

    @Override
    public Iterator<Set<V>> valuesIterator() {
        return new SetValuesIterator(this);
    }

    public Set<V> remove(K key) {
        Set set = (Set)this.removeCollection(key);
        return set == null ? Collections.emptySet() : set;
    }

    public MapSet<K, V> unmodifiableView() {
        return new UnmodifiableMapSet(this);
    }

    public static class MapHashCapacitySet<K, V>
    extends MapHashSet<K, V> {
        private final int initialCapacity;

        public MapHashCapacitySet(int initialCapacity) {
            this(new HashMap(), initialCapacity);
        }

        public MapHashCapacitySet(Map<K, Set<V>> map, int initialCapacity) {
            super(map);
            this.initialCapacity = initialCapacity;
        }

        @Override
        protected Set<V> createCollection() {
            return new HashSet(this.initialCapacity);
        }
    }

    public static class MapHashSet<K, V>
    extends MapSet<K, V> {
        public MapHashSet() {
            this(new HashMap());
        }

        public MapHashSet(Map<K, Set<V>> map) {
            super(map);
        }

        @Override
        protected Set<V> createCollection() {
            return new HashSet();
        }

        @Override
        protected Set<V> createCollection(Collection<? extends V> values) {
            return new HashSet<V>(values);
        }

        @Override
        protected Set<V> createCollection(V value, Collection<? extends V> values) {
            HashSet<V> result = new HashSet<V>(values);
            result.add(value);
            return result;
        }
    }

    public static class MapLinkedHashCapacitySet<K, V>
    extends MapSet<K, V> {
        private final int initialCapacity;

        public MapLinkedHashCapacitySet(int initialCapacity) {
            this(new LinkedHashMap(), initialCapacity);
        }

        public MapLinkedHashCapacitySet(Map<K, Set<V>> map, int initialCapacity) {
            super(map);
            this.initialCapacity = initialCapacity;
        }

        @Override
        protected Set<V> createCollection() {
            return new LinkedHashSet(this.initialCapacity);
        }

        @Override
        protected Set<V> createCollection(Collection<? extends V> values) {
            return new LinkedHashSet<V>(values);
        }

        @Override
        protected Set<V> createCollection(V value, Collection<? extends V> values) {
            LinkedHashSet<V> result = new LinkedHashSet<V>(4 * (values.size() + 1) / 3);
            result.add(value);
            result.addAll(values);
            return result;
        }
    }

    public static class MapLinkedHashSet<K, V>
    extends MapSet<K, V> {
        public MapLinkedHashSet() {
            this(new LinkedHashMap());
        }

        public MapLinkedHashSet(Map<K, Set<V>> map) {
            super(map);
        }

        @Override
        protected Set<V> createCollection() {
            return new LinkedHashSet();
        }

        @Override
        protected Set<V> createCollection(Collection<? extends V> values) {
            return new LinkedHashSet<V>(values);
        }

        @Override
        protected Set<V> createCollection(V value, Collection<? extends V> values) {
            LinkedHashSet<V> result = new LinkedHashSet<V>(4 * (values.size() + 1) / 3);
            result.add(value);
            result.addAll(values);
            return result;
        }
    }

    public static class MapTreeComparatorSet<K, V>
    extends MapSet<K, V> {
        private final Comparator<V> comparator;

        public MapTreeComparatorSet(Comparator<V> comparator) {
            this(new HashMap(), comparator);
        }

        public MapTreeComparatorSet(Map<K, Set<V>> map, Comparator<V> comparator) {
            super(map);
            this.comparator = comparator;
        }

        @Override
        protected Set<V> createCollection() {
            return new TreeSet<V>(this.comparator);
        }
    }

    public static class MapTreeSet<K, V extends Comparable<V>>
    extends MapSet<K, V> {
        public MapTreeSet() {
            this(new HashMap());
        }

        public MapTreeSet(Map<K, Set<V>> map) {
            super(map);
        }

        @Override
        protected Set<V> createCollection() {
            return new TreeSet();
        }
    }

    private static class SetValuesIterator<V>
    extends MapCollection.ValuesIterator<V, Set<V>> {
        SetValuesIterator(MapSet<?, V> x) {
            super(x);
        }

        @Override
        public Set<V> next() {
            return Collections.unmodifiableSet((Set)this.iter.next());
        }
    }

    private static class UnmodifiableMapSet<K, V>
    extends MapSet<K, V> {
        public UnmodifiableMapSet(MapSet<K, V> mapSet) {
            super(Collections.unmodifiableMap(mapSet.map));
        }

        @Override
        protected Set<V> createCollection() {
            throw new UnsupportedOperationException();
        }
    }
}

