/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import com.ibm.cic.common.core.utils.UnsupportedOperationException;
import com.ibm.cic.common.core.utils.Util;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class MapMap<K1, K2, V> {
    public static final MapMap EMPTY = new MapMap(Collections.EMPTY_MAP){

        protected Map createMap() {
            throw new UnsupportedOperationException();
        }
    };
    private final Map<K1, Map<K2, V>> map;

    public static <K1, K2, V> MapMap<K1, K2, V> emptyMap() {
        return EMPTY;
    }

    public static <K1, K2, V> MapMap<K1, K2, V> newHashHash() {
        return new MapHashMap(new HashMap());
    }

    protected MapMap(Map<K1, Map<K2, V>> map) {
        this.map = map;
    }

    protected abstract Map<K2, V> createMap();

    protected Map<K2, V> createMap(int initialSize) {
        return this.createMap();
    }

    public String toString() {
        return Util.toString(this.map, new Util.MapFormatter(){

            @Override
            protected String emptyString() {
                return "(empty)";
            }

            @Override
            protected String formatValue(Object value) {
                return Util.toString((Map)value, new Util.MapFormatter("=", " "));
            }
        });
    }

    public String getStats() {
        if (this.isEmpty()) {
            return "empty";
        }
        int min = Integer.MAX_VALUE;
        int max = 0;
        long total = 0L;
        for (Map<K2, V> innerMap : this.map.values()) {
            int size = innerMap.size();
            total += (long)size;
            if (size < min) {
                min = size;
            }
            if (size <= max) continue;
            max = size;
        }
        int avg = (int)(total / (long)this.map.size());
        return String.valueOf(this.map.size()) + " maps; avg size: " + avg + ", min: " + min + ", max: " + max;
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Map<K1, Map<K2, V>> toMap() {
        return Collections.unmodifiableMap(this.map);
    }

    public Map<K2, V> get(K1 key1) {
        Map<K2, V> innerMap = this.innerMap(key1);
        if (innerMap == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(innerMap);
    }

    public V get(K1 key1, K2 key2) {
        Map<K2, V> innerMap = this.innerMap(key1);
        return innerMap == null ? null : (V)innerMap.get(key2);
    }

    private Map<K2, V> innerMap(K1 key) {
        return this.map.get(key);
    }

    public boolean contains(Object key) {
        return this.map.containsKey(key);
    }

    public Set<K1> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public Set<K2> keySet(K1 key1) {
        return this.get(key1).keySet();
    }

    public Set<Map.Entry<K1, Map<K2, V>>> entrySet() {
        return Collections.unmodifiableSet(this.map.entrySet());
    }

    public void clear() {
        this.map.clear();
    }

    public V put(K1 key1, K2 key2, V value) {
        Map<K2, V> innerMap = this.innerMap(key1);
        if (innerMap == null) {
            this.map.put(key1, Collections.singletonMap(key2, value));
            return null;
        }
        if (innerMap.size() == 1) {
            Map.Entry<K2, V> entry = innerMap.entrySet().iterator().next();
            if (entry.getKey().equals(key2)) {
                this.map.put(key1, Collections.singletonMap(key2, value));
                return entry.getValue();
            }
            Map<K2, V> newInnerMap = this.createMap();
            this.map.put(key1, newInnerMap);
            newInnerMap.put(entry.getKey(), entry.getValue());
            newInnerMap.put(key2, value);
            return null;
        }
        return innerMap.put(key2, value);
    }

    public void putAll(K1 key1, Map<K2, V> toAdd) {
        if (toAdd.isEmpty()) {
            return;
        }
        if (toAdd.size() == 1) {
            Map.Entry<K2, V> entry = toAdd.entrySet().iterator().next();
            this.put(key1, entry.getKey(), entry.getValue());
        } else {
            Map<K2, V> innerMap = this.innerMap(key1);
            if (innerMap == null) {
                innerMap = this.createMap(toAdd.size());
                this.map.put(key1, innerMap);
            } else if (innerMap.size() == 1) {
                Map.Entry<K2, V> entry = innerMap.entrySet().iterator().next();
                innerMap = this.createMap(toAdd.size() + 1);
                this.map.put(key1, innerMap);
                innerMap.put(entry.getKey(), entry.getValue());
            }
            innerMap.putAll(toAdd);
        }
    }

    public Map<K2, V> remove(K1 key) {
        Map<K2, V> innerMap = this.map.remove(key);
        return innerMap == null ? Collections.emptyMap() : innerMap;
    }

    public V remove(K1 key1, K2 key2) {
        Map<K2, V> innerMap = this.innerMap(key1);
        if (innerMap == null) {
            return null;
        }
        if (innerMap.size() == 1) {
            V result = innerMap.get(key2);
            if (result != null) {
                this.map.remove(key1);
            }
            return result;
        }
        V result = innerMap.remove(key2);
        if (innerMap.isEmpty()) {
            this.map.remove(key1);
        }
        return result;
    }

    public static class MapHashCapacityMap<K1, K2, V>
    extends MapMap<K1, K2, V> {
        private final int capacity;

        public MapHashCapacityMap(Map<K1, Map<K2, V>> map, int capacity) {
            super(map);
            this.capacity = capacity;
        }

        @Override
        protected Map<K2, V> createMap() {
            return new HashMap(this.capacity);
        }
    }

    public static class MapHashMap<K1, K2, V>
    extends MapMap<K1, K2, V> {
        public MapHashMap(Map<K1, Map<K2, V>> map) {
            super(map);
        }

        @Override
        protected Map<K2, V> createMap() {
            return new HashMap();
        }
    }

    public static class MapLinkedHashCapacityMap<K1, K2, V>
    extends MapMap<K1, K2, V> {
        private final int capacity;

        public MapLinkedHashCapacityMap(Map<K1, Map<K2, V>> map, int capacity) {
            super(map);
            this.capacity = capacity;
        }

        @Override
        protected Map<K2, V> createMap() {
            return new LinkedHashMap(this.capacity);
        }
    }

    public static class MapLinkedHashMap<K1, K2, V>
    extends MapMap<K1, K2, V> {
        public MapLinkedHashMap(Map<K1, Map<K2, V>> map) {
            super(map);
        }

        @Override
        protected Map<K2, V> createMap() {
            return new LinkedHashMap();
        }
    }

    public static class MapTreeComparatorMap<K1, K2, V>
    extends MapMap<K1, K2, V> {
        private final Comparator<? super K2> comparator;

        public MapTreeComparatorMap(Map<K1, Map<K2, V>> map, Comparator<? super K2> comparator) {
            super(map);
            this.comparator = comparator;
        }

        @Override
        protected Map<K2, V> createMap() {
            return new TreeMap(this.comparator);
        }
    }

    public static class MapTreeMap<K1, K2 extends Comparable, V>
    extends MapMap<K1, K2, V> {
        public MapTreeMap(Map<K1, Map<K2, V>> map) {
            super(map);
        }

        @Override
        protected Map<K2, V> createMap() {
            return new TreeMap();
        }
    }
}

