/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import com.ibm.cic.common.core.utils.CicStatus;
import com.ibm.cic.common.core.utils.MultiStatusUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;

public class CicMultiStatus
extends CicStatus {
    private ArrayList<IStatus> children = null;

    public CicMultiStatus(String pluginId, int severity, int code, String uid, String explanation, String userAction, IStatus[] nested, Throwable exception, String msg, Object ... messageArgs) {
        super(pluginId, severity, code, uid, explanation, userAction, exception, msg, messageArgs);
        if (nested != null && nested.length > 0) {
            this.addAll(Arrays.asList(nested));
        }
    }

    public void setCanceled() {
        this.setSeverity(this.getSeverity() | 8);
    }

    @Override
    public void setMessage(String message) {
        super.setMessage(message);
    }

    public void setCode(int code) {
        super.setCode(code);
    }

    public void mapErrorToWarning() {
        int severity = this.getSeverity();
        if ((severity & 4) != 0) {
            severity &= 0xFFFFFFFB;
            this.setSeverity(severity |= 2);
        }
    }

    public void add(IStatus child) {
        if (child == null) {
            return;
        }
        if (!child.isOK()) {
            if (child.isMultiStatus() && child.getMessage().length() == 0) {
                this.addAll(child);
            } else {
                this.ensureExtraCapacity(1);
                this.children.add(child);
            }
            this.setCumulativeSeverity(child);
        }
    }

    public void addAllStatuses(IStatus child) {
        if (child == null) {
            return;
        }
        if (child.isMultiStatus() && child.getMessage().length() == 0) {
            this.addAll(child);
        } else {
            this.ensureExtraCapacity(1);
            this.children.add(child);
        }
        this.setCumulativeSeverity(child);
    }

    public void addAll(Collection<IStatus> nested) {
        this.ensureExtraCapacity(nested.size());
        for (IStatus child : nested) {
            this.add(child);
        }
    }

    public void addAll(IStatus status) {
        if (status == null || !status.isMultiStatus()) {
            this.add(status);
        } else {
            IStatus[] nested = status.getChildren();
            this.ensureExtraCapacity(nested.length);
            IStatus[] iStatusArray = nested;
            int n = nested.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                this.add(child);
                ++n2;
            }
        }
    }

    public IStatus[] getChildren() {
        IStatus[] result = new IStatus[this.children == null ? 0 : this.children.size()];
        if (result.length > 0) {
            this.children.toArray(result);
        }
        return result;
    }

    public boolean isMultiStatus() {
        return true;
    }

    public IStatus[] getLeaves() {
        List<IStatus> leaves = MultiStatusUtil.getStatusLeaves(this);
        IStatus[] result = new IStatus[leaves.size()];
        leaves.toArray(result);
        return result;
    }

    private void ensureExtraCapacity(int count) {
        if (this.children == null) {
            this.children = new ArrayList(count < 4 ? 4 : count);
        } else {
            this.children.ensureCapacity(this.children.size() + count);
        }
    }

    private void setCumulativeSeverity(IStatus child) {
        int childSeverity = child.getSeverity();
        if (childSeverity > this.getSeverity()) {
            this.setSeverity(childSeverity);
        }
    }

    public void merge(IStatus status) {
        if (!status.isMultiStatus()) {
            this.add(status);
        } else {
            this.addAll(status);
        }
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }
}

