/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

public class AdvisoryLockedFile
extends RandomAccessFile {
    private final String location;
    private final boolean forReadingOnly;
    private final boolean useLocking;
    private boolean inputInitialized = false;
    private ControlledFileInputStream inputStream = null;
    private boolean outputInitialized = false;
    private ControlledFileOutputStream outputStream = null;
    private boolean isClosed = false;

    public AdvisoryLockedFile(File file, boolean forReadingOnly, boolean useLocking) throws FileNotFoundException {
        super(file, forReadingOnly ? "r" : "rw");
        this.location = file.getPath();
        this.forReadingOnly = forReadingOnly;
        this.useLocking = useLocking;
    }

    public FileLock lock() throws IOException {
        return AdvisoryLockedFile.lock(this, this.forReadingOnly, true, this.useLocking);
    }

    public FileLock lock(boolean block) throws IOException {
        return AdvisoryLockedFile.lock(this, this.forReadingOnly, block, this.useLocking);
    }

    public static FileLock lock(RandomAccessFile file, boolean forReadingOnly, boolean block, boolean useFileLocks) throws IOException {
        assert (file != null);
        if (useFileLocks) {
            FileChannel fileChannel = file.getChannel();
            long size = 8192L;
            if (block) {
                return fileChannel.lock(0L, size, forReadingOnly);
            }
            return fileChannel.tryLock(0L, size, forReadingOnly);
        }
        file.getChannel();
        return null;
    }

    public static AdvisoryLockedFile lockCloseIfFails(AdvisoryLockedFile file) throws IOException {
        try {
            file.lock();
        }
        catch (IOException e) {
            try {
                file.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
        return file;
    }

    public String getLocation() {
        return this.location;
    }

    public FileInputStream getInputStream() throws IOException {
        if (!this.inputInitialized) {
            this.inputStream = this.getChannel().size() == 0L ? null : new ControlledFileInputStream(this.getFD());
            this.inputInitialized = true;
        }
        return this.inputStream;
    }

    public FileOutputStream getOutputStream() throws IOException {
        if (!this.outputInitialized) {
            this.outputStream = new ControlledFileOutputStream(this.getFD());
            this.outputInitialized = true;
        }
        return this.outputStream;
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed) {
            this.getChannel().close();
            if (this.outputStream != null) {
                this.outputStream.controlledClose();
                this.outputStream = null;
            }
            if (this.inputStream != null) {
                this.inputStream.controlledClose();
                this.inputStream = null;
            }
            super.close();
            this.isClosed = true;
        }
    }

    private static class ControlledFileInputStream
    extends FileInputStream {
        public ControlledFileInputStream(FileDescriptor fdObj) {
            super(fdObj);
        }

        @Override
        public void close() {
        }

        public void controlledClose() throws IOException {
            super.close();
        }
    }

    private static class ControlledFileOutputStream
    extends FileOutputStream {
        public ControlledFileOutputStream(FileDescriptor fdObj) {
            super(fdObj);
        }

        @Override
        public void close() {
        }

        public void controlledClose() throws IOException {
            super.close();
        }
    }
}

